/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.util;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class GraphUtils {
    public static <D, N extends TarjanNode<D>> Set<? extends Set<? extends N>> tarjan(Iterable<? extends N> iterable) {
        LinkedHashSet<Set<N>> linkedHashSet = new LinkedHashSet<Set<N>>();
        LinkedList linkedList = new LinkedList();
        int n = 0;
        for (TarjanNode tarjanNode : iterable) {
            if (tarjanNode.index != -1) continue;
            n += GraphUtils.tarjan(tarjanNode, n, linkedList, linkedHashSet);
        }
        return linkedHashSet;
    }

    private static <D, N extends TarjanNode<D>> int tarjan(N n, int n2, LinkedList<N> linkedList, Set<Set<N>> set) {
        n.index = n2;
        n.lowlink = n2++;
        linkedList.addFirst(n);
        n.active = true;
        Object tarjanNode = n.getDependencies().iterator();
        while (tarjanNode.hasNext()) {
            TarjanNode<D> object;
            TarjanNode<D> tarjanNode2 = object = tarjanNode.next();
            if (tarjanNode2.index == -1) {
                GraphUtils.tarjan(tarjanNode2, n2, linkedList, set);
                n.lowlink = Math.min(n.lowlink, tarjanNode2.lowlink);
                continue;
            }
            if (!linkedList.contains(tarjanNode2)) continue;
            n.lowlink = Math.min(n.lowlink, tarjanNode2.index);
        }
        if (n.lowlink == n.index) {
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            do {
                tarjanNode = (TarjanNode)linkedList.removeFirst();
                ((TarjanNode)tarjanNode).active = false;
                linkedHashSet.add(tarjanNode);
            } while (tarjanNode != n);
            set.add(linkedHashSet);
        }
        return n2;
    }

    public static <D> String toDot(Iterable<? extends TarjanNode<D>> iterable, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("digraph %s {\n", string));
        stringBuilder.append(String.format("label = \"%s\";\n", string2));
        for (TarjanNode<D> tarjanNode : iterable) {
            stringBuilder.append(String.format("%s [label = \"%s\"];\n", tarjanNode.hashCode(), tarjanNode.toString()));
        }
        for (TarjanNode<D> tarjanNode : iterable) {
            for (TarjanNode<D> tarjanNode2 : tarjanNode.getDependencies()) {
                stringBuilder.append(String.format("%s -> %s [label = \" %s \"];\n", tarjanNode.hashCode(), tarjanNode2.hashCode(), tarjanNode.printDependency(tarjanNode2)));
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static abstract class TarjanNode<D>
    extends Node<D>
    implements Comparable<TarjanNode<D>> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D d) {
            super(d);
        }

        @Override
        public abstract Iterable<? extends TarjanNode<D>> getDependencies();

        @Override
        public int compareTo(TarjanNode<D> tarjanNode) {
            return this.index < tarjanNode.index ? -1 : (this.index == tarjanNode.index ? 0 : 1);
        }
    }

    public static abstract class Node<D> {
        public final D data;

        public Node(D d) {
            this.data = d;
        }

        public abstract Iterable<? extends Node<D>> getDependencies();

        public abstract String printDependency(Node<D> var1);

        public String toString() {
            return this.data.toString();
        }
    }
}

