/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openjdk.asmtools.common.Module;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CFVersion;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.CodeAttr;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DefaultAnnotationAttr;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.FieldData;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.ModuleAttr;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.ParserAnnotation;
import org.openjdk.asmtools.jasm.ParserCP;
import org.openjdk.asmtools.jasm.ParserInstr;
import org.openjdk.asmtools.jasm.RecordData;
import org.openjdk.asmtools.jasm.Scanner;
import org.openjdk.asmtools.jasm.StackMapData;
import org.openjdk.asmtools.jasm.Tables;

class Parser
extends ParseBase {
    protected ConstantPool pool = null;
    ClassData cd = null;
    CodeAttr curCode;
    private ArrayList<ClassData> clsDataList = new ArrayList();
    private String pkg = null;
    private String pkgPrefix = "";
    private ArrayList<AnnotationData> pkgAnnttns = null;
    private ArrayList<AnnotationData> clsAnnttns = null;
    private ArrayList<AnnotationData> memberAnnttns = null;
    private boolean explicitcp = false;
    private ModuleAttr moduleAttribute;
    private CFVersion currentCFV;
    private ParserAnnotation annotParser;
    private ParserCP cpParser;
    private ParserInstr instrParser;

    protected Parser(Environment sf, CFVersion cfVersion) throws IOException {
        super.init(new Scanner(sf), this, sf);
        this.currentCFV = cfVersion;
        this.annotParser = new ParserAnnotation(this.scanner, this, this.env);
        this.cpParser = new ParserCP(this.scanner, this, this.env);
        this.instrParser = new ParserInstr(this.scanner, this, this.cpParser, this.env);
    }

    void setDebugFlags(boolean debugScanner, boolean debugMembers, boolean debugCP, boolean debugAnnot, boolean debugInstr) {
        this.enableDebug(debugMembers);
        this.scanner.enableDebug(debugScanner);
        this.cpParser.enableDebug(debugCP);
        this.annotParser.enableDebug(debugAnnot);
        this.instrParser.enableDebug(debugInstr);
    }

    String encodeClassString(String classname) {
        return "L" + classname + ";";
    }

    private void parseVersionPkg() throws IOException {
        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
            return;
        }
        if (this.scanner.token == JasmTokens.Token.VERSION) {
            this.scanner.scan();
            if (this.scanner.token == JasmTokens.Token.INTVAL) {
                this.currentCFV.setMajorVersion((short)this.scanner.intValue);
                this.scanner.scan();
                if (this.scanner.token == JasmTokens.Token.COLON) {
                    this.scanner.scan();
                    if (this.scanner.token == JasmTokens.Token.INTVAL) {
                        this.currentCFV.setMinorVersion((short)this.scanner.intValue);
                        this.scanner.scan();
                        this.debugScan("     [Parser.parseVersionPkg]: " + this.currentCFV.asString());
                        return;
                    }
                }
            }
        }
        this.env.error(this.scanner.pos, "version.expected");
        throw new Scanner.SyntaxError();
    }

    private void parseVersion() throws IOException {
        if (this.scanner.token == JasmTokens.Token.LBRACE) {
            return;
        }
        if (this.scanner.token == JasmTokens.Token.VERSION) {
            this.scanner.scan();
            if (this.scanner.token == JasmTokens.Token.INTVAL) {
                this.cd.cfv.setMajorVersion((short)this.scanner.intValue);
                this.scanner.scan();
                if (this.scanner.token == JasmTokens.Token.COLON) {
                    this.scanner.scan();
                    if (this.scanner.token == JasmTokens.Token.INTVAL) {
                        this.cd.cfv.setMinorVersion((short)this.scanner.intValue);
                        this.scanner.scan();
                        this.debugStr("parseVersion: " + this.cd.cfv.asString());
                        return;
                    }
                }
            }
        }
        this.env.error(this.scanner.pos, "version.expected");
        throw new Scanner.SyntaxError();
    }

    String parseIdent() throws Scanner.SyntaxError, IOException {
        String v = this.scanner.idValue;
        this.scanner.expect(JasmTokens.Token.IDENT);
        return v;
    }

    void parseLocVarDef() throws Scanner.SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            int v = this.scanner.intValue;
            this.scanner.scan();
            this.curCode.LocVarDataDef(v);
        } else {
            String type;
            String name = this.scanner.stringValue;
            this.scanner.expect(JasmTokens.Token.IDENT);
            if (this.scanner.token == JasmTokens.Token.COLON) {
                this.scanner.scan();
                type = this.parseIdent();
            } else {
                type = "I";
            }
            this.curCode.LocVarDataDef(name, this.pool.FindCellAsciz(type));
        }
    }

    Argument parseLocVarRef() throws Scanner.SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            int v = this.scanner.intValue;
            this.scanner.scan();
            return new Argument(v);
        }
        String name = this.scanner.stringValue;
        this.scanner.expect(JasmTokens.Token.IDENT);
        return this.curCode.LocVarDataRef(name);
    }

    void parseLocVarEnd() throws Scanner.SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            int v = this.scanner.intValue;
            this.scanner.scan();
            this.curCode.LocVarDataEnd(v);
        } else {
            String name = this.scanner.stringValue;
            this.scanner.expect(JasmTokens.Token.IDENT);
            this.curCode.LocVarDataEnd(name);
        }
    }

    void parseMapItem(DataVector map) throws Scanner.SyntaxError, IOException {
        Tables.StackMapType itemType = Tables.stackMapType(this.scanner.intValue, null);
        Tables.ConstType tag = null;
        Argument arg = null;
        JasmTokens.Token ptoken = this.scanner.token;
        int iValue = this.scanner.intValue;
        String sValue = this.scanner.stringValue;
        this.scanner.scan();
        switch (ptoken) {
            case INTVAL: {
                break;
            }
            case CLASS: {
                itemType = Tables.StackMapType.ITEM_Object;
                tag = Tables.ConstType.CONSTANT_CLASS;
                break;
            }
            case CPINDEX: {
                itemType = Tables.StackMapType.ITEM_Object;
                arg = this.pool.getCell(iValue);
                break;
            }
            case IDENT: {
                itemType = Tables.stackMapType(sValue);
                tag = Tables.tag(sValue);
                if (itemType != null) {
                    if (tag == null || this.scanner.token == JasmTokens.Token.SEMICOLON || this.scanner.token == JasmTokens.Token.COMMA) break;
                    itemType = Tables.StackMapType.ITEM_Object;
                    break;
                }
                if (tag != null) {
                    itemType = Tables.StackMapType.ITEM_Object;
                    break;
                }
            }
            default: {
                itemType = Tables.StackMapType.ITEM_Bogus;
                this.env.error("itemtype.expected", (Object)("<" + ptoken.printValue() + ">"));
            }
        }
        switch (itemType) {
            case ITEM_Object: {
                if (arg == null) {
                    arg = this.pool.FindCell(this.cpParser.parseConstValue(tag));
                }
                map.addElement(new StackMapData.StackMapItem2(itemType, arg));
                break;
            }
            case ITEM_NewObject: {
                arg = this.instrParser.parseLabelRef();
                map.addElement(new StackMapData.StackMapItem2(itemType, arg));
                break;
            }
            default: {
                map.addElement(new StackMapData.StackMapItem1(itemType));
            }
        }
    }

    ConstantPool.ConstCell parseName() throws Scanner.SyntaxError, IOException {
        this.debugScan("------- [Parser.parseName]: ");
        switch (this.scanner.token) {
            case CPINDEX: {
                int cpx = this.scanner.intValue;
                this.scanner.scan();
                return this.pool.getCell(cpx);
            }
            case STRINGVAL: {
                String v = this.scanner.stringValue;
                this.scanner.scan();
                return this.pool.FindCellAsciz(v);
            }
            case IDENT: 
            case OPEN: 
            case MODULE: 
            case VARARGS: 
            case REQUIRES: 
            case EXPORTS: 
            case TO: 
            case USES: 
            case PROVIDES: 
            case WITH: 
            case OPENS: 
            case ARRAY_TYPEPATH: 
            case INNER_TYPE_TYPEPATH: 
            case WILDCARD_TYPEPATH: 
            case TYPE_ARGUMENT_TYPEPATH: 
            case PERMITTEDSUBTYPES: 
            case INF: 
            case NAN: 
            case COMPONENT: 
            case SYNTHETIC: 
            case DEPRECATED: 
            case VERSION: 
            case BITS: 
            case STACK: 
            case LOCAL: 
            case OF: 
            case INNERCLASS: 
            case STRICT: 
            case FIELDREF: 
            case METHODREF: 
            case BRIDGE: {
                String v = this.scanner.idValue;
                this.scanner.scan();
                return this.pool.FindCellAsciz(v);
            }
        }
        this.env.error(this.scanner.pos, "name.expected", (Object)this.scanner.token);
        throw new Scanner.SyntaxError();
    }

    ConstantPool.ConstCell parseMethodHandle(Tables.SubTag subtag) throws Scanner.SyntaxError, IOException {
        ConstantPool.ConstCell refCell;
        switch (subtag) {
            case REF_GETFIELD: 
            case REF_GETSTATIC: 
            case REF_PUTFIELD: 
            case REF_PUTSTATIC: {
                refCell = this.pool.FindCell(this.cpParser.parseConstValue(Tables.ConstType.CONSTANT_FIELD));
                break;
            }
            case REF_INVOKEVIRTUAL: 
            case REF_NEWINVOKESPECIAL: {
                refCell = this.pool.FindCell(this.cpParser.parseConstValue(Tables.ConstType.CONSTANT_METHOD));
                break;
            }
            case REF_INVOKESTATIC: 
            case REF_INVOKESPECIAL: {
                Tables.ConstType ctype01 = Tables.ConstType.CONSTANT_METHOD;
                Tables.ConstType ctype02 = Tables.ConstType.CONSTANT_INTERFACEMETHOD;
                if (this.cd.cfv.major_version() >= 52 && Modifiers.isInterface(this.cd.access)) {
                    ctype01 = Tables.ConstType.CONSTANT_INTERFACEMETHOD;
                    ctype02 = Tables.ConstType.CONSTANT_METHOD;
                }
                refCell = this.cpParser.parseConstRef(ctype01, ctype02);
                break;
            }
            case REF_INVOKEINTERFACE: {
                refCell = this.pool.FindCell(this.cpParser.parseConstValue(Tables.ConstType.CONSTANT_INTERFACEMETHOD));
                break;
            }
            default: {
                throw new Scanner.SyntaxError();
            }
        }
        return refCell;
    }

    Tables.SubTag parseSubtag() throws Scanner.SyntaxError, IOException {
        Tables.SubTag subtag = null;
        switch (this.scanner.token) {
            case IDENT: {
                subtag = Tables.subtag(this.scanner.stringValue);
                break;
            }
            case INTVAL: {
                subtag = Tables.subtag(this.scanner.intValue);
            }
        }
        if (subtag == null) {
            this.env.error("subtag.expected");
            throw new Scanner.SyntaxError();
        }
        this.scanner.scan();
        return subtag;
    }

    ConstantPool.ConstCell parseClassName(boolean uncond) throws Scanner.SyntaxError, IOException {
        switch (this.scanner.token) {
            case CPINDEX: {
                int cpx = this.scanner.intValue;
                this.scanner.scan();
                return this.pool.getCell(cpx);
            }
            case STRINGVAL: {
                String v = this.scanner.stringValue;
                this.scanner.scan();
                v = this.prependPackage(v, uncond);
                return this.pool.FindCellAsciz(v);
            }
            case IDENT: 
            case OPEN: 
            case MODULE: 
            case VARARGS: 
            case REQUIRES: 
            case EXPORTS: 
            case TO: 
            case USES: 
            case PROVIDES: 
            case WITH: 
            case OPENS: 
            case ARRAY_TYPEPATH: 
            case INNER_TYPE_TYPEPATH: 
            case WILDCARD_TYPEPATH: 
            case TYPE_ARGUMENT_TYPEPATH: 
            case PERMITTEDSUBTYPES: 
            case INF: 
            case NAN: 
            case COMPONENT: 
            case SYNTHETIC: 
            case DEPRECATED: 
            case VERSION: 
            case BITS: 
            case STACK: 
            case LOCAL: 
            case OF: 
            case INNERCLASS: 
            case STRICT: 
            case FIELDREF: 
            case METHODREF: 
            case BRIDGE: {
                String v = this.scanner.idValue;
                this.scanner.scan();
                v = this.prependPackage(v, uncond);
                return this.pool.FindCellAsciz(v);
            }
        }
        Tables.ConstType key = Tables.tag(this.scanner.token.value());
        this.env.traceln("%%%%% Unrecognized token [" + (Object)((Object)this.scanner.token) + "]: '" + (key == null ? "null" : key.parseKey()) + "'.");
        this.env.error(this.scanner.prevPos, "name.expected", (Object)("\"" + this.scanner.token.parseKey() + "\""));
        throw new Scanner.SyntaxError();
    }

    private String prependPackage(String className, boolean uncond) {
        if (!(!uncond && this.scanner.token != JasmTokens.Token.FIELD || className.contains("/") || className.contains("["))) {
            className = this.pkgPrefix + className;
        }
        return className;
    }

    Argument parseInt(int size) throws Scanner.SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.BITS) {
            this.scanner.scan();
        }
        if (this.scanner.token != JasmTokens.Token.INTVAL) {
            this.env.error(this.scanner.pos, "int.expected");
            throw new Scanner.SyntaxError();
        }
        int arg = this.scanner.intValue * this.scanner.sign;
        switch (size) {
            case 1: {
                if (arg <= 255 && arg >= -128) break;
                this.env.error(this.scanner.pos, "value.large", (Object)"1 byte");
                throw new Scanner.SyntaxError();
            }
            case 2: {
                if (arg <= 65535 && arg >= Short.MIN_VALUE) break;
                this.env.error(this.scanner.pos, "value.large", (Object)"2 bytes");
                throw new Scanner.SyntaxError();
            }
            default: {
                throw new InternalError("parseInt(" + size + ")");
            }
        }
        this.scanner.scan();
        return new Argument(arg);
    }

    Argument parseUInt(int size) throws Scanner.SyntaxError, IOException {
        if (this.scanner.token != JasmTokens.Token.INTVAL) {
            this.env.error(this.scanner.pos, "int.expected");
            throw new Scanner.SyntaxError();
        }
        if (this.scanner.sign == -1) {
            this.env.error(this.scanner.pos, "neg.forbidden");
            throw new Scanner.SyntaxError();
        }
        int arg = this.scanner.intValue;
        switch (size) {
            case 1: {
                if (arg <= 255) break;
                this.env.error(this.scanner.pos, "value.large", (Object)"1 byte");
                throw new Scanner.SyntaxError();
            }
            case 2: {
                if (arg <= 65535) break;
                this.env.error(this.scanner.pos, "value.large", (Object)"2 bytes");
                throw new Scanner.SyntaxError();
            }
            default: {
                throw new InternalError("parseUInt(" + size + ")");
            }
        }
        this.scanner.scan();
        return new Argument(arg);
    }

    private void parseConstDef() throws IOException {
        while (true) {
            if (this.scanner.token != JasmTokens.Token.CPINDEX) {
                this.env.error("const.def.expected");
                throw new Scanner.SyntaxError();
            }
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            this.scanner.expect(JasmTokens.Token.ASSIGN);
            this.env.traceln("parseConstDef:" + cpx);
            this.pool.setCell(cpx, this.cpParser.parseConstRef(null));
            if (this.scanner.token != JasmTokens.Token.COMMA) {
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                return;
            }
            this.scanner.scan();
        }
    }

    private int scanModifier(int mod) throws IOException {
        while (true) {
            int nextmod = 0;
            switch (this.scanner.token) {
                case PUBLIC: {
                    nextmod = 1;
                    break;
                }
                case PRIVATE: {
                    nextmod = 2;
                    break;
                }
                case PROTECTED: {
                    nextmod = 4;
                    break;
                }
                case STATIC: {
                    nextmod = 8;
                    break;
                }
                case FINAL: {
                    nextmod = 16;
                    break;
                }
                case SYNCHRONIZED: {
                    nextmod = 32;
                    break;
                }
                case SUPER: {
                    nextmod = 32;
                    break;
                }
                case VOLATILE: {
                    nextmod = 64;
                    break;
                }
                case BRIDGE: {
                    nextmod = 64;
                    break;
                }
                case TRANSIENT: {
                    nextmod = 128;
                    break;
                }
                case VARARGS: {
                    nextmod = 128;
                    break;
                }
                case NATIVE: {
                    nextmod = 256;
                    break;
                }
                case INTERFACE: {
                    nextmod = 512;
                    break;
                }
                case ABSTRACT: {
                    nextmod = 1024;
                    break;
                }
                case STRICT: {
                    nextmod = 2048;
                    break;
                }
                case ENUM: {
                    nextmod = 16384;
                    break;
                }
                case SYNTHETIC: {
                    nextmod = 4096;
                    break;
                }
                case ANNOTATION_ACCESS: {
                    nextmod = 8192;
                    break;
                }
                case DEPRECATED: {
                    nextmod = 131072;
                    break;
                }
                case MANDATED: {
                    nextmod = 32768;
                    break;
                }
                default: {
                    return nextmod;
                }
            }
            int prevpos = this.scanner.pos;
            this.scanner.scan();
            if ((mod & nextmod) == 0) {
                return nextmod;
            }
            this.env.error(prevpos, "warn.repeated.modifier");
        }
    }

    int scanModifiers() throws IOException {
        int mod = 0;
        int nextmod;
        while ((nextmod = this.scanModifier(mod)) != 0) {
            mod |= nextmod;
        }
        return mod;
    }

    private void parseField(int mod) throws Scanner.SyntaxError, IOException {
        this.debugStr("  [Parser.parseField]: <<<Begin>>>");
        Modifiers.checkFieldModifiers(this.cd, mod, this.scanner.pos);
        while (true) {
            ConstantPool.ConstCell nameCell = this.parseName();
            this.scanner.expect(JasmTokens.Token.COLON);
            ConstantPool.ConstCell typeCell = this.parseName();
            FieldData fld = this.cd.addField(mod, nameCell, typeCell);
            if (this.memberAnnttns != null) {
                fld.addAnnotations(this.memberAnnttns);
            }
            if (this.scanner.token == JasmTokens.Token.COLON) {
                this.scanner.scan();
                ConstantPool.ConstCell signatureCell = this.parseName();
                fld.setSignatureAttr(signatureCell);
            }
            if (this.scanner.token == JasmTokens.Token.ASSIGN) {
                this.scanner.scan();
                fld.SetValue(this.cpParser.parseConstRef(null));
            }
            this.debugScan("  [Parser.parseField]: Field: " + fld + " ");
            if (this.scanner.token != JasmTokens.Token.COMMA) {
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                return;
            }
            this.scanner.scan();
        }
    }

    private int countParams(ConstantPool.ConstCell sigCell) throws Scanner.SyntaxError {
        String sig;
        try {
            ConstantPool.ConstValue_String strConst = (ConstantPool.ConstValue_String)sigCell.ref;
            sig = strConst.value;
        }
        catch (ClassCastException | NullPointerException e) {
            return 0;
        }
        int siglen = sig.length();
        int k = 0;
        int loccnt = 0;
        int errparam = 0;
        boolean arraytype = false;
        if (k < siglen) {
            if (sig.charAt(k) != '(') {
                errparam = 1;
            } else {
                block9: for (k = 1; k < siglen; ++k) {
                    switch (sig.charAt(k)) {
                        case ')': {
                            if (arraytype) {
                                errparam = 2;
                                break block9;
                            }
                            return loccnt;
                        }
                        case '[': {
                            arraytype = true;
                            continue block9;
                        }
                        case 'B': 
                        case 'C': 
                        case 'F': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            ++loccnt;
                            arraytype = false;
                            continue block9;
                        }
                        case 'D': 
                        case 'J': {
                            ++loccnt;
                            if (arraytype) {
                                arraytype = false;
                                continue block9;
                            }
                            ++loccnt;
                            continue block9;
                        }
                        case 'L': {
                            while (true) {
                                if (k >= siglen) {
                                    errparam = 3;
                                    break block9;
                                }
                                if (sig.charAt(k) == ';') break;
                                ++k;
                            }
                            ++loccnt;
                            arraytype = false;
                            continue block9;
                        }
                        default: {
                            errparam = 4;
                            break block9;
                        }
                    }
                }
            }
        }
        this.env.error(this.scanner.pos, "msig.malformed", (Object)Integer.toString(k), (Object)Integer.toString(errparam));
        return loccnt;
    }

    private void parseMethod(int mod) throws Scanner.SyntaxError, IOException {
        int posa = this.scanner.pos;
        this.debugStr("  [Parser.parseMethod]: <<<Begin>>>");
        ConstantPool.ConstCell nameCell = this.parseName();
        ConstantPool.ConstValue_String strConst = (ConstantPool.ConstValue_String)nameCell.ref;
        String name = strConst.value;
        boolean is_clinit = name.equals("<clinit>");
        boolean is_init = name.equals("<init>");
        DefaultAnnotationAttr defAnnot = null;
        Modifiers.checkMethodModifiers(this.cd, mod, posa, is_init, is_clinit);
        this.scanner.expect(JasmTokens.Token.COLON);
        ConstantPool.ConstCell typeCell = this.parseName();
        int paramcnt = this.countParams(typeCell);
        if (!Modifiers.isStatic(mod) && !is_clinit) {
            ++paramcnt;
        }
        if (paramcnt > 255) {
            this.env.error(this.scanner.pos, "warn.msig.more255", (Object)Integer.toString(paramcnt));
        }
        ArrayList<ConstantPool.ConstCell> exc_table = null;
        if (this.scanner.token == JasmTokens.Token.THROWS) {
            this.scanner.scan();
            exc_table = new ArrayList<ConstantPool.ConstCell>();
            while (true) {
                posa = this.scanner.pos;
                ConstantPool.ConstCell exc = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
                if (exc_table.contains(exc)) {
                    this.env.error(posa, "warn.exc.repeated");
                } else {
                    exc_table.add(exc);
                    this.env.traceln("THROWS:" + exc.arg);
                }
                if (this.scanner.token != JasmTokens.Token.COMMA) break;
                this.scanner.scan();
            }
        }
        if (this.scanner.token == JasmTokens.Token.DEFAULT) {
            defAnnot = this.annotParser.parseDefaultAnnotation();
        }
        MethodData curMethod = this.cd.StartMethod(mod, nameCell, typeCell, exc_table);
        Argument max_stack = null;
        Argument max_locals = null;
        if (this.scanner.token == JasmTokens.Token.STACK) {
            this.scanner.scan();
            max_stack = this.parseUInt(2);
        }
        if (this.scanner.token == JasmTokens.Token.LOCAL) {
            this.scanner.scan();
            max_locals = this.parseUInt(2);
        }
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            this.annotParser.parseParamAnnots(paramcnt, curMethod);
        }
        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
            if (max_stack != null || max_locals != null) {
                this.env.error("token.expected", (Object)"{");
            }
            this.scanner.scan();
        } else {
            this.scanner.expect(JasmTokens.Token.LBRACE);
            this.curCode = curMethod.startCode(posa, paramcnt, max_stack, max_locals);
            while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
                this.instrParser.parseInstr();
                if (this.scanner.token == JasmTokens.Token.RBRACE) break;
                if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
                    this.curCode.addAnnotations(this.annotParser.scanAnnotations());
                    break;
                }
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
            }
            this.curCode.endCode();
            this.scanner.expect(JasmTokens.Token.RBRACE);
        }
        if (defAnnot != null) {
            curMethod.addDefaultAnnotation(defAnnot);
        }
        if (this.memberAnnttns != null) {
            curMethod.addAnnotations(this.memberAnnttns);
        }
        this.cd.EndMethod();
        this.debugStr("  [Parser.parseMethod]: Method: " + curMethod);
    }

    private void parseCPXBootstrapMethod() throws Scanner.SyntaxError, IOException {
        ArrayList<ConstantPool.ConstCell> bsm_args;
        ConstantPool.ConstCell MHCell;
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            MHCell = this.pool.getCell(cpx);
            this.scanner.scan();
            bsm_args = new ArrayList<ConstantPool.ConstCell>(256);
            while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
                if (this.scanner.token != JasmTokens.Token.CPINDEX) {
                    this.env.error(this.scanner.pos, "invalid.bootstrapmethod");
                    throw new Scanner.SyntaxError();
                }
                bsm_args.add(this.pool.getCell(this.scanner.intValue));
                this.scanner.scan();
            }
        } else {
            this.env.error(this.scanner.pos, "invalid.bootstrapmethod");
            throw new Scanner.SyntaxError();
        }
        BootstrapMethodData bsmData = new BootstrapMethodData(MHCell, bsm_args);
        this.cd.addBootstrapMethod(bsmData);
    }

    private void parseNestHost() throws Scanner.SyntaxError, IOException {
        this.debugStr("  [Parser.parseNestHost]: <<<Begin>>>");
        String className = this.prependPackage(this.parseIdent(), true);
        ConstantPool.ConstCell hostClass = this.pool.FindCellClassByName(className);
        this.debugScan("  [Parser.parseNestHost]: NestHost: class " + className);
        this.scanner.expect(JasmTokens.Token.SEMICOLON);
        this.cd.addNestHost(hostClass);
    }

    private void parseClasses(Consumer<ArrayList<ConstantPool.ConstCell>> classesConsumer) throws Scanner.SyntaxError, IOException {
        ArrayList<ConstantPool.ConstCell> classes = new ArrayList<ConstantPool.ConstCell>();
        this.debugStr("  [Parser.parseClasses]: <<<Begin>>>");
        while (true) {
            String className = this.prependPackage(this.parseIdent(), true);
            classes.add(this.pool.FindCellClassByName(className));
            this.debugScan("  [Parser.parseClasses]: class " + className);
            if (this.scanner.token != JasmTokens.Token.COMMA) {
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                classesConsumer.accept(classes);
                return;
            }
            this.scanner.scan();
        }
    }

    private void parseRecord() throws Scanner.SyntaxError, IOException {
        this.debugScan("[Parser.parseRecord]:  Begin");
        this.scanner.expect(JasmTokens.Token.LBRACE);
        ArrayList<AnnotationData> componentAnntts = null;
        boolean grouped = false;
        RecordData rd = this.cd.setRecord(this.scanner.pos);
        while (true) {
            if (this.scanner.token == JasmTokens.Token.RBRACE) {
                if (rd.isEmpty()) {
                    this.env.error(this.scanner.pos, "warn.no.components.in.record.attribute");
                    this.cd.rejectRecord();
                } else if (grouped) {
                    this.env.error(this.scanner.pos, "grouped.component.expected");
                }
                break;
            }
            ConstantPool.ConstCell signatureCell = null;
            if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
                componentAnntts = this.annotParser.scanAnnotations();
            }
            this.scanner.expect(JasmTokens.Token.COMPONENT);
            ConstantPool.ConstCell nameCell = this.parseName();
            this.scanner.expect(JasmTokens.Token.COLON);
            ConstantPool.ConstCell descCell = this.parseName();
            if (this.scanner.token == JasmTokens.Token.COLON) {
                this.scanner.scan();
                signatureCell = this.parseName();
            }
            rd.addComponent(nameCell, descCell, signatureCell, componentAnntts);
            switch (this.scanner.token) {
                case COMMA: {
                    grouped = true;
                    break;
                }
                case SEMICOLON: {
                    grouped = false;
                    componentAnntts = null;
                    break;
                }
                default: {
                    this.env.error(this.scanner.pos, "one.of.two.token.expected", (Object)("<" + JasmTokens.Token.SEMICOLON.printValue() + ">"), (Object)("<" + JasmTokens.Token.COMMA.printValue() + ">"));
                }
            }
            this.scanner.scan();
        }
        this.scanner.scan();
        this.debugScan("[Parser.parseRecord]:  End");
    }

    private void parseInnerClass(int mod) throws Scanner.SyntaxError, IOException {
        this.debugScan("[Parser.parseInnerClass]:  Begin ");
        Modifiers.checkInnerClassModifiers(this.cd, mod, this.scanner.pos);
        ConstantPool.ConstCell innerClass = null;
        ConstantPool.ConstCell outerClass = null;
        if (this.scanner.token == JasmTokens.Token.CLASS) {
            ConstantPool.ConstCell nameCell = this.pool.getCell(0);
            this.parseInnerClass_s2(mod, nameCell, innerClass, outerClass);
        } else if (this.scanner.token == JasmTokens.Token.IDENT || this.scanner.checkTokenIdent()) {
            ConstantPool.ConstCell nameCell = this.parseName();
            this.parseInnerClass_s1(mod, nameCell, innerClass, outerClass);
        } else if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            ConstantPool.ConstCell nameCell = this.pool.getCell(cpx);
            ConstantPool.ConstValue nameCellValue = nameCell.ref;
            if (nameCellValue instanceof ConstantPool.ConstValue_String) {
                this.scanner.scan();
                this.parseInnerClass_s1(mod, nameCell, innerClass, outerClass);
            } else {
                nameCell = this.pool.getCell(0);
                this.parseInnerClass_s2(mod, nameCell, innerClass, outerClass);
            }
        } else {
            this.pic_error();
        }
    }

    private void parseInnerClass_s1(int mod, ConstantPool.ConstCell nameCell, ConstantPool.ConstCell innerClass, ConstantPool.ConstCell outerClass) throws IOException {
        if (this.scanner.token == JasmTokens.Token.ASSIGN) {
            this.scanner.scan();
            this.parseInnerClass_s2(mod, nameCell, innerClass, outerClass);
        } else {
            this.pic_error();
        }
    }

    private void parseInnerClass_s2(int mod, ConstantPool.ConstCell nameCell, ConstantPool.ConstCell innerClass, ConstantPool.ConstCell outerClass) throws IOException {
        if (this.scanner.token == JasmTokens.Token.CPINDEX || this.scanner.token == JasmTokens.Token.CLASS) {
            if (this.scanner.token == JasmTokens.Token.CPINDEX) {
                innerClass = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
            }
            if (this.scanner.token == JasmTokens.Token.CLASS) {
                this.scanner.scan();
                innerClass = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
            }
            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                outerClass = this.pool.getCell(0);
                this.pic_tracecreate(mod, nameCell, innerClass, outerClass);
                this.cd.addInnerClass(mod, nameCell, innerClass, outerClass);
            } else if (this.scanner.token == JasmTokens.Token.OF) {
                this.parseInnerClass_s3(mod, nameCell, innerClass, outerClass);
            } else {
                this.pic_error();
            }
        } else {
            this.pic_error();
        }
    }

    private void parseInnerClass_s3(int mod, ConstantPool.ConstCell nameCell, ConstantPool.ConstCell innerClass, ConstantPool.ConstCell outerClass) throws IOException {
        this.scanner.scan();
        if (this.scanner.token == JasmTokens.Token.CLASS || this.scanner.token == JasmTokens.Token.CPINDEX) {
            if (this.scanner.token == JasmTokens.Token.CLASS) {
                this.scanner.scan();
                outerClass = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
            }
            if (this.scanner.token == JasmTokens.Token.CPINDEX) {
                outerClass = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
            }
            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                this.pic_tracecreate(mod, nameCell, innerClass, outerClass);
                this.cd.addInnerClass(mod, nameCell, innerClass, outerClass);
            } else {
                this.pic_error();
            }
        } else {
            this.pic_error();
        }
    }

    private void pic_tracecreate(int mod, ConstantPool.ConstCell nameCell, ConstantPool.ConstCell innerClass, ConstantPool.ConstCell outerClass) {
        ConstantPool.ConstValue value;
        this.env.trace(" Creating InnerClass: [" + Modifiers.toString(mod, Tables.CF_Context.CTX_INNERCLASS) + "], ");
        if (nameCell != this.pool.getCell(0) && (value = nameCell.ref) != null) {
            this.env.trace(value.toString() + " = ");
        }
        ConstantPool.ConstValue_Cell ici_val = (ConstantPool.ConstValue_Cell)innerClass.ref;
        ConstantPool.ConstCell ici_ascii = ici_val.cell;
        if (ici_ascii.ref == null) {
            this.env.trace("<#cpx-unresolved> ");
        } else {
            ConstantPool.ConstValue_String cval = (ConstantPool.ConstValue_String)ici_ascii.ref;
            if (cval.value == null) {
                this.env.trace("<#cpx-0> ");
            } else {
                this.env.trace(cval.value + " ");
            }
        }
        if (outerClass != this.pool.getCell(0) && outerClass.arg != 0) {
            ConstantPool.ConstValue_Cell oci_val = (ConstantPool.ConstValue_Cell)outerClass.ref;
            ConstantPool.ConstCell oci_ascii = oci_val.cell;
            if (oci_ascii.ref == null) {
                this.env.trace(" of <#cpx-unresolved>  ");
            } else {
                ConstantPool.ConstValue_String cval = (ConstantPool.ConstValue_String)oci_ascii.ref;
                if (cval.value == null) {
                    this.env.trace(" of <#cpx-0>  ");
                } else {
                    this.env.trace(" of " + cval.value);
                }
            }
        }
        this.env.traceln("");
    }

    private void pic_error() {
        this.env.error(this.scanner.pos, "invalid.innerclass");
        throw new Scanner.SyntaxError();
    }

    private void match(JasmTokens.Token open, JasmTokens.Token close) throws IOException {
        int depth = 1;
        while (true) {
            this.scanner.scan();
            if (this.scanner.token == open) {
                ++depth;
                continue;
            }
            if (this.scanner.token == close) {
                if (--depth != 0) continue;
                return;
            }
            if (this.scanner.token == JasmTokens.Token.EOF) break;
        }
        this.env.error(this.scanner.pos, "unbalanced.paren");
    }

    private void recoverField() throws Scanner.SyntaxError, IOException {
        block7: while (true) {
            switch (this.scanner.token) {
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case FINAL: 
                case SYNCHRONIZED: 
                case VOLATILE: 
                case TRANSIENT: 
                case NATIVE: 
                case ABSTRACT: 
                case ANNOTATION_ACCESS: 
                case EOF: {
                    return;
                }
                case LBRACE: {
                    this.match(JasmTokens.Token.LBRACE, JasmTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block7;
                }
                case LPAREN: {
                    this.match(JasmTokens.Token.LPAREN, JasmTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block7;
                }
                case LSQBRACKET: {
                    this.match(JasmTokens.Token.LSQBRACKET, JasmTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block7;
                }
                case CLASS: 
                case INTERFACE: 
                case RBRACE: 
                case IMPORT: 
                case PACKAGE: {
                    this.endClass();
                    this.scanner.debugStr("    [Parser.recoverField]: pos: [" + this.scanner.pos + "]: ");
                    throw new Scanner.SyntaxError();
                }
            }
            this.scanner.scan();
        }
    }

    private void parseClass(int mod) throws IOException {
        int posa = this.scanner.pos;
        this.debugStr("   [Parser.parseClass]:  Begin ");
        Modifiers.checkClassModifiers(this.env, mod, this.scanner);
        if (this.cd == null) {
            this.cd = new ClassData(this.env, this.currentCFV.clone());
            this.pool = this.cd.pool;
        }
        if (this.clsAnnttns != null) {
            this.cd.addAnnotations(this.clsAnnttns);
        }
        if (this.scanner.token == JasmTokens.Token.CLASS) {
            this.scanner.scan();
        } else if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
            this.scanner.scan();
            if (this.scanner.token == JasmTokens.Token.INTERFACE) {
                mod |= 0x2200;
                this.scanner.scan();
            } else {
                this.env.error(this.scanner.prevPos, "token.expected", (Object)(JasmTokens.Token.ANNOTATION.parseKey() + JasmTokens.Token.INTERFACE.parseKey()));
                throw new Scanner.SyntaxError();
            }
        }
        ConstantPool.ConstCell nm = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS, null, true);
        if (this.scanner.token == JasmTokens.Token.FIELD) {
            String fileExtension;
            this.scanner.scan();
            switch (this.scanner.token) {
                case STRINGVAL: {
                    fileExtension = this.scanner.stringValue;
                    break;
                }
                case IDENT: {
                    fileExtension = this.scanner.idValue;
                    break;
                }
                default: {
                    this.env.error(this.scanner.pos, "name.expected");
                    throw new Scanner.SyntaxError();
                }
            }
            this.scanner.scan();
            this.cd.fileExtension = "." + fileExtension;
        } else {
            if (this.scanner.token == JasmTokens.Token.MODULE) {
                this.env.error(this.scanner.prevPos, "token.expected", (Object)JasmTokens.Token.OPEN.parseKey());
                throw new Scanner.SyntaxError();
            }
            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                this.scanner.scan();
            }
        }
        ConstantPool.ConstCell sup = null;
        if (this.scanner.token == JasmTokens.Token.EXTENDS) {
            this.scanner.scan();
            sup = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
            while (this.scanner.token == JasmTokens.Token.COMMA) {
                this.scanner.scan();
                this.env.error(posa, "multiple.inherit");
                this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
            }
        }
        ArrayList<Argument> impl = new ArrayList<Argument>();
        if (this.scanner.token == JasmTokens.Token.IMPLEMENTS) {
            do {
                this.scanner.scan();
                ConstantPool.ConstCell intf = this.cpParser.parseConstRef(Tables.ConstType.CONSTANT_CLASS);
                if (impl.contains(intf)) {
                    this.env.error(posa, "warn.intf.repeated", (Object)intf);
                    continue;
                }
                impl.add(intf);
            } while (this.scanner.token == JasmTokens.Token.COMMA);
        }
        this.parseVersion();
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this.cd.init(mod, nm, sup, impl);
        block10: while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            switch (this.scanner.token) {
                case SEMICOLON: {
                    this.scanner.scan();
                    continue block10;
                }
                case CONST: {
                    this.scanner.scan();
                    this.parseConstDef();
                    this.explicitcp = true;
                    continue block10;
                }
            }
            this.parseClassMembers();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        this.endClass();
    }

    private String parseTypeName() throws IOException {
        String name = "";
        String field = "";
        while (true) {
            if (!this.scanner.token.possibleModuleName()) {
                this.env.error(this.scanner.pos, "name.expected", (Object)("\"" + this.scanner.token.parseKey() + "\""));
                throw new Scanner.SyntaxError();
            }
            name = name + field + this.scanner.idValue;
            this.scanner.scan();
            if (this.scanner.token != JasmTokens.Token.FIELD) break;
            this.env.error(this.scanner.pos, "warn.dot.will.be.converted");
            field = "/";
            this.scanner.scan();
        }
        return name;
    }

    private String parseModuleName() throws IOException {
        String name = "";
        String field = "";
        while (true) {
            if (!this.scanner.token.possibleModuleName()) {
                this.env.error(this.scanner.pos, "module.name.expected", (Object)("\"" + this.scanner.token.parseKey() + "\""));
                throw new Scanner.SyntaxError().Fatal();
            }
            name = name + field + this.scanner.idValue;
            this.scanner.scanModuleStatement();
            if (this.scanner.token != JasmTokens.Token.FIELD) break;
            field = Character.toString((char)this.scanner.token.value());
            this.scanner.scanModuleStatement();
        }
        return name;
    }

    private void parseModule() throws IOException {
        this.debugStr("   [Parser.parseModule]:  Begin ");
        if (this.cd == null) {
            this.cd = new ClassData(this.env, this.currentCFV.clone());
            this.pool = this.cd.pool;
        }
        if (this.clsAnnttns != null) {
            this.cd.addAnnotations(this.clsAnnttns);
        }
        this.moduleAttribute = new ModuleAttr(this.cd);
        if (this.scanner.token == JasmTokens.Token.OPEN) {
            this.moduleAttribute.openModule();
            this.scanner.scan();
        }
        if (this.scanner.token != JasmTokens.Token.MODULE) {
            this.env.error(this.scanner.pos, "token.expected", (Object)JasmTokens.Token.MODULE.parseKey());
            throw new Scanner.SyntaxError().Fatal();
        }
        this.scanner.scanModuleStatement();
        String moduleName = this.parseModuleName();
        if (moduleName.isEmpty()) {
            this.env.error(this.scanner.pos, "name.expected");
            throw new Scanner.SyntaxError().Fatal();
        }
        this.moduleAttribute.setModuleName(moduleName);
        this.parseVersion();
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this.cd.initAsModule();
        block8: while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            switch (this.scanner.token) {
                case REQUIRES: {
                    this.scanRequires(this.moduleAttribute.requires);
                    continue block8;
                }
                case EXPORTS: {
                    this.scanStatement(this.moduleAttribute.exports, this::parseTypeName, this::parseModuleName, JasmTokens.Token.TO, true, "exports.expected");
                    continue block8;
                }
                case OPENS: {
                    this.scanStatement(this.moduleAttribute.opens, this::parseTypeName, this::parseModuleName, JasmTokens.Token.TO, true, "opens.expected");
                    continue block8;
                }
                case USES: {
                    this.scanStatement(this.moduleAttribute.uses, "uses.expected");
                    continue block8;
                }
                case PROVIDES: {
                    this.scanStatement(this.moduleAttribute.provides, this::parseTypeName, this::parseTypeName, JasmTokens.Token.WITH, false, "provides.expected");
                    continue block8;
                }
                case SEMICOLON: {
                    this.scanner.scan();
                    continue block8;
                }
            }
            this.env.error(this.scanner.pos, "module.statement.expected");
            throw new Scanner.SyntaxError().Fatal();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        this.endModule();
    }

    private void scanRequires(BiConsumer<String, Integer> action) throws IOException {
        int flags = 0;
        String mn = "";
        this.scanner.scanModuleStatement();
        block5: while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
            switch (this.scanner.token) {
                case STATIC: {
                    if ((flags & 1 << Module.Modifier.ACC_STATIC_PHASE.asInt()) != 0 || !mn.isEmpty()) {
                        this.env.error(this.scanner.pos, "requires.expected");
                        throw new Scanner.SyntaxError().Fatal();
                    }
                    flags |= Module.Modifier.ACC_STATIC_PHASE.asInt();
                    break;
                }
                case TRANSITIVE: {
                    if ((flags & 1 << Module.Modifier.ACC_TRANSITIVE.asInt()) != 0 || !mn.isEmpty()) {
                        this.env.error(this.scanner.pos, "requires.expected");
                        throw new Scanner.SyntaxError().Fatal();
                    }
                    flags |= Module.Modifier.ACC_TRANSITIVE.asInt();
                    break;
                }
                case IDENT: {
                    if (!mn.isEmpty()) {
                        this.env.error(this.scanner.pos, "requires.expected");
                        throw new Scanner.SyntaxError().Fatal();
                    }
                    mn = this.parseModuleName();
                    continue block5;
                }
                default: {
                    if (mn.isEmpty() && this.scanner.token.possibleModuleName()) {
                        mn = this.parseModuleName();
                        continue block5;
                    }
                    this.env.error(this.scanner.pos, "requires.expected");
                    throw new Scanner.SyntaxError().Fatal();
                }
            }
            this.scanner.scanModuleStatement();
        }
        if (mn.isEmpty()) {
            this.env.error(this.scanner.pos, "requires.expected");
            throw new Scanner.SyntaxError().Fatal();
        }
        action.accept(mn, flags);
        this.scanner.scanModuleStatement();
    }

    private void scanStatement(Consumer<Set<String>> action, String err) throws IOException {
        HashSet<String> names = this.scanList(() -> this.scanner.scan(), this::parseTypeName, err, true);
        if (names.size() != 1) {
            this.env.error(this.scanner.pos, err);
            throw new Scanner.SyntaxError().Fatal();
        }
        action.accept(names);
        this.scanner.scan();
    }

    private void scanStatement(BiConsumer<String, Set<String>> action, NameSupplier source, NameSupplier target, JasmTokens.Token startList, boolean emptyListAllowed, String err) throws IOException {
        String typeName = "";
        HashSet<Object> names = new HashSet();
        this.scanner.scan();
        while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
            if (this.scanner.token == JasmTokens.Token.IDENT) {
                if (typeName.isEmpty()) {
                    typeName = source.get();
                    continue;
                }
                this.env.error(this.scanner.pos, err);
                throw new Scanner.SyntaxError().Fatal();
            }
            if (this.scanner.token == startList) {
                if (typeName.isEmpty()) {
                    this.env.error(this.scanner.pos, err);
                    throw new Scanner.SyntaxError().Fatal();
                }
                names = this.scanList(this.scanner.token == JasmTokens.Token.TO ? () -> this.scanner.scanModuleStatement() : () -> this.scanner.scan(), target, err, false);
                break;
            }
            this.env.error(this.scanner.pos, err);
            throw new Scanner.SyntaxError().Fatal();
        }
        if (typeName.isEmpty() || names.isEmpty() && !emptyListAllowed) {
            this.env.error(this.scanner.pos, err);
            throw new Scanner.SyntaxError().Fatal();
        }
        action.accept(typeName, names);
        this.scanner.scan();
    }

    private HashSet<String> scanList(Method scanMethod, NameSupplier target, String err, boolean onlyOneElement) throws IOException {
        HashSet<String> names = new HashSet<String>();
        boolean comma = false;
        boolean first = true;
        scanMethod.call();
        block4: while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
            switch (this.scanner.token) {
                case COMMA: {
                    if (comma || first || onlyOneElement) {
                        this.env.error(this.scanner.pos, err);
                        throw new Scanner.SyntaxError().Fatal();
                    }
                    comma = true;
                    break;
                }
                case IDENT: {
                    if (!first && !comma) {
                        this.env.error(this.scanner.pos, err);
                        throw new Scanner.SyntaxError().Fatal();
                    }
                    names.add(target.get());
                    comma = false;
                    first = false;
                    continue block4;
                }
                default: {
                    this.env.error(this.scanner.pos, err);
                    throw new Scanner.SyntaxError().Fatal();
                }
            }
            this.scanner.scan();
        }
        if (names.isEmpty() || comma) {
            this.env.error(this.scanner.pos, err);
            throw new Scanner.SyntaxError().Fatal();
        }
        return names;
    }

    private void parseClassMembers() throws IOException {
        this.debugScan("[Parser.parseClassMembers]:  Begin ");
        if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
            this.memberAnnttns = this.annotParser.scanAnnotations();
        }
        int mod = this.scanModifiers();
        try {
            switch (this.scanner.token) {
                case FIELDREF: {
                    this.scanner.scan();
                    this.parseField(mod);
                    break;
                }
                case METHODREF: {
                    this.scanner.scan();
                    this.parseMethod(mod);
                    break;
                }
                case INNERCLASS: {
                    this.scanner.scan();
                    this.parseInnerClass(mod);
                    break;
                }
                case BOOTSTRAPMETHOD: {
                    this.scanner.scan();
                    this.parseCPXBootstrapMethod();
                    break;
                }
                case NESTHOST: {
                    if (this.cd.nestHostAttributeExists()) {
                        this.env.error(this.scanner.pos, "extra.nesthost.attribute");
                        throw new Scanner.SyntaxError();
                    }
                    if (this.cd.nestMembersAttributesExist()) {
                        this.env.error(this.scanner.pos, "both.nesthost.nestmembers.found");
                        throw new Scanner.SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseNestHost();
                    break;
                }
                case NESTMEMBERS: {
                    if (this.cd.nestMembersAttributesExist()) {
                        this.env.error(this.scanner.pos, "extra.nestmembers.attribute");
                        throw new Scanner.SyntaxError();
                    }
                    if (this.cd.nestHostAttributeExists()) {
                        this.env.error(this.scanner.pos, "both.nesthost.nestmembers.found");
                        throw new Scanner.SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseClasses(list -> this.cd.addNestMembers((List<ConstantPool.ConstCell>)list));
                    break;
                }
                case PERMITTEDSUBTYPES: {
                    if (this.cd.nestMembersAttributesExist()) {
                        this.env.error(this.scanner.pos, "extra.permittedsubtypes.attribute");
                        throw new Scanner.SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseClasses(list -> this.cd.addPermittedSubtypes((List<ConstantPool.ConstCell>)list));
                    break;
                }
                case RECORD: {
                    if (this.cd.recordAttributeExists()) {
                        this.env.error(this.scanner.pos, "extra.record.attribute");
                        throw new Scanner.SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseRecord();
                    break;
                }
                default: {
                    this.env.error(this.scanner.pos, "field.expected");
                    throw new Scanner.SyntaxError();
                }
            }
        }
        catch (Scanner.SyntaxError e) {
            this.recoverField();
        }
        this.memberAnnttns = null;
    }

    private void recoverFile() throws IOException {
        block7: while (true) {
            this.env.traceln("recoverFile: scanner.token=" + (Object)((Object)this.scanner.token));
            switch (this.scanner.token) {
                case CLASS: 
                case INTERFACE: {
                    return;
                }
                case LBRACE: {
                    this.match(JasmTokens.Token.LBRACE, JasmTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block7;
                }
                case LPAREN: {
                    this.match(JasmTokens.Token.LPAREN, JasmTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block7;
                }
                case LSQBRACKET: {
                    this.match(JasmTokens.Token.LSQBRACKET, JasmTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block7;
                }
                case EOF: {
                    return;
                }
            }
            this.scanner.scan();
        }
    }

    private void endClass() {
        if (this.explicitcp) {
            this.pool.fixRefsInPool();
            this.cd.relinkBootstrapMethods();
        }
        this.cd.endClass();
        this.clsDataList.add(this.cd);
        this.cd = null;
    }

    private void endModule() {
        this.cd.endModule(this.moduleAttribute);
        this.clsDataList.add(this.cd);
        this.cd = null;
    }

    final ClassData[] getClassesData() {
        return this.clsDataList.toArray(new ClassData[0]);
    }

    private void parseJasmPackages() throws IOException {
        try {
            if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
                if (this.cd == null) {
                    this.cd = new ClassData(this.env, this.currentCFV.clone());
                    this.pool = this.cd.pool;
                }
                this.pkgAnnttns = this.annotParser.scanAnnotations();
            }
            if (this.scanner.token == JasmTokens.Token.PACKAGE) {
                this.scanner.scan();
                int where = this.scanner.pos;
                String id = this.parseIdent();
                this.parseVersionPkg();
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                if (this.pkg == null) {
                    this.pkg = id;
                    this.pkgPrefix = id + "/";
                } else {
                    this.env.error(where, "package.repeated");
                }
                this.debugScan("[Parser.parseJasmPackages] {PARSED} package-prefix: " + this.pkgPrefix + " ");
            }
        }
        catch (Scanner.SyntaxError e) {
            this.recoverFile();
        }
        while (this.scanner.token == JasmTokens.Token.SEMICOLON) {
            this.scanner.scan();
        }
        if (this.scanner.token == JasmTokens.Token.EOF) {
            this.env.traceln("Scanner:  EOF");
            String sourceName = this.env.getSimpleInputFileName();
            int mod = 1536;
            if (sourceName.endsWith("package-info.jasm")) {
                this.env.traceln("Creating \"package-info.jasm\": package: " + this.pkg + " " + this.currentCFV.asString());
                if (this.cd == null) {
                    this.cd = new ClassData(this.env, this.currentCFV.clone());
                    this.pool = this.cd.pool;
                } else {
                    this.cd.cfv = this.currentCFV.clone();
                }
                ConstantPool.ConstCell me = this.pool.FindCellClassByName(this.pkgPrefix + "package-info");
                if (this.currentCFV.major_version() > 49) {
                    mod |= 0x10000;
                }
                this.cd.init(mod, me, new ConstantPool.ConstCell(0), null);
                if (this.pkgAnnttns != null) {
                    this.cd.addAnnotations(this.pkgAnnttns);
                }
                this.endClass();
            }
            return;
        }
        if (this.pkg == null && this.pkgAnnttns != null) {
            this.clsAnnttns = this.pkgAnnttns;
            this.pkgAnnttns = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseFile() {
        try {
            this.parseJasmPackages();
            block9: while (this.scanner.token != JasmTokens.Token.EOF) {
                try {
                    int mod;
                    block18: {
                        block17: {
                            if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
                                if (this.cd == null) {
                                    this.cd = new ClassData(this.env, this.currentCFV.clone());
                                    this.pool = this.cd.pool;
                                } else {
                                    this.cd.cfv = this.currentCFV.clone();
                                }
                                this.clsAnnttns = this.annotParser.scanAnnotations();
                            }
                            if ((mod = this.scanModifiers()) != 0) break block17;
                            switch (this.scanner.token) {
                                case CLASS: 
                                case CPINDEX: 
                                case IDENT: 
                                case STRINGVAL: 
                                case OPEN: 
                                case MODULE: {
                                    break block18;
                                }
                                case SEMICOLON: {
                                    this.scanner.scan();
                                    continue block9;
                                }
                                default: {
                                    this.debugScan(" [Parser.parseFile]: ");
                                    this.env.error(this.scanner.pos, "toplevel.expected");
                                    throw new Scanner.SyntaxError();
                                }
                            }
                        }
                        if (Modifiers.isInterface(mod) && this.scanner.token != JasmTokens.Token.CLASS) {
                            mod |= 0x400;
                        }
                    }
                    if (this.scanner.token == JasmTokens.Token.MODULE || this.scanner.token == JasmTokens.Token.OPEN) {
                        this.parseModule();
                    } else {
                        this.parseClass(mod);
                    }
                    this.clsAnnttns = null;
                }
                catch (Scanner.SyntaxError e) {
                    this.env.traceln("^^^^^^^ Syntax Error ^^^^^^^^^^^^");
                    if (this.scanner.debugFlag) {
                        e.printStackTrace();
                    }
                    if (e.isFatal()) return;
                    this.recoverFile();
                }
            }
            return;
        }
        catch (IOException e) {
            this.env.error(this.scanner.pos, "io.exception", (Object)this.env.getSimpleInputFileName());
            return;
        }
        catch (Error er) {
            er.printStackTrace();
        }
    }

    static class CompilerError
    extends Error {
        CompilerError(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    static interface Method {
        public void call() throws IOException;
    }

    @FunctionalInterface
    static interface NameSupplier {
        public String get() throws IOException;
    }
}

