/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public class TypeAnnotationTypePathData
implements Data {
    private ArrayList<TypeAnnotationTypes.TypePathEntry> typePathEntries = new ArrayList();

    public void addTypePathEntry(TypeAnnotationTypes.TypePathEntry entry) {
        this.typePathEntries.add(entry);
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeByte(this.typePathEntries.size());
        for (TypeAnnotationTypes.TypePathEntry entry : this.typePathEntries) {
            out.writeByte(entry.getTypePathKind());
            out.writeByte(entry.getTypeArgumentIndex());
        }
    }

    @Override
    public int getLength() {
        return 1 + this.typePathEntries.size() * 2;
    }

    public String toString(int tabLevel) {
        String buffer = "";
        if (this.typePathEntries.size() > 0) {
            StringBuilder sb = new StringBuilder(this.tabString(tabLevel));
            sb.append(" [ ");
            boolean first = true;
            for (TypeAnnotationTypes.TypePathEntry entry : this.typePathEntries) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(entry.toString());
            }
            sb.append("]");
            buffer = sb.toString();
        }
        return buffer;
    }

    public void print(PrintWriter out, String tab) {
        if (this.typePathEntries.size() > 0) {
            out.print(tab + " {");
            boolean first = true;
            for (TypeAnnotationTypes.TypePathEntry entry : this.typePathEntries) {
                if (!first) {
                    out.print(", ");
                }
                first = false;
                out.print(entry.toString());
            }
            out.print(tab + "} ");
        }
    }
}

