/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdec;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.Module;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;
import org.openjdk.asmtools.jcoder.JcodTokens;
import org.openjdk.asmtools.jdec.Main;
import org.openjdk.asmtools.jdec.NestedByteArrayInputStream;
import org.openjdk.asmtools.util.I18NResourceBundle;

class ClassData {
    private byte[] types;
    private Object[] cpool;
    private int CPlen;
    private NestedByteArrayInputStream countedin;
    private DataInputStream in;
    private PrintWriter out;
    private int[] cpe_pos;
    private boolean printDetails;
    private String entityType = "";
    private String entityName = "";
    public static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    private static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int shift = 0;
    boolean DebugFlag = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassData(DataInputStream dis, int printFlags, PrintWriter out) throws IOException {
        byte[] buf = new byte[dis.available()];
        try {
            if (dis.read(buf) <= 0) {
                throw new IOException("The file is empty");
            }
        }
        finally {
            dis.close();
        }
        this.countedin = new NestedByteArrayInputStream(buf);
        this.in = new DataInputStream(this.countedin);
        this.out = out;
        this.printDetails = (printFlags & 1) == 1;
    }

    private String toHex(long val, int width) {
        StringBuilder s = new StringBuilder();
        for (int i = width * 2 - 1; i >= 0; --i) {
            s.append(hexTable[(int)(val >> 4 * i) & 0xF]);
        }
        return "0x" + s.toString();
    }

    private String toHex(long val) {
        int width;
        for (width = 8; width > 0 && val >> (width - 1) * 8 == 0L; --width) {
        }
        return this.toHex(val, width);
    }

    private void printByteHex(PrintWriter out, int b) {
        out.print(hexTable[b >> 4 & 0xF]);
        out.print(hexTable[b & 0xF]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printBytes(PrintWriter out, DataInputStream in, int len) throws IOException {
        try {
            for (int i = 0; i < len; ++i) {
                if (i % 8 == 0) {
                    this.out_print("0x");
                }
                this.printByteHex(out, in.readByte());
                if (i % 8 != 7) continue;
                out.println(";");
            }
        }
        finally {
            if (len % 8 != 0) {
                out.println(";");
            }
        }
    }

    private void printRestOfBytes() {
        int i = 0;
        while (true) {
            try {
                byte b = this.in.readByte();
                if (i % 8 == 0) {
                    this.out_print("0x");
                }
                this.printByteHex(this.out, b);
                if (i % 8 == 7) {
                    this.out.print(";\n");
                }
            }
            catch (IOException e) {
                return;
            }
            ++i;
        }
    }

    private void printUtf8InfoIndex(int index, String indexName) {
        String name = (String)this.cpool[index];
        this.out_print("#" + index + "; // ");
        if (this.printDetails) {
            this.out.println(String.format("%-16s", indexName) + " : " + name);
        } else {
            this.out.println(indexName);
        }
    }

    private void out_begin(String s) {
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.println(s);
        ++this.shift;
    }

    private void out_print(String s) {
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.print(s);
    }

    private void out_println(String s) {
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.println(s);
    }

    private void out_end(String s) {
        --this.shift;
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.println(s);
    }

    private String startArray(int length) {
        return "[" + (this.printDetails ? Integer.toString(length) : "") + "]";
    }

    private void startArrayCmt(int length, String comment) {
        this.out_begin(this.startArray(length) + String.format(" {%s", comment == null ? "" : " // " + comment));
    }

    private void startArrayCmtB(int length, String comment) {
        this.out_begin(this.startArray(length) + String.format("b {%s", comment == null ? "" : " // " + comment));
    }

    private void readCP(DataInputStream in) throws IOException {
        int length;
        this.CPlen = length = in.readUnsignedShort();
        this.traceln(i18n.getString("jdec.trace.CP_len", (Object)length));
        this.types = new byte[length];
        this.cpool = new Object[length];
        this.cpe_pos = new int[length];
        block12: for (int i = 1; i < length; ++i) {
            this.cpe_pos[i] = this.countedin.getPos();
            byte btag = in.readByte();
            this.traceln(i18n.getString("jdec.trace.CP_entry", i, btag));
            this.types[i] = btag;
            Tables.ConstType tg = Tables.tag(btag);
            switch (tg) {
                case CONSTANT_UTF8: {
                    this.cpool[i] = in.readUTF();
                    continue block12;
                }
                case CONSTANT_INTEGER: {
                    int v1 = in.readInt();
                    this.cpool[i] = v1;
                    continue block12;
                }
                case CONSTANT_FLOAT: {
                    int v1 = Float.floatToIntBits(in.readFloat());
                    this.cpool[i] = v1;
                    continue block12;
                }
                case CONSTANT_LONG: {
                    long lv = in.readLong();
                    this.cpool[i] = lv;
                    ++i;
                    continue block12;
                }
                case CONSTANT_DOUBLE: {
                    long lv = Double.doubleToLongBits(in.readDouble());
                    this.cpool[i] = lv;
                    ++i;
                    continue block12;
                }
                case CONSTANT_CLASS: 
                case CONSTANT_STRING: 
                case CONSTANT_MODULE: 
                case CONSTANT_PACKAGE: {
                    int v1 = in.readUnsignedShort();
                    this.cpool[i] = v1;
                    continue block12;
                }
                case CONSTANT_INTERFACEMETHOD: 
                case CONSTANT_FIELD: 
                case CONSTANT_METHOD: 
                case CONSTANT_NAMEANDTYPE: {
                    this.cpool[i] = "#" + in.readUnsignedShort() + " #" + in.readUnsignedShort();
                    continue block12;
                }
                case CONSTANT_DYNAMIC: 
                case CONSTANT_INVOKEDYNAMIC: {
                    this.cpool[i] = in.readUnsignedShort() + "s #" + in.readUnsignedShort();
                    continue block12;
                }
                case CONSTANT_METHODHANDLE: {
                    this.cpool[i] = in.readUnsignedByte() + "b #" + in.readUnsignedShort();
                    continue block12;
                }
                case CONSTANT_METHODTYPE: {
                    this.cpool[i] = "#" + in.readUnsignedShort();
                    continue block12;
                }
                default: {
                    this.CPlen = i;
                    this.printCP(this.out);
                    this.out_println(this.toHex(btag, 1) + "; // invalid constant type: " + btag + " for element " + i);
                    throw new ClassFormatError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCP(PrintWriter out) {
        int length = this.CPlen;
        this.startArrayCmt(length, "Constant Pool");
        this.out_println("; // first element is empty");
        try {
            int size;
            for (int i = 1; i < length; i += size) {
                String valstr;
                size = 1;
                byte btag = this.types[i];
                Tables.ConstType tg = Tables.tag(btag);
                int pos = this.cpe_pos[i];
                if (tg == null) {
                    throw new Error("Can't get a tg representing the type of Constant in the Constant Pool at: " + i);
                }
                String tagstr = tg.parseKey();
                switch (tg) {
                    case CONSTANT_UTF8: {
                        tagstr = "Utf8";
                        valstr = StringUtils.Utf8ToString((String)this.cpool[i]);
                        break;
                    }
                    case CONSTANT_INTEGER: 
                    case CONSTANT_FLOAT: {
                        int v1 = (Integer)this.cpool[i];
                        valstr = this.toHex(v1, 4);
                        break;
                    }
                    case CONSTANT_LONG: 
                    case CONSTANT_DOUBLE: {
                        long lv = (Long)this.cpool[i];
                        valstr = this.toHex(lv, 8) + ";";
                        size = 2;
                        break;
                    }
                    case CONSTANT_CLASS: 
                    case CONSTANT_STRING: 
                    case CONSTANT_MODULE: 
                    case CONSTANT_PACKAGE: {
                        int v1 = (Integer)this.cpool[i];
                        valstr = "#" + v1;
                        break;
                    }
                    case CONSTANT_INTERFACEMETHOD: 
                    case CONSTANT_FIELD: 
                    case CONSTANT_METHOD: 
                    case CONSTANT_NAMEANDTYPE: 
                    case CONSTANT_DYNAMIC: 
                    case CONSTANT_INVOKEDYNAMIC: 
                    case CONSTANT_METHODHANDLE: 
                    case CONSTANT_METHODTYPE: {
                        valstr = (String)this.cpool[i];
                        break;
                    }
                    default: {
                        throw new Error("invalid constant type: " + btag);
                    }
                }
                this.out_print(tagstr + " " + valstr + "; // #" + i);
                if (this.printDetails) {
                    this.out_println(" at " + this.toHex(pos));
                    continue;
                }
                out.println();
            }
        }
        finally {
            this.out_end("} // Constant Pool");
            out.println();
        }
    }

    private String getStringPos() {
        return " at " + this.toHex(this.countedin.getPos());
    }

    private String getCommentPosCond() {
        if (this.printDetails) {
            return " // " + this.getStringPos();
        }
        return "";
    }

    private void decodeCPXAttr(DataInputStream in, int len, String attrname, PrintWriter out) throws IOException {
        this.decodeCPXAttrM(in, len, attrname, out, 1);
    }

    private void decodeCPXAttrM(DataInputStream in, int len, String attrname, PrintWriter out, int expectedIndices) throws IOException {
        if (len != expectedIndices * 2) {
            this.out_println("// invalid length of " + attrname + " attr: " + len + " (should be " + expectedIndices * 2 + ") > ");
            this.printBytes(out, in, len);
        } else {
            StringBuilder outputString = new StringBuilder();
            for (int k = 1; k <= expectedIndices; ++k) {
                outputString.append("#").append(in.readUnsignedShort()).append("; ");
                if (k % 16 != 0) continue;
                this.out_println(outputString.toString().replaceAll("\\s+$", ""));
                outputString = new StringBuilder();
            }
            if (outputString.length() > 0) {
                this.out_println(outputString.toString().replaceAll("\\s+$", ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackMap(DataInputStream in, int elementsNum) throws IOException {
        int num = elementsNum > 0 ? elementsNum : in.readUnsignedShort();
        this.out.print(this.startArray(num) + (elementsNum > 0 ? "z" : "") + "{");
        try {
            for (int k = 0; k < num; ++k) {
                String maptypeImg;
                int maptype = in.readUnsignedByte();
                Tables.StackMapType mptyp = Tables.stackMapType(maptype, this.out);
                if (this.printDetails) {
                    maptypeImg = maptype + "b";
                } else {
                    try {
                        maptypeImg = mptyp.parsekey();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        maptypeImg = "/* BAD TYPE: */ " + maptype + "b";
                    }
                }
                switch (mptyp) {
                    case ITEM_Object: 
                    case ITEM_NewObject: {
                        maptypeImg = maptypeImg + "," + in.readUnsignedShort();
                        break;
                    }
                    case ITEM_UNKNOWN: {
                        maptypeImg = maptype + "b";
                        break;
                    }
                }
                this.out.print(maptypeImg);
                if (k >= num - 1) continue;
                this.out.print("; ");
            }
        }
        finally {
            this.out.print("}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeTargetTypeAndRefInfo(DataInputStream in) throws IOException {
        int i;
        int tt = in.readUnsignedByte();
        TypeAnnotationTypes.ETargetType targetType = TypeAnnotationTypes.ETargetType.getTargetType(tt);
        if (targetType == null) {
            throw new Error("Type annotation: invalid target_type(u1) " + tt);
        }
        TypeAnnotationTypes.ETargetInfo targetInfo = targetType.targetInfo();
        this.out_println(this.toHex(tt, 1) + ";  //  target_type: " + targetType.parseKey());
        switch (targetInfo) {
            case TYPEPARAM: {
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  param_index");
                break;
            }
            case SUPERTYPE: {
                this.out_println(this.toHex(in.readUnsignedShort(), 2) + ";  //  type_index");
                break;
            }
            case TYPEPARAM_BOUND: {
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  param_index");
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  bound_index");
                break;
            }
            case EMPTY: {
                break;
            }
            case METHODPARAM: {
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  parameter_index");
                break;
            }
            case EXCEPTION: {
                this.out_println(in.readUnsignedShort() + ";  //  type_index");
                break;
            }
            case LOCALVAR: {
                int lv_num = in.readUnsignedShort();
                this.startArrayCmt(lv_num, "local_variables");
                try {
                    for (i = 0; i < lv_num; ++i) {
                        this.out_println(in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                    }
                    break;
                }
                finally {
                    this.out_end("}");
                }
            }
            case CATCH: {
                this.out_println(in.readUnsignedShort() + ";  //  exception_table_index");
                break;
            }
            case OFFSET: {
                this.out_println(in.readUnsignedShort() + ";  //  offset");
                break;
            }
            case TYPEARG: {
                this.out_println(in.readUnsignedShort() + ";  //  offset");
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  type_index");
                break;
            }
            default: {
                this.out_println(this.toHex(tt, 1) + "; // invalid target_info: " + tt);
                throw new ClassFormatError();
            }
        }
        int path_length = in.readUnsignedByte();
        this.startArrayCmtB(path_length, "type_paths");
        try {
            for (i = 0; i < path_length; ++i) {
                this.out_println("{ " + this.toHex(in.readUnsignedByte(), 1) + "; " + this.toHex(in.readUnsignedByte(), 1) + "; } // type_path[" + i + "]");
            }
        }
        finally {
            this.out_end("}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeElementValue(DataInputStream in, PrintWriter out) throws IOException {
        this.out_begin("{  //  element_value");
        try {
            char tg = (char)in.readByte();
            Tables.AnnotElemType tag = Tables.annotElemType(tg);
            if (tag != Tables.AnnotElemType.AE_UNKNOWN) {
                this.out_println("'" + tg + "';");
            }
            switch (tag) {
                case AE_BYTE: 
                case AE_CHAR: 
                case AE_DOUBLE: 
                case AE_FLOAT: 
                case AE_INT: 
                case AE_LONG: 
                case AE_SHORT: 
                case AE_BOOLEAN: 
                case AE_STRING: {
                    this.decodeCPXAttr(in, 2, "const_value_index", out);
                    return;
                }
                case AE_ENUM: {
                    this.out_begin("{  //  enum_const_value");
                    this.decodeCPXAttr(in, 2, "type_name_index", out);
                    this.decodeCPXAttr(in, 2, "const_name_index", out);
                    this.out_end("}  //  enum_const_value");
                    return;
                }
                case AE_CLASS: {
                    this.decodeCPXAttr(in, 2, "class_info_index", out);
                    return;
                }
                case AE_ANNOTATION: {
                    this.decodeAnnotation(in, out);
                    return;
                }
                case AE_ARRAY: {
                    int ev_num = in.readUnsignedShort();
                    this.startArrayCmt(ev_num, "array_value");
                    try {
                        for (int i = 0; i < ev_num; ++i) {
                            this.decodeElementValue(in, out);
                            if (i >= ev_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}  //  array_value");
                    }
                }
                default: {
                    String msg = "invalid element_value" + (this.isPrintableChar(tg) ? " tag type : " + tg : "");
                    this.out_println(this.toHex(tg, 1) + "; // " + msg);
                    throw new ClassFormatError(msg);
                }
            }
        }
        finally {
            this.out_end("}  //  element_value");
        }
    }

    public boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAnnotation(DataInputStream in, PrintWriter out) throws IOException {
        this.out_begin("{  //  annotation");
        try {
            this.decodeCPXAttr(in, 2, "field descriptor", out);
            int evp_num = in.readUnsignedShort();
            this.decodeElementValuePairs(evp_num, in, out);
        }
        finally {
            this.out_end("}  //  annotation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeElementValuePairs(int count, DataInputStream in, PrintWriter out) throws IOException {
        this.startArrayCmt(count, "element_value_pairs");
        try {
            for (int i = 0; i < count; ++i) {
                this.out_begin("{  //  element value pair");
                try {
                    this.decodeCPXAttr(in, 2, "name of the annotation type element", out);
                    this.decodeElementValue(in, out);
                    continue;
                }
                finally {
                    this.out_end("}  //  element value pair");
                    if (i < count - 1) {
                        this.out_println(";");
                    }
                }
            }
        }
        finally {
            this.out_end("}  //  element_value_pairs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeInfo(DataInputStream in, PrintWriter out, String elementName, boolean hasAccessFlag) throws IOException {
        this.out_begin("{  // " + elementName + (this.printDetails ? this.getStringPos() : ""));
        try {
            if (hasAccessFlag) {
                this.out_println(this.toHex(in.readShort(), 2) + "; // access");
            }
            this.printUtf8InfoIndex(in.readUnsignedShort(), "name_index");
            this.printUtf8InfoIndex(in.readUnsignedShort(), "descriptor_index");
            this.decodeAttrs(in, out);
        }
        finally {
            this.out_end("}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeTypeAnnotation(DataInputStream in, PrintWriter out) throws IOException {
        this.out_begin("{  //  type_annotation");
        try {
            this.decodeTargetTypeAndRefInfo(in);
            this.decodeCPXAttr(in, 2, "field descriptor", out);
            int evp_num = in.readUnsignedShort();
            this.decodeElementValuePairs(evp_num, in, out);
        }
        finally {
            this.out_end("}  //  type_annotation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeBootstrapMethod(DataInputStream in) throws IOException {
        this.out_begin("{  //  bootstrap_method");
        try {
            this.out_println("#" + in.readUnsignedShort() + "; // bootstrap_method_ref");
            int bm_args_cnt = in.readUnsignedShort();
            this.startArrayCmt(bm_args_cnt, "bootstrap_arguments");
            try {
                for (int i = 0; i < bm_args_cnt; ++i) {
                    this.out_println("#" + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                }
            }
            finally {
                this.out_end("}  //  bootstrap_arguments");
            }
        }
        finally {
            this.out_end("}  //  bootstrap_method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeAttr(DataInputStream in, PrintWriter out) throws IOException {
        String posComment = this.getStringPos();
        int name_cpx = in.readUnsignedShort();
        String AttrName = "";
        try {
            byte btag = this.types[name_cpx];
            Tables.ConstType tag = Tables.tag(btag);
            if (tag == Tables.ConstType.CONSTANT_UTF8) {
                AttrName = (String)this.cpool[name_cpx];
            }
        }
        catch (ArrayIndexOutOfBoundsException tag) {
            // empty catch block
        }
        Tables.AttrTag tg = Tables.attrtag(AttrName);
        String endingComment = AttrName;
        int len = in.readInt();
        this.countedin.enter(len);
        try {
            if (this.printDetails) {
                this.out_begin("Attr(#" + name_cpx + ", " + len + ") { // " + AttrName + posComment);
            } else {
                this.out_begin("Attr(#" + name_cpx + ") { // " + AttrName);
            }
            switch (tg) {
                case ATT_Code: {
                    this.out_println(in.readUnsignedShort() + "; // max_stack");
                    this.out_println(in.readUnsignedShort() + "; // max_locals");
                    int code_len = in.readInt();
                    this.out_begin("Bytes" + this.startArray(code_len) + "{");
                    try {
                        this.printBytes(out, in, code_len);
                    }
                    finally {
                        this.out_end("}");
                    }
                    int trap_num = in.readUnsignedShort();
                    this.startArrayCmt(trap_num, "Traps");
                    try {
                        for (int i = 0; i < trap_num; ++i) {
                            this.out_println(in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                    }
                    finally {
                        this.out_end("} // end Traps");
                    }
                    this.decodeAttrs(in, out);
                    return;
                }
                case ATT_Exceptions: {
                    int count = in.readUnsignedShort();
                    this.startArrayCmt(count, AttrName);
                    try {
                        for (int i = 0; i < count; ++i) {
                            this.out_println("#" + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_LineNumberTable: {
                    int ll_num = in.readUnsignedShort();
                    this.startArrayCmt(ll_num, "line_number_table");
                    try {
                        for (int i = 0; i < ll_num; ++i) {
                            this.out_println(in.readUnsignedShort() + "  " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_LocalVariableTable: 
                case ATT_LocalVariableTypeTable: {
                    int lvt_num = in.readUnsignedShort();
                    this.startArrayCmt(lvt_num, AttrName);
                    try {
                        for (int i = 0; i < lvt_num; ++i) {
                            this.out_println(in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_InnerClasses: {
                    int ic_num = in.readUnsignedShort();
                    this.startArrayCmt(ic_num, "classes");
                    try {
                        for (int i = 0; i < ic_num; ++i) {
                            this.out_println("#" + in.readUnsignedShort() + " #" + in.readUnsignedShort() + " #" + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_StackMap: {
                    int e_num = in.readUnsignedShort();
                    this.startArrayCmt(e_num, "");
                    try {
                        for (int k = 0; k < e_num; ++k) {
                            int start_pc = in.readUnsignedShort();
                            this.out_print("" + start_pc + ", ");
                            this.printStackMap(in, 0);
                            out.print(", ");
                            this.printStackMap(in, 0);
                            out.println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_StackMapTable: {
                    int et_num = in.readUnsignedShort();
                    this.startArrayCmt(et_num, "");
                    try {
                        block96: for (int k = 0; k < et_num; ++k) {
                            int frame_type = in.readUnsignedByte();
                            Tables.StackMapFrameType ftype = Tables.stackMapFrameType(frame_type);
                            switch (ftype) {
                                case SAME_FRAME: {
                                    this.out_print("" + frame_type + "b");
                                    out.println("; // same_frame");
                                    continue block96;
                                }
                                case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                                    this.out_print("" + frame_type + "b, ");
                                    this.printStackMap(in, 1);
                                    out.println("; // same_locals_1_stack_item_frame");
                                    continue block96;
                                }
                                case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                                    int noffset = in.readUnsignedShort();
                                    this.out_print("" + frame_type + "b, " + noffset + ", ");
                                    this.printStackMap(in, 1);
                                    out.println("; // same_locals_1_stack_item_frame_extended");
                                    continue block96;
                                }
                                case CHOP_1_FRAME: 
                                case CHOP_2_FRAME: 
                                case CHOP_3_FRAME: {
                                    int coffset = in.readUnsignedShort();
                                    this.out_print("" + frame_type + "b, " + coffset);
                                    out.println("; // chop_frame " + (251 - frame_type));
                                    continue block96;
                                }
                                case SAME_FRAME_EX: {
                                    int xoffset = in.readUnsignedShort();
                                    this.out_print("" + frame_type + "b, " + xoffset);
                                    out.println("; // same_frame_extended");
                                    continue block96;
                                }
                                case APPEND_FRAME: {
                                    int aoffset = in.readUnsignedShort();
                                    this.out_print("" + frame_type + "b, " + aoffset + ", ");
                                    this.printStackMap(in, frame_type - 251);
                                    out.println("; // append_frame " + (frame_type - 251));
                                    continue block96;
                                }
                                case FULL_FRAME: {
                                    int foffset = in.readUnsignedShort();
                                    this.out_print("" + frame_type + "b, " + foffset + ", ");
                                    this.printStackMap(in, 0);
                                    out.print(", ");
                                    this.printStackMap(in, 0);
                                    out.println("; // full_frame");
                                }
                            }
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_EnclosingMethod: {
                    this.decodeCPXAttrM(in, len, AttrName, out, 2);
                    return;
                }
                case ATT_AnnotationDefault: {
                    this.decodeElementValue(in, out);
                    return;
                }
                case ATT_RuntimeInvisibleAnnotations: 
                case ATT_RuntimeVisibleAnnotations: {
                    int an_num = in.readUnsignedShort();
                    this.startArrayCmt(an_num, "annotations");
                    try {
                        for (int i = 0; i < an_num; ++i) {
                            this.decodeAnnotation(in, out);
                            if (i >= an_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_RuntimeInvisibleTypeAnnotations: 
                case ATT_RuntimeVisibleTypeAnnotations: {
                    int ant_num = in.readUnsignedShort();
                    this.startArrayCmt(ant_num, "annotations");
                    try {
                        for (int i = 0; i < ant_num; ++i) {
                            this.decodeTypeAnnotation(in, out);
                            if (i >= ant_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_RuntimeInvisibleParameterAnnotations: 
                case ATT_RuntimeVisibleParameterAnnotations: {
                    int pm_num = in.readUnsignedByte();
                    this.startArrayCmtB(pm_num, "parameters");
                    try {
                        for (int k = 0; k < pm_num; ++k) {
                            int anp_num = in.readUnsignedShort();
                            this.startArrayCmt(anp_num, "annotations");
                            try {
                                for (int i = 0; i < anp_num; ++i) {
                                    this.decodeAnnotation(in, out);
                                    if (k >= anp_num - 1) continue;
                                    this.out_println(";");
                                }
                            }
                            finally {
                                this.out_end("}");
                            }
                            if (k >= pm_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_BootstrapMethods: {
                    int bm_num = in.readUnsignedShort();
                    this.startArrayCmt(bm_num, "bootstrap_methods");
                    try {
                        for (int i = 0; i < bm_num; ++i) {
                            this.decodeBootstrapMethod(in);
                            if (i >= bm_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_Module: {
                    this.decodeModule(in);
                    return;
                }
                case ATT_TargetPlatform: {
                    this.decodeCPXAttrM(in, len, AttrName, out, 3);
                    return;
                }
                case ATT_ModulePackages: {
                    int p_num = in.readUnsignedShort();
                    this.startArrayCmt(p_num, null);
                    try {
                        this.decodeCPXAttrM(in, len - 2, AttrName, out, p_num);
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_MethodParameters: {
                    int pcount = in.readUnsignedByte();
                    this.startArrayCmtB(pcount, AttrName);
                    try {
                        for (int i = 0; i < pcount; ++i) {
                            this.out_println("#" + in.readUnsignedShort() + "  " + this.toHex(in.readUnsignedShort(), 2) + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_Record: {
                    int ncomps = in.readUnsignedShort();
                    this.startArrayCmt(ncomps, "components");
                    try {
                        for (int i = 0; i < ncomps; ++i) {
                            this.decodeInfo(in, out, "component", false);
                            if (i >= ncomps - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_ConstantValue: 
                case ATT_Signature: 
                case ATT_SourceFile: {
                    this.decodeCPXAttr(in, len, AttrName, out);
                    return;
                }
                case ATT_NestHost: {
                    this.decodeTypes(in, out, 1);
                    return;
                }
                case ATT_NestMembers: 
                case ATT_PermittedSubtypes: {
                    int nsubtypes = in.readUnsignedShort();
                    this.startArrayCmt(nsubtypes, "classes");
                    try {
                        this.decodeTypes(in, out, nsubtypes);
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                default: {
                    this.printBytes(out, in, len);
                    if (AttrName != null) return;
                    endingComment = "Attr(#" + name_cpx + ")";
                    return;
                }
            }
        }
        catch (EOFException e) {
            out.println("// ======== unexpected end of attribute array");
            return;
        }
        finally {
            int rest = this.countedin.available();
            if (rest > 0) {
                out.println("// ======== attribute array started " + posComment + " has " + rest + " bytes more:");
                this.printBytes(out, in, rest);
            }
            this.out_end("} // end " + endingComment);
            this.countedin.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeModuleStatement(String statementName, DataInputStream in) throws IOException {
        int count = in.readUnsignedShort();
        this.startArrayCmt(count, statementName);
        try {
            for (int i = 0; i < count; ++i) {
                int index = in.readUnsignedShort();
                int nFlags = in.readUnsignedShort();
                String sFlags = this.printDetails ? Module.Modifier.getStatementFlags(nFlags) : "";
                this.out_println("#" + index + " " + this.toHex(nFlags, 2) + (sFlags.isEmpty() ? "" : " // [ " + sFlags + " ]"));
                int exports_to_count = in.readUnsignedShort();
                this.startArrayCmt(exports_to_count, null);
                try {
                    for (int j = 0; j < exports_to_count; ++j) {
                        this.out_println("#" + in.readUnsignedShort() + ";");
                    }
                    continue;
                }
                finally {
                    this.out_end("};");
                }
            }
        }
        finally {
            this.out_end("} // " + statementName + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeModule(DataInputStream in) throws IOException {
        int i;
        int index = in.readUnsignedShort();
        this.entityName = (String)this.cpool[(Integer)this.cpool[index]];
        this.out_print("#" + index + "; // ");
        if (this.printDetails) {
            this.out.println(String.format("%-16s", "name_index") + " : " + this.entityName);
        } else {
            this.out.println("name_index");
        }
        int moduleFlags = in.readUnsignedShort();
        this.out_print(this.toHex(moduleFlags, 2) + "; // flags");
        if (this.printDetails) {
            this.out_print(" " + Module.Modifier.getModuleFlags(moduleFlags));
        }
        this.out.println();
        int versionIndex = in.readUnsignedShort();
        this.out_println("#" + versionIndex + "; // version");
        int count = in.readUnsignedShort();
        this.startArrayCmt(count, "requires");
        try {
            for (i = 0; i < count; ++i) {
                index = in.readUnsignedShort();
                int nFlags = in.readUnsignedShort();
                versionIndex = in.readUnsignedShort();
                String sFlags = this.printDetails ? Module.Modifier.getStatementFlags(nFlags) : "";
                this.out_println("#" + index + " " + this.toHex(nFlags, 2) + " #" + versionIndex + ";" + (sFlags.isEmpty() ? "" : " // " + sFlags));
            }
        }
        finally {
            this.out_end("} // requires\n");
        }
        this.decodeModuleStatement("exports", in);
        this.decodeModuleStatement("opens", in);
        count = in.readUnsignedShort();
        this.startArrayCmt(count, "uses");
        try {
            for (i = 0; i < count; ++i) {
                this.out_println("#" + in.readUnsignedShort() + ";");
            }
        }
        finally {
            this.out_end("} // uses\n");
        }
        count = in.readUnsignedShort();
        this.startArrayCmt(count, "provides");
        try {
            for (i = 0; i < count; ++i) {
                this.out_println("#" + in.readUnsignedShort());
                int provides_with_count = in.readUnsignedShort();
                this.startArrayCmt(provides_with_count, null);
                try {
                    for (int j = 0; j < provides_with_count; ++j) {
                        this.out_println("#" + in.readUnsignedShort() + ";");
                    }
                    continue;
                }
                finally {
                    this.out_end("};");
                }
            }
        }
        finally {
            this.out_end("} // provides\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAttrs(DataInputStream in, PrintWriter out) throws IOException {
        int attr_num = in.readUnsignedShort();
        this.startArrayCmt(attr_num, "Attributes");
        try {
            for (int i = 0; i < attr_num; ++i) {
                this.decodeAttr(in, out);
                if (i + 1 >= attr_num) continue;
                this.out_println(";");
            }
        }
        finally {
            this.out_end("} // Attributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeMembers(DataInputStream in, PrintWriter out, String groupName, String elementName) throws IOException {
        int count = in.readUnsignedShort();
        this.traceln(groupName + "=" + count);
        this.startArrayCmt(count, groupName);
        try {
            for (int i = 0; i < count; ++i) {
                this.decodeInfo(in, out, elementName, true);
                if (i + 1 >= count) continue;
                this.out_println(";");
            }
        }
        finally {
            this.out_end("} // " + groupName);
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decodeClass(String fileName) throws IOException {
        try {
            int magic = this.in.readInt();
            int min_version = this.in.readUnsignedShort();
            int version = this.in.readUnsignedShort();
            this.readCP(this.in);
            short access = this.in.readShort();
            int this_cpx = this.in.readUnsignedShort();
            try {
                this.entityName = (String)this.cpool[(Integer)this.cpool[this_cpx]];
                if (this.entityName.equals("module-info")) {
                    this.entityType = "module";
                    this.entityName = "";
                } else {
                    this.entityType = "class";
                }
                if (!(this.entityName.isEmpty() || JcodTokens.keyword_token_ident(this.entityName) == JcodTokens.Token.IDENT && JcodTokens.constValue(this.entityName) == -1)) {
                    this.out_begin(String.format("file \"%s.class\" {", this.entityName));
                } else {
                    this.out_begin(String.format("%s %s {", this.entityType, this.entityName));
                }
            }
            catch (Exception e) {
                this.entityName = fileName;
                this.out.println("// " + e.getMessage() + " while accessing entityName");
                this.out_begin(String.format("%s %s { // source file name", this.entityType, this.entityName));
            }
            this.out_print(this.toHex(magic, 4) + ";");
            if (magic != -889275714) {
                this.out.print(" // wrong magic: 0x" + Integer.toString(-889275714, 16) + " expected");
            }
            this.out.println();
            this.out_println(min_version + "; // minor version");
            this.out_println(version + "; // version");
            this.printCP(this.out);
            this.out_println(this.toHex(access, 2) + "; // access" + (this.printDetails ? " [" + (" " + Modifiers.accessString(access, Tables.CF_Context.CTX_CLASS).toUpperCase()).replaceAll(" (\\S)", " ACC_$1") + "]" : ""));
            this.out_println("#" + this_cpx + ";// this_cpx");
            int super_cpx = this.in.readUnsignedShort();
            this.out_println("#" + super_cpx + ";// super_cpx");
            this.traceln(i18n.getString("jdec.trace.access_thisCpx_superCpx", access, this_cpx, super_cpx));
            this.out.println();
            int numinterfaces = this.in.readUnsignedShort();
            this.traceln(i18n.getString("jdec.trace.numinterfaces", (Object)numinterfaces));
            this.startArrayCmt(numinterfaces, "Interfaces");
            try {
                this.decodeTypes(this.in, this.out, numinterfaces);
            }
            finally {
                this.out_end("} // Interfaces\n");
            }
            this.decodeMembers(this.in, this.out, "Fields", "field");
            this.decodeMembers(this.in, this.out, "Methods", "method");
            this.decodeAttrs(this.in, this.out);
        }
        catch (EOFException magic) {
            this.out_end(String.format("} // end %s %s", this.entityType, this.entityName));
        }
        catch (ClassFormatError err) {
            try {
                String msg = err.getMessage();
                this.out.println("//------- ClassFormatError" + (msg == null || msg.isEmpty() ? "" : ": " + msg));
                this.printRestOfBytes();
            }
            catch (Throwable throwable) {
                this.out_end(String.format("} // end %s %s", this.entityType, this.entityName));
                throw throwable;
            }
            this.out_end(String.format("} // end %s %s", this.entityType, this.entityName));
        }
        this.out_end(String.format("} // end %s %s", this.entityType, this.entityName));
    }

    private void decodeTypes(DataInputStream in, PrintWriter out, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int type_cpx = in.readUnsignedShort();
            this.traceln(i18n.getString("jdec.trace.type", i, type_cpx));
            this.out_print("#" + type_cpx + ";");
            if (this.printDetails) {
                String name = (String)this.cpool[(Integer)this.cpool[type_cpx]];
                out.println(" // " + name + this.getStringPos());
                continue;
            }
            out.println();
        }
    }

    public void trace(String s) {
        if (!this.DebugFlag) {
            return;
        }
        System.out.print(s);
    }

    public void traceln(String s) {
        if (!this.DebugFlag) {
            return;
        }
        System.out.println(s);
    }
}

