/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Options;

public class ClassArrayData {
    String name;
    ClassData cls;
    int[] classes;
    private Options options = Options.OptionObject();

    protected ClassArrayData(ClassData cls, String attrName) {
        this.cls = cls;
        this.name = attrName;
    }

    public ClassArrayData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        int number_of_classes = in.readUnsignedShort();
        if (attribute_length != 2 + number_of_classes * 2) {
            throw new ClassFormatError(this.name + "_attribute: Invalid attribute length");
        }
        this.classes = new int[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.classes[i] = in.readUnsignedShort();
        }
        return this;
    }

    public void print() {
        String indexes = "";
        String names = "";
        boolean pr_cpx = this.options.contains(Options.PR.CPX);
        this.cls.out.print(this.name + " ");
        for (int i = 0; i < this.classes.length; ++i) {
            if (pr_cpx) {
                indexes = indexes + (indexes.isEmpty() ? "" : ", ") + "#" + this.classes[i];
            }
            names = names + (names.isEmpty() ? "" : ", ") + this.cls.pool.StringValue(this.classes[i]);
        }
        if (pr_cpx) {
            this.cls.out.print(indexes + "; // ");
        }
        this.cls.out.print(names);
        if (pr_cpx) {
            this.cls.out.println();
        } else {
            this.cls.out.println(";");
        }
    }
}

