/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.StackMapData;
import org.openjdk.asmtools.jdis.TraceUtils;
import org.openjdk.asmtools.jdis.TrapData;
import org.openjdk.asmtools.jdis.TypeAnnotationData;
import org.openjdk.asmtools.jdis.Utils;
import org.openjdk.asmtools.jdis.iAtt;

public class CodeData
extends Indenter {
    protected byte[] code;
    protected int max_stack;
    protected int max_locals;
    protected ArrayList<AttrData> attrs = new ArrayList(0);
    protected ClassData cls;
    protected MethodData meth;
    private ArrayList<TrapData> trap_table = new ArrayList(0);
    private ArrayList<LineNumData> lin_num_tb = new ArrayList(0);
    private ArrayList<LocVarData> loc_var_tb = new ArrayList(0);
    private ArrayList<StackMapData> stack_map = null;
    private ArrayList<TypeAnnotationData> visibleTypeAnnotations;
    private ArrayList<TypeAnnotationData> invisibleTypeAnnotations;
    private HashMap<Integer, iAtt> iattrs = new HashMap();
    private PrintWriter out;

    public CodeData(MethodData meth) {
        this.meth = meth;
        this.cls = meth.cls;
        this.out = this.cls.out;
    }

    private static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    private int getbyte(int pc) {
        return this.code[pc];
    }

    private int getUbyte(int pc) {
        return this.code[pc] & 0xFF;
    }

    private int getShort(int pc) {
        return this.code[pc] << 8 | this.code[pc + 1] & 0xFF;
    }

    private int getUShort(int pc) {
        return (this.code[pc] << 8 | this.code[pc + 1] & 0xFF) & 0xFFFF;
    }

    private int getInt(int pc) {
        return this.getShort(pc) << 16 | this.getShort(pc + 2) & 0xFFFF;
    }

    protected iAtt get_iAtt(int pc) {
        Integer PC = pc;
        iAtt res = this.iattrs.get(PC);
        if (res == null) {
            res = new iAtt(this);
            this.iattrs.put(PC, res);
        }
        return res;
    }

    private void readLineNumTable(DataInputStream in) throws IOException {
        int len = in.readInt();
        int numlines = in.readUnsignedShort();
        this.lin_num_tb = new ArrayList(numlines);
        TraceUtils.traceln(3, "CodeAttr:  LineNumTable[" + numlines + "] len=" + len);
        for (int l = 0; l < numlines; ++l) {
            this.lin_num_tb.add(new LineNumData(in));
        }
    }

    private void readLocVarTable(DataInputStream in) throws IOException {
        int len = in.readInt();
        int numlines = in.readUnsignedShort();
        this.loc_var_tb = new ArrayList(numlines);
        TraceUtils.traceln(3, "CodeAttr:  LocalVariableTable[" + numlines + "] len=" + len);
        for (int l = 0; l < numlines; ++l) {
            this.loc_var_tb.add(new LocVarData(in));
        }
    }

    private void readTrapTable(DataInputStream in) throws IOException {
        int trap_table_len = in.readUnsignedShort();
        TraceUtils.traceln(3, "CodeAttr:  TrapTable[" + trap_table_len + "]");
        this.trap_table = new ArrayList(trap_table_len);
        for (int l = 0; l < trap_table_len; ++l) {
            this.trap_table.add(new TrapData(in, l));
        }
    }

    private void readStackMap(DataInputStream in) throws IOException {
        int len = in.readInt();
        int stack_map_len = in.readUnsignedShort();
        TraceUtils.traceln(3, "CodeAttr:  Stack_Map: attrlen=" + len + " num=" + stack_map_len);
        this.stack_map = new ArrayList(stack_map_len);
        StackMapData.prevFramePC = 0;
        for (int k = 0; k < stack_map_len; ++k) {
            this.stack_map.add(new StackMapData(this, in));
        }
    }

    private void readStackMapTable(DataInputStream in) throws IOException {
        int len = in.readInt();
        int stack_map_len = in.readUnsignedShort();
        TraceUtils.traceln(3, "CodeAttr:  Stack_Map_Table: attrlen=" + len + " num=" + stack_map_len);
        this.stack_map = new ArrayList(stack_map_len);
        StackMapData.prevFramePC = 0;
        for (int k = 0; k < stack_map_len; ++k) {
            this.stack_map.add(new StackMapData(this, in, true));
        }
    }

    private void readTypeAnnotations(DataInputStream in, boolean isInvisible) throws IOException {
        int attrLength = in.readInt();
        int count = in.readShort();
        ArrayList<TypeAnnotationData> tannots = new ArrayList<TypeAnnotationData>(count);
        TraceUtils.traceln(3, "CodeAttr:   Runtime" + (isInvisible ? "Inv" : "V") + "isibleTypeAnnotation: attrlen=" + attrLength + " num=" + count);
        for (int index = 0; index < count; ++index) {
            TraceUtils.traceln("\t\t\t[" + index + "]:");
            TypeAnnotationData tannot = new TypeAnnotationData(isInvisible, this.cls);
            tannot.read(in);
            tannots.add(tannot);
        }
        if (isInvisible) {
            this.invisibleTypeAnnotations = tannots;
        } else {
            this.visibleTypeAnnotations = tannots;
        }
    }

    public void read(DataInputStream in, int codeattrlen) throws IOException {
        this.max_stack = in.readUnsignedShort();
        this.max_locals = in.readUnsignedShort();
        int codelen = in.readInt();
        TraceUtils.traceln(3, "CodeAttr:  Codelen=" + codelen + " fulllen=" + codeattrlen + " max_stack=" + this.max_stack + " max_locals=" + this.max_locals);
        this.code = new byte[codelen];
        in.read(this.code, 0, codelen);
        this.readTrapTable(in);
        int nattr = in.readUnsignedShort();
        TraceUtils.traceln(3, "CodeAttr: add.attr:" + nattr);
        block7: for (int k = 0; k < nattr; ++k) {
            int name_cpx = in.readUnsignedShort();
            ConstantPool.Constant name_const = this.cls.pool.getConst(name_cpx);
            if (name_const == null || name_const.tag != ConstantPool.TAG.CONSTANT_UTF8) continue;
            String attrname = this.cls.pool.getString(name_cpx);
            TraceUtils.traceln(3, "CodeAttr:  attr: " + attrname);
            Tables.AttrTag attrtag = Tables.attrtag(attrname);
            switch (attrtag) {
                case ATT_LineNumberTable: {
                    this.readLineNumTable(in);
                    continue block7;
                }
                case ATT_LocalVariableTable: {
                    this.readLocVarTable(in);
                    continue block7;
                }
                case ATT_StackMap: {
                    this.readStackMap(in);
                    continue block7;
                }
                case ATT_StackMapTable: {
                    this.readStackMapTable(in);
                    continue block7;
                }
                case ATT_RuntimeVisibleTypeAnnotations: 
                case ATT_RuntimeInvisibleTypeAnnotations: {
                    this.readTypeAnnotations(in, attrtag == Tables.AttrTag.ATT_RuntimeInvisibleTypeAnnotations);
                    continue block7;
                }
                default: {
                    AttrData attr = new AttrData(this.cls);
                    int attrlen = in.readInt();
                    attr.read(name_cpx, attrlen, in);
                    this.attrs.add(attr);
                }
            }
        }
    }

    private int checkForLabelRef(int pc) {
        int opc = this.getUbyte(pc);
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(opc);
        switch (opcode) {
            case opc_tableswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int low = this.getInt(tb + 4);
                int high = this.getInt(tb + 8);
                int count = high - low;
                for (int i = 0; i <= count; ++i) {
                    this.get_iAtt((int)(pc + this.getInt((int)(tb + 12 + 4 * i)))).referred = true;
                }
                this.get_iAtt((int)(default_skip + pc)).referred = true;
                return tb - pc + 16 + count * 4;
            }
            case opc_lookupswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int npairs = this.getInt(tb + 4);
                for (int i = 1; i <= npairs; ++i) {
                    this.get_iAtt((int)(pc + this.getInt((int)(tb + 4 + i * 8)))).referred = true;
                }
                this.get_iAtt((int)(default_skip + pc)).referred = true;
                return tb - pc + (npairs + 1) * 8;
            }
            case opc_jsr: 
            case opc_goto: 
            case opc_ifeq: 
            case opc_ifge: 
            case opc_ifgt: 
            case opc_ifle: 
            case opc_iflt: 
            case opc_ifne: 
            case opc_if_icmpeq: 
            case opc_if_icmpne: 
            case opc_if_icmpge: 
            case opc_if_icmpgt: 
            case opc_if_icmple: 
            case opc_if_icmplt: 
            case opc_if_acmpeq: 
            case opc_if_acmpne: 
            case opc_ifnull: 
            case opc_ifnonnull: {
                this.get_iAtt((int)(pc + this.getShort((int)(pc + 1)))).referred = true;
                return 3;
            }
            case opc_jsr_w: 
            case opc_goto_w: {
                this.get_iAtt((int)(pc + this.getInt((int)(pc + 1)))).referred = true;
                return 5;
            }
            case opc_wide: 
            case opc_nonpriv: 
            case opc_priv: {
                int opc2 = (opcode.value() << 8) + this.getUbyte(pc + 1);
                opcode = OpcodeTables.opcode(opc2);
            }
        }
        try {
            int opclen = opcode.length();
            return opclen == 0 ? 1 : opclen;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    private void loadLabelTable() {
        for (int pc = 0; pc < this.code.length; pc += this.checkForLabelRef(pc)) {
        }
    }

    private void loadLineNumTable() {
        for (LineNumData entry : this.lin_num_tb) {
            this.get_iAtt((int)entry.start_pc).lnum = entry.line_number;
        }
    }

    private void loadStackMap() {
        Iterator<StackMapData> iterator = this.stack_map.iterator();
        while (iterator.hasNext()) {
            StackMapData entry;
            this.get_iAtt((int)entry.start_pc).stackMapEntry = entry = iterator.next();
        }
    }

    private void loadLocVarTable() {
        for (LocVarData entry : this.loc_var_tb) {
            this.get_iAtt(entry.start_pc).add_var(entry);
            this.get_iAtt(entry.start_pc + entry.length).add_endvar(entry);
        }
    }

    private void loadTrapTable() {
        for (TrapData entry : this.trap_table) {
            this.get_iAtt(entry.start_pc).add_trap(entry);
            this.get_iAtt(entry.end_pc).add_endtrap(entry);
            this.get_iAtt(entry.handler_pc).add_handler(entry);
        }
    }

    private void PrintConstant(int cpx) {
        this.out.print("\t");
        this.cls.pool.PrintConstant(this.out, cpx);
    }

    private void PrintCommentedConstant(int cpx) {
        this.out.print(Utils.commentString(this.cls.pool.ConstantStrValue(cpx)));
    }

    private int printInstr(int pc) {
        boolean pr_cpx = this.meth.options.contains(Options.PR.CPX);
        int opc = this.getUbyte(pc);
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(opc);
        switch (opcode) {
            case opc_nonpriv: 
            case opc_priv: {
                int opc2 = this.getUbyte(pc + 1);
                int finalopc = (opc << 8) + opc2;
                OpcodeTables.Opcode opcode2 = OpcodeTables.opcode(finalopc);
                String mnem = opcode2 == null ? opcode.parsekey() + " " + opc2 : opcode2.parsekey();
                this.out.print(mnem);
                return 2;
            }
            case opc_wide: {
                int opc2 = this.getUbyte(pc + 1);
                int finalopcwide = (opc << 8) + opc2;
                OpcodeTables.Opcode opcode2 = OpcodeTables.opcode(finalopcwide);
                if (opcode2 == null) {
                    this.out.print("bytecode " + (Object)((Object)opcode));
                    return 1;
                }
                String mnem = opcode2.parsekey();
                this.out.print(mnem + " " + this.getUShort(pc + 2));
                if (opcode2 == OpcodeTables.Opcode.opc_iinc_w) {
                    this.out.print(", " + this.getShort(pc + 4));
                    return 6;
                }
                return 4;
            }
        }
        String mnem = opcode.parsekey();
        if (mnem == null) {
            this.out.print("bytecode " + (Object)((Object)opcode));
            return 1;
        }
        if (opcode.value() > OpcodeTables.Opcode.opc_jsr_w.value()) {
            this.out.print("bytecode " + (Object)((Object)opcode));
            return 1;
        }
        this.out.print(opcode.parsekey());
        switch (opcode) {
            case opc_aload: 
            case opc_astore: 
            case opc_fload: 
            case opc_fstore: 
            case opc_iload: 
            case opc_istore: 
            case opc_lload: 
            case opc_lstore: 
            case opc_dload: 
            case opc_dstore: 
            case opc_ret: {
                this.out.print("\t" + this.getUbyte(pc + 1));
                return 2;
            }
            case opc_iinc: {
                this.out.print("\t" + this.getUbyte(pc + 1) + ", " + this.getbyte(pc + 2));
                return 3;
            }
            case opc_tableswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int low = this.getInt(tb + 4);
                int high = this.getInt(tb + 8);
                int count = high - low;
                this.out.print("{ //" + low + " to " + high);
                for (int i = 0; i <= count; ++i) {
                    this.out.print("\n\t\t" + (i + low) + ": " + this.meth.lP + (pc + this.getInt(tb + 12 + 4 * i)) + ";");
                }
                this.out.print("\n\t\tdefault: " + this.meth.lP + (default_skip + pc) + " }");
                return tb - pc + 16 + count * 4;
            }
            case opc_lookupswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int npairs = this.getInt(tb + 4);
                this.out.print("{ //" + npairs);
                for (int i = 1; i <= npairs; ++i) {
                    this.out.print("\n\t\t" + this.getInt(tb + i * 8) + ": " + this.meth.lP + (pc + this.getInt(tb + 4 + i * 8)) + ";");
                }
                this.out.print("\n\t\tdefault: " + this.meth.lP + (default_skip + pc) + " }");
                return tb - pc + (npairs + 1) * 8;
            }
            case opc_newarray: {
                int tp = this.getUbyte(pc + 1);
                Tables.BasicType type = Tables.basictype(tp);
                switch (type) {
                    case T_BOOLEAN: {
                        this.out.print(" boolean");
                        break;
                    }
                    case T_BYTE: {
                        this.out.print(" byte");
                        break;
                    }
                    case T_CHAR: {
                        this.out.print(" char");
                        break;
                    }
                    case T_SHORT: {
                        this.out.print(" short");
                        break;
                    }
                    case T_INT: {
                        this.out.print(" int");
                        break;
                    }
                    case T_LONG: {
                        this.out.print(" long");
                        break;
                    }
                    case T_FLOAT: {
                        this.out.print(" float");
                        break;
                    }
                    case T_DOUBLE: {
                        this.out.print(" double");
                        break;
                    }
                    case T_CLASS: {
                        this.out.print(" class");
                        break;
                    }
                    default: {
                        this.out.print(" BOGUS TYPE:" + (Object)((Object)type));
                    }
                }
                return 2;
            }
            case opc_ldc_w: 
            case opc_ldc2_w: {
                this.cls.pool.setPrintTAG(true);
                int index = this.getUShort(pc + 1);
                if (pr_cpx) {
                    this.out.print("\t#" + index + "; //");
                }
                this.PrintConstant(index);
                this.cls.pool.setPrintTAG(false);
                return 3;
            }
            case opc_anewarray: 
            case opc_instanceof: 
            case opc_checkcast: 
            case opc_new: 
            case opc_putstatic: 
            case opc_getstatic: 
            case opc_putfield: 
            case opc_getfield: 
            case opc_invokevirtual: 
            case opc_invokespecial: 
            case opc_invokestatic: {
                int index = this.getUShort(pc + 1);
                if (pr_cpx) {
                    this.out.print("\t#" + index + "; //");
                }
                this.PrintConstant(index);
                return 3;
            }
            case opc_sipush: {
                this.out.print("\t" + this.getShort(pc + 1));
                return 3;
            }
            case opc_bipush: {
                this.out.print("\t" + this.getbyte(pc + 1));
                return 2;
            }
            case opc_ldc: {
                this.cls.pool.setPrintTAG(true);
                int index = this.getUbyte(pc + 1);
                if (pr_cpx) {
                    this.out.print("\t#" + index + "; //");
                }
                this.PrintConstant(index);
                this.cls.pool.setPrintTAG(false);
                return 2;
            }
            case opc_invokeinterface: {
                int index = this.getUShort(pc + 1);
                int nargs = this.getUbyte(pc + 3);
                if (pr_cpx) {
                    this.out.print("\t#" + index + ",  " + nargs + "; //");
                    this.PrintConstant(index);
                } else {
                    this.PrintConstant(index);
                    this.out.print(",  " + nargs);
                }
                return 5;
            }
            case opc_invokedynamic: {
                this.cls.pool.setPrintTAG(true);
                int index = this.getUShort(pc + 1);
                if (pr_cpx) {
                    this.out.print("\t#" + index + ";\t");
                    this.PrintCommentedConstant(index);
                } else {
                    this.PrintConstant(index);
                }
                this.cls.pool.setPrintTAG(false);
                return 5;
            }
            case opc_multianewarray: {
                int index = this.getUShort(pc + 1);
                int dimensions = this.getUbyte(pc + 3);
                if (pr_cpx) {
                    this.out.print("\t#" + index + ",  " + dimensions + "; //");
                    this.PrintConstant(index);
                } else {
                    this.PrintConstant(index);
                    this.out.print(",  " + dimensions);
                }
                return 4;
            }
            case opc_jsr: 
            case opc_goto: 
            case opc_ifeq: 
            case opc_ifge: 
            case opc_ifgt: 
            case opc_ifle: 
            case opc_iflt: 
            case opc_ifne: 
            case opc_if_icmpeq: 
            case opc_if_icmpne: 
            case opc_if_icmpge: 
            case opc_if_icmpgt: 
            case opc_if_icmple: 
            case opc_if_icmplt: 
            case opc_if_acmpeq: 
            case opc_if_acmpne: 
            case opc_ifnull: 
            case opc_ifnonnull: {
                this.out.print("\t" + this.meth.lP + (pc + this.getShort(pc + 1)));
                return 3;
            }
            case opc_jsr_w: 
            case opc_goto_w: {
                this.out.print("\t" + this.meth.lP + (pc + this.getInt(pc + 1)));
                return 5;
            }
        }
        return 1;
    }

    public void print() throws IOException {
        if (!this.lin_num_tb.isEmpty()) {
            this.loadLineNumTable();
        }
        if (this.stack_map != null) {
            this.loadStackMap();
        }
        if (!this.meth.options.contains(Options.PR.PC)) {
            this.loadLabelTable();
        }
        this.loadTrapTable();
        if (!this.loc_var_tb.isEmpty()) {
            this.loadLocVarTable();
        }
        this.out.println();
        this.out.println("\tstack " + this.max_stack + " locals " + this.max_locals);
        this.meth.printPAnnotations();
        this.out.println(this.getIndentString() + "{");
        iAtt iatt = this.iattrs.get(0);
        for (int pc = 0; pc < this.code.length; pc += this.printInstr(pc)) {
            if (iatt != null) {
                iatt.printBegins();
            } else {
                this.out.print("\t");
            }
            if (this.meth.options.contains(Options.PR.PC)) {
                this.out.print(pc + ":\t");
            } else if (iatt != null && iatt.referred) {
                this.out.print(this.meth.lP + pc + ":\t");
            } else {
                this.out.print("\t");
            }
            if (iatt != null) {
                iatt.printStackMap();
            }
            this.out.println(";");
            iatt = this.iattrs.get(pc);
            if (iatt == null) continue;
            iatt.printEnds();
        }
        if (iatt != null) {
            iatt.printBegins();
            if (iatt.referred) {
                this.out.print(this.meth.lP + this.code.length + ":\t");
            }
            iatt.printStackMap();
            this.out.println();
        }
        if (this.visibleTypeAnnotations != null) {
            this.out.println();
            for (TypeAnnotationData visad : this.visibleTypeAnnotations) {
                visad.print(this.out, this.getIndentString());
                this.out.println();
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            for (TypeAnnotationData invisad : this.invisibleTypeAnnotations) {
                invisad.print(this.out, this.getIndentString());
                this.out.println();
            }
        }
        this.out.println(this.getIndentString() + "}");
    }

    class LineNumData {
        short start_pc;
        short line_number;

        public LineNumData(DataInputStream in) throws IOException {
            this.start_pc = in.readShort();
            this.line_number = in.readShort();
        }
    }

    public static class LocVarData {
        short start_pc;
        short length;
        short name_cpx;
        short sig_cpx;
        short slot;

        public LocVarData(DataInputStream in) throws IOException {
            this.start_pc = in.readShort();
            this.length = in.readShort();
            this.name_cpx = in.readShort();
            this.sig_cpx = in.readShort();
            this.slot = in.readShort();
        }
    }
}

