/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.common.Tool;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.uEscWriter;
import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends Tool {
    private Options options = Options.OptionObject();
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public Main(PrintWriter out, PrintWriter err, String programName) {
        super(out, err, programName);
        this.DebugFlag = () -> this.options.contains(Options.PR.DEBUG);
        this.printCannotReadMsg = fname -> this.error(i18n.getString("jdis.error.cannot_read", fname));
    }

    public Main(PrintStream out, String program) {
        this(new PrintWriter(out), new PrintWriter(System.err), program);
    }

    @Override
    public void usage() {
        this.println(i18n.getString("jdis.usage"));
        this.println(i18n.getString("jdis.opt.g"));
        this.println(i18n.getString("jdis.opt.sl"));
        this.println(i18n.getString("jdis.opt.hx"));
        this.println(i18n.getString("jdis.opt.v"));
        this.println(i18n.getString("jdis.opt.version"));
    }

    public synchronized boolean disasm(String[] argv) {
        ArrayList<String> files = new ArrayList<String>();
        block17: for (int i = 0; i < argv.length; ++i) {
            String arg;
            switch (arg = argv[i]) {
                case "-g": {
                    this.options.setCodeOptions();
                    continue block17;
                }
                case "-v": {
                    this.options.set(Options.PR.DEBUG);
                    continue block17;
                }
                case "-sl": {
                    this.options.set(Options.PR.SRC);
                    continue block17;
                }
                case "-hx": {
                    this.options.set(Options.PR.HEX);
                    continue block17;
                }
                case "-version": {
                    this.out.println(ProductInfo.FULL_VERSION);
                    continue block17;
                }
                default: {
                    if (arg.startsWith("-")) {
                        this.error(i18n.getString("jdis.error.invalid_option", (Object)arg));
                        this.usage();
                        return false;
                    }
                    files.add(arg);
                }
            }
        }
        if (files.isEmpty()) {
            this.usage();
            return false;
        }
        for (String fname : files) {
            if (fname == null) continue;
            try {
                ClassData cc = new ClassData(this.out, this);
                cc.read(fname);
                cc.print();
                continue;
            }
            catch (Error ee) {
                if (this.DebugFlag.getAsBoolean()) {
                    ee.printStackTrace();
                }
                this.error(i18n.getString("jdis.error.fatal_error", (Object)fname));
            }
            catch (Exception ee) {
                if (this.DebugFlag.getAsBoolean()) {
                    ee.printStackTrace();
                }
                this.error(i18n.getString("jdis.error.fatal_exception", (Object)fname));
            }
            return false;
        }
        return true;
    }

    public static void main(String[] argv) {
        Main disassembler = new Main(new PrintWriter(new uEscWriter(System.out)), new PrintWriter(System.err), "jdis");
        boolean result = disassembler.disasm(argv);
        System.exit(result ? 0 : 1);
    }
}

