/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.Options;

public class NestHostData
extends Indenter {
    ClassData cls;
    int host_class_index;
    private Options options = Options.OptionObject();

    public NestHostData(ClassData cls) {
        this.cls = cls;
    }

    public NestHostData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        if (attribute_length != 2) {
            throw new ClassFormatError("ATT_NestHost: Invalid attribute length");
        }
        this.host_class_index = in.readUnsignedShort();
        return this;
    }

    public void print() {
        boolean pr_cpx = this.options.contains(Options.PR.CPX);
        this.cls.out.print(this.getIndentString() + JasmTokens.Token.NESTHOST.parseKey() + " ");
        if (pr_cpx) {
            this.cls.out.print("#" + this.host_class_index + "; //");
        }
        if (pr_cpx) {
            this.cls.pool.PrintConstant(this.cls.out, this.host_class_index);
            this.cls.out.println();
        } else {
            this.cls.out.println(this.cls.pool.StringValue(this.host_class_index) + ";");
        }
    }
}

