/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.StackMapData;
import org.openjdk.asmtools.jdis.TrapData;

class iAtt {
    private Options options;
    short lnum = 0;
    boolean referred = false;
    ArrayList<CodeData.LocVarData> vars;
    ArrayList<CodeData.LocVarData> endvars;
    ArrayList<TrapData> handlers;
    ArrayList<TrapData> traps;
    ArrayList<TrapData> endtraps;
    StackMapData stackMapEntry;
    CodeData code;
    ClassData cls;
    PrintWriter out;

    public iAtt(CodeData code) {
        this.code = code;
        this.cls = code.meth.cls;
        this.out = this.cls.out;
        this.options = this.cls.options;
    }

    void add_var(CodeData.LocVarData var) {
        if (this.vars == null) {
            this.vars = new ArrayList(4);
        }
        this.vars.add(var);
    }

    void add_endvar(CodeData.LocVarData endvar) {
        if (this.endvars == null) {
            this.endvars = new ArrayList(4);
        }
        this.endvars.add(endvar);
    }

    void add_trap(TrapData trap) {
        if (this.traps == null) {
            this.traps = new ArrayList(4);
        }
        this.traps.add(trap);
    }

    void add_endtrap(TrapData endtrap) {
        if (this.endtraps == null) {
            this.endtraps = new ArrayList(4);
        }
        this.endtraps.add(endtrap);
    }

    void add_handler(TrapData endtrap) {
        if (this.handlers == null) {
            this.handlers = new ArrayList(4);
        }
        this.handlers.add(endtrap);
    }

    public void printEnds() throws IOException {
        int len;
        if (this.endvars != null && this.options.contains(Options.PR.VAR)) {
            len = this.endvars.size() - 1;
            this.out.print("\t\tendvar");
            for (CodeData.LocVarData locVarData : this.endvars) {
                this.out.print(" " + locVarData.slot);
                if (len-- <= 0) continue;
                this.out.print(",");
            }
            this.out.println(";");
        }
        if (this.endtraps != null) {
            len = this.endtraps.size() - 1;
            this.out.print("\t\tendtry");
            for (TrapData trapData : this.endtraps) {
                this.out.print(" " + trapData.ident());
                if (len-- <= 0) continue;
                this.out.print(",");
            }
            this.out.println(";");
        }
    }

    public void printBegins() throws IOException {
        boolean bothOpt;
        boolean eitherOpt = this.options.contains(Options.PR.LNT) || this.options.contains(Options.PR.SRC);
        boolean bl = bothOpt = this.options.contains(Options.PR.LNT) && this.options.contains(Options.PR.SRC);
        if (this.lnum != 0 && eitherOpt) {
            if (bothOpt) {
                this.out.println("// " + this.lnum + ": " + this.cls.getSrcLine(this.lnum));
            } else if (this.options.contains(Options.PR.LNT)) {
                this.out.print(this.lnum);
            } else if (this.options.contains(Options.PR.SRC)) {
                this.out.println("// " + this.cls.getSrcLine(this.lnum));
            }
        }
        this.out.print("\t");
        if (this.handlers != null) {
            for (TrapData trapData : this.handlers) {
                this.out.print("\tcatch " + trapData.ident());
                this.out.print(" " + this.cls.pool.getClassName(trapData.catch_cpx) + ";\n\t");
            }
        }
        if (this.traps != null) {
            int len = this.traps.size() - 1;
            this.out.print("\ttry");
            for (TrapData line : this.traps) {
                this.out.print(" " + line.ident());
                if (len-- <= 0) continue;
                this.out.print(",");
            }
            this.out.print(";\n\t");
        }
        if (this.vars != null && this.options.contains(Options.PR.VAR)) {
            for (CodeData.LocVarData locVarData : this.vars) {
                this.out.println("\tvar " + locVarData.slot + "; // " + this.cls.pool.getName(locVarData.name_cpx) + ":" + this.cls.pool.getName(locVarData.sig_cpx));
                this.out.print("\t");
            }
        }
    }

    public void printMapList(int[] map) throws IOException {
        boolean pr_cpx = this.options.contains(Options.PR.CPX);
        for (int k = 0; k < map.length; ++k) {
            int fullmaptype = map[k];
            int mt_val = fullmaptype & 0xFF;
            Tables.StackMapType maptype = Tables.stackMapType(mt_val, this.out);
            int argument = fullmaptype >> 8;
            switch (maptype) {
                case ITEM_Object: {
                    if (pr_cpx) {
                        this.out.print(" #" + argument);
                        break;
                    }
                    this.out.print(" ");
                    this.cls.pool.PrintConstant(this.out, argument);
                    break;
                }
                case ITEM_NewObject: {
                    if (pr_cpx) {
                        this.out.print(" " + mt_val);
                    } else {
                        this.out.print(" " + maptype.printval());
                    }
                    this.out.print(" " + this.code.meth.lP + argument);
                    break;
                }
                default: {
                    if (pr_cpx) {
                        this.out.print(" " + mt_val);
                        break;
                    }
                    this.out.print(" " + maptype.printval());
                }
            }
            this.out.print(k == map.length - 1 ? (char)';' : ',');
        }
    }

    public void printStackMap() throws IOException {
        int[] map;
        if (this.stackMapEntry == null) {
            return;
        }
        boolean printed = false;
        if (this.stackMapEntry.stackFrameType != null) {
            this.out.print(OpcodeTables.Opcode.opc_stack_frame_type.parsekey());
            this.out.print(" " + this.stackMapEntry.stackFrameType.parsekey() + ';');
            this.out.print("\n\t\t");
            printed = true;
        }
        if ((map = this.stackMapEntry.lockMap) != null && map.length > 0) {
            this.out.print(OpcodeTables.Opcode.opc_locals_map.parsekey());
            this.printMapList(map);
            this.out.print("\n\t\t");
            printed = true;
        }
        if ((map = this.stackMapEntry.stackMap) != null && map.length > 0) {
            this.out.print(OpcodeTables.Opcode.opc_stack_map.parsekey());
            this.printMapList(map);
            this.out.print("\n\t\t");
            printed = true;
        }
        if (!printed) {
            this.out.print(OpcodeTables.Opcode.opc_locals_map.parsekey() + " ;\n\t\t");
        }
    }
}

