/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class InetAddressQuestion
extends Question {
    public static final int IPv4 = 0;
    public static final int IPv6 = 1;
    private static final ResourceBundle i18n = Interview.i18n;
    protected InetAddress value;
    private String stringValue;
    private transient String newStringValue;
    private InetAddress[] suggestions;
    private InetAddress defaultValue;
    private boolean valid;
    private int type = 0;
    private int style = 0;

    protected InetAddressQuestion(Interview interview, String tag) {
        super(interview, tag);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected InetAddressQuestion(Interview interview, String tag, int type) {
        super(interview, tag);
        this.setType(type);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected static boolean equal(InetAddress i1, InetAddress i2) {
        return i1 == null ? i2 == null : i1.equals(i2);
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public int getStyle() {
        return this.style;
    }

    protected void setStyle(int style) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException();
        }
        this.style = style;
    }

    public InetAddress[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(InetAddress ... newSuggestions) {
        if (newSuggestions != null) {
            for (int i = 1; i < newSuggestions.length; ++i) {
                if (newSuggestions[i] != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.suggestions = newSuggestions;
    }

    public InetAddress getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(InetAddress v) {
        this.defaultValue = v;
    }

    public InetAddress getValue() {
        return this.value;
    }

    public void setValue(InetAddress newValue) {
        InetAddress oldValue = this.value;
        this.value = newValue;
        this.stringValue = this.newStringValue;
        this.newStringValue = null;
        boolean bl = this.value == null ? false : (this.valid = this.type == 0 ? this.value instanceof Inet4Address : true);
        if (!InetAddressQuestion.equal(this.value, oldValue)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    @Override
    public void setValue(String newValue) throws Interview.Fault {
        InetAddress v = this.parse(newValue);
        this.newStringValue = newValue;
        this.setValue(v);
    }

    public InetAddress getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        if (this.stringValue == null && this.value != null) {
            this.stringValue = this.value.getHostAddress();
        }
        return this.stringValue;
    }

    @Override
    public boolean isValueValid() {
        return this.valid;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    private InetAddress parse(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        boolean seenAlpha = false;
        boolean seenDigit = false;
        boolean seenDot = false;
        boolean seenColon = false;
        int slen = s.length();
        block8: for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    seenDigit = true;
                    continue block8;
                }
                case '.': {
                    seenDot = true;
                    continue block8;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (this.type == 0) {
                        return null;
                    }
                    seenAlpha = true;
                    continue block8;
                }
                case ':': {
                    if (this.type == 0) {
                        return null;
                    }
                    seenColon = true;
                    continue block8;
                }
                default: {
                    return null;
                }
            }
        }
        if (!(this.type != 1 || seenColon || seenDot && seenDigit && !seenAlpha)) {
            return null;
        }
        try {
            return InetAddress.getByName(s);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void save(Map<String, String> data) {
        String s = this.getStringValue();
        if (s != null) {
            data.put(this.tag, s);
        }
    }
}

