/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TestEnvContext {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestEnvContext.class);
    private static boolean debug = Boolean.getBoolean("debug." + TestEnvContext.class.getName());
    private List<Map<String, String>> propTables;
    private String[] propTableNames;
    private String[] envNames;
    private String[] envMenuNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestEnvContext(File ... files) throws Fault {
        ArrayList<String> n = new ArrayList<String>();
        ArrayList<Map<String, String>> p = new ArrayList<Map<String, String>>();
        try {
            if (files != null) {
                for (File f : files) {
                    this.add(p, n, this.load(f), f.getPath());
                }
            }
        }
        finally {
            this.propTables = new ArrayList<Map<String, String>>(p);
            this.propTableNames = n.toArray(new String[n.size()]);
            this.updateEnvTable();
        }
    }

    public TestEnvContext(Map<String, String>[] tables, String ... tableNames) {
        ArrayList<String> n = new ArrayList<String>();
        ArrayList<Map<String, String>> p = new ArrayList<Map<String, String>>();
        for (int i = 0; i < tables.length; ++i) {
            this.add(p, n, tables[i], tableNames[i]);
        }
        this.propTables = new ArrayList<Map<String, String>>(p);
        this.propTableNames = n.toArray(new String[n.size()]);
        this.updateEnvTable();
    }

    public TestEnvContext(Map<String, String> table, String tableName) {
        ArrayList<String> n = new ArrayList<String>();
        ArrayList<Map<String, String>> p = new ArrayList<Map<String, String>>();
        this.add(p, n, table, tableName);
        this.propTables = new ArrayList<Map<String, String>>(p);
        this.propTableNames = n.toArray(new String[n.size()]);
        this.updateEnvTable();
    }

    public TestEnvironment getEnv(String name) throws TestEnvironment.Fault {
        if (this.isValidEnv(name)) {
            return new TestEnvironment(name, this.propTables, this.propTableNames);
        }
        return null;
    }

    public boolean isValidEnv(String name) {
        if (name.isEmpty()) {
            return true;
        }
        for (String envName : this.envNames) {
            if (!envName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getEnvNames() {
        return this.envNames;
    }

    public String[] getEnvMenuNames() {
        return this.envMenuNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> load(File f) throws Fault {
        if (f == null) {
            return null;
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            Map<String, String> p;
            Map<String, String> map = p = PropertyUtils.load(in);
            return map;
        }
        catch (FileNotFoundException e) {
            throw new Fault(i18n, "tec.cantFindFile", (Object)f);
        }
        catch (IOException e) {
            throw new Fault(i18n, "tec.ioError", f, e);
        }
    }

    private void add(List<Map<String, String>> pv, List<String> nv, Map<String, String> p, String n) {
        if (p != null) {
            pv.add(p);
            nv.add(n);
        }
    }

    private void updateEnvTable() {
        List<Map<String, String>> tables = this.propTables;
        String[] tableNames = this.propTableNames;
        List<Map<String, String>> defaultTables = TestEnvironment.defaultPropTables;
        String[] defaultTableNames = TestEnvironment.defaultPropTableNames;
        if (defaultTables != null && defaultTables.size() > 0) {
            ArrayList<Map<String, String>> newTables = new ArrayList<Map<String, String>>(defaultTables);
            if (tables != null) {
                newTables.addAll(tables);
            }
            tables = newTables;
            tableNames = DynamicArray.join(defaultTableNames, tableNames);
        }
        Vector<String> allVec = new Vector<String>();
        Vector<String> menuExcludeVec = new Vector<String>();
        String ENV_DOT = "env.";
        String DOT_DESCRIPTION = ".description";
        String DOT_FINDER = ".finder";
        String DOT_SCRIPT = ".script";
        String DOT_SCRIPT_DOT = ".script.";
        String DOT_INHERITS = ".inherits";
        String DOT_MENU = ".menu";
        String DOT_TESTSUITE = ".testsuite";
        if (debug) {
            System.err.println(this.getClass().getName() + ": trace");
        }
        for (int i = 0; i < tables.size(); ++i) {
            if (debug) {
                System.err.println("Checking " + tableNames[i] + " for environments...");
            }
            Map<String, String> table = tables.get(i);
            for (String prop : table.keySet()) {
                String name = null;
                if (debug) {
                    System.err.println("Checking property " + prop);
                }
                if (!prop.startsWith(ENV_DOT)) continue;
                if (prop.endsWith(DOT_INHERITS)) {
                    name = prop.substring(ENV_DOT.length(), prop.length() - DOT_INHERITS.length());
                } else if (prop.endsWith(DOT_MENU)) {
                    name = prop.substring(ENV_DOT.length(), prop.length() - DOT_MENU.length());
                    String value = table.get(prop);
                    if ("false".equals(value)) {
                        this.sortedInsert(menuExcludeVec, name);
                    }
                } else if (prop.endsWith(DOT_DESCRIPTION)) {
                    name = prop.substring(ENV_DOT.length(), prop.length() - DOT_DESCRIPTION.length());
                } else if (prop.endsWith(DOT_FINDER)) {
                    name = prop.substring(ENV_DOT.length(), prop.length() - DOT_FINDER.length());
                } else if (prop.endsWith(DOT_SCRIPT)) {
                    name = prop.substring(ENV_DOT.length(), prop.length() - DOT_SCRIPT.length());
                } else if (prop.endsWith(DOT_TESTSUITE)) {
                    name = prop.substring(ENV_DOT.length(), prop.length() - DOT_TESTSUITE.length());
                } else {
                    int lastDot = prop.lastIndexOf(46);
                    int scriptStartIndex = lastDot - DOT_SCRIPT_DOT.length() + 1;
                    if (scriptStartIndex <= 0 || !prop.regionMatches(scriptStartIndex, DOT_SCRIPT_DOT, 0, DOT_SCRIPT_DOT.length())) continue;
                    name = prop.substring(ENV_DOT.length(), scriptStartIndex);
                }
                if (debug) {
                    System.err.println("found environment name: " + name);
                }
                this.sortedInsert(allVec, name);
            }
        }
        this.envNames = allVec.toArray(new String[allVec.size()]);
        Vector menuVec = new Vector(allVec);
        for (String s : menuExcludeVec) {
            menuVec.remove(s);
        }
        this.envMenuNames = menuVec.toArray(new String[menuVec.size()]);
    }

    private void sortedInsert(Vector<String> v, String s) {
        for (int i = 0; i < v.size(); ++i) {
            int c = s.compareTo(v.get(i));
            if (c > 0) {
                v.add(i, s);
                return;
            }
            if (c != 0) continue;
            return;
        }
        v.add(s);
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object ... o) {
            super(i18n.getString(s, o));
        }
    }
}

