/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.DynamicArray;
import java.awt.EventQueue;
import java.util.ArrayList;

class MonitorState {
    private final Object vLock = new Object();
    private Harness harness;
    private boolean running;
    private Observer[] obs = new Observer[0];
    private volatile int[] stats;
    private ArrayList<TestResult> runningTests = new ArrayList(5);
    private long startTime;
    private long finishTime;
    private Dispatcher dispatcher = new Dispatcher();

    MonitorState(Harness h) {
        h.addObserver(this.dispatcher);
        this.harness = h;
        this.startTime = -1L;
        this.finishTime = -1L;
        this.stats = new int[4];
    }

    void addObserver(Observer o) {
        this.obs = DynamicArray.append(this.obs, o);
    }

    void removeObserver(Observer o) {
        this.obs = DynamicArray.remove(this.obs, o);
    }

    boolean isRunning() {
        return this.running;
    }

    long getElapsedTime() {
        return this.harness.getElapsedTime();
    }

    synchronized long getEstimatedTime() {
        return this.harness.getEstimatedTime();
    }

    synchronized int getEstimatedTotalTests() {
        WorkDirectory wd = this.harness.getResultTable().getWorkDir();
        if (wd == null) {
            return -1;
        }
        int count = wd.getTestSuiteTestCount();
        if (count == -1) {
            count = wd.getTestSuite().getEstimatedTestCount();
        }
        return count < 0 ? -1 : count;
    }

    synchronized int getTestsFoundCount() {
        return this.harness.getTestsFoundCount();
    }

    synchronized int getTestsDoneCount() {
        int done = 0;
        for (int stat : this.stats) {
            done += stat;
        }
        return done;
    }

    synchronized int getTestsRemainingCount() {
        return this.getTestsFoundCount() - this.getTestsDoneCount();
    }

    synchronized int[] getStats() {
        int[] copy = new int[this.stats.length];
        System.arraycopy(this.stats, 0, copy, 0, this.stats.length);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TestResult[] getRunningTests() {
        TestResult[] trs = new TestResult[]{};
        Object object = this.vLock;
        synchronized (object) {
            if (this.runningTests != null && !this.runningTests.isEmpty()) {
                trs = this.runningTests.toArray(trs);
            }
        }
        return trs;
    }

    private synchronized void incrementStat(int state) {
        int n = state;
        this.stats[n] = this.stats[n] + 1;
    }

    private synchronized void resetStats() {
        this.stats = new int[4];
    }

    class Dispatcher
    implements Harness.Observer {
        Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startingTestRun(Parameters p) {
            MonitorState.this.running = true;
            MonitorState.this.startTime = System.currentTimeMillis();
            MonitorState.this.finishTime = -1L;
            MonitorState.this.resetStats();
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                MonitorState.this.runningTests.clear();
            }
            this.notifySimple(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startingTest(TestResult tr) {
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                if (!MonitorState.this.runningTests.contains(tr)) {
                    MonitorState.this.runningTests.add(tr);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishedTest(TestResult tr) {
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                MonitorState.this.runningTests.remove(tr);
            }
            MonitorState.this.incrementStat(tr.getStatus().getType());
        }

        @Override
        public void stoppingTestRun() {
            this.notifySimple(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishedTesting() {
            MonitorState.this.finishTime = System.currentTimeMillis();
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                MonitorState.this.runningTests.clear();
            }
            this.notifySimple(2);
        }

        @Override
        public void finishedTestRun(boolean allOk) {
            MonitorState.this.running = false;
            this.notifyComplete(allOk);
        }

        private void notifySimple(int which) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = () -> this.notifySimple(which);
                EventQueue.invokeLater(cmd);
            } else {
                block5: for (Observer ob : MonitorState.this.obs) {
                    switch (which) {
                        case 0: {
                            ob.starting();
                            continue block5;
                        }
                        case 1: {
                            ob.stopping();
                            continue block5;
                        }
                        case 2: {
                            ob.postProcessing();
                            continue block5;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
        }

        private void notifyComplete(boolean allOk) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = () -> this.notifyComplete(allOk);
                EventQueue.invokeLater(cmd);
            } else {
                for (Observer ob : MonitorState.this.obs) {
                    ob.finished(allOk);
                }
            }
        }
    }

    static interface Observer {
        public void starting();

        public void postProcessing();

        public void stopping();

        public void finished(boolean var1);
    }
}

