/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BinaryTestWriter {
    private static final TestDescription[] noTests = new TestDescription[0];
    private PrintStream log = System.out;
    private boolean strictFinder = false;
    private int numFinderErrors = 0;

    public static void main(String ... args) {
        int result = 0;
        try {
            BinaryTestWriter m = new BinaryTestWriter();
            result = m.run(args);
        }
        catch (BadArgs e) {
            System.err.println("Bad Arguments: " + e.getMessage());
            BinaryTestWriter.usage(System.err);
            System.exit(1);
        }
        catch (Fault f) {
            System.err.println("Error: " + f.getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
            System.exit(3);
        }
        System.exit(result);
    }

    private static void usage(PrintStream out) {
        String prog = System.getProperty("program", "java " + BinaryTestWriter.class.getName());
        out.println("Usage:");
        out.println("  " + prog + " [options]  test-suite [tests...]");
        out.println("Options:");
        out.println("  -finder finderClass finderArgs... -end");
        out.println("  -o output-file");
        out.println("  -strictFinder");
    }

    private static void writeInt(DataOutputStream out, int v) throws IOException {
        if (v < 0) {
            throw new IllegalArgumentException();
        }
        boolean leadZero = true;
        for (int i = 28; i > 0; i -= 7) {
            int b = v >> i & 0x7F;
            boolean bl = leadZero = leadZero && b == 0;
            if (leadZero) continue;
            out.writeByte(0x80 | b);
        }
        out.writeByte(v & 0x7F);
    }

    /*
     * Exception decompiling
     */
    public int run(String ... args) throws BadArgs, Fault, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TestFinder initializeTestFinder(String finder, String[] args, File ts) throws Fault {
        TestFinder testFinder;
        if (ts == null) {
            throw new NullPointerException();
        }
        try {
            Class<TestFinder> c = Class.forName(finder).asSubclass(TestFinder.class);
            testFinder = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            testFinder.init(args, ts, null);
        }
        catch (ClassNotFoundException e) {
            throw new Fault("Error: Can't find class for test finder specified: " + finder);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Fault("Error: Can't create new instance of test finder: " + e);
        }
        catch (IllegalAccessException e) {
            throw new Fault("Error: Can't access test finder: " + e);
        }
        catch (TestFinder.Fault e) {
            throw new Fault("Error: Can't initialize test-finder: " + e.getMessage());
        }
        return testFinder;
    }

    private File getTestSuiteFile(String file) throws Fault {
        File tsa = new File(file);
        if (tsa.isFile()) {
            return tsa;
        }
        File tsb = new File(tsa, "testsuite.html");
        if (tsb.exists()) {
            return tsb;
        }
        File tsc = new File(tsa, "tests/testsuite.html");
        if (tsc.exists()) {
            return tsc;
        }
        throw new Fault("Bad input. " + file + " is not a JCK");
    }

    private String zipStats(ZipEntry e) {
        long size = e.getSize();
        long csize = e.getCompressedSize();
        return size + " bytes (" + csize + " compressed, " + csize * 100L / size + "%)";
    }

    void read(TestFinder finder, File[] files, TestTree testTree) throws Fault {
        if (files.length < 1) {
            throw new IllegalArgumentException();
        }
        File rootDir = finder.getRootDir();
        HashSet<File> allFiles = new HashSet<File>();
        TestTree.Node r = null;
        for (File file : files) {
            TestTree.Node n;
            File f = file;
            if (!f.isAbsolute()) {
                f = new File(rootDir, f.getPath());
            }
            if ((n = this.read0(finder, f, testTree, allFiles)) == null) continue;
            while (!f.equals(rootDir)) {
                f = f.getParentFile();
                TestTree testTree2 = testTree;
                testTree2.getClass();
                n = testTree2.new TestTree.Node(f.getName(), noTests, n);
            }
            r = r == null ? n : r.merge(n);
        }
        if (r == null) {
            throw new Fault("No tests found");
        }
        testTree.setRoot(r);
    }

    private TestTree.Node read0(TestFinder finder, File file, TestTree testTree, Set<File> allFiles) {
        if (allFiles.contains(file)) {
            return null;
        }
        allFiles.add(file);
        finder.read(file);
        TestDescription[] tests = finder.getTests();
        Object[] files = finder.getFiles();
        if (tests.length == 0 && files.length == 0) {
            return null;
        }
        Arrays.sort(files);
        Arrays.sort(tests, (td1, td2) -> td1.getRootRelativeURL().compareTo(td2.getRootRelativeURL()));
        Vector<TestTree.Node> v = new Vector<TestTree.Node>();
        for (Object file1 : files) {
            TestTree.Node n = this.read0(finder, (File)file1, testTree, allFiles);
            if (n == null) continue;
            v.add(n);
        }
        TestTree testTree2 = testTree;
        testTree2.getClass();
        return testTree2.new TestTree.Node(file.getName(), tests, v.toArray(new TestTree.Node[v.size()]));
    }

    private /* synthetic */ void lambda$run$0(String msg) {
        ++this.numFinderErrors;
        System.err.println("Finder reported error:\n" + msg);
        System.err.println("");
    }

    static class TestTree {
        private Node root;
        private TestTable testTable;

        TestTree(TestTable testTable) {
            this.testTable = testTable;
        }

        void setRoot(Node root) {
            this.root = root;
        }

        int getSize() {
            return this.root == null ? 0 : this.root.getSize();
        }

        ZipEntry write(ZipOutputStream zos) throws IOException {
            ZipEntry entry = new ZipEntry("tree");
            zos.putNextEntry(entry);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            this.write(dos);
            dos.flush();
            zos.closeEntry();
            return entry;
        }

        void write(DataOutputStream o) throws IOException {
            this.root.write(o);
        }

        class Node {
            private String name;
            private TestDescription[] tests;
            private Node[] children;

            Node(String name, TestDescription[] tests, Node ... children) {
                this.name = name;
                this.tests = tests;
                this.children = children;
                for (TestDescription test : tests) {
                    TestTree.this.testTable.add(test);
                }
            }

            int getSize() {
                int n = 1;
                if (this.children != null) {
                    for (Node aChildren : this.children) {
                        n += aChildren.getSize();
                    }
                }
                return n;
            }

            Node merge(Node other) {
                TestDescription[] mergedTests;
                if (!other.name.equals(this.name)) {
                    throw new IllegalArgumentException(this.name + ":" + other.name);
                }
                TreeMap<String, Node> mergedChildrenMap = new TreeMap<String, Node>();
                for (Node child : this.children) {
                    mergedChildrenMap.put(child.name, child);
                }
                for (int i = 0; i < other.children.length; ++i) {
                    Node otherChild = other.children[i];
                    Node c = (Node)mergedChildrenMap.get(otherChild.name);
                    mergedChildrenMap.put(otherChild.name, c == null ? otherChild : otherChild.merge(c));
                }
                Node[] mergedChildren = mergedChildrenMap.values().toArray(new Node[mergedChildrenMap.size()]);
                if (this.tests.length + other.tests.length == 0) {
                    mergedTests = noTests;
                } else {
                    mergedTests = new TestDescription[this.tests.length + other.tests.length];
                    System.arraycopy(this.tests, 0, mergedTests, 0, this.tests.length);
                    System.arraycopy(other.tests, 0, mergedTests, this.tests.length, other.tests.length);
                }
                return new Node(this.name, mergedTests, mergedChildren);
            }

            void write(DataOutputStream o) throws IOException {
                o.writeUTF(this.name);
                BinaryTestWriter.writeInt(o, this.tests.length);
                for (TestDescription test : this.tests) {
                    BinaryTestWriter.writeInt(o, TestTree.this.testTable.getIndex(test));
                }
                BinaryTestWriter.writeInt(o, this.children.length);
                for (Node aChildren : this.children) {
                    aChildren.write(o);
                }
            }
        }
    }

    static class TestTable {
        private Map<TestDescription, Entry> testMap = new HashMap<TestDescription, Entry>();
        private Vector<TestDescription> tests = new Vector();
        private StringTable stringTable;

        TestTable(StringTable stringTable) {
            this.stringTable = stringTable;
        }

        void add(TestDescription td) {
            this.tests.add(td);
            this.testMap.put(td, new Entry());
            this.stringTable.add(td);
        }

        int getSize() {
            return this.tests.size();
        }

        int getIndex(TestDescription td) {
            Entry e = this.testMap.get(td);
            if (e == null) {
                throw new IllegalArgumentException();
            }
            return e.index;
        }

        ZipEntry write(ZipOutputStream zos) throws IOException {
            ZipEntry entry = new ZipEntry("tests");
            zos.putNextEntry(entry);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            this.write(dos);
            dos.flush();
            zos.closeEntry();
            return entry;
        }

        void write(DataOutputStream o) throws IOException {
            BinaryTestWriter.writeInt(o, this.tests.size());
            for (TestDescription td : this.tests) {
                Entry e = this.testMap.get(td);
                e.index = o.size();
                this.write(td, o);
            }
        }

        private void write(TestDescription td, DataOutputStream o) throws IOException {
            BinaryTestWriter.writeInt(o, td.getParameterCount());
            Iterator<String> i = td.getParameterKeys();
            while (i.hasNext()) {
                String key = i.next();
                String value = td.getParameter(key);
                this.stringTable.writeRef(key, o);
                this.stringTable.writeRef(value, o);
            }
        }

        static class Entry {
            int index = -1;

            Entry() {
            }
        }
    }

    static class StringTable {
        private Map<String, Entry> map = new TreeMap<String, Entry>();
        private int writtenSize;

        StringTable() {
        }

        void add(String s) {
            Entry e = this.map.get(s);
            if (e == null) {
                e = new Entry();
                this.map.put(s, e);
            }
            ++e.useCount;
        }

        void add(TestDescription test) {
            Iterator<String> i = test.getParameterKeys();
            while (i.hasNext()) {
                String key = i.next();
                String param = test.getParameter(key);
                this.add(key);
                this.add(param);
            }
        }

        int getSize() {
            return this.map.size();
        }

        int getWrittenSize() {
            return this.writtenSize;
        }

        int getIndex(String s) {
            Entry e = this.map.get(s);
            if (e == null) {
                throw new IllegalArgumentException();
            }
            return e.index;
        }

        ZipEntry write(ZipOutputStream zos) throws IOException {
            ZipEntry entry = new ZipEntry("strings");
            zos.putNextEntry(entry);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            this.write(dos);
            dos.flush();
            zos.closeEntry();
            return entry;
        }

        void write(DataOutputStream o) throws IOException {
            Vector<String> v = new Vector<String>(this.map.size());
            v.add("");
            int nextIndex = 1;
            for (Map.Entry<String, Entry> e : this.map.entrySet()) {
                String key = e.getKey();
                Entry entry = e.getValue();
                if (!entry.isFrequent()) continue;
                entry.index = nextIndex++;
                v.add(key);
            }
            BinaryTestWriter.writeInt(o, v.size());
            for (String s : v) {
                o.writeUTF(s);
            }
            this.writtenSize = nextIndex;
        }

        void writeRef(String s, DataOutputStream o) throws IOException {
            Entry e = this.map.get(s);
            if (e == null) {
                throw new IllegalArgumentException();
            }
            if (e.isFrequent()) {
                BinaryTestWriter.writeInt(o, e.index);
            } else {
                BinaryTestWriter.writeInt(o, 0);
                o.writeUTF(s);
            }
        }

        static class Entry {
            int useCount = 0;
            int index = 0;

            Entry() {
            }

            boolean isFrequent() {
                return this.useCount > 1;
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(String msg) {
            super(msg);
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(String msg) {
            super(msg);
        }
    }
}

