/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.CommandLineArgs;
import org.testng.IAnnotationTransformer;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IExecutionListener;
import org.testng.IHookable;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.ReporterConfig;
import org.testng.SuiteRunner;
import org.testng.SuiteRunnerWorker;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.Configuration;
import org.testng.internal.DynamicGraph;
import org.testng.internal.IConfiguration;
import org.testng.internal.IResultListener2;
import org.testng.internal.OverrideProcessor;
import org.testng.internal.SuiteRunnerMap;
import org.testng.internal.Utils;
import org.testng.internal.Version;
import org.testng.internal.annotations.DefaultAnnotationTransformer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.JDK15AnnotationFinder;
import org.testng.internal.thread.graph.GraphThreadPoolExecutor;
import org.testng.internal.thread.graph.SuiteWorkerFactory;
import org.testng.junit.JUnitTestFinder;
import org.testng.log4testng.Logger;
import org.testng.remote.SuiteDispatcher;
import org.testng.remote.SuiteSlave;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.EmailableReporter2;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.JUnitReportReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.reporters.VerboseReporter;
import org.testng.reporters.XMLReporter;
import org.testng.reporters.jq.Main;
import org.testng.xml.Parser;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.SAXException;

public class TestNG {
    private static final Logger LOGGER = Logger.getLogger(TestNG.class);
    public static final String DEFAULT_COMMAND_LINE_SUITE_NAME = "Command line suite";
    public static final String DEFAULT_COMMAND_LINE_TEST_NAME = "Command line test";
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    public static final String SHOW_TESTNG_STACK_FRAMES = "testng.show.stack.frames";
    public static final String TEST_CLASSPATH = "testng.test.classpath";
    private static TestNG m_instance;
    private static JCommander m_jCommander;
    private List<String> m_commandLineMethods;
    protected List<XmlSuite> m_suites = Lists.newArrayList();
    private List<XmlSuite> m_cmdlineSuites;
    private String m_outputDir = "test-output";
    private String[] m_includedGroups;
    private String[] m_excludedGroups;
    private Boolean m_isJUnit = XmlSuite.DEFAULT_JUNIT;
    private Boolean m_isMixed = XmlSuite.DEFAULT_MIXED;
    protected boolean m_useDefaultListeners = true;
    private ITestRunnerFactory m_testRunnerFactory;
    private List<ITestListener> m_testListeners = Lists.newArrayList();
    private List<ISuiteListener> m_suiteListeners = Lists.newArrayList();
    private Set<IReporter> m_reporters = Sets.newHashSet();
    protected static final int HAS_FAILURE = 1;
    protected static final int HAS_SKIPPED = 2;
    protected static final int HAS_FSP = 4;
    protected static final int HAS_NO_TEST = 8;
    public static final Integer DEFAULT_VERBOSE;
    private int m_status;
    private boolean m_hasTests = false;
    private String m_slavefileName = null;
    private String m_masterfileName = null;
    private int m_threadCount;
    private boolean m_useThreadCount;
    private String m_parallelMode;
    private boolean m_useParallelMode;
    private String m_configFailurePolicy;
    private Class[] m_commandLineTestClasses;
    private String m_defaultSuiteName = "Command line suite";
    private String m_defaultTestName = "Command line test";
    private Map<String, Integer> m_methodDescriptors = Maps.newHashMap();
    private ITestObjectFactory m_objectFactory;
    private List<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();
    private Integer m_dataProviderThreadCount = null;
    private String m_jarPath;
    private String m_xmlPathInJar = "testng.xml";
    private List<String> m_stringSuites = Lists.newArrayList();
    private IHookable m_hookable;
    private IConfigurable m_configurable;
    protected long m_end;
    protected long m_start;
    private List<IExecutionListener> m_executionListeners = Lists.newArrayList();
    private boolean m_isInitialized = false;
    private Integer m_verbose = null;
    private final IAnnotationTransformer m_defaultAnnoProcessor;
    private IAnnotationTransformer m_annotationTransformer = this.m_defaultAnnoProcessor = new DefaultAnnotationTransformer();
    private Boolean m_skipFailedInvocationCounts = false;
    private List<IMethodInterceptor> m_methodInterceptors = new ArrayList<IMethodInterceptor>();
    private List<String> m_testNames;
    private Integer m_suiteThreadPoolSize = CommandLineArgs.SUITE_THREAD_POOL_SIZE_DEFAULT;
    private boolean m_randomizeSuites = Boolean.FALSE;
    private boolean m_preserveOrder = false;
    private Boolean m_groupByInstances;
    private IConfiguration m_configuration;
    private URLClassLoader m_serviceLoaderClassLoader;
    private List<ITestNGListener> m_serviceLoaderListeners = Lists.newArrayList();

    public TestNG() {
        this.init(true);
    }

    public TestNG(boolean useDefaultListeners) {
        this.init(useDefaultListeners);
    }

    private void init(boolean useDefaultListeners) {
        m_instance = this;
        this.m_useDefaultListeners = useDefaultListeners;
        this.m_configuration = new Configuration();
    }

    public int getStatus() {
        return this.m_status;
    }

    private void setStatus(int status) {
        this.m_status |= status;
    }

    public void setOutputDirectory(String outputdir) {
        if (Utils.isStringNotEmpty(outputdir)) {
            this.m_outputDir = outputdir;
        }
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public void setTestJar(String jarPath) {
        this.m_jarPath = jarPath;
    }

    public void setXmlPathInJar(String xmlPathInJar) {
        this.m_xmlPathInJar = xmlPathInJar;
    }

    public void initializeSuitesAndJarFile() {
        if (this.m_isInitialized) {
            return;
        }
        this.m_isInitialized = true;
        if (this.m_suites.size() > 0) {
            for (XmlSuite xmlSuite : this.m_suites) {
                for (String suiteFile : xmlSuite.getSuiteFiles()) {
                    try {
                        Collection<XmlSuite> childSuites = this.getParser(suiteFile).parse();
                        for (XmlSuite cSuite : childSuites) {
                            cSuite.setParentSuite(xmlSuite);
                            xmlSuite.getChildSuites().add(cSuite);
                        }
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return;
        }
        for (String string : this.m_stringSuites) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("suiteXmlPath: \"" + string + "\"");
            }
            try {
                Collection<XmlSuite> allSuites = this.getParser(string).parse();
                for (XmlSuite s : allSuites) {
                    if (this.m_testNames != null) {
                        this.m_suites.add(TestNG.extractTestNames(s, this.m_testNames));
                        continue;
                    }
                    this.m_suites.add(s);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace(System.out);
            }
            catch (Exception ex) {
                Throwable t = ex;
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                if (t instanceof TestNGException) {
                    throw (TestNGException)t;
                }
                throw new TestNGException(t);
            }
        }
        if (this.m_jarPath != null && this.m_stringSuites.size() > 0) {
            StringBuilder suites = new StringBuilder();
            for (String s : this.m_stringSuites) {
                suites.append(s);
            }
            Utils.log("TestNG", 2, "Ignoring the XML file inside " + this.m_jarPath + " and using " + suites + " instead");
            return;
        }
        if (Utils.isStringEmpty(this.m_jarPath)) {
            return;
        }
        File jarFile = new File(this.m_jarPath);
        try {
            Utils.log("TestNG", 2, "Trying to open jar file:" + jarFile);
            JarFile jarFile2 = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jarFile2.entries();
            List<String> classes = Lists.newArrayList();
            boolean foundTestngXml = false;
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (je.getName().equals(this.m_xmlPathInJar)) {
                    Parser parser = this.getParser(jarFile2.getInputStream(je));
                    Collection<XmlSuite> suites = parser.parse();
                    for (XmlSuite suite : suites) {
                        if (this.m_testNames != null) {
                            this.m_suites.add(TestNG.extractTestNames(suite, this.m_testNames));
                            continue;
                        }
                        this.m_suites.add(suite);
                    }
                    foundTestngXml = true;
                    break;
                }
                if (!je.getName().endsWith(".class")) continue;
                int n = je.getName().length() - ".class".length();
                classes.add(je.getName().replace("/", ".").substring(0, n));
            }
            if (!foundTestngXml) {
                Utils.log("TestNG", 1, "Couldn't find the " + this.m_xmlPathInJar + " in the jar file, running all the classes");
                XmlSuite xmlSuite = new XmlSuite();
                xmlSuite.setVerbose(0);
                xmlSuite.setName("Jar suite");
                XmlTest xmlTest = new XmlTest(xmlSuite);
                List<XmlClass> xmlClasses = Lists.newArrayList();
                for (String cls : classes) {
                    XmlClass xmlClass = new XmlClass(cls);
                    xmlClasses.add(xmlClass);
                }
                xmlTest.setXmlClasses(xmlClasses);
                this.m_suites.add(xmlSuite);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
        }
    }

    private Parser getParser(String path) {
        Parser result = new Parser(path);
        this.initProcessor(result);
        return result;
    }

    private Parser getParser(InputStream is) {
        Parser result = new Parser(is);
        this.initProcessor(result);
        return result;
    }

    private void initProcessor(Parser result) {
        result.setPostProcessor(new OverrideProcessor(this.m_includedGroups, this.m_excludedGroups));
    }

    private static XmlSuite extractTestNames(XmlSuite s, List<String> testNames) {
        List tests = Lists.newArrayList();
        for (XmlTest xt : s.getTests()) {
            for (String tn : testNames) {
                if (!xt.getName().equals(tn)) continue;
                tests.add(xt);
            }
        }
        if (tests.size() == 0) {
            return s;
        }
        XmlSuite result = (XmlSuite)s.clone();
        result.getTests().clear();
        result.getTests().addAll(tests);
        return result;
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            TestNG.exitWithError("Cannot use a threadCount parameter less than 1; 1 > " + threadCount);
        }
        this.m_threadCount = threadCount;
        this.m_useThreadCount = true;
    }

    public void setParallel(String parallel) {
        this.m_parallelMode = parallel;
        this.m_useParallelMode = true;
    }

    public void setCommandLineSuite(XmlSuite suite) {
        this.m_cmdlineSuites = Lists.newArrayList();
        this.m_cmdlineSuites.add(suite);
        this.m_suites.add(suite);
    }

    public void setTestClasses(Class[] classes) {
        this.m_suites.clear();
        this.m_commandLineTestClasses = classes;
    }

    private String[] splitMethod(String m) {
        int index = m.lastIndexOf(".");
        if (index < 0) {
            throw new TestNGException("Bad format for command line method:" + m + ", expected <class>.<method>");
        }
        return new String[]{m.substring(0, index), m.substring(index + 1).replaceAll("\\*", "\\.\\*")};
    }

    private List<XmlSuite> createCommandLineSuitesForMethods(List<String> commandLineMethods) {
        Set classes = Sets.newHashSet();
        for (String m : commandLineMethods) {
            Class<?> c = ClassHelper.forName(this.splitMethod(m)[0]);
            if (c == null) continue;
            classes.add(c);
        }
        List<XmlSuite> result = this.createCommandLineSuitesForClasses(classes.toArray(new Class[0]));
        List<XmlClass> xmlClasses = Lists.newArrayList();
        for (XmlSuite s : result) {
            for (XmlTest t : s.getTests()) {
                xmlClasses.addAll(t.getClasses());
            }
        }
        for (XmlClass xc : xmlClasses) {
            for (String m : commandLineMethods) {
                String[] split = this.splitMethod(m);
                String className = split[0];
                if (!xc.getName().equals(className)) continue;
                XmlInclude includedMethod = new XmlInclude(split[1]);
                xc.getIncludedMethods().add(includedMethod);
            }
        }
        return result;
    }

    private List<XmlSuite> createCommandLineSuitesForClasses(Class[] classes) {
        XmlClass[] xmlClasses = Utils.classesToXmlClasses(classes);
        Map<String, XmlSuite> suites = Maps.newHashMap();
        IAnnotationFinder finder = this.m_configuration.getAnnotationFinder();
        for (int i = 0; i < classes.length; ++i) {
            Class c = classes[i];
            ITestAnnotation test = finder.findAnnotation(c, ITestAnnotation.class);
            String suiteName = this.getDefaultSuiteName();
            String testName = this.getDefaultTestName();
            boolean isJUnit = false;
            if (test != null) {
                suiteName = Utils.defaultIfStringEmpty(test.getSuiteName(), suiteName);
                testName = Utils.defaultIfStringEmpty(test.getTestName(), testName);
            } else if (this.m_isMixed.booleanValue() && JUnitTestFinder.isJUnitTest(c)) {
                isJUnit = true;
                testName = c.getName();
            }
            XmlSuite xmlSuite = (XmlSuite)suites.get(suiteName);
            if (xmlSuite == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(suiteName);
                suites.put(suiteName, xmlSuite);
            }
            if (this.m_dataProviderThreadCount != null) {
                xmlSuite.setDataProviderThreadCount(this.m_dataProviderThreadCount);
            }
            XmlTest xmlTest = null;
            for (XmlTest xt : xmlSuite.getTests()) {
                if (!xt.getName().equals(testName)) continue;
                xmlTest = xt;
                break;
            }
            if (xmlTest == null) {
                xmlTest = new XmlTest(xmlSuite);
                xmlTest.setName(testName);
                xmlTest.setJUnit(isJUnit);
            }
            xmlTest.getXmlClasses().add(xmlClasses[i]);
        }
        return new ArrayList<XmlSuite>(suites.values());
    }

    public void addMethodSelector(String className, int priority) {
        this.m_methodDescriptors.put(className, priority);
    }

    public void setTestSuites(List<String> suites) {
        this.m_stringSuites = suites;
    }

    public void setXmlSuites(List<XmlSuite> suites) {
        this.m_suites = suites;
    }

    public void setExcludedGroups(String groups) {
        this.m_excludedGroups = Utils.split(groups, ",");
    }

    public void setGroups(String groups) {
        this.m_includedGroups = Utils.split(groups, ",");
    }

    private void setTestRunnerFactoryClass(Class testRunnerFactoryClass) {
        this.setTestRunnerFactory((ITestRunnerFactory)ClassHelper.newInstance(testRunnerFactoryClass));
    }

    protected void setTestRunnerFactory(ITestRunnerFactory itrf) {
        this.m_testRunnerFactory = itrf;
    }

    public void setObjectFactory(Class c) {
        this.m_objectFactory = (ITestObjectFactory)ClassHelper.newInstance(c);
    }

    public void setObjectFactory(ITestObjectFactory factory) {
        this.m_objectFactory = factory;
    }

    public void setListenerClasses(List<Class> classes) {
        for (Class cls : classes) {
            this.addListener(ClassHelper.newInstance(cls));
        }
    }

    public void addListener(Object listener) {
        if (!(listener instanceof ITestNGListener)) {
            TestNG.exitWithError("Listener " + listener + " must be one of ITestListener, ISuiteListener, IReporter, " + " IAnnotationTransformer, IMethodInterceptor or IInvokedMethodListener");
        } else {
            if (listener instanceof ISuiteListener) {
                this.addListener((ISuiteListener)listener);
            }
            if (listener instanceof ITestListener) {
                this.addListener((ITestListener)listener);
            }
            if (listener instanceof IReporter) {
                this.addListener((IReporter)listener);
            }
            if (listener instanceof IAnnotationTransformer) {
                this.setAnnotationTransformer((IAnnotationTransformer)listener);
            }
            if (listener instanceof IMethodInterceptor) {
                this.m_methodInterceptors.add((IMethodInterceptor)listener);
            }
            if (listener instanceof IInvokedMethodListener) {
                this.addInvokedMethodListener((IInvokedMethodListener)listener);
            }
            if (listener instanceof IHookable) {
                this.setHookable((IHookable)listener);
            }
            if (listener instanceof IConfigurable) {
                this.setConfigurable((IConfigurable)listener);
            }
            if (listener instanceof IExecutionListener) {
                this.addExecutionListener((IExecutionListener)listener);
            }
            if (listener instanceof IConfigurationListener) {
                this.getConfiguration().addConfigurationListener((IConfigurationListener)listener);
            }
        }
    }

    public void addListener(IInvokedMethodListener listener) {
        this.m_invokedMethodListeners.add(listener);
    }

    public void addListener(ISuiteListener listener) {
        if (null != listener) {
            this.m_suiteListeners.add(listener);
        }
    }

    public void addListener(ITestListener listener) {
        if (null != listener) {
            this.m_testListeners.add(listener);
        }
    }

    public void addListener(IReporter listener) {
        if (null != listener) {
            this.m_reporters.add(listener);
        }
    }

    public void addInvokedMethodListener(IInvokedMethodListener listener) {
        this.m_invokedMethodListeners.add(listener);
    }

    public Set<IReporter> getReporters() {
        return this.m_reporters;
    }

    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    public List<ISuiteListener> getSuiteListeners() {
        return this.m_suiteListeners;
    }

    public void setVerbose(int verbose) {
        this.m_verbose = verbose;
    }

    private void initializeCommandLineSuites() {
        if (this.m_commandLineTestClasses != null || this.m_commandLineMethods != null) {
            this.m_cmdlineSuites = null != this.m_commandLineMethods ? this.createCommandLineSuitesForMethods(this.m_commandLineMethods) : this.createCommandLineSuitesForClasses(this.m_commandLineTestClasses);
            for (XmlSuite s : this.m_cmdlineSuites) {
                for (XmlTest t : s.getTests()) {
                    t.setPreserveOrder(String.valueOf(this.m_preserveOrder));
                }
                this.m_suites.add(s);
                if (this.m_groupByInstances == null) continue;
                s.setGroupByInstances(this.m_groupByInstances);
            }
        }
    }

    private void initializeCommandLineSuitesParams() {
        if (null == this.m_cmdlineSuites) {
            return;
        }
        for (XmlSuite s : this.m_cmdlineSuites) {
            if (this.m_useThreadCount) {
                s.setThreadCount(this.m_threadCount);
            }
            if (this.m_useParallelMode) {
                s.setParallel(this.m_parallelMode);
            }
            if (this.m_configFailurePolicy == null) continue;
            s.setConfigFailurePolicy(this.m_configFailurePolicy.toString());
        }
    }

    private void initializeCommandLineSuitesGroups() {
        List<XmlSuite> suites;
        boolean hasIncludedGroups = null != this.m_includedGroups && this.m_includedGroups.length > 0;
        boolean hasExcludedGroups = null != this.m_excludedGroups && this.m_excludedGroups.length > 0;
        List<XmlSuite> list = suites = this.m_cmdlineSuites != null ? this.m_cmdlineSuites : this.m_suites;
        if (hasIncludedGroups || hasExcludedGroups) {
            for (XmlSuite s : suites) {
                for (XmlTest t : s.getTests()) {
                    if (hasIncludedGroups) {
                        t.setIncludedGroups(Arrays.asList(this.m_includedGroups));
                    }
                    if (!hasExcludedGroups) continue;
                    t.setExcludedGroups(Arrays.asList(this.m_excludedGroups));
                }
            }
        }
    }

    private void addReporter(Class<? extends IReporter> r) {
        if (!this.m_reporters.contains(r)) {
            this.m_reporters.add(ClassHelper.newInstance(r));
        }
    }

    private void initializeDefaultListeners() {
        this.m_testListeners.add(new ExitCodeListener(this));
        if (this.m_useDefaultListeners) {
            this.addReporter(SuiteHTMLReporter.class);
            this.addReporter(Main.class);
            this.addReporter(FailedReporter.class);
            this.addReporter(XMLReporter.class);
            if (System.getProperty("oldTestngEmailableReporter") != null) {
                this.addReporter(EmailableReporter.class);
            } else if (System.getProperty("noEmailableReporter") == null) {
                this.addReporter(EmailableReporter2.class);
            }
            this.addReporter(JUnitReportReporter.class);
            if (this.m_verbose != null && this.m_verbose > 4) {
                this.addListener(new VerboseReporter("[TestNG] "));
            }
        }
    }

    private void initializeConfiguration() {
        ITestObjectFactory factory = this.m_objectFactory;
        this.addServiceLoaderListeners();
        for (XmlSuite s : this.m_suites) {
            for (String listenerName : s.getListeners()) {
                Class<?> listenerClass = ClassHelper.forName(listenerName);
                if (listenerClass == null) {
                    throw new TestNGException("Listener " + listenerName + " was not found in project's classpath");
                }
                Object listener = ClassHelper.newInstance(listenerClass);
                this.addListener(listener);
            }
            for (XmlMethodSelector methodSelector : s.getMethodSelectors()) {
                this.addMethodSelector(methodSelector.getClassName(), methodSelector.getPriority());
            }
            if (s.getObjectFactory() == null) continue;
            if (factory == null) {
                factory = s.getObjectFactory();
                continue;
            }
            throw new TestNGException("Found more than one object-factory tag in your suites");
        }
        this.m_configuration.setAnnotationFinder(new JDK15AnnotationFinder(this.getAnnotationTransformer()));
        this.m_configuration.setHookable(this.m_hookable);
        this.m_configuration.setConfigurable(this.m_configurable);
        this.m_configuration.setObjectFactory(factory);
    }

    private void addServiceLoaderListeners() {
        ServiceLoader<ITestNGListener> loader = this.m_serviceLoaderClassLoader != null ? ServiceLoader.load(ITestNGListener.class, this.m_serviceLoaderClassLoader) : ServiceLoader.load(ITestNGListener.class);
        for (ITestNGListener l : loader) {
            Utils.log("[TestNG]", 2, "Adding ServiceLoader listener:" + l);
            this.addListener(l);
            this.addServiceLoaderListener(l);
        }
    }

    private void sanityCheck() {
        this.checkTestNames(this.m_suites);
        this.checkSuiteNames(this.m_suites);
    }

    private void checkTestNames(List<XmlSuite> suites) {
        for (XmlSuite suite : suites) {
            Set testNames = Sets.newHashSet();
            for (XmlTest test : suite.getTests()) {
                if (testNames.contains(test.getName())) {
                    throw new TestNGException("Two tests in the same suite cannot have the same name: " + test.getName());
                }
                testNames.add(test.getName());
            }
            this.checkTestNames(suite.getChildSuites());
        }
    }

    private void checkSuiteNames(List<XmlSuite> suites) {
        this.checkSuiteNamesInternal(suites, Sets.newHashSet());
    }

    private void checkSuiteNamesInternal(List<XmlSuite> suites, Set<String> names) {
        for (XmlSuite suite : suites) {
            String name = suite.getName();
            if (names.contains(name)) {
                throw new TestNGException("Two suites cannot have the same name: " + name);
            }
            names.add(name);
            this.checkSuiteNamesInternal(suite.getChildSuites(), names);
        }
    }

    public void run() {
        this.initializeSuitesAndJarFile();
        this.initializeConfiguration();
        this.initializeDefaultListeners();
        this.initializeCommandLineSuites();
        this.initializeCommandLineSuitesParams();
        this.initializeCommandLineSuitesGroups();
        this.sanityCheck();
        List<ISuite> suiteRunners = null;
        this.runExecutionListeners(true);
        this.m_start = System.currentTimeMillis();
        if (this.m_slavefileName != null) {
            SuiteSlave slave = new SuiteSlave(this.m_slavefileName, this);
            slave.waitForSuites();
        } else if (this.m_masterfileName == null) {
            suiteRunners = this.runSuitesLocally();
        } else {
            SuiteDispatcher dispatcher = new SuiteDispatcher(this.m_masterfileName);
            suiteRunners = dispatcher.dispatch(this.getConfiguration(), this.m_suites, this.getOutputDirectory(), this.getTestListeners());
        }
        this.m_end = System.currentTimeMillis();
        this.runExecutionListeners(false);
        if (null != suiteRunners) {
            this.generateReports(suiteRunners);
        }
        if (!this.m_hasTests) {
            this.setStatus(8);
            if (TestRunner.getVerbose() > 1) {
                System.err.println("[TestNG] No tests found. Nothing was run");
                TestNG.usage();
            }
        }
    }

    private void p(String string) {
        System.out.println("[TestNG] " + string);
    }

    private void runExecutionListeners(boolean start) {
        for (List listeners : Arrays.asList(this.m_executionListeners, this.m_configuration.getExecutionListeners())) {
            for (IExecutionListener l : listeners) {
                if (start) {
                    l.onExecutionStart();
                    continue;
                }
                l.onExecutionFinish();
            }
        }
    }

    public void addExecutionListener(IExecutionListener l) {
        this.m_executionListeners.add(l);
    }

    private static void usage() {
        if (m_jCommander == null) {
            m_jCommander = new JCommander((Object)new CommandLineArgs());
        }
        m_jCommander.usage();
    }

    private void generateReports(List<ISuite> suiteRunners) {
        for (IReporter reporter : this.m_reporters) {
            try {
                long start = System.currentTimeMillis();
                reporter.generateReport(this.m_suites, suiteRunners, this.m_outputDir);
                Utils.log("TestNG", 2, "Time taken by " + reporter + ": " + (System.currentTimeMillis() - start) + " ms");
            }
            catch (Exception ex) {
                System.err.println("[TestNG] Reporter " + reporter + " failed");
                ex.printStackTrace(System.err);
            }
        }
    }

    public List<ISuite> runSuitesLocally() {
        SuiteRunnerMap suiteRunnerMap = new SuiteRunnerMap();
        if (this.m_suites.size() > 0) {
            if (this.m_suites.get(0).getVerbose() >= 2) {
                Version.displayBanner();
            }
            for (XmlSuite xmlSuite : this.m_suites) {
                this.createSuiteRunners(suiteRunnerMap, xmlSuite);
            }
            if (this.m_suiteThreadPoolSize == 1 && !this.m_randomizeSuites) {
                for (XmlSuite xmlSuite : this.m_suites) {
                    this.runSuitesSequentially(xmlSuite, suiteRunnerMap, this.getVerbose(xmlSuite), this.getDefaultSuiteName());
                }
            } else {
                DynamicGraph<ISuite> suiteGraph = new DynamicGraph<ISuite>();
                for (XmlSuite xmlSuite : this.m_suites) {
                    this.populateSuiteGraph(suiteGraph, suiteRunnerMap, xmlSuite);
                }
                SuiteWorkerFactory suiteWorkerFactory = new SuiteWorkerFactory(suiteRunnerMap, 0, this.getDefaultSuiteName());
                GraphThreadPoolExecutor<ISuite> pooledExecutor = new GraphThreadPoolExecutor<ISuite>(suiteGraph, suiteWorkerFactory, this.m_suiteThreadPoolSize, this.m_suiteThreadPoolSize, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                Utils.log("TestNG", 2, "Starting executor for all suites");
                pooledExecutor.run();
                try {
                    pooledExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    pooledExecutor.shutdownNow();
                }
                catch (InterruptedException handled) {
                    Thread.currentThread().interrupt();
                    TestNG.error("Error waiting for concurrent executors to finish " + handled.getMessage());
                }
            }
        } else {
            this.setStatus(8);
            TestNG.error("No test suite found. Nothing to run");
            TestNG.usage();
        }
        return Lists.newArrayList(suiteRunnerMap.values());
    }

    private static void error(String s) {
        LOGGER.error(s);
    }

    private int getVerbose(XmlSuite xmlSuite) {
        int result = xmlSuite.getVerbose() != null ? xmlSuite.getVerbose() : (this.m_verbose != null ? this.m_verbose : DEFAULT_VERBOSE);
        return result;
    }

    private void runSuitesSequentially(XmlSuite xmlSuite, SuiteRunnerMap suiteRunnerMap, int verbose, String defaultSuiteName) {
        for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
            this.runSuitesSequentially(childSuite, suiteRunnerMap, verbose, defaultSuiteName);
        }
        SuiteRunnerWorker srw = new SuiteRunnerWorker(suiteRunnerMap.get(xmlSuite), suiteRunnerMap, verbose, defaultSuiteName);
        srw.run();
    }

    private void populateSuiteGraph(DynamicGraph<ISuite> suiteGraph, SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        ISuite parentSuiteRunner = suiteRunnerMap.get(xmlSuite);
        if (xmlSuite.getChildSuites().isEmpty()) {
            suiteGraph.addNode(parentSuiteRunner);
        } else {
            for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
                suiteGraph.addEdge(parentSuiteRunner, suiteRunnerMap.get(childSuite));
                this.populateSuiteGraph(suiteGraph, suiteRunnerMap, childSuite);
            }
        }
    }

    private void createSuiteRunners(SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        if (null != this.m_isJUnit && !this.m_isJUnit.equals(XmlSuite.DEFAULT_JUNIT)) {
            xmlSuite.setJUnit(this.m_isJUnit);
        }
        if (null != this.m_skipFailedInvocationCounts) {
            xmlSuite.setSkipFailedInvocationCounts(this.m_skipFailedInvocationCounts);
        }
        if (this.m_verbose != null) {
            xmlSuite.setVerbose(this.m_verbose);
        }
        if (null != this.m_configFailurePolicy) {
            xmlSuite.setConfigFailurePolicy(this.m_configFailurePolicy);
        }
        for (XmlTest t : xmlSuite.getTests()) {
            for (Map.Entry<String, Integer> ms : this.m_methodDescriptors.entrySet()) {
                XmlMethodSelector xms = new XmlMethodSelector();
                xms.setName(ms.getKey());
                xms.setPriority(ms.getValue());
                t.getMethodSelectors().add(xms);
            }
        }
        suiteRunnerMap.put(xmlSuite, this.createSuiteRunner(xmlSuite));
        for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
            this.createSuiteRunners(suiteRunnerMap, childSuite);
        }
    }

    private SuiteRunner createSuiteRunner(XmlSuite xmlSuite) {
        SuiteRunner result = new SuiteRunner(this.getConfiguration(), xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_useDefaultListeners, this.m_methodInterceptors, this.m_invokedMethodListeners, this.m_testListeners);
        for (ISuiteListener isl : this.m_suiteListeners) {
            result.addListener(isl);
        }
        for (IReporter r : result.getReporters()) {
            this.addListener(r);
        }
        for (IConfigurationListener cl : this.m_configuration.getConfigurationListeners()) {
            result.addConfigurationListener(cl);
        }
        return result;
    }

    protected IConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public static void main(String[] argv) {
        TestNG testng = TestNG.privateMain(argv, null);
        System.exit(testng.getStatus());
    }

    public static TestNG privateMain(String[] argv, ITestListener listener) {
        TestNG result = new TestNG();
        if (null != listener) {
            result.addListener(listener);
        }
        try {
            CommandLineArgs cla = new CommandLineArgs();
            m_jCommander = new JCommander((Object)cla, argv);
            TestNG.validateCommandLineParameters(cla);
            result.configure(cla);
        }
        catch (ParameterException ex) {
            TestNG.exitWithError(ex.getMessage());
        }
        try {
            result.run();
        }
        catch (TestNGException ex) {
            if (TestRunner.getVerbose() > 1) {
                ex.printStackTrace(System.out);
            } else {
                TestNG.error(ex.getMessage());
            }
            result.setStatus(1);
        }
        return result;
    }

    protected void configure(CommandLineArgs cla) {
        if (cla.verbose != null) {
            this.setVerbose(cla.verbose);
        }
        this.setOutputDirectory(cla.outputDirectory);
        String testClasses = cla.testClass;
        if (null != testClasses) {
            String[] strClasses = testClasses.split(",");
            List classes = Lists.newArrayList();
            String[] stringArray = strClasses;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String c = stringArray[i];
                classes.add(ClassHelper.fileToClass(c));
            }
            this.setTestClasses(classes.toArray(new Class[classes.size()]));
        }
        this.setOutputDirectory(cla.outputDirectory);
        if (cla.testNames != null) {
            this.setTestNames(Arrays.asList(cla.testNames.split(",")));
        }
        if (cla.useDefaultListeners != null) {
            this.setUseDefaultListeners("true".equalsIgnoreCase(cla.useDefaultListeners));
        }
        this.setGroups(cla.groups);
        this.setExcludedGroups(cla.excludedGroups);
        this.setTestJar(cla.testJar);
        this.setXmlPathInJar(cla.xmlPathInJar);
        this.setJUnit(cla.junit);
        this.setMixed(cla.mixed);
        this.setMaster(cla.master);
        this.setSlave(cla.slave);
        this.setSkipFailedInvocationCounts(cla.skipFailedInvocationCounts);
        if (cla.parallelMode != null) {
            this.setParallel(cla.parallelMode);
        }
        if (cla.configFailurePolicy != null) {
            this.setConfigFailurePolicy(cla.configFailurePolicy);
        }
        if (cla.threadCount != null) {
            this.setThreadCount(cla.threadCount);
        }
        if (cla.dataProviderThreadCount != null) {
            this.setDataProviderThreadCount(cla.dataProviderThreadCount);
        }
        if (cla.suiteName != null) {
            this.setDefaultSuiteName(cla.suiteName);
        }
        if (cla.testName != null) {
            this.setDefaultTestName(cla.testName);
        }
        if (cla.listener != null) {
            String sep = ";";
            if (cla.listener.contains(",")) {
                sep = ",";
            }
            String[] strs = Utils.split(cla.listener, sep);
            List<Class> classes = Lists.newArrayList();
            for (String cls : strs) {
                classes.add(ClassHelper.fileToClass(cls));
            }
            this.setListenerClasses(classes);
        }
        if (null != cla.methodSelectors) {
            String[] strs;
            for (String cls : strs = Utils.split(cla.methodSelectors, ",")) {
                String[] sel = Utils.split(cls, ":");
                try {
                    if (sel.length == 2) {
                        this.addMethodSelector(sel[0], Integer.valueOf(sel[1]));
                        continue;
                    }
                    TestNG.error("Method selector value was not in the format org.example.Selector:4");
                }
                catch (NumberFormatException nfe) {
                    TestNG.error("Method selector value was not in the format org.example.Selector:4");
                }
            }
        }
        if (cla.objectFactory != null) {
            this.setObjectFactory(ClassHelper.fileToClass(cla.objectFactory));
        }
        if (cla.testRunnerFactory != null) {
            this.setTestRunnerFactoryClass(ClassHelper.fileToClass(cla.testRunnerFactory));
        }
        if (cla.reporter != null) {
            ReporterConfig reporterConfig = ReporterConfig.deserialize(cla.reporter);
            this.addReporter(reporterConfig);
        }
        if (cla.commandLineMethods.size() > 0) {
            this.m_commandLineMethods = cla.commandLineMethods;
        }
        if (cla.suiteFiles != null) {
            this.setTestSuites(cla.suiteFiles);
        }
        this.setSuiteThreadPoolSize(cla.suiteThreadPoolSize);
        this.setRandomizeSuites(cla.randomizeSuites);
    }

    public void setSuiteThreadPoolSize(Integer suiteThreadPoolSize) {
        this.m_suiteThreadPoolSize = suiteThreadPoolSize;
    }

    public Integer getSuiteThreadPoolSize() {
        return this.m_suiteThreadPoolSize;
    }

    public void setRandomizeSuites(boolean randomizeSuites) {
        this.m_randomizeSuites = randomizeSuites;
    }

    public void setSourcePath(String path) {
    }

    @Deprecated
    public void configure(Map cmdLineArgs) {
        String failurePolicy;
        String reporterConfigs;
        String runnerFactory;
        String objectFactory;
        Object listeners;
        String defaultTestName;
        String defaultSuiteName;
        Integer dptc;
        String threadCount;
        String useDefaultListeners;
        String testNames;
        CommandLineArgs result = new CommandLineArgs();
        Integer verbose = (Integer)cmdLineArgs.get("-log");
        if (null != verbose) {
            result.verbose = verbose;
        }
        result.outputDirectory = (String)cmdLineArgs.get("-d");
        String testClasses = (String)cmdLineArgs.get("-testclass");
        if (null != testClasses) {
            result.testClass = testClasses;
        }
        if ((testNames = (String)cmdLineArgs.get("-testnames")) != null) {
            result.testNames = testNames;
        }
        if (null != (useDefaultListeners = (String)cmdLineArgs.get("-usedefaultlisteners"))) {
            result.useDefaultListeners = useDefaultListeners;
        }
        result.groups = (String)cmdLineArgs.get("-groups");
        result.excludedGroups = (String)cmdLineArgs.get("-excludegroups");
        result.testJar = (String)cmdLineArgs.get("-testjar");
        result.xmlPathInJar = (String)cmdLineArgs.get("-xmlpathinjar");
        result.junit = (Boolean)cmdLineArgs.get("-junit");
        result.mixed = (Boolean)cmdLineArgs.get("-mixed");
        result.master = (String)cmdLineArgs.get("-master");
        result.slave = (String)cmdLineArgs.get("-slave");
        result.skipFailedInvocationCounts = (Boolean)cmdLineArgs.get("-skipfailedinvocationcounts");
        String parallelMode = (String)cmdLineArgs.get("-parallel");
        if (parallelMode != null) {
            result.parallelMode = parallelMode;
        }
        if ((threadCount = (String)cmdLineArgs.get("-threadcount")) != null) {
            result.threadCount = Integer.parseInt(threadCount);
        }
        if ((dptc = (Integer)cmdLineArgs.get("-dataproviderthreadcount")) != null) {
            result.dataProviderThreadCount = dptc;
        }
        if ((defaultSuiteName = (String)cmdLineArgs.get("-suitename")) != null) {
            result.suiteName = defaultSuiteName;
        }
        if ((defaultTestName = (String)cmdLineArgs.get("-testname")) != null) {
            result.testName = defaultTestName;
        }
        result.listener = (listeners = cmdLineArgs.get("-listener")) instanceof List ? Utils.join((List)listeners, ",") : (String)listeners;
        String ms = (String)cmdLineArgs.get("-methodselectors");
        if (null != ms) {
            result.methodSelectors = ms;
        }
        if (null != (objectFactory = (String)cmdLineArgs.get("-objectfactory"))) {
            result.objectFactory = objectFactory;
        }
        if (null != (runnerFactory = (String)cmdLineArgs.get("-testrunfactory"))) {
            result.testRunnerFactory = runnerFactory;
        }
        if ((reporterConfigs = (String)cmdLineArgs.get("-reporter")) != null) {
            result.reporter = reporterConfigs;
        }
        if ((failurePolicy = (String)cmdLineArgs.get("-configfailurepolicy")) != null) {
            result.configFailurePolicy = failurePolicy;
        }
        this.configure(result);
    }

    public void setTestNames(List<String> testNames) {
        this.m_testNames = testNames;
    }

    public void setSkipFailedInvocationCounts(Boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    private void addReporter(ReporterConfig reporterConfig) {
        Object instance = reporterConfig.newReporterInstance();
        if (instance != null) {
            this.addListener(instance);
        } else {
            LOGGER.warn("Could not find reporte class : " + reporterConfig.getClassName());
        }
    }

    public void setMaster(String fileName) {
        this.m_masterfileName = fileName;
    }

    public void setSlave(String fileName) {
        this.m_slavefileName = fileName;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setMixed(Boolean isMixed) {
        if (isMixed == null) {
            return;
        }
        this.m_isMixed = isMixed;
    }

    @Deprecated
    public static void setTestNGVersion() {
        LOGGER.info("setTestNGVersion has been deprecated.");
    }

    @Deprecated
    public static boolean isJdk14() {
        return false;
    }

    protected static void validateCommandLineParameters(CommandLineArgs args) {
        String testClasses = args.testClass;
        List<String> testNgXml = args.suiteFiles;
        String testJar = args.testJar;
        String slave = args.slave;
        List<String> methods = args.commandLineMethods;
        if (testClasses == null && slave == null && testJar == null && (testNgXml == null || testNgXml.isEmpty()) && (methods == null || methods.isEmpty())) {
            throw new ParameterException("You need to specify at least one testng.xml, one class or one method");
        }
        String groups = args.groups;
        String excludedGroups = args.excludedGroups;
        if (!(testJar != null || null == groups && null == excludedGroups || testClasses != null || testNgXml != null && !testNgXml.isEmpty())) {
            throw new ParameterException("Groups option should be used with testclass option");
        }
        if (args.slave != null && args.master != null) {
            throw new ParameterException("-slave can't be combined with -master");
        }
        Boolean junit = args.junit;
        Boolean mixed = args.mixed;
        if (junit.booleanValue() && mixed.booleanValue()) {
            throw new ParameterException("-mixed can't be combined with -junit");
        }
    }

    public boolean hasFailure() {
        return (this.getStatus() & 1) == 1;
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return (this.getStatus() & 4) == 4;
    }

    public boolean hasSkip() {
        return (this.getStatus() & 2) == 2;
    }

    static void exitWithError(String msg) {
        System.err.println(msg);
        TestNG.usage();
        System.exit(1);
    }

    public String getOutputDirectory() {
        return this.m_outputDir;
    }

    public IAnnotationTransformer getAnnotationTransformer() {
        return this.m_annotationTransformer;
    }

    public void setAnnotationTransformer(IAnnotationTransformer t) {
        if (this.m_annotationTransformer != this.m_defaultAnnoProcessor && this.m_annotationTransformer != t) {
            LOGGER.warn("AnnotationTransformer already set");
        }
        this.m_annotationTransformer = t;
    }

    public String getDefaultSuiteName() {
        return this.m_defaultSuiteName;
    }

    public void setDefaultSuiteName(String defaultSuiteName) {
        this.m_defaultSuiteName = defaultSuiteName;
    }

    public String getDefaultTestName() {
        return this.m_defaultTestName;
    }

    public void setDefaultTestName(String defaultTestName) {
        this.m_defaultTestName = defaultTestName;
    }

    public void setConfigFailurePolicy(String failurePolicy) {
        this.m_configFailurePolicy = failurePolicy;
    }

    public String getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    @Deprecated
    public static TestNG getDefault() {
        return m_instance;
    }

    @Deprecated
    public void setHasFailure(boolean hasFailure) {
        this.m_status |= 1;
    }

    @Deprecated
    public void setHasFailureWithinSuccessPercentage(boolean hasFailureWithinSuccessPercentage) {
        this.m_status |= 4;
    }

    @Deprecated
    public void setHasSkip(boolean hasSkip) {
        this.m_status |= 2;
    }

    private void setConfigurable(IConfigurable c) {
        if (this.m_configurable != null && this.m_configurable != c) {
            LOGGER.warn("Configurable already set");
        }
        this.m_configurable = c;
    }

    private void setHookable(IHookable h) {
        if (this.m_hookable != null && this.m_hookable != h) {
            LOGGER.warn("Hookable already set");
        }
        this.m_hookable = h;
    }

    public void setMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptors.add(methodInterceptor);
    }

    public void setDataProviderThreadCount(int count) {
        this.m_dataProviderThreadCount = count;
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader != null) {
            ClassHelper.addClassLoader(loader);
        }
    }

    public void setPreserveOrder(boolean b) {
        this.m_preserveOrder = b;
    }

    protected long getStart() {
        return this.m_start;
    }

    protected long getEnd() {
        return this.m_end;
    }

    public void setGroupByInstances(boolean b) {
        this.m_groupByInstances = b;
    }

    public void setServiceLoaderClassLoader(URLClassLoader ucl) {
        this.m_serviceLoaderClassLoader = ucl;
    }

    private void addServiceLoaderListener(ITestNGListener l) {
        this.m_serviceLoaderListeners.add(l);
    }

    public List<ITestNGListener> getServiceLoaderListeners() {
        return this.m_serviceLoaderListeners;
    }

    static {
        DEFAULT_VERBOSE = 1;
    }

    public static class ExitCodeListener
    implements IResultListener2 {
        private TestNG m_mainRunner;

        public ExitCodeListener() {
            this.m_mainRunner = m_instance;
        }

        public ExitCodeListener(TestNG runner) {
            this.m_mainRunner = runner;
        }

        @Override
        public void beforeConfiguration(ITestResult tr) {
        }

        @Override
        public void onTestFailure(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(1);
        }

        @Override
        public void onTestSkipped(ITestResult result) {
            this.setHasRunTests();
            if ((this.m_mainRunner.getStatus() & 1) != 0) {
                this.m_mainRunner.setStatus(2);
            }
        }

        @Override
        public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(4);
        }

        @Override
        public void onTestSuccess(ITestResult result) {
            this.setHasRunTests();
        }

        @Override
        public void onStart(ITestContext context) {
            this.setHasRunTests();
        }

        @Override
        public void onFinish(ITestContext context) {
        }

        @Override
        public void onTestStart(ITestResult result) {
            this.setHasRunTests();
        }

        private void setHasRunTests() {
            this.m_mainRunner.m_hasTests = true;
        }

        @Override
        public void onConfigurationFailure(ITestResult itr) {
            this.m_mainRunner.setStatus(1);
        }

        @Override
        public void onConfigurationSkip(ITestResult itr) {
            this.m_mainRunner.setStatus(2);
        }

        @Override
        public void onConfigurationSuccess(ITestResult itr) {
        }
    }
}

