/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.CommandListener;
import com.sun.tdk.jcov.Merger;
import com.sun.tdk.jcov.Server;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Grabber
extends JCovCMDTool {
    static final Logger logger;
    public static final String COMMAND_PORT_PORPERTY = "jcov.grabber.commandPort";
    public static final String MAX_COUNT_PROPERTY = "jcov.grabber.maxCount";
    public static final String OUTPUTFILE_PROPERTY = "jcov.grabber.outputfile";
    public static final String PORT_PROPERTY = "jcov.grabber.port";
    public static final String RUN_LINE_PROPERTY = "jcov.grabber.runLine";
    public static final String SAVE_ON_RECEIVE_PROPERTY = "jcov.grabber.saveOnReceive";
    public static final String SAVE_IN_SHUTDOWN_HOOK_PROPERTY = "jcov.grabber.shutdownHookInstalled";
    public static final String TEMPLATE_PROPERTY = "jcov.grabber.template";
    public static final String SERVER_VERSION_PROPERTY = "jcov.grabber.version";
    public static final String SERVER_LOCAL_HOSTNAME_PROPERTY = "jcov.grabber.localhostname";
    private boolean saveInShutdownHook = false;
    private String propfile;
    private String hostName;
    private int maxCount;
    private Thread shutdownHook = null;
    private boolean noCommand;
    private CommandListener commandListener = null;
    private int commandPort;
    private String runCommand;
    private int port;
    private Server server = null;
    private boolean once;
    private String template;
    private String filename;
    private boolean saveOnReceive;
    private String onceHostToConnect;
    private String outTestList;
    private boolean genscale;
    private String baddata;
    private String messageFormat;
    private boolean mergeByTestNames = false;
    public static final OptionDescr DSC_SAVE_MODE;
    public static final OptionDescr DSC_OUTPUT;
    public static final OptionDescr DSC_VERBOSE;
    public static final OptionDescr DSC_VERBOSEST;
    public static final OptionDescr DSC_SHOW_MEMORY_CHECKS;
    public static final OptionDescr DSC_HOSTNAME;
    public static final OptionDescr DSC_ONCE;
    public static final OptionDescr DSC_PORT;
    public static final OptionDescr DSC_COUNT;
    public static final OptionDescr DSC_COMMAND_PORT;
    public static final OptionDescr DSC_NO_COMMAND;
    public static final OptionDescr DSC_PROPFILE;
    public static final OptionDescr DSC_BADDATA;
    public static final OptionDescr DSC_MESSAGE_FORMAT;
    public static final OptionDescr DSC_SCALE_BY_NAME;

    public Properties getProperties() {
        Properties ps = new Properties();
        ps.setProperty(PORT_PROPERTY, Integer.toString(this.server.getPort()));
        if (this.commandListener != null) {
            ps.setProperty(COMMAND_PORT_PORPERTY, Integer.toString(this.commandListener.getPort()));
            ps.setProperty(RUN_LINE_PROPERTY, this.commandListener.getRunCommand());
        }
        ps.setProperty(SAVE_ON_RECEIVE_PROPERTY, Boolean.toString(this.server.isSaveOnReceive()));
        ps.setProperty(SAVE_IN_SHUTDOWN_HOOK_PROPERTY, Boolean.toString(this.saveInShutdownHook));
        ps.setProperty(MAX_COUNT_PROPERTY, Integer.toString(this.server.getMaxCount()));
        if (this.server != null) {
            ps.setProperty(TEMPLATE_PROPERTY, this.server.getTemplateName());
            ps.setProperty(OUTPUTFILE_PROPERTY, this.server.getFileName());
        }
        ps.setProperty(SERVER_VERSION_PROPERTY, "3.0-2");
        try {
            ps.setProperty(SERVER_LOCAL_HOSTNAME_PROPERTY, InetAddress.getLocalHost().toString());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropfile(String file) throws IOException {
        Properties ps = this.getProperties();
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file);
            ps.store(out, null);
        }
    }

    public void waitForStopping() throws InterruptedException {
        if (this.server != null) {
            this.server.join();
        }
        if (this.commandListener != null) {
            this.commandListener.kill();
            this.commandListener.join();
        }
    }

    public void start(boolean startCommandListener) throws BindException, IOException {
        this.saveInShutdownHook = true;
        this.createServer();
        if (startCommandListener) {
            this.startCommandListener(this.commandPort);
        }
        this.installShutdownHook();
        this.startServer();
    }

    public void createServer() throws BindException, IOException {
        this.server = new Server(this.port, this.once, this.template, this.filename, this.outTestList, this.hostName, this.maxCount, this.saveOnReceive, this.genscale, this.mergeByTestNames);
        this.server.setSaveBadData(this.baddata);
    }

    public void startServer() {
        this.server.start();
    }

    public void startCommandListener(int commandPort) throws BindException, IOException {
        if (this.server == null) {
            throw new IllegalStateException("Server is not created");
        }
        if (this.commandListener != null && this.commandListener.isAlive()) {
            return;
        }
        this.commandListener = new CommandListener(commandPort, this.server);
        this.commandListener.start();
    }

    public void startCommandListener(int commandPort, String runCommand) throws BindException, IOException {
        if (this.server == null) {
            throw new IllegalStateException("Server is not created");
        }
        if (this.commandListener != null && this.commandListener.isAlive()) {
            return;
        }
        this.commandListener = new CommandListener(commandPort, this.server, runCommand, this.hostName);
        this.commandListener.start();
    }

    public void installShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                @Override
                public void run() {
                    logger.log(Level.CONFIG, "Shutdownhook fired");
                    if (Grabber.this.commandListener != null) {
                        Grabber.this.commandListener.kill();
                    }
                    if (Grabber.this.server != null && Grabber.this.server.isWorking()) {
                        if (Grabber.this.saveInShutdownHook) {
                            Grabber.this.server.saveData();
                        }
                        Grabber.this.server.kill(false);
                    }
                    logger.log(Level.FINE, "Shutdownhook done");
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            logger.log(Level.FINE, "Shutdownhook installed");
        }
    }

    public void stopServer(boolean force) {
        if (this.server != null) {
            this.server.kill(force);
            this.server = null;
        }
        if (this.commandListener != null) {
            this.stopCommandListener();
        }
    }

    public void stopCommandListener() {
        this.commandListener.kill();
        this.commandListener = null;
    }

    public boolean setRunCommand(String command) {
        if (this.commandListener != null) {
            this.commandListener.setRunCommand(command);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Grabber tool = new Grabber();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    @Override
    public String usageString() {
        return "java com.sun.tdk.jcov.Grabber [-option value]";
    }

    @Override
    public String exampleString() {
        return "java -cp jcov.jar com.sun.tdk.jcov.Grabber -output grabbed.xml -port 3000 -once -merge";
    }

    @Override
    protected String getDescr() {
        return "gathers information from JCov runtime via sockets";
    }

    public int getServerPort() {
        if (this.server != null) {
            return this.server.getPort();
        }
        return -1;
    }

    public int getCommandListenerPort() {
        if (this.commandListener != null) {
            return this.commandListener.getPort();
        }
        return -1;
    }

    @Override
    public EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_OUTPUT, DSC_VERBOSE, DSC_VERBOSEST, DSC_SHOW_MEMORY_CHECKS, InstrumentationOptions.DSC_TEMPLATE, DSC_HOSTNAME, DSC_ONCE, DSC_PORT, DSC_COUNT, DSC_SAVE_MODE, DSC_COMMAND_PORT, DSC_PROPFILE, Merger.DSC_OUTPUT_TEST_LIST, Merger.DSC_SCALE, DSC_BADDATA, DSC_MESSAGE_FORMAT, DSC_SCALE_BY_NAME}, (JCovTool)this);
    }

    @Override
    public int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        this.template = opts.getValue(InstrumentationOptions.DSC_TEMPLATE);
        try {
            File t = Utils.checkFileNotNull(this.template, "template filename", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_CANREAD);
            long recomendedMemory = Math.max(1000000000L, t.length() * 16L + 150000000L);
            long minMemory = Math.max(468000000L, t.length() * 6L + 50000000L);
            if (Runtime.getRuntime().maxMemory() < minMemory) {
                logger.log(Level.WARNING, "Grabber started with {0}M max memory. Minimal requirement for this template is {1}M, recomended {2}M. ", new Object[]{Runtime.getRuntime().maxMemory() / 1000000L, minMemory / 1000000L, recomendedMemory / 1000000L});
            } else if (Runtime.getRuntime().maxMemory() < recomendedMemory) {
                logger.log(Level.WARNING, "Grabber started with {0}M max memory. It''s recomended to have at least {1}M max memory. ", new Object[]{Runtime.getRuntime().maxMemory() / 1000000L, recomendedMemory / 1000000L});
            }
        }
        catch (JCovTool.EnvHandlingException ex) {
            if (opts.isSet(InstrumentationOptions.DSC_TEMPLATE)) {
                throw ex;
            }
            logger.log(Level.WARNING, "Grabber started without template, accepting only dynamic data");
            this.template = null;
        }
        try {
            InetAddress adr = InetAddress.getLocalHost();
            this.hostName = adr.getHostName();
        }
        catch (Exception ee) {
            logger.log(Level.WARNING, "Can't get real local host name, using '<localhost>'");
            this.hostName = "<localhost>";
        }
        if (opts.isSet(DSC_VERBOSE)) {
            Utils.setLoggingLevel(Level.INFO);
        }
        if (opts.isSet(DSC_VERBOSEST)) {
            Utils.setLoggingLevel(Level.ALL);
        }
        if (opts.isSet(DSC_SHOW_MEMORY_CHECKS)) {
            Server.showMemoryChecks = true;
        }
        this.once = opts.isSet(DSC_ONCE);
        this.port = opts.isSet(DSC_PORT) ? Utils.checkedToInt(opts.getValue(DSC_PORT), "port number", Utils.CheckOptions.INT_NONNEGATIVE) : (this.once ? 3335 : 3334);
        this.maxCount = Utils.checkedToInt(opts.getValue(DSC_COUNT), "max connections count", new Utils.CheckOptions[0]);
        this.filename = opts.isSet(DSC_OUTPUT) ? opts.getValue(DSC_OUTPUT) : "result.xml";
        Utils.checkFileNotNull(this.filename, "output filename", Utils.CheckOptions.FILE_PARENTEXISTS, Utils.CheckOptions.FILE_NOTISDIR);
        this.saveOnReceive = "receive".equalsIgnoreCase(opts.getValue(DSC_SAVE_MODE));
        if (this.once) {
            this.onceHostToConnect = opts.getValue(DSC_HOSTNAME);
            Utils.checkHostCanBeNull(this.onceHostToConnect, "testing host");
        }
        String commandPortStr = opts.getValue(DSC_COMMAND_PORT);
        this.commandPort = this.once ? 0 : (commandPortStr == null ? 3336 : Utils.checkedToInt(commandPortStr, "command port number", new Utils.CheckOptions[0]));
        this.noCommand = opts.isSet(DSC_NO_COMMAND);
        this.propfile = opts.getValue(DSC_PROPFILE);
        Utils.checkFileCanBeNull(this.propfile, "property filename", Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_PARENTEXISTS);
        this.runCommand = opts.unParse();
        this.outTestList = opts.getValue(Merger.DSC_OUTPUT_TEST_LIST);
        Utils.checkFileCanBeNull(this.outTestList, "output testlist filename", Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_PARENTEXISTS);
        this.genscale = opts.isSet(Merger.DSC_SCALE);
        this.baddata = opts.getValue(DSC_BADDATA);
        Utils.checkFileCanBeNull(this.baddata, "directory for bad datafiles", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISDIR);
        this.messageFormat = opts.getCleanValue(DSC_MESSAGE_FORMAT);
        this.mergeByTestNames = opts.isSet(DSC_SCALE_BY_NAME);
        return 0;
    }

    @Override
    public int run() throws Exception {
        if (!this.saveOnReceive) {
            logger.log(Level.INFO, "Installing shutdown hook");
        }
        this.saveInShutdownHook = !this.saveOnReceive;
        try {
            boolean shouldStartCL;
            this.createServer();
            int returnValue = 0;
            boolean bl = shouldStartCL = !this.once || this.noCommand;
            if (shouldStartCL) {
                try {
                    this.startCommandListener(this.commandPort, this.runCommand);
                }
                catch (BindException ex) {
                    logger.log(Level.SEVERE, "Cannot bind CommandListener to {0}: {1}", new Object[]{this.commandPort == 0 ? "any free port" : "port " + String.valueOf(this.commandPort), ex.getMessage()});
                    returnValue = 6;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Cannot create CommandListener", ex);
                    returnValue = 6;
                }
            }
            if (!shouldStartCL || this.commandListener != null) {
                this.installShutdownHook();
                this.startServer();
                char[] c = new char[]{'p', 'h', 'c', 't', 'C', 'o', 'O', 's', 'S'};
                String[] s = new String[]{Integer.toString(this.server.getPort()), this.hostName, Integer.toString(this.commandListener.getPort()), this.template, Integer.toString(this.maxCount), this.filename, this.outTestList, Boolean.toString(this.genscale), this.saveOnReceive ? "receive" : "exit"};
                System.out.println(PropertyFinder.processMacroString(this.messageFormat, c, s));
                String file = this.propfile;
                if (file != null) {
                    try {
                        this.writePropfile(file);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Error while trying to store properties file: ", ex);
                    }
                }
            } else {
                this.server.kill(true);
            }
            logger.log(Level.INFO, "Waiting for closing all processes");
            this.waitForStopping();
            logger.log(Level.INFO, "Server is stopped");
            return returnValue;
        }
        catch (BindException ex) {
            logger.log(Level.SEVERE, "Cannot bind Server to {0}: {1}", new Object[]{this.port == 0 ? "any free port" : "port " + String.valueOf(this.commandPort), ex.getMessage()});
            return 5;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Cannot create Server", ex);
            return 5;
        }
    }

    public int getCommandPort() {
        return this.commandPort;
    }

    public void setCommandPort(int commandPort) {
        this.commandPort = commandPort;
    }

    public String getOutputFilename() {
        return this.filename;
    }

    public void setOutputFilename(String filename) {
        this.filename = filename;
    }

    public boolean isGenscale() {
        return this.genscale;
    }

    public void setGenscale(boolean genscale) {
        this.genscale = genscale;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public boolean isNoCommand() {
        return this.noCommand;
    }

    public void setNoCommand(boolean noCommand) {
        this.noCommand = noCommand;
    }

    public boolean isOnce() {
        return this.once;
    }

    public void setOnce(boolean once) {
        this.once = once;
    }

    public String getHostToConnect() {
        return this.onceHostToConnect;
    }

    public void setHostToConnect(String onceHostToConnect) {
        this.onceHostToConnect = onceHostToConnect;
    }

    public String getOutTestList() {
        return this.outTestList;
    }

    public void setOutTestList(String outTestList) {
        this.outTestList = outTestList;
    }

    public void setMergeByTestNames(boolean mergeByTestNames) {
        this.mergeByTestNames = mergeByTestNames;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSaveInShutdownHook() {
        return this.saveInShutdownHook;
    }

    public void setSaveInShutdownHook(boolean saveInShutdownHook) {
        this.saveInShutdownHook = saveInShutdownHook;
    }

    public boolean isSaveOnReceive() {
        return this.saveOnReceive;
    }

    public void setSaveOnReceive(boolean saveOnReceive) {
        this.saveOnReceive = saveOnReceive;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getMessageString() {
        return this.messageFormat;
    }

    public void setMessageString(String message) {
        this.messageFormat = message;
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(Grabber.class.getName());
        DSC_SAVE_MODE = new OptionDescr("save", "", 1, (String[][])new String[][]{{"receive", "Save data to a file on receiving and then merge into it"}, {"exit", "Save data on exit merging it in memory (faster but more memory used)"}}, "Specify when incoming data should be merged and saved.", "exit");
        DSC_OUTPUT = new OptionDescr("grabber.output", new String[]{"output", "o"}, "Output parameters definition", 1, "Specifies output file.", "result.xml for xml format or java.jcov for legacy");
        DSC_VERBOSE = new OptionDescr("verbose", new String[]{"v"}, "Verbosity level", "Show more messages.");
        DSC_VERBOSEST = new OptionDescr("verbosemore", new String[]{"vv"}, "", "Show all messages.");
        DSC_SHOW_MEMORY_CHECKS = new OptionDescr("showmemory", "", "Show memory checks.");
        DSC_HOSTNAME = new OptionDescr("hostname", "Connection parameters", 1, "Specify host to connect when client mode is used.", "localhost");
        DSC_ONCE = new OptionDescr("once", new String[]{"client"}, "", "Specify client mode.");
        DSC_PORT = new OptionDescr("port", "", 1, "Specify port. Use -port 0 to use any free port for server (only for server mode)", "3334 for server mode, or 3335 for client mode.");
        DSC_COUNT = new OptionDescr("count", "", 1, "Specify maximum times of receiving data. 0 corresponds to unlimited.", "0");
        DSC_COMMAND_PORT = new OptionDescr("command_port", new String[]{"command"}, "", 1, "Set port to listen commands. Use -command 0 to use any free port for command listener.", Integer.toString(3336));
        DSC_NO_COMMAND = new OptionDescr("nocommand", new String[]{"nc"}, "", 0, "Use to not run command listener");
        DSC_PROPFILE = new OptionDescr("grabber.props", "Properties file", 1, "Write properties to a file to use them in the manager.");
        DSC_BADDATA = new OptionDescr("baddatato", "manage bad data", 1, "Directory to write data that can't be merged with the template.");
        DSC_MESSAGE_FORMAT = new OptionDescr("message", "welcome message format", 1, "Specify format for output welcome message. %p% - port, %c% - command port, %h% - running host, %t% - used template, %C% - maximum connection count (0 == unlimited), %o% - output file, %O% - output testlist file, %s% - generate scales, %S% - save at receive or exit", "Server started on %h%:%p%. Command listener at port %c%. Used template '%t%'.");
        DSC_SCALE_BY_NAME = new OptionDescr("mergebyname", "process/generate test scales", "test name identifies the test. tests with same name will be automatically merged");
    }
}

