/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.insert.AbstractUniversalInstrumenter;
import com.sun.tdk.jcov.instrument.ClassMorph;
import com.sun.tdk.jcov.instrument.ClassMorph2;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instr2
extends JCovCMDTool {
    private boolean genabstract;
    private boolean genfield;
    private boolean gennative;
    private boolean gensynthetic;
    private boolean genanonymous;
    private String template;
    private String flushPath;
    private String[] include;
    private String[] exclude;
    private static final Logger logger;
    private String[] srcs;
    private File outDir;
    static final OptionDescr DSC_OUTPUT;
    static final OptionDescr DSC_VERBOSE;

    public static void main(String[] args) {
        Instr2 tool = new Instr2();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    @Override
    protected String usageString() {
        return "java com.sun.tdk.jcov.Instr2 [-option [value]]";
    }

    @Override
    protected String exampleString() {
        return "java -cp jcov.jar com.sun.tdk.jcov.Instr2 -include java.lang.* -abstract on -native on -field on -template mytemplate.xml instrumented_classes";
    }

    @Override
    protected String getDescr() {
        return "instrumenter designed for abstract, native methods and fields";
    }

    @Override
    protected int run() throws Exception {
        Utils.addToClasspath(this.srcs);
        AbstractUniversalInstrumenter instrumenter = new AbstractUniversalInstrumenter(true){
            ClassMorph2 morph;
            {
                this.morph = new ClassMorph2(new InstrumentationParams(Instr2.this.gennative, Instr2.this.genfield, Instr2.this.genabstract, Instr2.this.include, Instr2.this.exclude, InstrumentationOptions.InstrumentationMode.BLOCK).setInstrumentAnonymous(Instr2.this.genanonymous).setInstrumentSynthetic(Instr2.this.gensynthetic), Instr2.this.template);
            }

            @Override
            protected byte[] instrument(byte[] classData, int classLen) throws IOException {
                return this.morph.morph(classData, Instr2.this.flushPath);
            }

            @Override
            public void finishWork() {
            }
        };
        for (String root : this.srcs) {
            instrumenter.instrument(new File(root), this.outDir);
        }
        instrumenter.finishWork();
        return 0;
    }

    @Override
    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_OUTPUT, DSC_VERBOSE, InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_TEMPLATE, InstrumentationOptions.DSC_ABSTRACT, InstrumentationOptions.DSC_NATIVE, InstrumentationOptions.DSC_FIELD, InstrumentationOptions.DSC_SYNTHETIC, InstrumentationOptions.DSC_ANONYM, ClassMorph.DSC_FLUSH_CLASSES}, (JCovTool)this);
    }

    @Override
    protected int handleEnv(EnvHandler envHandler) throws JCovTool.EnvHandlingException {
        String abstractValue;
        this.srcs = envHandler.getTail();
        if (this.srcs == null) {
            throw new JCovTool.EnvHandlingException("No input files specified");
        }
        if (envHandler.isSet(DSC_VERBOSE)) {
            logger.setLevel(Level.INFO);
        }
        this.outDir = null;
        if (envHandler.isSet(DSC_OUTPUT)) {
            this.outDir = new File(envHandler.getValue(DSC_OUTPUT));
            if (!this.outDir.exists()) {
                this.outDir.mkdirs();
                logger.log(Level.INFO, "The directory {0} was created.", this.outDir.getAbsolutePath());
            }
        }
        if ((abstractValue = envHandler.getValue(InstrumentationOptions.DSC_ABSTRACT)).equals("off")) {
            this.genabstract = false;
        } else if (abstractValue.equals("on")) {
            this.genabstract = true;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_ABSTRACT.name + "' parameter value error: expected 'on' or 'off'; found: '" + abstractValue + "'");
        }
        String nativeValue = envHandler.getValue(InstrumentationOptions.DSC_NATIVE);
        if (nativeValue.equals("on")) {
            this.gennative = true;
        } else if (nativeValue.equals("off")) {
            this.gennative = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_NATIVE.name + "' parameter value error: expected 'on' or 'off'; found: '" + nativeValue + "'");
        }
        String fieldValue = envHandler.getValue(InstrumentationOptions.DSC_FIELD);
        if (fieldValue.equals("on")) {
            this.genfield = true;
        } else if (fieldValue.equals("off")) {
            this.genfield = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_FIELD.name + "' parameter value error: expected 'on' or 'off'; found: '" + fieldValue + "'");
        }
        String anonym = envHandler.getValue(InstrumentationOptions.DSC_ANONYM);
        this.genanonymous = anonym.equals("on");
        String syntheticField = envHandler.getValue(InstrumentationOptions.DSC_SYNTHETIC);
        this.gensynthetic = syntheticField.equals("on");
        this.template = envHandler.getValue(InstrumentationOptions.DSC_TEMPLATE);
        Utils.checkFileNotNull(this.template, "template filename", Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_PARENTEXISTS);
        this.include = InstrumentationOptions.handleInclude(envHandler);
        this.exclude = InstrumentationOptions.handleExclude(envHandler);
        this.flushPath = envHandler.getValue(ClassMorph.DSC_FLUSH_CLASSES);
        if ("none".equals(this.flushPath)) {
            this.flushPath = null;
        }
        return 0;
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(Instr2.class.getName());
        DSC_OUTPUT = new OptionDescr("instr2.output", new String[]{"output", "o"}, "Output directory", 1, "Specifies output file or directory, default directory is current.");
        DSC_VERBOSE = new OptionDescr("verbose", "Verbose mode", "Enable verbose mode.");
    }
}

