/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.filter;

import com.sun.tdk.jcov.filter.FilterSpi;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;

public class FilterFactory {
    private FilterSpi spi = null;

    private FilterFactory(String spiClassName) {
        if (spiClassName == null) {
            this.spi = null;
        } else {
            try {
                Class<?> spiClass = Class.forName(spiClassName);
                this.spi = (FilterSpi)spiClass.newInstance();
            }
            catch (Exception e) {
                throw new Error("Cannot create an instance of FilterFactorySpi: " + e);
            }
        }
    }

    public static FilterFactory getInstance(String spiClassName) {
        return new FilterFactory(spiClassName);
    }

    public MemberFilter getMemberFilter() {
        MemberFilter filter = this.spi == null ? MemberFilter.ACCEPT_ALL : new DelegateFilter(this.spi);
        return filter;
    }

    final class DelegateFilter
    implements MemberFilter {
        private String spiName;
        private MemberFilter delegate;

        DelegateFilter(FilterSpi spi) {
            this.spiName = spi.getClass().getName();
            this.delegate = spi.getFilter();
        }

        @Override
        public boolean accept(DataClass clz) {
            if (this.delegate == null) {
                throw new UnsupportedOperationException("Trying to filter using " + this.spiName);
            }
            return this.delegate.accept(clz);
        }

        @Override
        public boolean accept(DataClass clz, DataMethod m) {
            if (this.delegate == null) {
                throw new UnsupportedOperationException("Trying to filter modern data using " + this.spiName);
            }
            return this.delegate.accept(clz, m);
        }

        @Override
        public boolean accept(DataClass clz, DataField f) {
            if (this.delegate == null) {
                throw new UnsupportedOperationException("Trying to filter modern data using " + this.spiName);
            }
            return this.delegate.accept(clz, f);
        }

        public String toString() {
            return this.delegate == null ? this.spiName + " filter" : this.delegate.toString();
        }
    }
}

