/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.LocationConcrete;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;

public class CharacterRangeTableAttribute
extends Attribute {
    public int length;
    public CRTEntry[] entries;
    private int rootId;

    public int getRootId() {
        return this.rootId;
    }

    public void setRootId(int rootId) {
        this.rootId = rootId;
    }

    public CharacterRangeTableAttribute(int rootId) {
        this(rootId, 0, new CRTEntry[0]);
    }

    CharacterRangeTableAttribute(int rootId, int length, CRTEntry[] entries) {
        super("CharacterRangeTable");
        this.length = length;
        this.entries = entries;
        this.rootId = rootId;
    }

    CRTEntry[] getEntries() {
        return this.entries;
    }

    public void setEntries(CRTEntry[] entries) {
        this.entries = entries;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    CRTEntry getEntry(int pc, int flag) {
        CRTEntry result = null;
        for (CRTEntry entry : this.getEntries()) {
            if (entry.startBCI() != pc || (entry.flags & flag) == 0) continue;
            result = result == null ? entry : (entry.char_start < result.char_start ? entry : result);
        }
        return result;
    }

    @Override
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        int length = cr.readShort(off);
        CRTEntry[] entries = new CRTEntry[length];
        for (int i = 0; i < length; ++i) {
            int eoff = off + 2 + i * 14;
            short start_pc = cr.readShort(eoff + 0);
            short end_pc = cr.readShort(eoff + 2);
            int char_start = cr.readInt(eoff + 4);
            int char_end = cr.readInt(eoff + 8);
            short flags = cr.readShort(eoff + 12);
            entries[i] = new CRTEntry(this.rootId, start_pc, end_pc, char_start, char_end, flags);
        }
        return new CharacterRangeTableAttribute(this.rootId, length, entries);
    }

    @Override
    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        bv.putShort(this.length);
        for (CRTEntry entry : this.entries) {
            entry.put(bv);
        }
        return bv;
    }

    void xmlGen(XmlContext ctx) {
        ctx.indent();
        ctx.println("<crt>");
        ctx.incIndent();
        for (CRTEntry entry : this.entries) {
            entry.xmlGen(ctx);
        }
        ctx.decIndent();
        ctx.indent();
        ctx.println("</crt>");
    }

    public void readDataFrom() throws FileFormatException {
        ReaderFactory rf = DataRoot.getInstance(this.rootId).getReaderFactory();
        Reader r = rf.getReaderFor(this);
        r.readData(this);
    }

    public int getPos(int line, int col) {
        return line << 10 | col;
    }

    public static class CRTEntry
    extends LocationConcrete {
        public final int char_start;
        public final int char_end;
        public final int flags;
        public static final int CRT_STATEMENT = 1;
        public static final int CRT_BLOCK = 2;
        public static final int CRT_ASSIGNMENT = 4;
        public static final int CRT_FLOW_CONTROLLER = 8;
        public static final int CRT_FLOW_TARGET = 16;
        public static final int CRT_INVOKE = 32;
        public static final int CRT_CREATE = 64;
        public static final int CRT_BRANCH_TRUE = 128;
        public static final int CRT_BRANCH_FALSE = 256;

        public CRTEntry(int rootId, int start_pc, int end_pc, int char_start, int char_end, int flags) {
            super(rootId, start_pc, end_pc);
            this.char_start = char_start;
            this.char_end = char_end;
            this.flags = flags;
        }

        void put(ByteVector bv) {
            bv.putShort(this.startBCI());
            bv.putShort(this.endBCI());
            bv.putInt(this.char_start);
            bv.putInt(this.char_end);
            bv.putShort(this.flags);
        }

        @Override
        public String kind() {
            return "range";
        }

        @Override
        void xmlAttrs(XmlContext ctx) {
            super.xmlAttrs(ctx);
            if ((this.flags & 1) != 0) {
                ctx.attr("statement", true);
            }
            if ((this.flags & 2) != 0) {
                ctx.attr("block", true);
            }
            if ((this.flags & 4) != 0) {
                ctx.attr("assignment", true);
            }
            if ((this.flags & 8) != 0) {
                ctx.attr("controller", true);
            }
            if ((this.flags & 0x10) != 0) {
                ctx.attr("target", true);
            }
            if ((this.flags & 0x20) != 0) {
                ctx.attr("invoke", true);
            }
            if ((this.flags & 0x40) != 0) {
                ctx.attr("create", true);
            }
            if ((this.flags & 0x80) != 0) {
                ctx.attr("branchtrue", true);
            }
            if ((this.flags & 0x100) != 0) {
                ctx.attr("branchfalse", true);
            }
        }

        private void xmlPos(XmlContext ctx, int char_pos) {
            ctx.indent();
            ctx.format("<pos line='%d' col='%d'/>", char_pos >> 10, char_pos & 0x3FF);
            ctx.println();
        }

        @Override
        void xmlBody(XmlContext ctx) {
            this.xmlPos(ctx, this.char_start);
            this.xmlPos(ctx, this.char_end);
        }
    }
}

