/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public abstract class DataAbstract {
    protected int rootId;
    public static final int ACCESS_MASK = Short.MAX_VALUE;

    DataAbstract(int rootId) {
        this.rootId = rootId;
    }

    public int rootId() {
        return this.rootId;
    }

    public abstract String kind();

    void xmlTagOpen(XmlContext ctx, String tag) {
        ctx.indent();
        ctx.print("<");
        ctx.print(tag);
        this.xmlAttrs(ctx);
        ctx.println(">");
    }

    void xmlTagClose(XmlContext ctx, String tag) {
        ctx.indent();
        ctx.print("</");
        ctx.print(tag);
        ctx.println(">");
    }

    void xmlTagSingle(XmlContext ctx, String tag) {
        ctx.indent();
        ctx.print("<");
        ctx.print(tag);
        this.xmlAttrs(ctx);
        ctx.println("/>");
    }

    void xmlAttrs(XmlContext ctx) {
    }

    void xmlBody(XmlContext ctx) {
    }

    void xmlGen(XmlContext ctx) {
        this.xmlTagOpen(ctx, this.kind());
        ctx.incIndent();
        this.xmlBody(ctx);
        ctx.decIndent();
        this.xmlTagClose(ctx, this.kind());
    }

    void xmlGenBodiless(XmlContext ctx) {
        this.xmlTagSingle(ctx, this.kind());
    }

    void xmlAccessFlags(XmlContext ctx, int access) {
        String[] flags;
        ctx.print(" flags='");
        for (String fl : flags = this.accessFlags(access)) {
            ctx.print(" " + fl);
        }
        ctx.print("'");
    }

    public void readDataFrom() throws FileFormatException {
        ReaderFactory rf = DataRoot.getInstance(this.rootId).getReaderFactory();
        Reader r = rf.getReaderFor(this);
        r.readData(this);
    }

    String[] accessFlags(int access) {
        ArrayList<String> flags = new ArrayList<String>();
        if ((access & 1) != 0) {
            flags.add("public");
        }
        if ((access & 2) != 0) {
            flags.add("private");
        }
        if ((access & 4) != 0) {
            flags.add("protected");
        }
        if ((access & 8) != 0) {
            flags.add("static");
        }
        if ((access & 0x10) != 0) {
            flags.add("final");
        }
        if ((access & 0x20) != 0) {
            flags.add("synchronized");
        }
        if ((access & 0x40) != 0) {
            flags.add("volatile");
        }
        if ((access & 0x40) != 0) {
            flags.add("bridge");
        }
        if ((access & 0x80) != 0) {
            flags.add("varargs");
        }
        if ((access & 0x80) != 0) {
            flags.add("transient");
        }
        if ((access & 0x100) != 0) {
            flags.add("native");
        }
        if ((access & 0x200) != 0) {
            flags.add("interface");
        }
        if ((access & 0x400) != 0) {
            flags.add("abstract");
        }
        if ((access & 0x800) != 0) {
            flags.add("strict");
        }
        if ((access & 0x2000) != 0) {
            flags.add("annotation");
        }
        if ((access & 0x4000) != 0) {
            flags.add("enum");
        }
        if ((access & 0x1000) != 0) {
            flags.add("synthetic");
        }
        return flags.isEmpty() ? new String[]{} : flags.toArray(new String[flags.size()]);
    }

    public int access(String[] accessFlags) {
        int access = 0;
        for (String flag : accessFlags) {
            if (flag.contains("public")) {
                access |= 1;
            }
            if (flag.contains("private")) {
                access |= 2;
            }
            if (flag.contains("protected")) {
                access |= 4;
            }
            if (flag.contains("static")) {
                access |= 8;
            }
            if (flag.contains("final")) {
                access |= 0x10;
            }
            if (flag.contains("volatile")) {
                access |= 0x40;
            }
            if (flag.contains("bridge")) {
                access |= 0x40;
            }
            if (flag.contains("varargs")) {
                access |= 0x80;
            }
            if (flag.contains("transient")) {
                access |= 0x80;
            }
            if (flag.contains("native")) {
                access |= 0x100;
            }
            if (flag.contains("interface") || flag.contains("defender")) {
                access |= 0x200;
            }
            if (flag.contains("abstract")) {
                access |= 0x400;
            }
            if (flag.contains("strict")) {
                access |= 0x800;
            }
            if (flag.contains("annotation")) {
                access |= 0x2000;
            }
            if (flag.contains("enum")) {
                access |= 0x4000;
            }
            if (flag.contains("synthetic")) {
                access |= 0x1000;
            }
            if (!flag.contains("synchronized")) continue;
            access |= 0x20;
        }
        return access;
    }

    public String access(int access) {
        String res = "";
        for (String s : this.accessFlags(access)) {
            res = res + " " + s;
        }
        res = res.length() > 0 ? res.substring(1) : res;
        return res;
    }

    protected DataRoot getDataRoot() {
        return DataRoot.getInstance(this.rootId);
    }

    static void writeString(DataOutput out, String s) throws IOException {
        if (s != null) {
            out.writeBoolean(true);
            out.writeUTF(s);
        } else {
            out.writeBoolean(false);
        }
    }

    static String readString(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    static void writeStrings(DataOutput out, String[] strs) throws IOException {
        if (strs != null) {
            out.writeShort(strs.length);
            for (int i = 0; i < strs.length; ++i) {
                out.writeUTF(strs[i]);
            }
        } else {
            out.writeShort(Short.MAX_VALUE);
        }
    }

    static String[] readStrings(DataInput in) throws IOException {
        int len = in.readShort();
        if (len != Short.MAX_VALUE) {
            String[] res = new String[len];
            for (int i = 0; i < len; ++i) {
                res[i] = in.readUTF();
            }
            return res;
        }
        return null;
    }

    public static class LocationCoords {
        public int start;
        public int end;
    }
}

