/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.data.ScaleOptions;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.LocationRef;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public abstract class DataBlock
extends LocationRef {
    protected int slot;
    protected long count;
    protected boolean attached;
    protected Scale scale;

    DataBlock(int rootId) {
        super(rootId);
        this.slot = Collect.newSlot();
        this.attached = true;
    }

    DataBlock(int rootId, int slot, boolean attached, long count) {
        super(rootId);
        this.slot = slot;
        this.attached = attached;
        this.count = count;
        if (attached) {
            this.setCollectCount(count);
        }
    }

    public int getId() {
        return this.slot;
    }

    public void setId(int slot) {
        this.slot = slot;
    }

    void attach() {
        this.setCollectCount(this.count);
        this.attached = true;
    }

    void detach() {
        this.update();
        this.attached = false;
    }

    void update() {
        this.count = this.collectCount();
    }

    public boolean wasHit() {
        if (this.attached) {
            return this.wasCollectHit();
        }
        return this.count != 0L;
    }

    public long getCount() {
        if (this.attached) {
            return this.collectCount();
        }
        return this.count;
    }

    public void setCount(long count) {
        if (this.attached) {
            this.setCollectCount(count);
        }
        this.count = count;
    }

    protected boolean wasCollectHit() {
        return Collect.wasHit(this.slot);
    }

    protected long collectCount() {
        return Collect.countFor(this.slot);
    }

    protected void setCollectCount(long count) {
        Collect.setCountFor(this.slot, count);
    }

    boolean isNested() {
        return false;
    }

    boolean isFallenInto() {
        return false;
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        super.xmlAttrs(ctx);
        ctx.attr("id", this.getId());
        ctx.attr("count", this.getCount());
        this.printScale(ctx);
    }

    void printScale(XmlContext ctx) {
        DataRoot r = DataRoot.getInstance(this.rootId);
        if (this.scale != null) {
            ScaleOptions opts = r.getScaleOpts();
            StringBuffer sb = new StringBuffer(Utils.halfBytesRequiredFor(this.scale.size()));
            sb.setLength(sb.capacity());
            sb.setLength(this.scale.convertToChars(opts.scalesCompressed(), sb, opts.getScaleCompressor()));
            ctx.attr("scale", sb);
        }
    }

    @Override
    void xmlBody(XmlContext ctx) {
    }

    @Override
    void xmlGen(XmlContext ctx) {
        this.xmlGenBodiless(ctx);
    }

    public void readScale(String s) {
        if (s != null && s.length() > 0) {
            try {
                DataRoot r = DataRoot.getInstance(this.rootId);
                ScaleOptions opts = r.getScaleOpts();
                if (opts.needReadScales()) {
                    this.scale = new Scale(s.toCharArray(), s.length(), opts.getScaleSize(), opts.getScaleCompressor(), opts.scalesCompressed());
                }
            }
            catch (FileFormatException fileFormatException) {
                // empty catch block
            }
        }
    }

    public void expandScales(int newSize, boolean add_before) {
        this.scale = Scale.expandScale(this.scale, newSize, add_before, this.getCount());
    }

    public void expandScales(int newSize, boolean add_before, long count) {
        this.scale = Scale.expandScale(this.scale, newSize, add_before, count);
    }

    void mergeScale(DataBlock other) {
        boolean readScale = DataRoot.getInstance(this.rootId).getScaleOpts().needReadScales();
        if (!readScale) {
            return;
        }
        this.scale = Scale.merge(this.scale, other.scale, this.getCount(), other.getCount());
    }

    public void illuminateDuplicatesInScales(int new_size, ArrayList pairs) {
        this.scale = Scale.illuminateDuplicates(this.scale, new_size, pairs);
    }

    public Scale getScale() {
        return this.scale;
    }

    public void cleanScale() {
        try {
            this.scale = new Scale(new char[0], 0, 0, null, false);
        }
        catch (FileFormatException fileFormatException) {
            // empty catch block
        }
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeLong(this.getCount());
        out.writeInt(this.slot);
        if (this.scale != null) {
            out.writeBoolean(true);
            this.scale.writeObject(out);
        } else {
            out.writeBoolean(false);
        }
    }

    DataBlock(int rootId, DataInput in) throws IOException {
        super(rootId, in);
        this.count = in.readLong();
        this.slot = in.readInt();
        this.scale = in.readBoolean() ? new Scale(in) : null;
    }
}

