/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.Constants;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataExit;
import com.sun.tdk.jcov.instrument.XmlContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DataExitSimple
extends DataExit {
    int opcode;

    public DataExitSimple(int rootId, int bciStart, int bciEnd, int opcode) {
        super(rootId, bciStart, bciEnd);
        this.opcode = opcode;
    }

    public String opcodeName() {
        return Constants.opcNames[this.opcode];
    }

    @Override
    public String kind() {
        return "exit";
    }

    @Override
    void xmlGen(XmlContext cxt) {
        this.xmlGenBodiless(cxt);
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        super.xmlAttrs(ctx);
        ctx.attr("opcode", this.opcodeName());
    }

    @Override
    public Iterator<DataBlock> getIterator() {
        return new Iterator<DataBlock>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public DataBlock next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.write(this.opcode);
    }

    DataExitSimple(int rootId, DataInput in) throws IOException {
        super(rootId, in);
        this.opcode = in.readByte();
        if (this.opcode < 0) {
            this.opcode += 256;
        }
    }
}

