/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBranch;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.InvokeMethodAdapter;
import com.sun.tdk.jcov.instrument.LocationConcrete;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.CollectDetect;
import com.sun.tdk.jcov.tools.OneElemIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataMethodInvoked
extends DataMethod {
    private final DataBlock entryBlock;

    public DataMethodInvoked(DataClass k, int access, String name, String desc, String signature, String[] exceptions) {
        this(k, access, name, desc, signature, exceptions, -1);
    }

    public DataMethodInvoked(final DataClass k, int access, final String name, final String desc, String signature, String[] exceptions, int id) {
        super(k, access, name, desc, signature, exceptions, false);
        boolean newSlot = id == -1;
        int slot = newSlot ? Collect.newSlot() : id;
        this.entryBlock = new DataBlock(this.rootId, slot, newSlot, 0L){

            @Override
            public String kind() {
                return "invoked";
            }

            @Override
            protected boolean wasCollectHit() {
                return CollectDetect.wasInvokeHit(InvokeMethodAdapter.getInvokeID(k.getFullname(), name, desc));
            }

            @Override
            protected long collectCount() {
                return CollectDetect.invokeCountFor(InvokeMethodAdapter.getInvokeID(k.getFullname(), name, desc));
            }

            @Override
            protected void setCollectCount(long count) {
                CollectDetect.setInvokeCountFor(InvokeMethodAdapter.getInvokeID(k.getFullname(), name, desc), count);
            }

            @Override
            void xmlAttrs(XmlContext ctx) {
                ctx.attr("id", this.getId());
                ctx.attr("count", this.getCount());
                this.printScale(ctx);
            }
        };
        LocationConcrete loc = new LocationConcrete(0){

            @Override
            public String kind() {
                return "trash";
            }
        };
        this.entryBlock.setConcreteLocation(loc);
    }

    @Override
    public DataMethod clone(DataClass newClass, int newAccess, String newName) {
        return new DataMethodInvoked(newClass, newAccess, newName, this.getVmSignature(), this.getSignature(), this.getExceptions());
    }

    public int getId() {
        return this.entryBlock.getId();
    }

    @Override
    public boolean wasHit() {
        return this.entryBlock.wasHit();
    }

    @Override
    public long getCount() {
        return this.entryBlock.getCount();
    }

    @Override
    public void setCount(long cnt) {
        this.entryBlock.setCount(cnt);
    }

    public void setScale(String s) {
        this.entryBlock.readScale(s);
    }

    @Override
    public Scale getScale() {
        return this.entryBlock.scale;
    }

    @Override
    public int getSlot() {
        return this.entryBlock.slot;
    }

    @Override
    void xmlGen(XmlContext ctx) {
        super.xmlGenBodiless(ctx);
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        super.xmlAttrs(ctx);
        this.entryBlock.xmlAttrs(ctx);
    }

    @Override
    public void checkCompatibility(DataMethod other, String trace) throws MergeException {
        if (!(other instanceof DataMethodInvoked)) {
            throw new MergeException("Method has other type than it's merging copy, expected DataMethodInvoked; found " + other.getClass().getSimpleName(), trace, 0);
        }
        DataMethodInvoked m = (DataMethodInvoked)other;
        if (!this.getDataRoot().getParams().isDynamicCollect() && !other.getDataRoot().getParams().isDynamicCollect() && this.getId() != m.getId()) {
            throw new MergeException("Method has other id than it's merging copy, expected " + this.getId() + "; found " + m.getId(), trace, 0);
        }
    }

    @Override
    public void merge(DataMethod other) {
        DataMethodInvoked m = (DataMethodInvoked)other;
        this.entryBlock.mergeScale(m.entryBlock);
        this.entryBlock.setCount(this.getCount() + m.getCount());
    }

    @Override
    public Iterator<DataBlock> iterator() {
        return new OneElemIterator<DataBlock>(this.entryBlock);
    }

    @Override
    public List<DataBlock> getBlocks() {
        ArrayList<DataBlock> list = new ArrayList<DataBlock>(1);
        list.add(this.entryBlock);
        return list;
    }

    @Override
    public List<DataBranch> getBranches() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<DataBlockTarget> getBranchTargets() {
        return Collections.EMPTY_LIST;
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.entryBlock.writeObject(out);
    }

    DataMethodInvoked(final DataClass parent, DataInput in) throws IOException {
        super(parent, in);
        this.entryBlock = new DataBlock(this.rootId, in){

            @Override
            public String kind() {
                return "invoked";
            }

            @Override
            protected boolean wasCollectHit() {
                return CollectDetect.wasInvokeHit(InvokeMethodAdapter.getInvokeID(parent.getFullname(), DataMethodInvoked.this.name, DataMethodInvoked.this.vmSig));
            }

            @Override
            protected long collectCount() {
                return CollectDetect.invokeCountFor(InvokeMethodAdapter.getInvokeID(parent.getFullname(), DataMethodInvoked.this.name, DataMethodInvoked.this.vmSig));
            }

            @Override
            protected void setCollectCount(long count) {
                CollectDetect.setInvokeCountFor(InvokeMethodAdapter.getInvokeID(parent.getFullname(), DataMethodInvoked.this.name, DataMethodInvoked.this.vmSig), count);
            }

            @Override
            void xmlAttrs(XmlContext ctx) {
                ctx.attr("id", this.getId());
                ctx.attr("count", this.getCount());
                this.printScale(ctx);
            }
        };
    }
}

