/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.JREInstr;
import com.sun.tdk.jcov.instrument.OffsetLabelingClassReader;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class OverriddenClassWriter
extends ClassWriter {
    private final ClassLoader loader;
    private static String[] customExtentions = PropertyFinder.findValue("clext", "").split(":");
    private static final HashMap<String, String> class_superclass = new HashMap();
    private static final HashMap<String, List<String>> class_interfaces = new HashMap();
    private static final List<String> EMPTY_LIST = new ArrayList<String>();

    public OverriddenClassWriter(ClassReader classReader, int flags, ClassLoader loader) {
        super(classReader, flags);
        this.loader = loader;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        return OverriddenClassWriter.getCommonSuperClassAlt(type1, type2, this.loader);
    }

    static String getCommonSuperClassAlt(String type1, String type2, ClassLoader loader) {
        if (OverriddenClassWriter.isAssignableFrom(type2, type1, loader)) {
            return type2;
        }
        String type = type1;
        while (!OverriddenClassWriter.isAssignableFrom(type, type2, loader)) {
            type = OverriddenClassWriter.getSuperClass(type, loader);
        }
        return type;
    }

    public static void clean() {
        class_superclass.clear();
        class_interfaces.clear();
    }

    public static void addClassInfo(InputStream in) {
        try {
            OffsetLabelingClassReader cr = new OffsetLabelingClassReader(in);
            if (class_superclass.get(cr.getClassName()) == null) {
                class_superclass.put(cr.getClassName(), cr.getSuperName());
            }
            if (class_interfaces.get(cr.getClassName()) == null) {
                class_interfaces.put(cr.getClassName(), Arrays.asList(cr.getInterfaces()));
            }
        }
        catch (IOException ioe) {
            System.err.println("Failed to read class. Reason: " + ioe.getMessage());
        }
    }

    public static boolean isAssignableFrom(String t1, String t2, ClassLoader loader) {
        if (t1 == null) {
            throw new RuntimeException("Can't read superclass bytecode. Please add it to the classpath. ");
        }
        if (t1.equals(t2)) {
            return true;
        }
        if (t2 == null || t2.equals("java/lang/Object")) {
            return false;
        }
        String superType = OverriddenClassWriter.getSuperClass(t2, loader);
        List<String> t2Interfaces = class_interfaces.get(t2);
        if (t2Interfaces != null && !t2Interfaces.isEmpty()) {
            for (String in2 : t2Interfaces) {
                if (!t1.equals(in2)) continue;
                return true;
            }
        }
        return OverriddenClassWriter.isAssignableFrom(t1, superType, loader);
    }

    public static String getSuperClass(String clName, ClassLoader loader) {
        if (clName == null) {
            return null;
        }
        String loaded = class_superclass.get(clName);
        if (loaded != null) {
            return loaded;
        }
        try {
            ClassInfo ci = OverriddenClassWriter.getClassInfo(clName, loader);
            String superName = ci.getSuperName();
            class_superclass.put(clName, superName);
            OverriddenClassWriter.detectInterfaces(clName, ci, loader);
            return superName;
        }
        catch (IOException e) {
            System.err.println("Failed to read class: " + clName + ". Reason: " + e.getMessage());
            return null;
        }
    }

    static void detectInterfaces(String clName, ClassInfo ci, ClassLoader loader) throws IOException {
        if (class_interfaces.get(clName) != null) {
            return;
        }
        if (ci == null) {
            ci = OverriddenClassWriter.getClassInfo(clName, loader);
            String superName = ci.getSuperName();
            class_superclass.put(clName, superName);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] interfaces = ci.getInterfaces();
        if (interfaces != null) {
            for (String itf : interfaces) {
                list.add(itf);
                OverriddenClassWriter.detectInterfaces(itf, null, loader);
                list.addAll((Collection)class_interfaces.get(itf));
            }
        }
        if (list.isEmpty()) {
            class_interfaces.put(clName, EMPTY_LIST);
        } else {
            class_interfaces.put(clName, list);
        }
    }

    public static ClassInfo getClassInfo(String clName, ClassLoader loader) throws IOException {
        ClassInfo classInfo;
        OffsetLabelingClassReader cr;
        if (loader instanceof JREInstr.StaticJREInstrClassLoader) {
            InputStream in = OverriddenClassWriter.getInputStreamForName(clName, loader, false, ".class");
            if (in == null) {
                in = OverriddenClassWriter.getInputStreamForName(clName, ClassLoader.getSystemClassLoader(), false, ".class");
                if (in == null) {
                    throw new IOException("Can't read class " + clName + " from classloader " + loader);
                }
                OffsetLabelingClassReader cr2 = new OffsetLabelingClassReader(in);
                ClassInfo classInfo2 = new ClassInfo(cr2.getSuperName(), cr2.getInterfaces());
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return classInfo2;
            }
            OffsetLabelingClassReader cr3 = new OffsetLabelingClassReader(in);
            ClassInfo classInfo3 = new ClassInfo(cr3.getSuperName(), cr3.getInterfaces());
            try {
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return classInfo3;
        }
        InputStream in = OverriddenClassWriter.getInputStreamForName(clName, ClassLoader.getSystemClassLoader(), false, ".class");
        String superClassName = null;
        String[] interfaceNames = null;
        if (in == null) {
            try {
                Class<?>[] iclasses;
                Class<?> cClass = Class.forName(clName.replace("/", "."));
                superClassName = "java/lang/Object";
                if (cClass.getSuperclass() != null) {
                    superClassName = cClass.getSuperclass().getName();
                }
                if ((iclasses = cClass.getInterfaces()) != null) {
                    interfaceNames = new String[iclasses.length];
                    for (int i = 0; i < iclasses.length; ++i) {
                        interfaceNames[i] = iclasses[i].getName();
                    }
                }
            }
            catch (ClassNotFoundException cClass) {
                // empty catch block
            }
        }
        if (in == null && superClassName == null && (in = OverriddenClassWriter.getInputStreamForName(clName, ClassLoader.getSystemClassLoader(), false, ".clazz")) == null) {
            if (!ClassLoader.getSystemClassLoader().equals(loader)) {
                in = OverriddenClassWriter.getInputStreamForName(clName, loader, false, ".class");
                if (in != null) {
                    cr = new OffsetLabelingClassReader(in);
                    ClassInfo classInfo4 = new ClassInfo(cr.getSuperName(), cr.getInterfaces());
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return classInfo4;
                }
                throw new IOException("Can't read class " + clName + " from classloader " + loader);
            }
            throw new IOException("Can't read class " + clName + " from classloader " + loader);
        }
        if (superClassName == null) {
            cr = new OffsetLabelingClassReader(in);
            classInfo = new ClassInfo(cr.getSuperName(), cr.getInterfaces());
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        } else {
            classInfo = new ClassInfo(superClassName, interfaceNames);
        }
        return classInfo;
    }

    private static InputStream getInputStreamForName(final String name, final ClassLoader loader, boolean priveleged, final String ext) {
        try {
            InputStream in = loader.getResourceAsStream(name + ext);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable in) {
            // empty catch block
        }
        for (int i = 0; i < customExtentions.length; ++i) {
            try {
                InputStream in = loader.getResourceAsStream(name + "." + customExtentions[i]);
                if (in == null) continue;
                return in;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!priveleged) {
            return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return OverriddenClassWriter.getInputStreamForName(name, loader, true, ext);
                }
            });
        }
        return null;
    }

    private static class ClassInfo {
        String superName;
        String[] interfaces;

        ClassInfo(String superName, String[] interfaces) {
            this.superName = superName;
            this.interfaces = interfaces;
        }

        public String getSuperName() {
            return this.superName;
        }

        public String[] getInterfaces() {
            return this.interfaces;
        }
    }
}

