/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.DataBlockTargetCase;
import com.sun.tdk.jcov.instrument.DataBlockTargetDefault;
import com.sun.tdk.jcov.instrument.DataBranchSwitch;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.ReaderFactoryStAX;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataBranchSwitchStAX
implements Reader {
    private DataBranchSwitch swtch;
    private XMLStreamReader parser;

    @Override
    public void readData(Object dest) throws FileFormatException {
        this.swtch = (DataBranchSwitch)dest;
        try {
            this.readData();
        }
        catch (XMLStreamException ex) {
            throw new FileFormatException(ex);
        }
    }

    void readData() throws XMLStreamException, FileFormatException {
        while (this.parser.getEventType() != 2 || this.parser.getLocalName() != "switch") {
            this.parser.nextTag();
            String elem = this.parser.getLocalName();
            if (elem == "default") {
                DataBlockTargetDefault def = new DataBlockTargetDefault(this.swtch.rootId(), 0, false, 0L);
                def.readDataFrom();
                this.swtch.setDefault(def);
                this.swtch.addTarget(def);
                this.parser.nextTag();
                continue;
            }
            if (elem != "case") continue;
            int val = Integer.parseInt(this.parser.getAttributeValue(null, "val"));
            DataBlockTargetCase cs = new DataBlockTargetCase(this.swtch.rootId(), val, 0, false, 0L);
            cs.readDataFrom();
            this.swtch.addTarget(cs);
            this.parser.nextTag();
        }
    }

    @Override
    public void setReaderFactory(ReaderFactory r) {
        this.parser = ((ReaderFactoryStAX)r).parser;
    }
}

