/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.processing;

import com.sun.tdk.jcov.processing.DataProcessor;
import com.sun.tdk.jcov.processing.DataProcessorSPI;
import com.sun.tdk.jcov.processing.StubSpi;

public class DataProcessorFactory {
    public static final String DEFAULT_SPI = "com.sun.tdk.jcov.processing.DefaultDataProcessorSpi";
    public static final String PROP_NAME = "dataprocessor.spi";
    private DataProcessorSPI spi = null;

    private DataProcessorFactory(String spiClassName) {
        if (spiClassName == null) {
            this.spi = null;
        } else {
            try {
                Class<?> spiClass = Class.forName(spiClassName);
                this.spi = (DataProcessorSPI)spiClass.newInstance();
            }
            catch (Exception e) {
                throw new Error("Cannot create an instance of  DataProcessorFactorySpi: " + e);
            }
        }
    }

    public static DataProcessorFactory getInstance() {
        String spiClassName = System.getProperty(PROP_NAME);
        if (spiClassName == null) {
            spiClassName = DEFAULT_SPI;
        } else if ("none".equalsIgnoreCase(spiClassName)) {
            spiClassName = StubSpi.class.getName();
        }
        return new DataProcessorFactory(spiClassName);
    }

    public DataProcessor getDataProcessor() {
        return this.spi == null ? DataProcessor.STUB : this.spi.getDataProcessor();
    }
}

