/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JcovVersion;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class JCovTool {
    public static final int SUCCESS_EXIT_CODE = 0;
    public static final int ERROR_CMDLINE_EXIT_CODE = 1;
    public static final int ERROR_EXEC_EXIT_CODE = 2;
    private static HashMap<String, Class> spis;
    protected boolean readPlugins = false;
    private PrintStream out = System.out;
    private static final String[] allTools;
    public static final List<String> allToolsList;

    protected JCovTool() {
    }

    protected abstract EnvHandler defineHandler();

    protected abstract int handleEnv(EnvHandler var1) throws EnvHandlingException;

    protected abstract String getDescr();

    protected boolean isMainClassProvided() {
        return true;
    }

    protected abstract String usageString();

    protected abstract String exampleString();

    protected final void registerSPI(String envname, Class classname) {
        if (spis == null) {
            spis = new HashMap();
        }
        spis.put(envname, classname);
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public static void printHelp() {
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()), true);
        writer.println("Java Code Coverage Tool ver." + JcovVersion.getJcovVersion());
        writer.println("Usage: 'java -jar jcov.jar <Name>' or 'java -cp jcov.jar com.sun.tdk.jcov.<Name>'");
        writer.println("JCov includes the following components:");
        writer.println();
        for (String str : allTools) {
            Class<?> c = null;
            JCovTool h = null;
            Object o = null;
            try {
                c = Class.forName(str);
                o = c.newInstance();
                h = o;
            }
            catch (NoClassDefFoundError cndfe) {
                if ("com.sun.tdk.jcov.IssueCoverage".equals(str)) {
                    System.out.println("IssueCoverage command request jdk9 or javax.tools in classpath");
                    continue;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            String name = c.getName();
            writer.println(String.format("   %-20s%s", str.substring(name.lastIndexOf(".") + 1), h.getDescr()));
        }
        writer.println();
        writer.println("Use \"java -jar jcov.jar <Name> -help\" for command-line help on each component, or \"java -jar jcov.jar <Name> -help-verbose\" for wider description");
    }

    public static void printHelp(JCovTool toolClassObject, String[] args) {
        try {
            JCovTool d = toolClassObject;
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].endsWith(EnvHandler.HELP_VERBOSE.name)) continue;
                d.defineHandler().usage(true);
                return;
            }
            d.defineHandler().usage(false);
        }
        catch (Exception e) {
            System.out.println("INTERNAL ERROR! " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        allTools = new String[]{"com.sun.tdk.jcov.Exec", "com.sun.tdk.jcov.Agent", "com.sun.tdk.jcov.Instr", "com.sun.tdk.jcov.JREInstr", "com.sun.tdk.jcov.ProductInstr", "com.sun.tdk.jcov.Instr2", "com.sun.tdk.jcov.TmplGen", "com.sun.tdk.jcov.Grabber", "com.sun.tdk.jcov.GrabberManager", "com.sun.tdk.jcov.Merger", "com.sun.tdk.jcov.RepMerge", "com.sun.tdk.jcov.Filter", "com.sun.tdk.jcov.DiffCoverage", "com.sun.tdk.jcov.RepGen", "com.sun.tdk.jcov.JCov", "com.sun.tdk.jcov.IssueCoverage"};
        allToolsList = Collections.unmodifiableList(Arrays.asList(allTools));
    }

    public static class EnvHandlingException
    extends Exception {
        public EnvHandlingException(String message) {
            super(message);
        }

        public EnvHandlingException(String message, Throwable cause) {
            super(message, cause);
        }

        public EnvHandlingException() {
        }
    }
}

