/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.Interview;
import com.sun.interview.Properties2;
import com.sun.interview.PropertiesQuestion;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.ResourceLoader;
import com.sun.javatest.report.HTMLWriterEx;
import com.sun.javatest.tool.CustomPropagationController;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class InterviewPropagator {
    private static final String PROP_STYLESHEET = "stylesheet.css";
    private static final int NEW_TEMPLATE = 0;
    private static final int OLD_TEMPLATE = 1;
    private static final int CONFIGURATION = 2;
    private static final int QUESTION_TEXT = 3;
    private static ViewManager view;
    private static TestRefresher refresher;
    private I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(InterviewPropagator.class);
    private String notAvailable = this.i18n.getString("tmpltProp.notAvailable");
    private InterviewParameters interview;
    private PropogateMap pm;
    private String[] ignorableProps;
    private String[] ignorablePrefs;

    InterviewPropagator(InterviewParameters par, String[] igProps, String ... igPrefs) {
        this.interview = par;
        this.ignorableProps = igProps;
        this.ignorablePrefs = igPrefs;
    }

    public static Properties2 stringToProperties2(String str) throws IOException {
        Properties2 result = new Properties2();
        if (str != null) {
            result.load(new StringReader(str));
        }
        return result;
    }

    public static String properties2ToString(Properties2 pr) {
        StringWriter sw = new StringWriter();
        pr.save(sw, null);
        return sw.toString();
    }

    public static boolean isPropertyQuestion(String key, InterviewParameters interview) {
        return InterviewPropagator.isPropertyQuestion(key, interview.getAllQuestions());
    }

    public static boolean isPropertyQuestion(String key, Map<String, Question> allQ) {
        Question q = allQ.get(key);
        if (q != null) {
            return q instanceof PropertiesQuestion;
        }
        return false;
    }

    public static void setViewManager(ViewManager v) {
        view = v;
    }

    public static void setTestRefresher(TestRefresher r) {
        refresher = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkForUpdate() {
        boolean wasUpdated = false;
        if (view == null) {
            return false;
        }
        if (this.isFromTemplate() && this.interview.getFile() != null) {
            this.interview.getPropagationController().setRefresher(refresher);
            this.interview.getPropagationController().setInterview(this.interview);
            this.fireEvent(CustomPropagationController.EventType.Start, null);
            PrintStream psConflicts = null;
            PrintStream psUpdates = null;
            boolean needToSave1 = false;
            boolean needToSave2 = false;
            HashMap<String, String> templateData = new HashMap();
            File template = new File(this.interview.getTemplatePath());
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(template));){
                templateData = PropertyUtils.load(in);
                this.fireEvent(CustomPropagationController.EventType.TemplateLoaded, templateData);
            }
            catch (IOException ex) {
                this.notifyError(this.i18n.getString("tmpltProp.tmpFileError", (Object)this.interview.getTemplatePath()));
                this.logException(ex);
            }
            try {
                Map<String, Question> allQuestionMap;
                this.pm = new PropogateMap();
                HashMap<String, String> actual = new HashMap<String, String>();
                this.interview.save(actual);
                needToSave1 = this.interview.getPropagationController().preprocessData(templateData, this.interview);
                needToSave2 = this.processNotUpdatableKeys(templateData, this.interview);
                if (needToSave1 || needToSave2) {
                    this.saveInterview();
                }
                if (this.processPartialQuestions(templateData, allQuestionMap = this.interview.getAllQuestions(), actual)) {
                    this.interview.save(actual);
                }
                this.processQuestionFromSet(templateData, allQuestionMap, templateData.keySet(), actual);
                this.processQuestionFromSet(templateData, allQuestionMap, this.interview.retrieveTemplateKeys(), actual);
                this.processQuestionFromSet(templateData, allQuestionMap, actual.keySet(), actual);
                if (this.pm.hasConflicts() || this.pm.hasUpdates()) {
                    psConflicts = new PrintStream((OutputStream)new FileOutputStream(this.pm.getConflictReportFile()), true, StandardCharsets.UTF_8.name());
                    psUpdates = new PrintStream((OutputStream)new FileOutputStream(this.pm.getUpdatesReportFile()), true, StandardCharsets.UTF_8.name());
                    this.pm.makeConflictsReport(psConflicts);
                    this.pm.makeUpdatesReport(psUpdates);
                    this.updateAll();
                    if (view != null) {
                        view.showView(this, this.interview);
                        wasUpdated = true;
                    }
                }
            }
            catch (IOException ex) {
                this.logException(ex);
            }
            finally {
                if (psConflicts != null) {
                    psConflicts.close();
                }
                if (psUpdates != null) {
                    psUpdates.close();
                }
            }
            if (needToSave1 || needToSave2 || this.pm.hasConflicts() || this.pm.hasUpdates()) {
                this.fireEvent(CustomPropagationController.EventType.Finish, null);
            }
        }
        this.cleanup();
        return wasUpdated;
    }

    private void fireEvent(CustomPropagationController.EventType eventType, Map<String, String> templateData) {
        this.interview.getPropagationController().notify(eventType, this.interview, templateData);
    }

    private boolean processNotUpdatableKeys(Map<String, String> templateData, InterviewParameters interview) {
        boolean wasUpdate = false;
        for (String templateKey : templateData.keySet()) {
            if (this.isSystemIgnorableTemplateProperty(templateKey) || this.interview.isUpdatableKey(templateKey)) continue;
            String newTV = templateData.get(templateKey);
            String oldTV = interview.retrieveTemplateProperty(templateKey);
            if (oldTV == null || oldTV.equals(newTV)) continue;
            wasUpdate = true;
            interview.storeTemplateProperty(templateKey, newTV);
        }
        return wasUpdate;
    }

    private boolean processPartialQuestions(Map<String, String> templateData, Map<String, Question> allQuestionMap, Map<String, String> actual) throws IOException {
        Iterator<String> keys = templateData.keySet().iterator();
        boolean updated = false;
        while (keys.hasNext()) {
            String questionKey = keys.next();
            if (!this.interview.isUpdatableKey(questionKey) || !InterviewPropagator.isPropertyQuestion(questionKey, allQuestionMap)) continue;
            String templateValue = templateData.get(questionKey);
            Properties2 templateProps = InterviewPropagator.stringToProperties2(templateValue);
            String actualValue = actual.get(questionKey);
            Properties2 actualProps = InterviewPropagator.stringToProperties2(actualValue);
            String oldTVal = this.interview.retrieveTemplateProperty(questionKey);
            Properties2 oldTemplateProps = null;
            if (oldTVal != null) {
                oldTemplateProps = InterviewPropagator.stringToProperties2(oldTVal);
            }
            Iterator itt = templateProps.keySet().iterator();
            boolean currentQuestionUpdated = false;
            Properties2 oldValuesMap = new Properties2();
            while (itt.hasNext()) {
                String subKey = (String)itt.next();
                if (!this.interview.isAutoUpdatableKey(questionKey, subKey) && actualProps.containsKey(subKey)) continue;
                String templateSubValue = templateProps.getProperty(subKey);
                String actualSubValue = actualProps.getProperty(subKey);
                if (actualSubValue != null && templateSubValue.equals(actualSubValue)) continue;
                actualSubValue = actualSubValue == null ? this.notAvailable : actualSubValue;
                oldValuesMap.put(subKey, actualSubValue);
                currentQuestionUpdated = true;
                actualProps.put(subKey, templateSubValue);
                if (oldTemplateProps == null) continue;
                oldTemplateProps.put(subKey, templateSubValue);
            }
            if (!currentQuestionUpdated) continue;
            StringWriter sw = new StringWriter();
            actualProps.save(sw, null);
            StringWriter swOld = new StringWriter();
            oldValuesMap.save(swOld, null);
            if (oldTemplateProps != null) {
                StringWriter swOldT = new StringWriter();
                oldTemplateProps.save(swOldT, null);
                this.interview.storeTemplateProperty(questionKey, swOldT.toString());
            } else {
                this.interview.storeTemplateProperty(questionKey, sw.toString());
            }
            PropertiesQuestion pq = (PropertiesQuestion)allQuestionMap.get(questionKey);
            pq.setValue(sw.toString());
            this.interview.setEdited(true);
            updated = true;
            String[] data = new String[]{sw.toString(), swOld.toString(), swOld.toString(), this.getQuestionText(questionKey, allQuestionMap)};
            this.pm.partialUpdateMap.put(questionKey, data);
        }
        return updated;
    }

    private void processQuestionFromSet(Map<String, String> templateData, Map<String, Question> allQ, Set<String> keySet, Map<String, String> actual) {
        for (String questionKey : keySet) {
            if (this.isIgnorableTemplateProperty(questionKey)) continue;
            String templateV = templateData.get(questionKey);
            String oldTemplateV = this.interview.retrieveTemplateProperty(questionKey);
            String configurationV = actual.get(questionKey);
            this.pm.add(questionKey, templateV, oldTemplateV, configurationV, this.getQuestionText(questionKey, allQ), InterviewPropagator.isPropertyQuestion(questionKey, allQ));
        }
    }

    private boolean isIgnorableTemplateProperty(String propertyName) {
        return this.isSystemIgnorableTemplateProperty(propertyName) || !this.interview.isUpdatableKey(propertyName);
    }

    private boolean isSystemIgnorableTemplateProperty(String propertyName) {
        if (propertyName == null) {
            return true;
        }
        for (String ignorableProp : this.ignorableProps) {
            if (!propertyName.equals(ignorableProp)) continue;
            return true;
        }
        for (String ignorablePref : this.ignorablePrefs) {
            if (!propertyName.startsWith(ignorablePref)) continue;
            return true;
        }
        return false;
    }

    private boolean isFromTemplate() {
        return !this.interview.isTemplate() && this.interview.getTemplatePath() != null;
    }

    private String getQuestionText(String key, Map<String, Question> allQ) {
        Question q = allQ.get(key);
        String result = key;
        if (q != null) {
            result = q.getText();
        }
        result = this.interview.getPropagationController().getQuestionText(key, result);
        return result;
    }

    public PropogateMap getPropagateMap() {
        return this.pm;
    }

    public void acceptAll() {
        PropogateMap pm = this.getPropagateMap();
        if (pm.hasConflicts()) {
            Map map = pm.conflictMap;
            this.acceptTemplateDatafromMap(map);
            try {
                this.interview.save();
            }
            catch (Interview.Fault | IOException ex) {
                this.logException(ex);
            }
        }
    }

    public void rejectAll() {
        PropogateMap pm = this.getPropagateMap();
        if (pm.hasConflicts()) {
            Map map = pm.conflictMap;
            this.acceptTemplateDatafromMap(map, true);
            try {
                this.interview.save();
            }
            catch (Interview.Fault | IOException ex) {
                this.logException(ex);
            }
        }
    }

    private void updateAll() {
        PropogateMap pm = this.getPropagateMap();
        if (pm.hasUpdates()) {
            Map map = pm.updateMap;
            this.acceptTemplateDatafromMap(map);
            this.saveInterview();
        }
    }

    private void saveInterview() {
        this.interview.setEdited(true);
        try {
            this.interview.save();
        }
        catch (Interview.Fault | IOException ex) {
            this.logException(ex);
        }
    }

    private void acceptTemplateDatafromMap(Map<String, String[]> map) {
        this.acceptTemplateDatafromMap(map, false);
    }

    private void acceptTemplateDatafromMap(Map<String, String[]> map, boolean templateOnly) {
        for (String string : map.keySet()) {
            String[] vals = map.get(string);
            this.interview.storeTemplateProperty(string, vals[0].toString());
        }
        if (!templateOnly) {
            HashMap<String, String> actual = new HashMap<String, String>();
            this.interview.save(actual);
            for (String key : map.keySet()) {
                String[] vals = map.get(key);
                actual.put(key, vals[0]);
            }
            try {
                this.interview.load(actual, false);
            }
            catch (Interview.Fault fault) {
                this.logException(fault);
            }
            this.interview.setEdited(true);
        }
    }

    private void cleanup() {
        if (this.pm != null) {
            this.pm.cleanup();
        }
        this.interview.getPropagationController().setRefresher(null);
        this.interview.getPropagationController().setInterview(null);
    }

    private void logException(Throwable th) {
        if (view != null) {
            view.logException(th, this.interview);
        } else {
            th.printStackTrace();
        }
    }

    private void notifyError(String message) {
        if (view != null) {
            view.notifyError(message, this.interview);
        }
    }

    public static interface ViewManager {
        public void showView(InterviewPropagator var1, InterviewParameters var2);

        public void logException(Throwable var1, InterviewParameters var2);

        public void notifyError(String var1, InterviewParameters var2);
    }

    public static interface TestRefresher {
        public void refreshTestTree(InterviewParameters var1);
    }

    public class PropogateMap {
        private Set<String> propQs = new HashSet<String>();
        private Map<String, String[]> conflictMap = new LinkedHashMap<String, String[]>();
        private Map<String, String[]> updateMap = new LinkedHashMap<String, String[]>();
        private Map<String, String[]> partialUpdateMap = new LinkedHashMap<String, String[]>();
        private File conflictReport;
        private File updateReport;
        private boolean debug = false;

        void add(String key, String templV, String oldTemplV, String confV, String questionText, boolean isPropQ) {
            if (isPropQ) {
                this.propQs.add(key);
            }
            if (InterviewPropagator.this.interview.isAutoUpdatableKey(key, null)) {
                this.add(this.updateMap, key, templV, oldTemplV, confV, questionText, isPropQ, this.updateMap);
            } else {
                this.add(this.conflictMap, key, templV, oldTemplV, confV, questionText, isPropQ, this.updateMap);
            }
        }

        private void add(Map<String, String[]> aMap, String key, String templV, String oldTemplV, String confV, String questionText, boolean isPropQ, Map<String, String[]> updateMap) {
            if (templV != null) {
                String[] data;
                String[] comp_data = data = new String[]{templV, oldTemplV, confV, questionText};
                boolean added = false;
                boolean isUpdate = false;
                if (isPropQ) {
                    comp_data = this.convertPQ(data);
                }
                if (comp_data[1] == null && !comp_data[0].equals(comp_data[2])) {
                    comp_data[1] = InterviewPropagator.this.notAvailable;
                    if (comp_data[2] == null) {
                        comp_data[2] = InterviewPropagator.this.notAvailable;
                    }
                    updateMap.put(key, data);
                    added = true;
                    isUpdate = true;
                } else if (comp_data[1] != null && comp_data[2] != null) {
                    if (!comp_data[0].equals(comp_data[2]) && comp_data[1].equals(comp_data[2])) {
                        updateMap.put(key, data);
                        added = true;
                        isUpdate = true;
                    } else if (!comp_data[0].equals(comp_data[2]) && !comp_data[0].equals(comp_data[1])) {
                        aMap.put(key, data);
                        added = true;
                    } else if (!(!comp_data[0].equals(comp_data[2]) && comp_data[0].equals(comp_data[1]) || comp_data[0].equals(comp_data[1]))) {
                        aMap.put(key, data);
                        added = true;
                    }
                }
                if (this.debug && added) {
                    System.out.println("= ADDED ==========================================================");
                    if (isUpdate) {
                        System.out.println("UPDATE !!!");
                    }
                    System.out.println("Key      " + key);
                    System.out.println("Value    " + confV);
                    System.out.println("Template " + templV);
                    System.out.println("Old Temp " + oldTemplV);
                }
            }
        }

        public boolean hasConflicts() {
            return !this.conflictMap.isEmpty();
        }

        public boolean hasUpdates() {
            return !this.updateMap.isEmpty() || !this.partialUpdateMap.isEmpty();
        }

        void makeConflictsReport(PrintStream sw) {
            this.makeReport(sw, this.conflictMap, false);
        }

        void makeUpdatesReport(PrintStream sw) {
            LinkedHashMap<String, String[]> allUpdate = new LinkedHashMap<String, String[]>(this.updateMap);
            allUpdate.putAll(this.partialUpdateMap);
            this.makeReport(sw, allUpdate, true);
        }

        private void makeReport(PrintStream sw, Map<String, String[]> m, boolean hideOldTemplate) {
            Iterator<String> it = m.keySet().iterator();
            if (!it.hasNext()) {
                return;
            }
            try {
                HTMLWriterEx writer = new HTMLWriterEx((Writer)new PrintWriter(sw), InterviewPropagator.this.i18n);
                writer.startTag("html");
                writer.startTag("head");
                writer.writeContentMeta();
                writer.writeEntity(this.getCSS());
                writer.endTag("head");
                writer.startTag("body");
                writer.startTag("table");
                writer.writeAttr("border", 0);
                writer.startTag("tr");
                writer.startTag("td");
                writer.writeAttr("colspan", 3);
                writer.writeAttr("class", "head");
                if (hideOldTemplate) {
                    writer.writeI18N("templProp.updateText");
                } else {
                    writer.writeI18N("templProp.conflictText");
                }
                writer.endTag("td");
                writer.endTag("tr");
                writer.startTag("tr");
                writer.startTag("td");
                writer.writeAttr("class", "head2");
                writer.writeI18N("tmpltProp.Configuration");
                writer.endTag("td");
                if (!hideOldTemplate) {
                    writer.startTag("td");
                    writer.writeAttr("class", "head2");
                    writer.writeI18N("tmpltProp.oldTmplt");
                    writer.endTag("td");
                }
                writer.startTag("td");
                writer.writeAttr("class", "head2");
                writer.writeI18N("tmpltProp.newTmplt");
                writer.endTag("td");
                writer.endTag("tr");
                while (it.hasNext()) {
                    int i;
                    String[] s;
                    String key = it.next();
                    String[] data = m.get(key);
                    writer.startTag("tr");
                    writer.startTag("td");
                    writer.writeAttr("class", "pname");
                    writer.writeAttr("colspan", hideOldTemplate ? 2 : 3);
                    writer.startTag("hr");
                    writer.write(data[3]);
                    writer.endTag("td");
                    writer.endTag("tr");
                    if (!this.propQs.contains(key)) {
                        s = new String[data.length];
                        for (i = 0; i < data.length; ++i) {
                            s[i] = data[i];
                        }
                    } else {
                        s = this.convertPQ(data);
                    }
                    writer.startTag("tr");
                    for (i = 2; i >= 0; --i) {
                        if (i == 1 && hideOldTemplate) continue;
                        writer.startTag("td");
                        writer.writeAttr("class", "val");
                        writer.writeAttr("valign", "top");
                        writer.writeEntity(s[i]);
                        writer.endTag("td");
                    }
                    writer.endTag("tr");
                }
                writer.endTag("table");
                writer.endTag("body");
                writer.endTag("html");
                writer.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        private String[] convertPQ(String[] data) {
            try {
                Properties2 oldT = InterviewPropagator.stringToProperties2(data[1]);
                Properties2 newT = InterviewPropagator.stringToProperties2(data[0]);
                Properties2 conf = InterviewPropagator.stringToProperties2(data[2]);
                HTMLWriterEx[] writers = new HTMLWriterEx[3];
                StringWriter[] stringWriters = new StringWriter[writers.length];
                for (int i = 0; i < writers.length; ++i) {
                    stringWriters[i] = new StringWriter();
                    writers[i] = new HTMLWriterEx((Writer)stringWriters[i], InterviewPropagator.this.i18n);
                    writers[i].startTag("table");
                    writers[i].writeAttr("border", 1);
                }
                for (Object o : conf.keySet()) {
                    int i;
                    String key = (String)o;
                    String[] props = new String[]{newT.getProperty(key), oldT.getProperty(key), conf.getProperty(key)};
                    for (i = 0; i < props.length; ++i) {
                        if (props[i] != null) continue;
                        props[i] = "";
                    }
                    if (props[0].equals(props[1]) && props[0].equals(props[2]) && props[1].equals(props[2])) continue;
                    for (i = 0; i < writers.length; ++i) {
                        writers[i].startTag("tr");
                        writers[i].startTag("td");
                        writers[i].write(key);
                        writers[i].endTag("td");
                        writers[i].startTag("td");
                        writers[i].write(props[i]);
                        writers[i].endTag("td");
                        writers[i].endTag("tr");
                    }
                }
                String[] result = new String[writers.length];
                for (int i = 0; i < writers.length; ++i) {
                    writers[i].endTag("table");
                    writers[i].flush();
                    result[i] = stringWriters[i].toString();
                    writers[i].close();
                }
                return result;
            }
            catch (IOException ex) {
                InterviewPropagator.this.logException(ex);
                return new String[]{"", "", ""};
            }
        }

        private String getCSS() {
            BufferedReader r = null;
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                InputStream is = ResourceLoader.getResourceAsStream(InterviewPropagator.PROP_STYLESHEET, this.getClass());
                if (is == null) {
                    return "";
                }
                r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = r.readLine()) != null) {
                    sb.append(line);
                }
                return sb.toString();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return "";
            }
        }

        public File getConflictReportFile() {
            if (this.conflictReport == null) {
                try {
                    this.conflictReport = File.createTempFile("conflicts", ".html");
                }
                catch (IOException ex) {
                    InterviewPropagator.this.logException(ex);
                }
                this.conflictReport.deleteOnExit();
            }
            return this.conflictReport;
        }

        public File getUpdatesReportFile() {
            if (this.updateReport == null) {
                try {
                    this.updateReport = File.createTempFile("updates", ".html");
                }
                catch (IOException ex) {
                    InterviewPropagator.this.logException(ex);
                }
                this.updateReport.deleteOnExit();
            }
            return this.updateReport;
        }

        private void cleanup() {
            this.conflictMap.clear();
            this.updateMap.clear();
            this.partialUpdateMap.clear();
            this.propQs.clear();
        }
    }
}

