/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.NewJavaTestSecurityManager;
import java.io.FileDescriptor;
import java.net.InetAddress;

public class JavaTestSecurityManager
extends SecurityManager {
    private static boolean allowExit = false;
    private static boolean allowPropertiesAccess = true;
    private static boolean verbose = Boolean.getBoolean("javatest.security.verbose");

    public JavaTestSecurityManager() {
        String s = System.getProperty("javatest.security.allowPropertiesAccess");
        if (s != null) {
            allowPropertiesAccess = Boolean.valueOf(s);
        }
    }

    public static void install() {
        block6: {
            try {
                String noSecurityMgr = "javatest.security.noSecurityManager";
                if (Boolean.getBoolean(noSecurityMgr)) {
                    System.err.println();
                    System.err.println("     ---- WARNING -----");
                    System.err.println();
                    System.err.println("JT Harness did not install its own Security Manager");
                    System.err.println("because the property " + noSecurityMgr + " was set.");
                    System.err.println("This is not a fatal error, but it may affect the");
                    System.err.println("execution of sameJVM tests");
                    System.err.println();
                } else {
                    try {
                        Class.forName("java.security.Permission");
                        System.setSecurityManager(new NewJavaTestSecurityManager());
                    }
                    catch (ClassNotFoundException e) {
                        System.setSecurityManager(new JavaTestSecurityManager());
                    }
                }
            }
            catch (SecurityException e) {
                SecurityManager sm = System.getSecurityManager();
                if (sm instanceof JavaTestSecurityManager) break block6;
                System.err.println();
                System.err.println("     ---- WARNING -----");
                System.err.println();
                System.err.println("JT Harness could not install its own Security Manager");
                System.err.println("because of the following exception:");
                System.err.println("     " + e);
                System.err.println("This is not a fatal error, but it may affect the");
                System.err.println("execution of sameJVM tests");
                System.err.println();
            }
        }
    }

    @Override
    public void checkAccept(String host, int port) {
    }

    @Override
    public void checkAccess(Thread g) {
    }

    @Override
    public void checkAccess(ThreadGroup g) {
    }

    @Override
    public void checkConnect(String host, int port) {
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkDelete(String file) {
    }

    @Override
    public void checkExec(String cmd) {
    }

    @Override
    public void checkExit(int status) {
        if (!allowExit) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": System.exit() forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("System.exit() forbidden by JT Harness");
        }
    }

    @Override
    public void checkLink(String lib) {
    }

    @Override
    public void checkListen(int port) {
    }

    @Override
    public void checkPackageAccess(String pkg) {
    }

    @Override
    public void checkPackageDefinition(String pkg) {
    }

    @Override
    public synchronized void checkPropertiesAccess() {
        if (!allowPropertiesAccess) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": properties access forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("Action forbidden by JT Harness: checkPropertiesAccess");
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
    }

    @Override
    public void checkRead(FileDescriptor fd) {
    }

    @Override
    public void checkRead(String file) {
    }

    @Override
    public void checkRead(String file, Object context) {
    }

    @Override
    public void checkSetFactory() {
    }

    @Deprecated
    public boolean checkTopLevelWindow(Object window) {
        return true;
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
    }

    @Override
    public void checkWrite(String file) {
    }

    @Deprecated
    public void checkAwtEventQueueAccess() {
    }

    @Deprecated
    public void checkMemberAccess(Class<?> clazz, int which) {
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
    }

    @Override
    public void checkMulticast(InetAddress maddr, byte ttl) {
    }

    @Override
    public void checkPrintJobAccess() {
    }

    @Override
    public void checkSecurityAccess(String provider) {
    }

    @Deprecated
    public void checkSystemClipboardAccess() {
    }

    public static boolean setAllowExit(boolean bool) {
        boolean prev = allowExit;
        allowExit = bool;
        return prev;
    }

    public boolean setAllowPropertiesAccess(boolean bool) {
        boolean prev = allowPropertiesAccess;
        allowPropertiesAccess = bool;
        return prev;
    }
}

