/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyUtils;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class TestEnvironment {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static String[] defaultPropTableNames = new String[0];
    static List<Map<String, String>> defaultPropTables = new ArrayList<Map<String, String>>();
    static final String DISABLE_INLINE_COMMENTS_PROPERTY = "com.sun.javatest.InlineEnvComments";
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestEnvironment.class);
    private final String name;
    private final String[] inherits;
    private Map<String, Element> table = new HashMap<String, Element>();
    private Map<String, String[]> extras = new HashMap<String, String[]>();
    private final Map<String, Element> cache = new HashMap<String, Element>();

    public TestEnvironment(String name, Map<String, String> propTable, String propTableName) throws Fault {
        this(name, new PropTableArrayList(propTable), propTableName);
    }

    @Deprecated
    public TestEnvironment(String name, Map[] propTables, String ... propTableNames) throws Fault {
        this(name, Arrays.asList(propTables), propTableNames);
    }

    public TestEnvironment(String name, List<Map<String, String>> propTables, String ... propTableNames) throws Fault {
        this.name = name;
        if (defaultPropTables != null && defaultPropTables.size() > 0) {
            ArrayList<Map<String, String>> newPropsTables = new ArrayList<Map<String, String>>(defaultPropTables);
            if (propTables != null) {
                newPropsTables.addAll(propTables);
            }
            propTables = newPropsTables;
            propTableNames = DynamicArray.join(defaultPropTableNames, propTableNames);
        }
        Vector<String[]> v = new Vector<String[]>();
        String[] n = name;
        String inherit = null;
        while (n != null && !n.isEmpty()) {
            if (v.contains(n)) {
                throw new Fault(i18n, "env.loop", (Object)name);
            }
            v.add(n);
            String prefix = "env." + (String)n + ".";
            for (int i = propTables.size() - 1; i >= 0 && inherit == null; --i) {
                inherit = propTables.get(i).get("env." + (String)n + ".inherits");
            }
            n = inherit;
            inherit = null;
        }
        for (String inherit2 : this.inherits = v.toArray(new String[v.size()])) {
            String prefix = "env." + inherit2 + ".";
            for (int propIndex = propTables.size() - 1; propIndex >= 0; --propIndex) {
                Map<String, String> propTable = propTables.get(propIndex);
                for (String prop : propTable.keySet()) {
                    String key;
                    if (!prop.startsWith(prefix) || this.table.containsKey(key = prop.substring(prefix.length()))) continue;
                    Element elem = new Element(key, propTable.get(prop), inherit2, propTableNames[propIndex]);
                    this.table.put(key, elem);
                }
            }
        }
        for (int propIndex = propTables.size() - 1; propIndex >= 0; --propIndex) {
            Map<String, String> propTable = propTables.get(propIndex);
            for (String key : propTable.keySet()) {
                if (key.startsWith("env.") || this.table.containsKey(key)) continue;
                Element elem = new Element(key, propTable.get(key), null, propTableNames[propIndex]);
                this.table.put(key, elem);
            }
        }
    }

    protected TestEnvironment(TestEnvironment o) {
        this.name = o.name;
        this.inherits = o.inherits;
        this.table = o.table;
        this.extras = new HashMap<String, String[]>(o.extras);
    }

    public static synchronized void addDefaultPropTable(String name, Map<String, String> propTable) {
        if (name == null || propTable == null) {
            throw new NullPointerException();
        }
        defaultPropTableNames = DynamicArray.append(defaultPropTableNames, name);
        defaultPropTables.add(propTable);
    }

    public static synchronized void addDefaultPropTable(String name, Properties propTable) {
        TestEnvironment.addDefaultPropTable(name, PropertyUtils.convertToStringProps(propTable));
    }

    public static synchronized void clearDefaultPropTables() {
        defaultPropTableNames = new String[0];
        defaultPropTables = new ArrayList<Map<String, String>>();
    }

    static boolean isInlineCommentsDisabled() {
        return Boolean.parseBoolean(System.getProperty(DISABLE_INLINE_COMMENTS_PROPERTY, "false"));
    }

    private static boolean isNameChar(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c) || Character.isDigit(c) || c == '_' || c == '.';
    }

    public TestEnvironment copy() {
        return new TestEnvironment(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        if (this.table == null || !this.table.containsKey("description")) {
            return null;
        }
        return this.table.get("description").getValue();
    }

    public String[] getInherits() {
        return this.inherits;
    }

    public void put(String name, String value) {
        String[] v = new String[]{value};
        this.extras.put(name, v);
    }

    public void put(String name, String ... value) {
        this.extras.put(name, value);
    }

    public void putUrlAndFile(String name, File f) {
        String filePath = f.getPath();
        if (filePath.endsWith(File.separator)) {
            filePath = filePath.substring(0, filePath.length() - File.separator.length());
        }
        String url = f.toURI().toASCIIString();
        this.put(name, filePath);
        this.put(name + "URL", url);
    }

    public Map<String, String[]> getExtraValues() {
        return this.extras;
    }

    public String[] lookup(String key) throws Fault {
        return this.lookup(key, null);
    }

    private String[] lookup(String key, Vector<String> activeKeys) throws Fault {
        String[] v = this.extras.get(key);
        if (v != null) {
            return v;
        }
        Element elem = this.table.get(key);
        if (elem != null) {
            this.cache.put(key, elem);
            if (activeKeys == null) {
                activeKeys = new Vector();
            } else if (activeKeys.contains(key)) {
                throw new Fault(i18n, "env.recursive", key, elem.getDefinedInFile());
            }
            activeKeys.add(key);
            try {
                String[] stringArray = this.resolve(elem.getValue(), activeKeys);
                return stringArray;
            }
            catch (Fault e) {
                throw new Fault(i18n, "env.badName", key, elem.getDefinedInFile(), e.getMessage());
            }
            finally {
                activeKeys.remove(key);
            }
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] resolve(String s) throws Fault {
        return this.resolve(s, null);
    }

    private String[] resolve(String s, Vector<String> activeKeys) throws Fault {
        Vector<String> v = new Vector<String>();
        StringBuilder current = new StringBuilder(64);
        char term = '\u0000';
        block14: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '#': {
                    if (!(TestEnvironment.isInlineCommentsDisabled() && i != 0 && s.charAt(i - 1) != ' ' && s.charAt(i - 1) != '\t' || term != '\u0000' && term != ' ')) break block14;
                    current.append(c);
                    continue block14;
                }
                case '\"': 
                case '\'': {
                    if (term == '\u0000' || term == ' ') {
                        term = c;
                        continue block14;
                    }
                    if (term == c) {
                        term = ' ';
                        continue block14;
                    }
                    current.append(c);
                    continue block14;
                }
                case '$': {
                    if (term != '\'') {
                        StringBuffer buf = new StringBuffer();
                        String name = null;
                        String[] nameArgs = null;
                        try {
                            c = s.charAt(++i);
                            switch (c) {
                                case '/': {
                                    current.append(File.separatorChar);
                                    continue block14;
                                }
                                case ':': {
                                    current.append(File.pathSeparatorChar);
                                    continue block14;
                                }
                                case '$': {
                                    current.append('$');
                                    continue block14;
                                }
                                case '{': {
                                    c = s.charAt(++i);
                                    while (c != ':' && c != '}') {
                                        buf.append(c);
                                        c = s.charAt(++i);
                                    }
                                    name = TestEnvironment.convertToName(this.resolve(buf.toString()));
                                    if (c != ':') break;
                                    buf = new StringBuffer();
                                    c = s.charAt(++i);
                                    while (c != '}') {
                                        buf.append(c);
                                        c = s.charAt(++i);
                                    }
                                    nameArgs = StringArray.split(buf.toString());
                                    break;
                                }
                                default: {
                                    if (TestEnvironment.isNameChar(c)) {
                                        while (i < s.length() && TestEnvironment.isNameChar(s.charAt(i))) {
                                            buf.append(s.charAt(i++));
                                        }
                                        --i;
                                    } else {
                                        throw new Fault(i18n, "env.badExprChar", (Object)new Character(c));
                                    }
                                    name = buf.toString();
                                }
                            }
                            String[] val = this.lookup(name, activeKeys);
                            if (nameArgs != null) {
                                for (void var15_17 : nameArgs) {
                                    if (var15_17.startsWith("FS=") && var15_17.length() == 4) {
                                        TestEnvironment.substituteChar(val, File.separatorChar, var15_17.charAt(3));
                                        continue;
                                    }
                                    if (var15_17.startsWith("PS=") && var15_17.length() == 4) {
                                        TestEnvironment.substituteChar(val, File.pathSeparatorChar, var15_17.charAt(3));
                                        continue;
                                    }
                                    if (var15_17.startsWith("MAP=")) {
                                        TestEnvironment.substituteMap(val, this.lookup("map." + var15_17.substring(4), activeKeys));
                                        continue;
                                    }
                                    if (var15_17.equals("MAP")) {
                                        TestEnvironment.substituteMap(val, this.lookup("map", activeKeys));
                                        continue;
                                    }
                                    throw new Fault(i18n, "env.badOption", (Object)var15_17);
                                }
                            }
                            if (val == null || val.length <= 0) continue block14;
                            if (term == '\u0000') {
                                term = ' ';
                            }
                            for (int vi = 0; vi < val.length; ++vi) {
                                if (vi == 0) {
                                    current.append(val[vi]);
                                    continue;
                                }
                                if (term == '\"') {
                                    current.append(' ');
                                    current.append(val[vi]);
                                    continue;
                                }
                                v.add(current.toString());
                                current.setLength(0);
                                current.append(val[vi]);
                            }
                            continue block14;
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new Fault(i18n, "env.badExpr");
                        }
                    }
                    current.append(c);
                    continue block14;
                }
                case '\t': 
                case ' ': {
                    if (term == '\u0000') continue block14;
                    if (term == ' ') {
                        v.add(current.toString());
                        current.setLength(0);
                        term = '\u0000';
                        continue block14;
                    }
                    current.append(c);
                    continue block14;
                }
                default: {
                    if (term == '\u0000') {
                        term = ' ';
                    }
                    current.append(c);
                }
            }
        }
        if (term != '\u0000') {
            v.add(current.toString());
        }
        return v.toArray(new String[v.size()]);
    }

    public boolean hasUndefinedValues() {
        for (Element entry : this.elements()) {
            if (!entry.value.contains("VALUE_NOT_DEFINED")) continue;
            return true;
        }
        return false;
    }

    private static void substituteChar(String[] v, char from, char to) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i].replace(from, to);
        }
    }

    private static void substituteMap(String[] v, String ... map) {
        if (map == null) {
            return;
        }
        for (int i = 0; i < v.length; ++i) {
            String word = v[i];
            int j = 0;
            while (j + 1 < map.length) {
                String f = map[j];
                String t = map[j + 1];
                int index = word.indexOf(f);
                while (index != -1) {
                    word = word.substring(0, index) + t + word.substring(index + f.length());
                    index = word.indexOf(f, index + t.length());
                }
                j += 2;
            }
            v[i] = word;
        }
    }

    private static String convertToName(String ... v) {
        String s = "";
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                s = s + '_';
            }
            for (int j = 0; j < v[i].length(); ++j) {
                char c = v[i].charAt(j);
                s = s + (TestEnvironment.isNameChar(c) ? c : (char)'_');
            }
        }
        return s;
    }

    public Set<String> keys() {
        return this.table.keySet();
    }

    public Collection<Element> elementsUsed() {
        return this.cache.values();
    }

    public void resetElementsUsed() {
        this.cache.clear();
    }

    public Collection<Element> elements() {
        return this.table.values();
    }

    private static class PropTableArrayList
    extends ArrayList<Map<String, String>> {
        public PropTableArrayList(Map<String, String> propTable) {
            this.add(propTable);
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object ... o) {
            super(i18n.getString(s, o));
        }
    }

    public static class Element {
        String key;
        String value;
        String definedInEnv;
        String definedInFile;

        Element(String key, String value, String definedInEnv, String definedInFile) {
            this.key = key;
            this.value = value;
            this.definedInEnv = definedInEnv;
            this.definedInFile = definedInFile;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefinedInEnv() {
            return this.definedInEnv;
        }

        public String getDefinedInFile() {
            return this.definedInFile;
        }
    }
}

