/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.ExecToolManager;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.FileSystemTableModel;
import com.sun.javatest.exec.FileTable;
import com.sun.javatest.exec.FileTableNode;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.SelectedWorkDirApprover;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.table.TableModel;

public class WorkDirChooseTool
extends JDialog {
    public static final int LOAD_TEMPLATE = 3;
    public static final int LOAD_CONFIG = 4;
    public static final String DEFAULT_WD_PREF_NAME = "wdct.default_wd_path";
    static final String JTI = ".jti";
    static final String JTM = ".jtm";
    private static final String uiKey = "wdc";
    private static File defWD = null;
    private boolean isNonDefaultDirAllowed = true;
    private boolean template;
    private boolean showConfigEditorFlag;
    private boolean withoutTemplate = true;
    private int mode;
    private boolean allowTraversDirs;
    private Color disabledColor;
    private Color enabledColor;
    private Component parent;
    private File selectedTemplate;
    private File wd;
    private File defaultDir;
    private File currentTemplateDir;
    private File defaultTemplateDir;
    private FileSystemTableModel fsm;
    private FileTable fileTable;
    private JButton createBtn;
    private JButton cancelBtn;
    private JButton browseTmplBtn;
    private JButton[] buttons;
    private JCheckBox launchEditorCB;
    private FileChooser fileChooser;
    private JLabel templatePLabel;
    private JPanel main;
    private JPanel bottom;
    private JPanel treePanel;
    private JRadioButton noTemplateCB;
    private JRadioButton templateCB;
    private JScrollPane scPane;
    private JTextField tField;
    private JTextField dirField;
    private JTextField templateField;
    private Object cancelButton;
    private SelectedWorkDirApprover swda;
    private ExecModel em;
    private TestSuite testSuite;
    private TestSuiteChooser testSuiteChooser;
    private TreeExpansionEvent event;
    private UIFactory uif;
    private ChosenFileHandler chosenFileHandler;
    private boolean hideTemplates = false;

    public WorkDirChooseTool(Frame parent, TestSuite testSuite, final UIFactory uif, int mode) {
        super(parent, true);
        this.uif = uif;
        this.parent = parent;
        this.testSuite = testSuite;
        this.mode = mode;
        this.swda = new SelectedWorkDirApprover(mode, parent);
        if (this.defaultDir == null) {
            try {
                this.defaultDir = new File(".").getCanonicalFile();
            }
            catch (IOException e) {
                this.defaultDir = new File(System.getProperty("user.dir"));
            }
        }
        if (this.currentTemplateDir == null) {
            try {
                this.currentTemplateDir = new File(".").getCanonicalFile();
            }
            catch (IOException e) {
                this.currentTemplateDir = new File(System.getProperty("user.dir"));
            }
        }
        this.setDefaultCloseOperation(2);
        final int currMode = mode;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (currMode == 3 && !WorkDirChooseTool.this.wdWithoutTemplatePermitted(WorkDirChooseTool.this.em.getWorkDirectory())) {
                    uif.showError("ce.force_close");
                } else {
                    ((JDialog)e.getSource()).setVisible(false);
                    ((JDialog)e.getSource()).dispose();
                }
            }
        });
    }

    private static File getDefDir() {
        if (defWD != null) {
            return defWD;
        }
        Preferences prefs = Preferences.access();
        String prefsDefaultDir = prefs.getPreference(DEFAULT_WD_PREF_NAME);
        defWD = prefsDefaultDir != null ? new File(prefsDefaultDir) : new File(".");
        return defWD;
    }

    private static void setDefDir(File newDefDir) {
        if (newDefDir != null) {
            Preferences prefs = Preferences.access();
            try {
                prefs.setPreference(DEFAULT_WD_PREF_NAME, newDefDir.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            defWD = newDefDir;
        }
    }

    public static WorkDirectory chooseWD(JComponent parent, File dir, TestSuite ts, int mode) {
        return WorkDirChooseTool.chooseWD(parent, dir, ts, mode, true);
    }

    public static WorkDirectory chooseWD(JComponent parent, File dir, TestSuite ts, int mode, boolean noTemplate) {
        File initDir = dir != null ? dir : WorkDirChooseTool.getDefDir();
        WorkDirChooser wdc = new WorkDirChooser(initDir);
        wdc.setMode(mode);
        wdc.setTestSuite(ts);
        wdc.setAllowNoTemplate(noTemplate);
        int action = wdc.showDialog(parent);
        if (action == 0) {
            WorkDirectory wd = wdc.getSelectedWorkDirectory();
            WorkDirChooseTool.setDefDir(wd.getRoot());
            return wd;
        }
        return null;
    }

    public static WorkDirChooseTool getTool(JComponent parent, UIFactory ui, ExecModel em, int mode, TestSuite ts, boolean showTemplateStuff) {
        Frame aFrame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        WorkDirChooseTool wdct = new WorkDirChooseTool(aFrame, ts, ui, mode);
        File defaultWorkDirPath = em.getContextManager().getDefaultWorkDirPath();
        if (defaultWorkDirPath == null || defaultWorkDirPath.isAbsolute()) {
            wdct.setDefaultDirectoryNoPrefs(defaultWorkDirPath, true);
        } else {
            try {
                wdct.setDefaultDirectoryNoPrefs(defaultWorkDirPath.getCanonicalFile(), true);
            }
            catch (IOException ex) {
                wdct.setDefaultDirectoryNoPrefs(defaultWorkDirPath, true);
            }
        }
        if (mode != 4) {
            wdct.setDefaultTemplateDir(em.getContextManager().getDefaultTemplateLoadPath(), true);
            wdct.setAllowTraversDirs(em.getContextManager().getAllowTemplateLoadOutsideDefault());
        } else {
            wdct.setDefaultTemplateDir(em.getContextManager().getDefaultConfigLoadPath(), true);
            wdct.setAllowTraversDirs(em.getContextManager().getAllowConfigLoadOutsideDefault());
        }
        wdct.setWithoutTemplateMode(em.getContextManager().getFeatureManager().isEnabled(5));
        wdct.setExecModel(em);
        wdct.setHideTemplateButtons(showTemplateStuff);
        return wdct;
    }

    public void setDefaultDirectory(File f, boolean isNonDefaultDirAllowed) {
        this.setDefaultDirectoryNoPrefs(f, isNonDefaultDirAllowed);
        if (f != null) {
            Preferences prefs = Preferences.access();
            try {
                prefs.setPreference(DEFAULT_WD_PREF_NAME, f.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void setDefaultDirectoryNoPrefs(File f, boolean isNonDefaultDirAllowed) {
        if (f != null) {
            this.defaultDir = f;
        }
        this.isNonDefaultDirAllowed = isNonDefaultDirAllowed;
    }

    public void updateDefaultDirectory(boolean isNonDefaultDirAllowed) {
        Preferences prefs = Preferences.access();
        String prefsDefaultDir = prefs.getPreference(DEFAULT_WD_PREF_NAME);
        if (prefsDefaultDir != null) {
            this.setDefaultDirectoryNoPrefs(new File(prefsDefaultDir), isNonDefaultDirAllowed);
        }
    }

    public void setDefaultTemplateDir(File f, boolean isNonDefaultDirAllowed) {
        if (f != null) {
            this.currentTemplateDir = f;
            this.defaultTemplateDir = f;
        }
    }

    public void setAllowTraversDirs(boolean allow) {
        this.allowTraversDirs = allow;
    }

    public void setWithoutTemplateMode(boolean withoutTemplate) {
        this.withoutTemplate = withoutTemplate;
    }

    public void initGUI() {
        this.main = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                int dpi = WorkDirChooseTool.this.uif.getDotsPerInch();
                if (!WorkDirChooseTool.this.hideTemplates) {
                    return new Dimension(5 * dpi, 4 * dpi);
                }
                Dimension d = super.getPreferredSize();
                d.width = 5 * dpi;
                return d;
            }
        };
        ActionListener closeListener = actionEvent -> {
            this.setVisible(false);
            this.dispose();
        };
        this.rootPane.registerKeyboardAction(closeListener, KeyStroke.getKeyStroke(27, 0), 2);
        if (this.mode == 3) {
            this.setTitle(this.uif.getI18NString("wdc.loadtemplatetitle"));
        } else if (this.mode == 4) {
            this.setTitle(this.uif.getI18NString("wdc.loadconfig"));
        } else {
            this.setTitle(this.uif.getI18NString("wdc.createtitle"));
        }
        this.main.setName("wdc.body");
        this.main.setFocusable(false);
        this.main.setLayout(new GridBagLayout());
        this.main.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints lc = new GridBagConstraints();
        if (this.mode != 3 && this.mode != 4) {
            JLabel dirLabel = this.uif.createLabel("wdc.dir.name", true);
            lc.gridx = 0;
            lc.gridy = 0;
            lc.anchor = 17;
            lc.insets.right = 10;
            lc.insets.bottom = 11;
            this.main.add((Component)dirLabel, lc);
            this.tField = this.uif.createInputField("wdc.namefield", dirLabel);
            this.tField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent evt) {
                    WorkDirChooseTool.this.updateCreateBtn();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    WorkDirChooseTool.this.updateCreateBtn();
                }
            });
            lc = new GridBagConstraints();
            lc.gridwidth = 2;
            lc.fill = 2;
            lc.weightx = 1.0;
            this.main.add((Component)this.tField, lc);
            JLabel dirPLabel = this.uif.createLabel("wdc.dir.path", true);
            lc = new GridBagConstraints();
            lc.gridy = 1;
            lc.anchor = 17;
            if (!this.withoutTemplate) {
                lc.insets.bottom = 10;
            }
            this.main.add((Component)dirPLabel, lc);
            this.updateDefaultDirectory(true);
            this.dirField = this.uif.createInputField("wdc.savefield", dirPLabel);
            this.dirField.setText(this.defaultDir.getAbsolutePath());
            this.dirField.setEditable(false);
            lc = new GridBagConstraints();
            lc.gridx = 1;
            lc.fill = 2;
            lc.weightx = 1.0;
            if (!this.withoutTemplate) {
                lc.insets.bottom = 10;
            }
            this.main.add((Component)this.dirField, lc);
            JButton browseBtn = this.uif.createButton("wdc.browse", ae -> {
                int returnVal;
                if (this.fileChooser == null) {
                    this.fileChooser = new FileChooser(true);
                } else {
                    this.fileChooser.resetChoosableFileFilters();
                }
                this.fileChooser.setFileSelectionMode(1);
                this.fileChooser.setDialogTitle(this.uif.getI18NString("wdc.filechoosertitle"));
                File f = new File(this.dirField.getText());
                if (f.isDirectory()) {
                    this.fileChooser.setCurrentDirectory(f);
                }
                if ((returnVal = this.fileChooser.showOpenDialog(this.parent)) == 0) {
                    File dir = this.fileChooser.getSelectedFile();
                    if (!dir.exists()) {
                        int answer = this.uif.showYesNoDialog("wdc.createparents");
                        if (answer == 1) {
                            return;
                        }
                        if (!dir.mkdirs()) {
                            this.uif.showError("wdc.createerror", (Object)dir);
                            return;
                        }
                    }
                    this.dirField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            });
            browseBtn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
            lc = new GridBagConstraints();
            lc.gridy = 1;
            lc.insets.left = 11;
            if (!this.withoutTemplate) {
                lc.insets.bottom = 10;
            }
            this.main.add((Component)browseBtn, lc);
            ButtonGroup group = new ButtonGroup();
            this.noTemplateCB = this.uif.createRadioButton("wdc.notemplate", group);
            this.noTemplateCB.setSelected(true);
            this.noTemplateCB.addActionListener(e -> {
                this.template = false;
                this.setTemplatesEnabled(false);
            });
            lc = new GridBagConstraints();
            lc.gridy = 2;
            lc.gridwidth = 3;
            lc.anchor = 17;
            if (!this.hideTemplates) {
                this.main.add((Component)this.noTemplateCB, lc);
            }
            this.templateCB = this.uif.createRadioButton("wdc.template", group);
            this.template = true;
            this.templateCB.addActionListener(e -> {
                this.template = true;
                this.setTemplatesEnabled(true);
            });
            lc = new GridBagConstraints();
            lc.gridy = 3;
            lc.gridwidth = 3;
            lc.anchor = 17;
            if (!this.hideTemplates) {
                this.main.add((Component)this.templateCB, lc);
            }
            if (!this.withoutTemplate) {
                this.noTemplateCB.setVisible(false);
                this.templateCB.setVisible(false);
            }
        }
        this.bottom = this.uif.createPanel("wdc.bottom", false);
        this.bottom.setLayout(new GridBagLayout());
        Border tb = null;
        switch (this.mode) {
            case 0: 
            case 1: 
            case 3: {
                tb = this.uif.createTitledBorder("wdc.templateFile");
                break;
            }
            case 4: {
                tb = this.uif.createTitledBorder("wdc.configFile");
                break;
            }
            default: {
                tb = BorderFactory.createEmptyBorder();
            }
        }
        this.bottom.setBorder(BorderFactory.createCompoundBorder(tb, BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        this.templatePLabel = this.uif.createLabel("wdc.template.path", true);
        lc = new GridBagConstraints();
        lc.insets.right = 10;
        lc.insets.bottom = 11;
        this.bottom.add((Component)this.templatePLabel, lc);
        this.templateField = this.uif.createInputField("wdc.templatefield", this.templatePLabel);
        this.templateField.setEditable(false);
        this.templateField.setText(this.currentTemplateDir.getAbsolutePath());
        lc = new GridBagConstraints();
        lc.gridx = 1;
        lc.fill = 2;
        lc.weightx = 1.0;
        this.bottom.add((Component)this.templateField, lc);
        this.makeBrowsTemplateButton();
        if (this.allowTraversDirs) {
            lc = new GridBagConstraints();
            lc.gridx = 2;
            lc.insets.left = 11;
            lc.weightx = 0.0;
            this.bottom.add((Component)this.browseTmplBtn, lc);
        }
        lc.gridwidth = 0;
        lc.fill = 1;
        this.makeFileList();
        lc = new GridBagConstraints();
        lc.fill = 1;
        lc.gridwidth = 3;
        lc.gridy = 1;
        lc.insets.top = 5;
        lc.weightx = 1.0;
        lc.weighty = 1.0;
        lc.fill = 1;
        this.bottom.add((Component)this.treePanel, lc);
        lc = new GridBagConstraints();
        lc.gridy = 4;
        lc.gridwidth = 3;
        lc.weightx = 1.0;
        lc.weighty = 1.0;
        lc.fill = 1;
        if (!this.hideTemplates) {
            this.main.add((Component)this.bottom, lc);
        }
        lc = new GridBagConstraints();
        lc.gridy = 5;
        lc.gridwidth = 3;
        lc.anchor = 17;
        this.launchEditorCB = this.mode == 0 || this.mode == 4 ? this.uif.createCheckBox("wdc.launncheditor") : this.uif.createCheckBox("wdc.launchteditor");
        this.launchEditorCB.addItemListener(e -> {
            this.showConfigEditorFlag = this.launchEditorCB.isSelected();
        });
        if (!this.hideTemplates) {
            this.main.add((Component)this.launchEditorCB, lc);
        }
        if (this.mode == 0) {
            this.createBtn = this.uif.createButton("wdc.create", new CreateWDAction());
        } else if (this.mode == 3) {
            this.createBtn = this.uif.createButton("wdc.load", new LoadTemplateAction());
        } else if (this.mode == 4) {
            this.createBtn = this.uif.createButton("wdc.load", new LoadConfigAction());
        }
        this.createBtn.setEnabled(false);
        this.cancelBtn = this.uif.createCancelButton("wdc.cancel", ae -> {
            this.setVisible(false);
            this.dispose();
        });
        if (this.mode == 3 && !this.wdWithoutTemplatePermitted(this.em.getWorkDirectory())) {
            this.cancelBtn.setEnabled(false);
        }
        this.setButtons(new JButton[]{this.createBtn, this.cancelBtn}, this.createBtn);
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.parent);
        switch (this.mode) {
            case 3: {
                this.setTemplatesEnabled(true);
                break;
            }
            case 4: {
                this.setTemplatesEnabled(true);
                break;
            }
            case 0: 
            case 1: {
                this.setTemplatesEnabled(!this.withoutTemplate);
                break;
            }
            default: {
                tb = BorderFactory.createEmptyBorder();
            }
        }
        this.pack();
        this.setVisible(true);
    }

    void openSimpleChooser() {
        this.updateDefaultDirectory(true);
        WorkDirChooser wdc = new WorkDirChooser(this.defaultDir);
        wdc.setMode(this.mode);
        wdc.setTestSuite(this.testSuite);
        wdc.setAllowNoTemplate(this.withoutTemplate);
        int action = wdc.showDialog(this.parent);
        if (action == 0) {
            WorkDirectory wd = wdc.getSelectedWorkDirectory();
            if (!this.wdWithoutTemplatePermitted(wd)) {
                this.uif.showError("ce.force_close");
                return;
            }
            this.setDefaultDirectory(wd.getRoot().getParentFile(), true);
            if (this.mode == 1) {
                this.em.getExecToolManager().showWorkDirectory(wd);
            } else if (this.mode == 2 || this.mode == 0) {
                if (this.em.getTestSuite() == null) {
                    this.em.getExecToolManager().showWorkDirectory(wd);
                } else {
                    this.em.setWorkDir(wd, true);
                }
            }
        }
        wdc.setSelectedWorkDirectory(null);
        wdc.setTestSuite(null);
    }

    private boolean wdWithoutTemplatePermitted(WorkDirectory wd) {
        String wdTmpl = TemplateUtilities.getTemplatePath(wd);
        FeatureManager fm = this.em.getContextManager().getFeatureManager();
        return fm.isEnabled(5) || wdTmpl != null;
    }

    private void makeFileList() {
        this.fsm = new FileSystemTableModel(this.currentTemplateDir.getAbsolutePath(), this.getTableFilter(), this.defaultTemplateDir, this.allowTraversDirs);
        this.setUpTree(new FileTable(this.fsm, this.uif));
    }

    private void setTableListeners() {
        ListSelectionModel rowSM = this.fileTable.getSelectionModel();
        rowSM.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                FileSystemTableModel model = (FileSystemTableModel)this.fileTable.getModel();
                File selected = model.getNode(selectedRow);
                this.selectedTemplate = selected != null && selected.isFile() ? selected : null;
                this.updateCreateBtn();
            }
        });
        this.fileTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FileSystemTableModel model;
                File selected;
                if (e.getClickCount() == 2 && WorkDirChooseTool.this.fileTable.getSelectedRow() != -1 && (selected = (model = (FileSystemTableModel)WorkDirChooseTool.this.fileTable.getModel()).getNode(WorkDirChooseTool.this.fileTable.getSelectedRow())).isDirectory()) {
                    File oldDir = model.getCurrentDir();
                    WorkDirChooseTool.this.currentTemplateDir = selected;
                    WorkDirChooseTool.this.templateField.setText(WorkDirChooseTool.this.currentTemplateDir.getAbsolutePath());
                    model.resetTable(selected.getAbsolutePath());
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        if (!model.getNode(i).equals(oldDir)) continue;
                        WorkDirChooseTool.this.fileTable.setRowSelectionInterval(i, i);
                        WorkDirChooseTool.this.scrollIfNeed(i);
                        break;
                    }
                }
            }
        });
        this.fileTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (WorkDirChooseTool.this.fileTable.getSelectedRow() != -1) {
                        FileSystemTableModel model = (FileSystemTableModel)WorkDirChooseTool.this.fileTable.getModel();
                        File selected = model.getNode(WorkDirChooseTool.this.fileTable.getSelectedRow());
                        if (selected.isDirectory()) {
                            File oldDir = model.getCurrentDir();
                            WorkDirChooseTool.this.currentTemplateDir = selected;
                            WorkDirChooseTool.this.templateField.setText(WorkDirChooseTool.this.currentTemplateDir.getAbsolutePath());
                            model.resetTable(selected.getAbsolutePath());
                            for (int i = 0; i < model.getRowCount(); ++i) {
                                block17: {
                                    if (!model.getNode(i).equals(oldDir)) continue;
                                    try {
                                        WorkDirChooseTool.this.fileTable.setRowSelectionInterval(i - 1, i - 1);
                                    }
                                    catch (IllegalArgumentException exc) {
                                        if (i == 0) {
                                            WorkDirChooseTool.this.fileTable.setRowSelectionInterval(WorkDirChooseTool.this.fileTable.getRowCount() - 1, WorkDirChooseTool.this.fileTable.getRowCount() - 1);
                                        }
                                        if (i != WorkDirChooseTool.this.fileTable.getRowCount() - 1) break block17;
                                        WorkDirChooseTool.this.fileTable.setRowSelectionInterval(WorkDirChooseTool.this.fileTable.getRowCount() - 2, WorkDirChooseTool.this.fileTable.getRowCount() - 2);
                                    }
                                }
                                WorkDirChooseTool.this.scrollIfNeed(i);
                                break;
                            }
                        } else {
                            ActionEvent ae = new ActionEvent(WorkDirChooseTool.this.createBtn, 1001, "pressed");
                            ActionListener[] als = WorkDirChooseTool.this.createBtn.getActionListeners();
                            if (als != null) {
                                for (ActionListener al : als) {
                                    al.actionPerformed(ae);
                                }
                            }
                        }
                    }
                } else {
                    if ((e.getModifiersEx() & 0x80) != 0) {
                        return;
                    }
                    if ((e.getModifiersEx() & 0x40) != 0 && e.getKeyCode() == 9) {
                        int i = WorkDirChooseTool.this.fileTable.getSelectedRow();
                        if (i == -1) {
                            return;
                        }
                        i = i == 0 ? WorkDirChooseTool.this.fileTable.getRowCount() - 1 : --i;
                        WorkDirChooseTool.this.fileTable.setRowSelectionInterval(i, i);
                        e.consume();
                        WorkDirChooseTool.this.fileTable.scrollRectToVisible(WorkDirChooseTool.this.fileTable.getCellRect(i, 0, true));
                    } else if (e.getKeyCode() == 9) {
                        int i = WorkDirChooseTool.this.fileTable.getSelectedRow();
                        if (i == -1) {
                            return;
                        }
                        i = i == WorkDirChooseTool.this.fileTable.getRowCount() - 1 ? 0 : ++i;
                        WorkDirChooseTool.this.fileTable.setRowSelectionInterval(i, i);
                        e.consume();
                        WorkDirChooseTool.this.fileTable.scrollRectToVisible(WorkDirChooseTool.this.fileTable.getCellRect(i, 0, true));
                    }
                }
            }
        });
    }

    private void scrollIfNeed(int rowIndex) {
        if (!this.isCellVisible(rowIndex, 0)) {
            this.scrollToCenter(rowIndex, 0);
        }
    }

    private boolean isCellVisible(int rowIndex, int vColIndex) {
        if (!(this.fileTable.getParent() instanceof JViewport)) {
            return false;
        }
        JViewport viewport = (JViewport)this.fileTable.getParent();
        Rectangle rect = this.fileTable.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        return new Rectangle(viewport.getExtentSize()).contains(rect);
    }

    public void scrollToCenter(int rowIndex, int vColIndex) {
        if (!(this.fileTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.fileTable.getParent();
        Rectangle rect = this.fileTable.getCellRect(rowIndex, vColIndex, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
    }

    private void makeBrowsTemplateButton() {
        this.browseTmplBtn = this.uif.createButton("wdc.template.browse", ae -> {
            if (this.fileChooser == null) {
                this.fileChooser = new FileChooser(true);
            } else {
                this.fileChooser.resetChoosableFileFilters();
            }
            this.fileChooser.setFileSelectionMode(2);
            switch (this.mode) {
                case 0: 
                case 3: {
                    this.fileChooser.setDialogTitle(this.uif.getI18NString("wdc.templchoosertitle"));
                    this.fileChooser.addChoosableExtension(JTM, this.uif.getI18NString("ce.jtmFiles"));
                    break;
                }
                case 4: {
                    this.fileChooser.setDialogTitle(this.uif.getI18NString("wdc.configchoosertitle"));
                    this.fileChooser.addChoosableExtension(JTI, this.uif.getI18NString("ce.jtiFiles"));
                    break;
                }
            }
            this.fileChooser.setCurrentDirectory(this.currentTemplateDir);
            File selectedFile = null;
            int returnVal = this.fileChooser.showOpenDialog(this.parent);
            if (returnVal == 0) {
                this.currentTemplateDir = this.fileChooser.getSelectedFile();
                if (!this.currentTemplateDir.exists()) {
                    int answer = this.uif.showYesNoDialog("wdc.createparents");
                    if (answer == 1) {
                        return;
                    }
                    if (!this.currentTemplateDir.mkdirs()) {
                        this.uif.showError("wdc.createerror");
                        return;
                    }
                }
                if (this.currentTemplateDir.isFile()) {
                    selectedFile = this.currentTemplateDir;
                    this.currentTemplateDir = this.currentTemplateDir.getParentFile();
                }
                if (this.currentTemplateDir != null) {
                    this.templateField.setText(this.currentTemplateDir.getAbsolutePath());
                    this.fsm = new FileSystemTableModel(this.currentTemplateDir.getAbsolutePath(), this.getTableFilter(), this.defaultTemplateDir, this.allowTraversDirs);
                    this.setUpTree(new FileTable(this.fsm, this.uif));
                    if (selectedFile != null) {
                        TableModel mod = this.fileTable.getModel();
                        for (int i = 0; i < mod.getRowCount(); ++i) {
                            FileTableNode ftn = (FileTableNode)mod.getValueAt(i, 0);
                            if (!selectedFile.equals(ftn.getFile())) continue;
                            this.fileTable.getSelectionModel().setSelectionInterval(i, i);
                            this.fileTable.scrollRectToVisible(this.fileTable.getCellRect(i, 0, true));
                            break;
                        }
                    }
                }
            }
        });
        this.browseTmplBtn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
    }

    private void setUpTree(FileTable table) {
        if (this.treePanel == null) {
            this.treePanel = new JPanel();
            this.treePanel.setLayout(new BorderLayout());
        }
        this.scPane = this.uif.createScrollPane(table);
        this.enabledColor = table.getBackground();
        this.disabledColor = UIFactory.Colors.BUTTON_DISABLED_FOREGROUND.getValue();
        this.scPane.getViewport().setBackground(this.enabledColor);
        this.treePanel.removeAll();
        this.treePanel.add((Component)this.scPane, "Center");
        this.fileTable = table;
        this.setTableListeners();
        this.main.revalidate();
    }

    private FileSystemTableModel.FileTableFilter getTableFilter() {
        if (this.mode == 4) {
            return new FileSystemTableModel.FileTableFilter(JTI);
        }
        return new FileSystemTableModel.FileTableFilter(JTM);
    }

    public void setTestSuite(TestSuite ts) {
        this.testSuite = ts;
    }

    public WorkDirectory getWorkDirectory() {
        return this.swda.getWorkDirectory();
    }

    private void doDone() {
        File templateName = null;
        if (this.mode != 3 && this.mode != 4) {
            if (this.selectedTemplate != null && (this.templateCB.isSelected() || !this.em.getContextManager().getFeatureManager().isEnabled(5))) {
                templateName = this.selectedTemplate;
            }
        } else {
            templateName = this.selectedTemplate;
            if (this.chosenFileHandler != null) {
                this.chosenFileHandler.file = this.selectedTemplate;
                this.chosenFileHandler.isEditConfig = this.showConfigEditorFlag;
            }
        }
        try {
            if (this.mode == 1) {
                this.em.getExecToolManager().showWorkDirectory(this.getWorkDirectory());
            } else if (this.mode == 2) {
                this.em.setWorkDir(this.getWorkDirectory(), true);
            } else if (this.mode == 0) {
                TemplateUtilities.setTemplateFile(this.getWorkDirectory(), templateName, true);
                this.em.setWorkDir(this.getWorkDirectory(), true);
            }
        }
        catch (IOException e) {
            this.uif.showError("exec.wd.errorOpeningWD", (Object)e);
        }
        if (this.showConfigEditorFlag) {
            if (this.mode == 3) {
                this.em.showTemplateEditor();
            } else {
                this.em.showConfigEditor(false);
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    protected void setButtons(JButton[] buttons, JButton defaultButton) {
        this.buttons = buttons;
        this.cancelButton = null;
        if (buttons != null) {
            for (int i = 0; i < buttons.length && this.cancelButton == null; ++i) {
                if (!buttons[i].getActionCommand().equals("cancel")) continue;
                this.cancelButton = buttons[i];
            }
        }
        this.initMain();
        this.setContentPane(this.main);
        this.getRootPane().setDefaultButton(defaultButton);
    }

    private void initMain() {
        JPanel m = this.uif.createPanel("wdc.main", false);
        m.setLayout(new BorderLayout());
        m.add((Component)this.main, "Center");
        Dimension maxBtnDims = new Dimension();
        for (JButton button2 : this.buttons) {
            Dimension d = button2.getPreferredSize();
            maxBtnDims.width = Math.max(maxBtnDims.width, d.width);
            maxBtnDims.height = Math.max(maxBtnDims.height, d.height);
        }
        for (JButton button1 : this.buttons) {
            button1.setPreferredSize(maxBtnDims);
        }
        JPanel p = this.uif.createPanel("wdc.btns", false);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.insets.top = 0;
        c.insets.bottom = 11;
        c.insets.right = 11;
        c.weightx = 1.0;
        for (JButton button : this.buttons) {
            p.add((Component)button, c);
            c.weightx = 0.0;
        }
        m.add((Component)p, "South");
        this.main = m;
    }

    private void updateCreateBtn() {
        if (this.mode == 0) {
            if (this.tField.getText().trim() != null && this.tField.getText().trim().isEmpty()) {
                this.createBtn.setEnabled(false);
            } else {
                this.createBtn.setEnabled(this.noTemplateCB.isSelected() || this.selectedTemplate != null);
            }
        } else if (this.mode == 3 || this.mode == 4) {
            this.createBtn.setEnabled(this.selectedTemplate != null);
        }
    }

    public void setExecModel(ExecModel em) {
        this.em = em;
    }

    private void setTemplatesEnabled(boolean t) {
        this.browseTmplBtn.setEnabled(t);
        this.fileTable.setEnabled(t);
        Color c = t ? this.enabledColor : this.disabledColor;
        this.fileTable.setBackground(c);
        this.scPane.getViewport().setBackground(c);
        this.templatePLabel.setEnabled(t);
        this.templateField.setEnabled(t);
        this.updateCreateBtn();
    }

    private void setHideTemplateButtons(boolean show) {
        this.hideTemplates = !show;
    }

    public void doTool() {
        if (this.mode == 0 || this.mode == 3 || this.mode == 4) {
            this.initGUI();
        } else {
            this.openSimpleChooser();
        }
    }

    public void setChosenFileHandler(ChosenFileHandler cfh) {
        this.chosenFileHandler = cfh;
    }

    private class CreateWDAction
    extends AbstractAction {
        private CreateWDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            File dir = null;
            if (WorkDirChooseTool.this.dirField.getText() == null || WorkDirChooseTool.this.dirField.getText().isEmpty()) {
                WorkDirChooseTool.this.uif.showError("wdc.dirnotselected");
                return;
            }
            if (WorkDirChooseTool.this.tField.getText() == null || WorkDirChooseTool.this.tField.getText().isEmpty()) {
                WorkDirChooseTool.this.uif.showError("wdc.namenotdefined");
                return;
            }
            dir = new File(WorkDirChooseTool.this.dirField.getText());
            if (!dir.isDirectory()) {
                WorkDirChooseTool.this.uif.showError("wdc.incorrectdirname");
                return;
            }
            if (WorkDirChooseTool.this.selectedTemplate != null) {
                String templateFName = WorkDirChooseTool.this.selectedTemplate.getName();
                if (!templateFName.endsWith(WorkDirChooseTool.this.uif.getI18NString("template.ext"))) {
                    WorkDirChooseTool.this.uif.showError("wdc.nottemplatefile");
                    return;
                }
            } else if (!WorkDirChooseTool.this.em.getContextManager().getFeatureManager().isEnabled(5) && !WorkDirChooseTool.this.hideTemplates) {
                WorkDirChooseTool.this.uif.showError("wdc.wdNeedTemplate");
                return;
            }
            WorkDirChooseTool.this.wd = new File(dir, WorkDirChooseTool.this.tField.getText());
            if (!WorkDirChooseTool.this.swda.approveNewSelection(WorkDirChooseTool.this.wd, WorkDirChooseTool.this.testSuite)) {
                return;
            }
            if (WorkDirChooseTool.this.swda.isOpenedInsteadOfCreated()) {
                WorkDirChooseTool.this.selectedTemplate = TemplateUtilities.getTemplateFile(WorkDirChooseTool.this.swda.getWorkDirectory());
            }
            WorkDirChooseTool.this.setDefaultDirectory(dir, true);
            WorkDirChooseTool.this.doDone();
        }
    }

    private class LoadTemplateAction
    extends AbstractAction {
        private LoadTemplateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String templateFName;
            if (WorkDirChooseTool.this.selectedTemplate != null && !(templateFName = WorkDirChooseTool.this.selectedTemplate.getName()).endsWith(WorkDirChooseTool.this.uif.getI18NString("template.ext"))) {
                WorkDirChooseTool.this.uif.showError("wdc.nottemplatefile");
                return;
            }
            WorkDirChooseTool.this.doDone();
        }
    }

    private class LoadConfigAction
    extends AbstractAction {
        private LoadConfigAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String templateFName;
            if (WorkDirChooseTool.this.selectedTemplate != null && !(templateFName = WorkDirChooseTool.this.selectedTemplate.getName()).endsWith(WorkDirChooseTool.this.uif.getI18NString("config.ext"))) {
                WorkDirChooseTool.this.uif.showError("wdc.notconfigfile");
                return;
            }
            WorkDirChooseTool.this.doDone();
        }
    }

    public static class ChosenFileHandler {
        public File file = null;
        public boolean isEditConfig;
    }

    public static class ExecModelStub
    implements ExecModel {
        private final TestSuite ts;
        private final ContextManager cm;
        private WorkDirectory wd;
        private boolean editConfig = false;

        public ExecModelStub(TestSuite ts, ContextManager cm) {
            this.ts = ts;
            this.cm = cm;
        }

        @Override
        public TestSuite getTestSuite() {
            return this.ts;
        }

        @Override
        public WorkDirectory getWorkDirectory() {
            return this.wd;
        }

        @Override
        public InterviewParameters getInterviewParameters() {
            return null;
        }

        @Override
        public FilterConfig getFilterConfig() {
            return null;
        }

        @Override
        public ContextManager getContextManager() {
            return this.cm;
        }

        @Override
        public TestResultTable getActiveTestResultTable() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void showWorkDirDialog(boolean allowTemplates) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void configure() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isConfiguring() {
            return false;
        }

        @Override
        public void showConfigEditor(boolean runTestsWhenDone) {
            this.editConfig = true;
        }

        public boolean isShowConfigEditor() {
            return this.editConfig;
        }

        @Override
        public void showTemplateEditor() {
        }

        @Override
        public void runTests(String ... urls) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void showMessage(ResourceBundle msgs, String key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void printSetup() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void print(Printable p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setWorkDir(WorkDirectory wd, boolean addToFileHistory) {
            this.wd = wd;
        }

        @Override
        public ExecToolManager getExecToolManager() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

