/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class ShowTests {
    private TestFinder testFinder;
    private PrintStream out;
    private boolean nodes;
    private boolean fullTests;

    public static void main(String ... args) {
        try {
            if (args.length == 0) {
                ShowTests.usage(System.out);
            } else {
                ShowTests m = new ShowTests();
                m.run(args);
            }
        }
        catch (BadArgs e) {
            System.err.println("Bad Arguments: " + e.getMessage());
            ShowTests.usage(System.err);
            System.exit(1);
        }
        catch (Fault f) {
            System.err.println("Error: " + f.getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
            System.exit(3);
        }
    }

    private static void usage(PrintStream out) {
        String prog = System.getProperty("program", "java " + ShowTests.class.getName());
        out.println("Usage:");
        out.println("  " + prog + " [options]  test-suite");
        out.println("Options:");
        out.println("  -finder finderClass finderArgs... -end");
        out.println("                          specify the test finder to be used");
        out.println("  -initial initial-file   specify a starting point (optional)");
        out.println("  -o output-file          output file (default is standard output)");
        out.println("  -nodes                  show nodes in the tree");
        out.println("  -fulltests              show contents of tests");
    }

    public void run(String ... args) throws BadArgs, Fault, IOException {
        File testSuite = null;
        String finder = null;
        String[] finderArgs = null;
        File outFile = null;
        File initialFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-finder") && i + 1 < args.length) {
                finder = args[++i];
                int j = ++i;
                while (i < args.length - 1 && !args[i].equalsIgnoreCase("-end")) {
                    ++i;
                }
                finderArgs = new String[i - j];
                System.arraycopy(args, j, finderArgs, 0, finderArgs.length);
                continue;
            }
            if (args[i].equalsIgnoreCase("-initial") && i + 1 < args.length) {
                initialFile = new File(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-o") && i + 1 < args.length) {
                outFile = new File(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-nodes")) {
                this.nodes = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fulltests")) {
                this.fullTests = true;
                continue;
            }
            if (args[i].startsWith("-")) {
                throw new BadArgs(args[i]);
            }
            testSuite = new File(args[i]);
        }
        if (finder == null) {
            throw new BadArgs("no test finder specified");
        }
        if (testSuite == null) {
            throw new BadArgs("testsuite.html file not specified");
        }
        this.testFinder = this.initializeTestFinder(finder, finderArgs, testSuite);
        if (initialFile == null) {
            initialFile = this.testFinder.getRoot();
        }
        this.out = outFile == null ? System.out : new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), true, StandardCharsets.UTF_8.name());
        this.list(initialFile);
    }

    private TestFinder initializeTestFinder(String finder, String[] args, File ts) throws Fault {
        TestFinder testFinder;
        try {
            Class<TestFinder> c = Class.forName(finder).asSubclass(TestFinder.class);
            testFinder = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            testFinder.init(args, ts, null);
        }
        catch (ClassNotFoundException e) {
            throw new Fault("Error: Can't find class for TestFinder specified - " + finder);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Fault("Error: Can't create new instance of TestFinder - " + finder);
        }
        catch (IllegalAccessException e) {
            throw new Fault("Error: Illegal Access Exception. TestFinder - " + finder);
        }
        catch (TestFinder.Fault e) {
            throw new Fault("Error: Can't initialize test-finder: " + e.getMessage());
        }
        return testFinder;
    }

    private void list(File file) {
        if (this.nodes) {
            this.out.println(file);
        }
        this.testFinder.read(file);
        TestDescription[] tests = this.testFinder.getTests();
        File[] files = this.testFinder.getFiles();
        if (tests != null) {
            for (Serializable serializable : tests) {
                this.out.println("    " + ((TestDescription)serializable).getRootRelativeURL());
                if (!this.fullTests) continue;
                Iterator<String> iter = ((TestDescription)serializable).getParameterKeys();
                while (iter.hasNext()) {
                    String key = iter.next();
                    String value = ((TestDescription)serializable).getParameter(key);
                    this.out.print("        ");
                    this.out.print(key);
                    this.pad(key, 15);
                    this.out.print(value);
                    this.out.println();
                }
            }
        }
        if (files != null) {
            for (Serializable serializable : files) {
                this.list((File)serializable);
            }
        }
    }

    void pad(String s, int length) {
        for (int i = s.length(); i < length; ++i) {
            this.out.write(32);
        }
        this.out.write(32);
    }

    public static class BadArgs
    extends Exception {
        BadArgs(String msg) {
            super(msg);
        }
    }

    public static class Fault
    extends Exception {
        Fault(String msg) {
            super(msg);
        }
    }
}

