/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.agent.Alarm;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public abstract class TimeoutHandler {
    protected final PrintWriter log;
    protected final File outputDir;
    protected final File testJdk;
    private long timeout;

    public TimeoutHandler(PrintWriter printWriter, File file, File file2) {
        this.log = printWriter;
        this.outputDir = file;
        this.testJdk = file2;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTimeout(Process process) {
        this.log.println("Timeout information:");
        long l = 0L;
        try {
            l = this.getProcessId(process);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.log);
        }
        if (l == 0L) {
            this.log.println("Could not find process id for the process that timed out.");
            this.log.println("Skipping timeout handling.");
            return;
        }
        Alarm alarm = this.timeout <= 0L ? Alarm.NONE : Alarm.scheduleInterrupt(this.timeout, TimeUnit.SECONDS, this.log, Thread.currentThread());
        try {
            this.runActions(process, l);
        }
        catch (InterruptedException interruptedException) {
            alarm.cancel();
            this.log.println("Timeout handler interrupted: ");
            interruptedException.printStackTrace(this.log);
        }
        finally {
            alarm.cancel();
        }
        this.log.println("--- Timeout information end.");
    }

    protected abstract void runActions(Process var1, long var2) throws InterruptedException;

    protected long getProcessId(Process process) {
        try {
            try {
                Method method = Process.class.getMethod("pid", new Class[0]);
                return (Long)method.invoke((Object)process, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return TimeoutHandler.getProcessIdPreJdk9(process);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getProcessIdPreJdk9(Process process) throws IllegalAccessException, NoSuchFieldException {
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            int n;
            Field field = process.getClass().getDeclaredField("pid");
            boolean bl = field.isAccessible();
            try {
                field.setAccessible(true);
                n = field.getInt(process);
            }
            finally {
                field.setAccessible(bl);
            }
            return n;
        }
        return 0L;
    }
}

