/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.RegressionSecurityManager;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class ActionHelper {
    protected static final String EXEC_ERROR_CLEANUP = "Error while cleaning up threads after test";
    protected static final String EXEC_PASS = "Execution successful";
    protected static final String UNEXPECT_SYS_EXIT = "Unexpected exit from test";
    protected static final String AGENTVM_CANT_RESET_SECMGR = "Cannot reset security manager";
    protected static final String AGENTVM_CANT_RESET_SECPROVS = "Cannot reset security providers";
    protected static final String AGENTVM_CANT_RESET_PROPS = "Cannot reset system properties";

    private static <T> boolean equal(T[] TArray, T[] TArray2) {
        if (TArray == null || TArray2 == null) {
            return TArray == TArray2;
        }
        if (TArray.length != TArray2.length) {
            return false;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == TArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static Map<?, ?> copyProperties(Properties properties) {
        HashMap hashMap = new HashMap();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            hashMap.put(obj, properties.get(obj));
        }
        return hashMap;
    }

    private static Properties newProperties(Map<?, ?> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AStatus redirectOutput(PrintStream printStream, PrintStream printStream2) {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager instanceof RegressionSecurityManager) {
                boolean bl = ((RegressionSecurityManager)securityManager).setAllowSetIO(true);
                System.setOut(printStream);
                System.setErr(printStream2);
                ((RegressionSecurityManager)securityManager).setAllowSetIO(bl);
            } else {
                System.setOut(printStream);
                System.setErr(printStream2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return AStatus.passed("OK");
        }
    }

    public static class PrintStringWriter
    extends PrintWriter {
        private final StringWriter w;

        public PrintStringWriter() {
            super(new StringWriter());
            this.w = (StringWriter)this.out;
        }

        public String getOutput() {
            return this.w.toString();
        }
    }

    public static interface OutputHandler {
        public PrintStream getPrintStream(OutputKind var1, boolean var2);

        public PrintWriter getPrintWriter(OutputKind var1, boolean var2);

        public static enum OutputKind {
            LOG(""),
            STDOUT("System.out"),
            STDERR("System.err"),
            DIRECT("direct"),
            DIRECT_LOG("direct.log");

            public final String name;

            private OutputKind(String string2) {
                this.name = string2;
            }
        }
    }

    static class SaveState {
        final SecurityManager secMgr;
        final PrintStream stdOut;
        final PrintStream stdErr;
        final Locale locale;
        final Provider[] securityProviders;
        static Map<?, ?> sysProps;

        SaveState() {
            if (sysProps == null) {
                sysProps = ActionHelper.copyProperties(System.getProperties());
            }
            this.stdOut = System.out;
            this.stdErr = System.err;
            this.locale = Locale.getDefault();
            this.secMgr = System.getSecurityManager();
            if (this.secMgr instanceof RegressionSecurityManager) {
                RegressionSecurityManager regressionSecurityManager = (RegressionSecurityManager)this.secMgr;
                regressionSecurityManager.setAllowPropertiesAccess(true);
                regressionSecurityManager.resetPropertiesModified();
            }
            this.securityProviders = Security.getProviders();
        }

        AStatus restore(String string, AStatus aStatus) {
            AStatus aStatus2;
            block12: {
                aStatus2 = null;
                try {
                    if (System.getSecurityManager() != this.secMgr) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                System.setSecurityManager(secMgr);
                                return null;
                            }
                        });
                    }
                }
                catch (SecurityException securityException) {
                    this.stdErr.println();
                    this.stdErr.println("***");
                    this.stdErr.println("*** " + string);
                    this.stdErr.println("*** Cannot reset security manager after test");
                    this.stdErr.println("*** " + securityException.getMessage());
                    this.stdErr.println("***");
                    this.stdErr.println();
                    aStatus2 = AStatus.error("Cannot reset security manager: " + securityException);
                }
                try {
                    final Provider[] providerArray = Security.getProviders();
                    if (!ActionHelper.equal(this.securityProviders, providerArray)) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                for (Provider provider : providerArray) {
                                    Security.removeProvider(provider.getName());
                                }
                                for (Provider provider : securityProviders) {
                                    Security.addProvider(provider);
                                }
                                return null;
                            }
                        });
                    }
                }
                catch (SecurityException securityException) {
                    aStatus2 = AStatus.error("Cannot reset security providers: " + securityException);
                }
                SecurityManager securityManager = System.getSecurityManager();
                boolean bl = securityManager instanceof RegressionSecurityManager ? ((RegressionSecurityManager)securityManager).isPropertiesModified() : true;
                try {
                    if (bl) {
                        System.setProperties(ActionHelper.newProperties(sysProps));
                    } else {
                        System.setProperty("java.class.path", (String)sysProps.get("java.class.path"));
                    }
                }
                catch (SecurityException securityException) {
                    if (aStatus2 != null) break block12;
                    aStatus2 = AStatus.error("Cannot reset system properties: " + securityException);
                }
            }
            AStatus aStatus3 = ActionHelper.redirectOutput(this.stdOut, this.stdErr);
            if (aStatus2 == null && !aStatus3.isPassed()) {
                aStatus2 = aStatus3;
            }
            if (this.locale != Locale.getDefault()) {
                Locale.setDefault(this.locale);
            }
            return aStatus2 != null ? aStatus2 : aStatus;
        }
    }
}

