/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.ModuleHelper;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MainActionHelper
extends ActionHelper {
    private final String testName;
    private Map<String, String> props;
    private Set<String> addExports;
    private Set<String> addOpens;
    private Set<String> addMods;
    private SearchPath classpath;
    private SearchPath modulepath;
    private String className;
    private List<String> classArgs;
    private int timeout;
    private float timeoutFactor;
    private ActionHelper.OutputHandler outputHandler;
    private static final boolean traceCleanup = Flags.get("traceCleanup");
    private static final String MSG_PREFIX = "JavaTest Message: ";
    private static final String SKIP_EXCEPTION = "jtreg.SkippedException";
    private static final String MAIN_THREAD_INTR = "Thread interrupted: ";
    private static final String MAIN_THREAD_TIMEOUT = "Timeout";
    private static final String MAIN_THREW_EXCEPT = "`main' threw exception: ";
    private static final String MAIN_CANT_LOAD_TEST = "Can't load test: ";
    private static final String MAIN_CANT_FIND_MAIN = "Can't find `main' method";
    private static final String MAIN_CANT_INIT_MODULE_EXPORTS = "Can't init module exports: ";
    private static final String MAIN_SKIPPED = "Skipped: ";

    MainActionHelper(String string) {
        this.testName = string;
    }

    MainActionHelper properties(Map<String, String> map) {
        this.props = map;
        return this;
    }

    MainActionHelper addExports(Set<String> set) {
        this.addExports = set;
        return this;
    }

    MainActionHelper addOpens(Set<String> set) {
        this.addOpens = set;
        return this;
    }

    MainActionHelper addMods(Set<String> set) {
        this.addMods = set;
        return this;
    }

    MainActionHelper classpath(SearchPath searchPath) {
        this.classpath = searchPath;
        return this;
    }

    MainActionHelper modulepath(SearchPath searchPath) {
        this.modulepath = searchPath;
        return this;
    }

    MainActionHelper className(String string) {
        this.className = string;
        return this;
    }

    MainActionHelper classArgs(List<String> list) {
        this.classArgs = list;
        return this;
    }

    MainActionHelper timeout(int n) {
        this.timeout = n;
        return this;
    }

    MainActionHelper timeoutFactor(float f) {
        this.timeoutFactor = f;
        return this;
    }

    MainActionHelper outputHandler(ActionHelper.OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public AStatus runClass() {
        Object object;
        Object classNotFoundException;
        Object object2;
        ActionHelper.SaveState saveState = new ActionHelper.SaveState();
        Properties properties = System.getProperties();
        for (Map.Entry<String, String> object42 : this.props.entrySet()) {
            object2 = object42.getKey();
            classNotFoundException = object42.getValue();
            if (((String)object2).equals("test.class.path.prefix")) {
                object = new SearchPath(new String[]{classNotFoundException, System.getProperty("java.class.path")});
                properties.put("java.class.path", ((SearchPath)object).toString());
                continue;
            }
            properties.put(object42.getKey(), object42.getValue());
        }
        System.setProperties(properties);
        PrintStream printStream = this.outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDOUT, false);
        PrintStream printStream2 = this.outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDERR, true);
        object2 = AStatus.passed("Execution successful");
        try {
            Object object3;
            void var10_17;
            Class[] classArray;
            object = ClassLoader.getSystemClassLoader();
            if (this.modulepath != null && !this.modulepath.isEmpty()) {
                object = ModuleHelper.addModules(this.modulepath.asList(), this.addMods);
            }
            if (this.classpath != null && !this.classpath.isEmpty()) {
                classArray = new ArrayList();
                for (File file : this.classpath.asList()) {
                    try {
                        classArray.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                object = new URLClassLoader(classArray.toArray(new URL[classArray.size()]), (ClassLoader)object);
            }
            ModuleHelper.addExports(this.addExports, (ClassLoader)object);
            ModuleHelper.addOpens(this.addOpens, (ClassLoader)object);
            classNotFoundException = ((ClassLoader)object).loadClass(this.className);
            String[] stringArray = this.classArgs.toArray(new String[this.classArgs.size()]);
            if (TestRunner.class.isAssignableFrom((Class<?>)classNotFoundException)) {
                classArray = new Class[]{ClassLoader.class, String[].class};
                Object[] objectArray = new Object[]{object, stringArray};
            } else {
                classArray = new Class[]{String[].class};
                Object[] objectArray = new Object[]{stringArray};
            }
            Method method = ((Class)classNotFoundException).getMethod("main", classArray);
            PrintStream printStream3 = System.err;
            AStatus aStatus = MainActionHelper.redirectOutput(printStream, printStream2);
            if (!aStatus.isPassed()) {
                AStatus aStatus2 = aStatus;
                return aStatus2;
            }
            AgentVMThreadGroup agentVMThreadGroup = new AgentVMThreadGroup(printStream2, MSG_PREFIX, this.timeoutFactor);
            AgentVMRunnable agentVMRunnable = new AgentVMRunnable(method, (Object[])var10_17, printStream2);
            Thread thread = new Thread(agentVMThreadGroup, agentVMRunnable, "AgentVMThread");
            Alarm alarm = null;
            if (this.timeout > 0) {
                object3 = this.outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.LOG, true);
                alarm = Alarm.schedulePeriodicInterrupt(this.timeout, TimeUnit.SECONDS, (PrintWriter)object3, thread);
            }
            object3 = null;
            thread.start();
            try {
                thread.join();
                if (traceCleanup) {
                    printStream3.println("main method returned");
                }
            }
            catch (InterruptedException interruptedException) {
                printStream3.println("main method interrupted");
                if (thread.isInterrupted() && agentVMThreadGroup.uncaughtThrowable == null) {
                    object3 = interruptedException;
                    object2 = AStatus.error(MAIN_THREAD_INTR + interruptedException.getMessage());
                }
            }
            finally {
                if (traceCleanup) {
                    printStream3.println("cleaning threads");
                }
                agentVMThreadGroup.cleanup();
                if (traceCleanup) {
                    printStream3.println("thread cleanup completed");
                }
                if (alarm != null) {
                    alarm.cancel();
                    if (alarm.didFire() && object3 == null) {
                        printStream2.println("Test timed out. No timeout information is available in agentvm mode.");
                        object3 = new Error("timeout");
                        object2 = AStatus.error(MAIN_THREAD_TIMEOUT);
                    }
                }
            }
            if ((agentVMRunnable.t != null || agentVMThreadGroup.uncaughtThrowable != null) && object3 == null) {
                object3 = agentVMRunnable.t == null ? agentVMThreadGroup.uncaughtThrowable : agentVMRunnable.t;
                object2 = SKIP_EXCEPTION.equals(object3.getClass().getName()) ? AStatus.passed(MAIN_SKIPPED + ((Throwable)object3).toString()) : AStatus.failed(MAIN_THREW_EXCEPT + ((Throwable)object3).toString());
            }
            if (((AStatus)object2).getReason().contains("java.lang.SecurityException: System.exit() forbidden")) {
                object2 = AStatus.failed("Unexpected exit from test");
            } else if (!agentVMThreadGroup.cleanupOK) {
                object2 = AStatus.error("Error while cleaning up threads after test");
            }
        }
        catch (ClassNotFoundException noSuchMethodException) {
            noSuchMethodException.printStackTrace(printStream2);
            printStream2.println();
            printStream2.println("JavaTest Message: main() method must be in a public class named");
            printStream2.println(MSG_PREFIX + this.className + " in file " + this.className + ".java");
            printStream2.println();
            object2 = AStatus.error(MAIN_CANT_LOAD_TEST + noSuchMethodException);
        }
        catch (NoSuchMethodException fault) {
            fault.printStackTrace(printStream2);
            printStream2.println();
            printStream2.println("JavaTest Message: main() method must be in a public class named");
            printStream2.println(MSG_PREFIX + this.className + " in file " + this.className + ".java");
            printStream2.println();
            object2 = AStatus.error(MAIN_CANT_FIND_MAIN);
        }
        catch (ModuleHelper.Fault fault) {
            if (fault.getCause() != null) {
                fault.printStackTrace(printStream2);
            }
            object2 = AStatus.error(MAIN_CANT_INIT_MODULE_EXPORTS + fault.getMessage());
        }
        finally {
            printStream.close();
            printStream2.close();
            object2 = saveState.restore(this.testName, (AStatus)object2);
        }
        return object2;
    }

    public static interface TestRunner {
    }

    static class AgentVMThreadGroup
    extends ThreadGroup {
        private double timeoutFactor;
        private final PrintStream out;
        private final String messagePrefix;
        private boolean cleaning = false;
        Throwable uncaughtThrowable = null;
        Thread uncaughtThread = null;
        boolean cleanupOK = false;

        AgentVMThreadGroup(PrintStream printStream, String string, double d) {
            super("AgentVMThreadGroup");
            this.out = printStream;
            this.messagePrefix = string;
            this.timeoutFactor = d;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            if (this.uncaughtThrowable == null && !this.cleaning) {
                this.uncaughtThrowable = throwable;
                this.uncaughtThread = thread;
            }
            this.cleanup();
        }

        private void cleanup() {
            this.cleaning = true;
            long l = (long)(10000.0 * this.timeoutFactor);
            long l2 = l / 4L;
            long l3 = System.nanoTime();
            block2: for (int i = 1; i <= 4; ++i) {
                long l4 = l3 + (long)i * l2 * 1000000L;
                List<Thread> list = this.liveThreads();
                if (list.isEmpty()) {
                    this.cleanupOK = true;
                    return;
                }
                for (Thread thread : list) {
                    thread.interrupt();
                }
                for (Thread thread : list) {
                    long l5 = (l4 - System.nanoTime()) / 1000000L;
                    if (l5 <= 0L) continue block2;
                    try {
                        thread.join(l5);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            List<Thread> list = this.liveThreads();
            if (list.isEmpty()) {
                this.cleanupOK = true;
                return;
            }
            this.out.println();
            this.out.println(this.messagePrefix + "Problem cleaning up the following threads:");
            this.printTraces(list);
            this.cleanupOK = false;
        }

        private List<Thread> liveThreads() {
            int n = this.activeCount() + 1;
            while (true) {
                Thread[] threadArray;
                int n2;
                if ((n2 = this.enumerate(threadArray = new Thread[n])) < threadArray.length) {
                    ArrayList<Thread> arrayList = new ArrayList<Thread>(n2);
                    for (int i = 0; i < n2; ++i) {
                        Thread thread = threadArray[i];
                        if (!thread.isAlive() || thread == Thread.currentThread() || thread.isDaemon()) continue;
                        arrayList.add(thread);
                    }
                    return arrayList;
                }
                n *= 2;
            }
        }

        private void printTraces(List<Thread> list) {
            for (Thread thread : list) {
                this.out.println(thread.getName());
                StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    this.out.println("  at " + stackTraceElementArray[i]);
                    if (i != 20) continue;
                    this.out.println("  ...");
                    break;
                }
                this.out.println();
            }
        }
    }

    private static class AgentVMRunnable
    implements Runnable {
        public Object result;
        private final Method method;
        private final Object[] args;
        private final PrintStream out;
        Throwable t = null;

        public AgentVMRunnable(Method method, Object[] objectArray, PrintStream printStream) {
            this.method = method;
            this.args = objectArray;
            this.out = printStream;
        }

        @Override
        public void run() {
            try {
                this.result = this.method.invoke(null, this.args);
                this.out.println();
                this.out.println("JavaTest Message: Test complete.");
                this.out.println();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace(this.out);
                this.t = invocationTargetException.getTargetException();
                this.out.println();
                this.out.println("JavaTest Message: Test threw exception: " + this.t.getClass().getName());
                this.out.println("JavaTest Message: shutting down test");
                this.out.println();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(this.out);
                this.t = illegalAccessException;
                this.out.println();
                this.out.println("JavaTest Message: Verify that the class defining the test is");
                this.out.println("JavaTest Message: declared public (test invoked via reflection)");
                this.out.println();
            }
        }
    }
}

