/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestFinder;
import com.sun.javatest.TestSuite;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.ExtraPropDefns;
import com.sun.javatest.regtest.config.RegressionKeywords;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.StringUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TestProperties {
    private final TestFinder.ErrorHandler errHandler;
    private final Cache cache;
    final boolean checkBugID;
    final Set<String> validKeys;
    final ExecMode defaultExecMode;
    final List<String> groupFiles;
    final Version requiredVersion;
    final ExtraPropDefns extraPropDefns;
    private static final boolean allowLocalKeys = Boolean.parseBoolean(System.getProperty("javatest.regtest.allowLocalKeys", "true"));
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionTestSuite.class);

    TestProperties(File file, TestFinder.ErrorHandler errorHandler) {
        this.errHandler = errorHandler;
        this.cache = new Cache(this.canon(file));
        Cache.Entry entry = this.cache.getEntry(this.cache.rootDir);
        this.validKeys = entry.validKeys;
        String string = entry.properties.getProperty("checkBugID");
        this.checkBugID = string == null || !string.trim().equals("false");
        String string2 = entry.properties.getProperty("defaultExecMode");
        this.defaultExecMode = ExecMode.fromString(string2);
        String string3 = entry.properties.getProperty("groups");
        this.groupFiles = string3 == null ? Collections.emptyList() : Arrays.asList(string3.split("\\s+"));
        String string4 = entry.properties.getProperty("requiredVersion");
        this.requiredVersion = new Version(string4);
        String string5 = entry.properties.getProperty("requires.extraPropDefns");
        this.extraPropDefns = string5 == null ? new ExtraPropDefns() : new ExtraPropDefns(string5, entry.properties.getProperty("requires.extraPropDefns.libs"), entry.properties.getProperty("requires.extraPropDefns.bootlibs"), entry.properties.getProperty("requires.extraPropDefns.javacOpts"), entry.properties.getProperty("requires.extraPropDefns.vmOpts"));
    }

    Set<String> getValidKeys(File file) throws TestSuite.Fault {
        if (!allowLocalKeys) {
            return this.validKeys;
        }
        return this.getEntry((File)file).validKeys;
    }

    Set<String> getValidRequiresProperties(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).validRequiresProperties;
    }

    ExecMode getDefaultExecMode() {
        return this.defaultExecMode;
    }

    List<String> getGroupFiles() {
        return this.groupFiles;
    }

    boolean useBootClassPath(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).useBootClassPath;
    }

    boolean useOtherVM(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).useOtherVM;
    }

    boolean isTestNG(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).testNGRoot != null;
    }

    File getTestNGRoot(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).testNGRoot;
    }

    boolean needsExclusiveAccess(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).needsExclusiveAccess;
    }

    Set<String> getLibDirs(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).libDirs;
    }

    Set<String> getLibBuildArgs(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).libBuildArgs;
    }

    Set<String> getModules(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).modules;
    }

    Version getRequiredVersion() {
        return this.requiredVersion;
    }

    Set<File> getExternalLibs(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).extLibRoots;
    }

    ExtraPropDefns getExtraPropDefns() {
        return this.extraPropDefns;
    }

    int getMaxOutputSize(File file) {
        return this.getEntry((File)file).maxOutputSize;
    }

    boolean getAllowSmartActionArgs(File file) {
        return this.getEntry((File)file).allowSmartActionArgs;
    }

    boolean getEnablePreview(File file) {
        return this.getEntry((File)file).enablePreview;
    }

    private Cache.Entry getEntry(File file) {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        return this.cache.getEntry(file2);
    }

    private void error(I18NResourceBundle i18NResourceBundle, String string, Object ... objectArray) {
        this.errHandler.error(i18NResourceBundle.getString(string, objectArray));
    }

    private File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(file.getAbsoluteFile().toURI().normalize());
        }
    }

    class Cache {
        Map<File, SoftReference<Entry>> map;
        Entry lastUsedEntry;
        File rootDir;

        Cache(File file) {
            this.rootDir = file;
            this.map = new HashMap<File, SoftReference<Entry>>();
        }

        synchronized Entry getEntry(File file) {
            if (this.lastUsedEntry == null || !this.lastUsedEntry.dir.equals(file)) {
                this.lastUsedEntry = this.getEntryInternal(file);
            }
            return this.lastUsedEntry;
        }

        private Entry getEntryInternal(File file) {
            Entry entry;
            SoftReference<Entry> softReference = this.map.get(file);
            Entry entry2 = entry = softReference == null ? null : softReference.get();
            if (entry == null) {
                Entry entry3 = file.equals(this.rootDir) ? null : this.getEntryInternal(file.getParentFile());
                entry = new Entry(entry3, file);
                this.map.put(file, new SoftReference<Entry>(entry));
            }
            return entry;
        }

        class Entry {
            final Entry parent;
            final File dir;
            final Properties properties;
            final Set<String> validKeys;
            final Set<String> validRequiresProperties;
            final boolean useBootClassPath;
            private final Set<File> bootClassPathDirs;
            final boolean useOtherVM;
            private final Set<File> otherVMDirs;
            final boolean needsExclusiveAccess;
            private final Set<File> exclusiveAccessDirs;
            final File testNGRoot;
            private final Set<File> testNGDirs;
            final Set<String> libDirs;
            final Set<String> libBuildArgs;
            final Set<File> extLibRoots;
            final Set<String> modules;
            final int maxOutputSize;
            final boolean allowSmartActionArgs;
            final boolean enablePreview;

            Entry(Entry entry, File file) {
                this.parent = entry;
                this.dir = file;
                File file2 = new File(file, entry == null ? "TEST.ROOT" : "TEST.properties");
                if (file2.canRead()) {
                    this.properties = entry == null ? new Properties() : new Properties(entry.properties);
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));){
                        this.properties.load(bufferedInputStream);
                    }
                    catch (IOException iOException) {
                        TestProperties.this.error(i18n, "props.cantRead", file2);
                    }
                    this.validKeys = this.initKeywordSet(entry == null ? null : entry.validKeys, "keys");
                    this.validRequiresProperties = this.initSimpleSet(entry == null ? null : entry.validRequiresProperties, "requires.properties");
                    this.bootClassPathDirs = this.initFileSet(entry == null ? null : entry.bootClassPathDirs, "bootclasspath.dirs", file);
                    this.otherVMDirs = this.initFileSet(entry == null ? null : entry.otherVMDirs, "othervm.dirs", file);
                    this.exclusiveAccessDirs = this.initFileSet(entry == null ? null : entry.exclusiveAccessDirs, "exclusiveAccess.dirs", file);
                    this.testNGDirs = this.initFileSet(entry == null ? null : entry.testNGDirs, "TestNG.dirs", file);
                    this.libDirs = this.initLibDirSet(entry == null ? null : entry.libDirs, "lib.dirs", file);
                    this.libBuildArgs = this.initSimpleSet(entry == null ? null : entry.libBuildArgs, "lib.build");
                    this.extLibRoots = this.initFileSet(entry == null ? null : entry.extLibRoots, "external.lib.roots", file);
                    this.modules = this.initSimpleSet(entry == null ? null : entry.modules, "modules");
                    this.maxOutputSize = this.getInt("maxOutputSize", -1);
                    this.allowSmartActionArgs = this.initAllowSmartActionArgs(entry);
                    this.enablePreview = this.initEnablePreview(entry);
                } else {
                    if (entry == null) {
                        throw new IllegalStateException("TEST.ROOT not found");
                    }
                    this.properties = entry.properties;
                    this.validKeys = entry.validKeys;
                    this.validRequiresProperties = entry.validRequiresProperties;
                    this.bootClassPathDirs = entry.bootClassPathDirs;
                    this.otherVMDirs = entry.otherVMDirs;
                    this.exclusiveAccessDirs = entry.exclusiveAccessDirs;
                    this.testNGDirs = entry.testNGDirs;
                    this.libDirs = entry.libDirs;
                    this.libBuildArgs = entry.libBuildArgs;
                    this.extLibRoots = entry.extLibRoots;
                    this.modules = entry.modules;
                    this.maxOutputSize = entry.maxOutputSize;
                    this.allowSmartActionArgs = entry.allowSmartActionArgs;
                    this.enablePreview = entry.enablePreview;
                }
                this.useBootClassPath = this.initUseBootClassPath(entry, file);
                this.useOtherVM = this.initUseOtherVM(entry, file);
                this.needsExclusiveAccess = this.initNeedsExclusiveAccess(entry, file);
                this.testNGRoot = this.initTestNGRoot(entry, file);
            }

            private int getInt(String string, int n) {
                String string2 = this.properties.getProperty(string);
                try {
                    if (string2 != null) {
                        return Integer.parseInt(string2.trim());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    TestProperties.this.error(i18n, "props.bad.value", string, string2);
                }
                return n;
            }

            private Set<File> initFileSet(Set<File> set, String string, File file) {
                String[] stringArray = StringUtils.splitWS(this.properties.getProperty(string));
                if (set == null || stringArray.length > 0) {
                    LinkedHashSet<File> linkedHashSet = set == null ? new LinkedHashSet<File>() : new LinkedHashSet<File>(set);
                    for (String string2 : stringArray) {
                        File file2 = this.toFile(file, string2);
                        if (file2 == null) continue;
                        linkedHashSet.add(file2);
                    }
                    return Collections.unmodifiableSet(linkedHashSet);
                }
                return set;
            }

            private Set<String> initLibDirSet(Set<String> set, String string, File file) {
                String[] stringArray = StringUtils.splitWS(this.properties.getProperty(string));
                if (set == null || stringArray.length > 0) {
                    LinkedHashSet<Object> linkedHashSet = set == null ? new LinkedHashSet<Object>() : new LinkedHashSet<String>(set);
                    for (String string2 : stringArray) {
                        if (string2.startsWith("/")) {
                            linkedHashSet.add(string2);
                            continue;
                        }
                        File file2 = this.toFile(file, string2);
                        if (file2 == null) continue;
                        linkedHashSet.add("/" + Cache.this.rootDir.toPath().relativize(file2.toPath()).toString().replace(File.separatorChar, '/'));
                    }
                    return Collections.unmodifiableSet(linkedHashSet);
                }
                return set;
            }

            private Set<String> initKeywordSet(Set<String> set, String string) {
                String[] stringArray = StringUtils.splitWS(this.properties.getProperty(string));
                if (set == null || stringArray.length > 0) {
                    LinkedHashSet<String> linkedHashSet = set == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(set);
                    for (String string2 : stringArray) {
                        try {
                            RegressionKeywords.validateKey(string2);
                            linkedHashSet.add(string2.replace("-", "_"));
                        }
                        catch (RegressionKeywords.Fault fault) {
                            File file = new File(this.dir, set == null ? "TEST.ROOT" : "TEST.properties");
                            TestProperties.this.error(i18n, "props.bad.keyword", file, string2, fault.getMessage());
                        }
                    }
                    return Collections.unmodifiableSet(linkedHashSet);
                }
                return set;
            }

            private Set<String> initSimpleSet(Set<String> set, String string) {
                String[] stringArray = StringUtils.splitWS(this.properties.getProperty(string));
                if (set == null || stringArray.length > 0) {
                    LinkedHashSet<String> linkedHashSet = set == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(set);
                    linkedHashSet.addAll(Arrays.asList(stringArray));
                    return Collections.unmodifiableSet(linkedHashSet);
                }
                return set;
            }

            private boolean initUseBootClassPath(Entry entry, File file) {
                if (entry == null) {
                    return false;
                }
                if (entry.useBootClassPath) {
                    return true;
                }
                for (File file2 : this.bootClassPathDirs) {
                    if (!this.includes(file2, file)) continue;
                    return true;
                }
                return false;
            }

            private boolean initUseOtherVM(Entry entry, File file) {
                if (entry == null) {
                    return false;
                }
                if (entry.useOtherVM) {
                    return true;
                }
                for (File file2 : this.otherVMDirs) {
                    if (!this.includes(file2, file)) continue;
                    return true;
                }
                return false;
            }

            private boolean initNeedsExclusiveAccess(Entry entry, File file) {
                if (entry == null) {
                    return false;
                }
                if (entry.needsExclusiveAccess) {
                    return true;
                }
                for (File file2 : this.exclusiveAccessDirs) {
                    if (!this.includes(file2, file)) continue;
                    return true;
                }
                return false;
            }

            private File initTestNGRoot(Entry entry, File file) {
                if (entry == null) {
                    return null;
                }
                if (entry.testNGRoot != null) {
                    return entry.testNGRoot;
                }
                for (File file2 : this.testNGDirs) {
                    if (!this.includes(file2, file)) continue;
                    return file2;
                }
                return null;
            }

            private boolean includes(File file, File file2) {
                while (file2 != null) {
                    if (file.equals(file2)) {
                        return true;
                    }
                    file2 = file2.getParentFile();
                }
                return false;
            }

            private boolean initAllowSmartActionArgs(Entry entry) {
                if (this.properties.containsKey("allowSmartActionArgs")) {
                    return this.properties.getProperty("allowSmartActionArgs").equals("true");
                }
                if (entry != null) {
                    return entry.allowSmartActionArgs;
                }
                String string = this.properties.getProperty("requiredVersion");
                if (string != null) {
                    return new Version(string).compareTo(new Version("4.2 b14")) >= 0;
                }
                return false;
            }

            private boolean initEnablePreview(Entry entry) {
                if (this.properties.containsKey("enablePreview")) {
                    return this.properties.getProperty("enablePreview").equals("true");
                }
                if (entry != null) {
                    return entry.enablePreview;
                }
                return false;
            }

            private File toFile(File file, String string) {
                if (string.startsWith("/")) {
                    File file2 = new File(Cache.this.rootDir, string.substring(1));
                    if (file2.exists()) {
                        return new File(file2.toURI().normalize());
                    }
                } else {
                    File file3 = new File(file, string);
                    if (file3.exists()) {
                        return new File(file3.toURI().normalize());
                    }
                    file3 = new File(Cache.this.rootDir, string);
                    if (file3.exists()) {
                        return new File(file3.toURI().normalize());
                    }
                }
                return null;
            }
        }
    }
}

