/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.MainWrapper;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.JUnitAction;
import com.sun.javatest.regtest.exec.Lock;
import com.sun.javatest.regtest.exec.ModuleConfig;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestNGAction;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MainAction
extends Action {
    public static final String NAME = "main";
    private final List<String> testJavaArgs = new ArrayList<String>();
    private final List<String> testClassArgs = new ArrayList<String>();
    private Class<? extends MainActionHelper.TestRunner> driverClass = null;
    private List<String> driverArgs = null;
    private String testModuleName = null;
    private String testClassName = null;
    private File policyFN = null;
    private String secureCN = null;
    private boolean overrideSysPolicy = false;
    protected boolean reverseStatus = false;
    protected boolean useBootClassPath = false;
    protected Set<String> othervmOverrideReasons = new LinkedHashSet<String>();
    protected boolean nativeCode = false;
    private int timeout = -1;
    private String manual = "unset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        this.init(map, list, string, regressionScript, null, null);
    }

    void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript, Class<? extends MainActionHelper.TestRunner> clazz, String ... stringArray) throws ParseException {
        Set<Locations.LibLocn.Kind> set;
        boolean bl;
        Object object2;
        super.init(map, list, string, regressionScript);
        if (list.isEmpty()) {
            throw new ParseException("No class provided for `main'");
        }
        boolean bl2 = false;
        block22: for (Map.Entry<String, String> entry : map.entrySet()) {
            object2 = entry.getKey();
            String string2 = entry.getValue();
            switch (object2) {
                case "fail": {
                    this.reverseStatus = this.parseFail(string2);
                    continue block22;
                }
                case "manual": {
                    this.manual = this.parseMainManual(string2);
                    continue block22;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(string2);
                    continue block22;
                }
                case "othervm": {
                    bl2 = true;
                    this.othervmOverrideReasons.add("/othervm specified");
                    continue block22;
                }
                case "native": {
                    this.nativeCode = true;
                    continue block22;
                }
                case "bootclasspath": {
                    this.useBootClassPath = true;
                    this.othervmOverrideReasons.add("/bootclasspath specified");
                    continue block22;
                }
                case "policy": {
                    this.overrideSysPolicy = true;
                    this.policyFN = this.parsePolicy(string2);
                    continue block22;
                }
                case "java.security.policy": {
                    String string3 = string2;
                    if (string2.startsWith("=")) {
                        this.overrideSysPolicy = true;
                        string3 = string2.substring(1, string2.length());
                    }
                    this.policyFN = this.parsePolicy(string3);
                    continue block22;
                }
                case "secure": {
                    this.secureCN = this.parseSecure(string2);
                    continue block22;
                }
            }
            throw new ParseException("Bad option for main: " + (String)object2);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(-1);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        if (clazz != null) {
            this.driverClass = clazz;
            this.driverArgs = Arrays.asList(stringArray);
        }
        if (regressionScript.useBootClassPath()) {
            this.useBootClassPath = true;
            this.othervmOverrideReasons.add("test or library uses bootclasspath");
        }
        boolean bl3 = false;
        for (int i = 0; i < list.size(); ++i) {
            object2 = list.get(i);
            if (this.testClassName == null) {
                if (((String)object2).startsWith("-")) {
                    if (((String)object2).equals("--enable-preview")) {
                        bl3 = true;
                    }
                    this.testJavaArgs.add((String)object2);
                    if (!JDKOpts.hasFollowingArg((String)object2)) continue;
                    this.testJavaArgs.add(list.get(++i));
                    continue;
                }
                int n = ((String)object2).indexOf("/");
                if (n == -1) {
                    this.testModuleName = null;
                    this.testClassName = object2;
                    continue;
                }
                this.testModuleName = ((String)object2).substring(0, n);
                this.testClassName = ((String)object2).substring(n + 1);
                continue;
            }
            this.testClassArgs.add((String)object2);
        }
        if (this.testClassName == null) {
            throw new ParseException("No class provided for `main'");
        }
        if (!bl2) {
            if (this.testJavaArgs.size() > 0) {
                throw new ParseException(this.testJavaArgs + ": vm option(s) found, need to specify /othervm");
            }
            if (this.policyFN != null) {
                throw new ParseException("`/policy' and `/java.security.policy` require use of `/othervm'");
            }
            if (this.secureCN != null) {
                throw new ParseException("`/secure' requires use of `/othervm'");
            }
        }
        if (regressionScript.enablePreview() && !bl3) {
            this.testJavaArgs.add("--enable-preview");
            if (!bl2) {
                this.othervmOverrideReasons.add("test requires --enable-preview");
            }
        }
        if (!bl2) {
            for (Object object2 : regressionScript.getModules()) {
                String string4 = ((Modules.Entry)object2).moduleName;
                if (!regressionScript.systemModules.contains(string4) || regressionScript.defaultModules.contains(string4)) continue;
                this.othervmOverrideReasons.add("test requires non-default system module");
                break;
            }
        }
        if (!bl2 && (this instanceof TestNGAction || this instanceof JUnitAction) && (bl = (set = regressionScript.locations.getDirKinds(regressionScript.locations.absTestSrcDir())).equals(EnumSet.of(Locations.LibLocn.Kind.USER_MODULE)))) {
            this.othervmOverrideReasons.add("test requires testng and/or junit as modules");
        }
    }

    public List<String> getJavaArgs() {
        return this.testJavaArgs;
    }

    public String getModuleName() {
        return this.testModuleName;
    }

    public String getClassName() {
        return this.testClassName;
    }

    public List<String> getClassArgs() {
        return this.testClassArgs;
    }

    List<String> filterJavaOpts(List<String> list) {
        return list;
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        if (this.testClassName != null) {
            Map<String, String> map = Collections.emptyMap();
            List<String> list = Arrays.asList(this.join(this.testModuleName, this.testClassName));
            try {
                BuildAction buildAction = new BuildAction();
                buildAction.init(map, list, "Named class compiled on demand", this.script);
                linkedHashSet.addAll(buildAction.getSourceFiles());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.policyFN != null) {
            linkedHashSet.add(this.policyFN);
        }
        return linkedHashSet;
    }

    @Override
    public Set<String> getModules() {
        return this.testModuleName == null ? Collections.emptySet() : Collections.singleton(this.testModuleName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Status run() throws TestRunException {
        Status status;
        if (this.script.usePatchModules()) {
            this.othervmOverrideReasons.add("test or library overrides a system module");
        }
        if (!(status = this.build()).isPassed()) {
            return status;
        }
        if (this.nativeCode && this.script.getNativeDir() == null) {
            return RStatus.error("Use -nativepath to specify the location of native code");
        }
        if (this.script.isCheck()) {
            this.startAction(true);
            status = RStatus.passed("Test description appears acceptable");
            this.endAction(status);
            return status;
        }
        Lock lock = this.script.getLockIfRequired();
        if (lock != null) {
            lock.lock();
        }
        this.startAction(true);
        try {
            switch (!this.othervmOverrideReasons.isEmpty() ? ExecMode.OTHERVM : this.script.getExecMode()) {
                case AGENTVM: {
                    this.showMode(ExecMode.AGENTVM);
                    status = this.runAgentJVM();
                    return status;
                }
                case OTHERVM: {
                    this.showMode(ExecMode.OTHERVM, this.othervmOverrideReasons);
                    status = this.runOtherJVM();
                    return status;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        finally {
            this.endAction(status);
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    protected Status build() throws TestRunException {
        Map<String, String> map = Collections.emptyMap();
        List<String> list = Arrays.asList(this.join(this.testModuleName, this.testClassName));
        BuildAction buildAction = new BuildAction();
        return buildAction.build(map, list, "Named class compiled on demand", this.script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runOtherJVM() throws TestRunException {
        Object object;
        Object object4;
        List<Object> list;
        String string;
        String string2;
        if (this.driverClass == null) {
            string2 = this.testModuleName;
            string = this.join(this.testModuleName, this.testClassName);
            list = this.testClassArgs;
        } else {
            string2 = null;
            string = this.driverClass.getName();
            list = new ArrayList<String>();
            list.addAll(this.driverArgs);
            list.add(this.join(this.testModuleName, this.testClassName));
            list.addAll(this.testClassArgs);
        }
        File file = this.getArgFile();
        try {
            object4 = new BufferedWriter(new FileWriter(file));
            try {
                ((Writer)object4).write(string + "\u0000");
                ((Writer)object4).write(StringUtils.join(list, " ") + "\u0000");
            }
            finally {
                ((BufferedWriter)object4).close();
            }
        }
        catch (IOException iOException) {
            return RStatus.error("Can't write `main' argument file");
        }
        object4 = new LinkedHashMap();
        object4.putAll(this.getEnvVars(this.nativeCode));
        Set<Locations.LibLocn.Kind> set = this.script.locations.getDirKinds(this.script.locations.absTestSrcDir());
        boolean bl = set.equals(EnumSet.of(Locations.LibLocn.Kind.USER_MODULE));
        Map<RegressionScript.PathKind, SearchPath> map = this.script.getExecutionPaths(bl, string2, this.useBootClassPath, true);
        SearchPath searchPath = map.get((Object)RegressionScript.PathKind.CLASSPATH);
        if (searchPath != null && !searchPath.isEmpty()) {
            object4.put("CLASSPATH", searchPath.toString());
        }
        String string3 = this.script.getJavaProg();
        JDKOpts jDKOpts = new JDKOpts();
        SearchPath searchPath2 = map.get((Object)RegressionScript.PathKind.BOOTCLASSPATH_APPEND);
        SearchPath searchPath3 = map.get((Object)RegressionScript.PathKind.PATCHPATH);
        jDKOpts.addPath("-Xbootclasspath/a:", searchPath2);
        jDKOpts.addAllPatchModules(searchPath3);
        jDKOpts.addPath("--module-path", map.get((Object)RegressionScript.PathKind.MODULEPATH));
        Set<String> set2 = this.addMods(map);
        if (!set2.isEmpty()) {
            jDKOpts.add("--add-modules");
            jDKOpts.add(StringUtils.join(set2, ","));
        }
        if (searchPath3 != null && !searchPath3.isEmpty() && searchPath2 != null && !searchPath2.isEmpty()) {
            for (String object32 : this.getModules(searchPath3)) {
                jDKOpts.add("--add-reads=" + object32 + "=ALL-UNNAMED");
            }
        }
        jDKOpts.addAll(this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC));
        jDKOpts.addAll(this.script.getTestVMJavaOptions());
        jDKOpts.addAll(this.script.getTestDebugOptions());
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        linkedHashMap.putAll(this.script.getTestProperties());
        if (this.policyFN != null) {
            File file2 = this.addGrantEntries(this.policyFN, file);
            linkedHashMap.put("java.security.policy", (this.overrideSysPolicy ? "=" : "") + file2);
        }
        if (this.secureCN != null) {
            linkedHashMap.put("java.security.manager", this.secureCN);
        } else if (this.policyFN != null) {
            linkedHashMap.put("java.security.manager", "default");
        }
        jDKOpts.addAll(this.testJavaArgs);
        String string4 = MainWrapper.class.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getPath());
        arrayList.addAll(list);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string3);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            arrayList2.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        arrayList2.addAll(this.filterJavaOpts(jDKOpts.toList()));
        arrayList2.add(string4);
        arrayList2.addAll(arrayList);
        PrintWriter printWriter = this.section.createOutput("System.out");
        PrintWriter printWriter2 = this.section.createOutput("System.err");
        try {
            if (showMode) {
                this.showMode(this.getName(), ExecMode.OTHERVM, this.section);
            }
            if (showCmd) {
                this.showCmd(this.getName(), arrayList2, this.section);
            }
            new ModuleConfig("Boot Layer").setFromOpts(jDKOpts).write(this.configWriter);
            this.recorder.java((Map<String, String>)object4, string3, linkedHashMap, jDKOpts.toList(), string4, arrayList);
            ProcessCommand processCommand = new ProcessCommand();
            processCommand.setExecDir(this.script.absTestScratchDir());
            processCommand.setStatusForExit(Status.exitCodes[0], RStatus.passed("Execution successful"));
            processCommand.setStatusForExit(Status.exitCodes[1], RStatus.failed("Execution failed"));
            processCommand.setDefaultStatus(RStatus.failed("Unexpected exit from test"));
            TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
            processCommand.setCommand(arrayList2).setEnvironment((Map<String, String>)object4).setStreams(printWriter, printWriter2).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
            object = RStatus.normalize(processCommand.exec());
        }
        finally {
            printWriter.close();
            printWriter2.close();
        }
        object = this.checkReverse((Status)object, this.reverseStatus);
        return object;
    }

    private Set<String> addMods(Map<RegressionScript.PathKind, SearchPath> map) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.testModuleName != null) {
            linkedHashSet.add(this.testModuleName);
        }
        linkedHashSet.addAll(this.getModules(map.get((Object)RegressionScript.PathKind.MODULEPATH)));
        return linkedHashSet;
    }

    private Status runAgentJVM() throws TestRunException {
        Status status;
        Agent agent;
        Set<String> set;
        List<String> list;
        String string;
        String string2;
        if (this.driverClass == null) {
            string2 = this.testModuleName;
            string = this.testClassName;
            list = this.testClassArgs;
        } else {
            string2 = null;
            string = this.driverClass.getName();
            list = new ArrayList<String>();
            list.addAll(this.driverArgs);
            list.add(this.testClassName);
            list.addAll(this.testClassArgs);
        }
        Set<Locations.LibLocn.Kind> set2 = this.script.locations.getDirKinds(this.script.locations.absTestSrcDir());
        boolean bl = set2.equals(EnumSet.of(Locations.LibLocn.Kind.USER_MODULE));
        Map<RegressionScript.PathKind, SearchPath> map = this.script.getExecutionPaths(bl, string2, this.useBootClassPath, true);
        JDK jDK = this.script.getTestJDK();
        List<File> list2 = new SearchPath().append(this.script.getJavaTestClassPath()).append(jDK.getJDKClassPath()).append(this.script.getJUnitPath()).append(this.script.getTestNGPath()).asList();
        Version version = this.script.getRequiredVersion();
        SearchPath searchPath = map.get((Object)RegressionScript.PathKind.CLASSPATH);
        SearchPath searchPath2 = version.version == null || version.compareTo(new Version("5.1 b01")) >= 0 ? new SearchPath().append(list2) : new SearchPath(searchPath).retainAll(list2);
        SearchPath searchPath3 = new SearchPath(searchPath).removeAll(list2);
        SearchPath searchPath4 = map.get((Object)RegressionScript.PathKind.MODULEPATH);
        if (showMode) {
            this.showMode(this.getName(), ExecMode.AGENTVM, this.section);
        }
        Map<String, String> map2 = this.script.getTestProperties();
        String string3 = this.script.getJavaProg();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-classpath");
        arrayList.add(searchPath.toString());
        if (searchPath4 != null) {
            arrayList.add("--module-path");
            arrayList.add(searchPath4.toString());
        }
        if (!(set = this.addMods(map)).isEmpty()) {
            arrayList.add("--add-modules");
            arrayList.add(StringUtils.join(set, ","));
        }
        this.recorder.java(this.script.getEnvVars(), string3, map2, arrayList, string, list);
        try {
            agent = this.script.getAgent(jDK, searchPath2, this.filterJavaOpts(MainAction.join(this.script.getTestVMJavaOptions(), this.script.getTestDebugOptions())));
            this.section.getMessageWriter().println("Agent id: " + agent.getId());
            new ModuleConfig("Boot Layer").setFromOpts(agent.vmOpts).write(this.configWriter);
        }
        catch (Agent.Fault fault) {
            return RStatus.error("Cannot get VM for test: " + fault.getCause());
        }
        TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
        try {
            Object object;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
            if (jDK.hasModules()) {
                for (Object object2 : this.script.getModules()) {
                    if (((Modules.Entry)object2).packageName == null) continue;
                    if (((Modules.Entry)object2).addExports) {
                        linkedHashSet.add(((Modules.Entry)object2).moduleName + "/" + ((Modules.Entry)object2).packageName);
                    }
                    if (!((Modules.Entry)object2).addOpens) continue;
                    linkedHashSet2.add(((Modules.Entry)object2).moduleName + "/" + ((Modules.Entry)object2).packageName);
                }
            }
            if (!linkedHashSet.isEmpty()) {
                object = null;
                for (String string4 : linkedHashSet) {
                    if (!string4.contains("/")) continue;
                    if (object == null) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Additional exports to unnamed modules from @modules: ");
                    } else {
                        ((StringBuilder)object).append(" ");
                    }
                    ((StringBuilder)object).append(string4);
                }
                if (object != null) {
                    this.section.getMessageWriter().println(object);
                }
            }
            if (!linkedHashSet2.isEmpty()) {
                object = null;
                for (String string4 : linkedHashSet2) {
                    if (!string4.contains("/")) continue;
                    if (object == null) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Additional opens to unnamed modules from @modules: ");
                    } else {
                        ((StringBuilder)object).append(" ");
                    }
                    ((StringBuilder)object).append(string4);
                }
                if (object != null) {
                    this.section.getMessageWriter().println(object);
                }
            }
            new ModuleConfig("Test Layer").setAddExportsToUnnamed(linkedHashSet).setAddOpensToUnnamed(linkedHashSet2).setClassPath(searchPath3).setModulePath(searchPath4).write(this.configWriter);
            status = agent.doMainAction(this.script.getTestResult().getTestName(), map2, linkedHashSet, linkedHashSet2, set, searchPath3, searchPath4 != null ? searchPath4 : new SearchPath(), string, list, this.timeout, timeoutHandler, this.section);
        }
        catch (Agent.Fault fault) {
            status = fault.getCause() instanceof IOException ? RStatus.error(String.format("Agent communication error: %s; check console log for any additional details", fault.getCause())) : RStatus.error(String.format("Agent error: %s; check console log for any additional details", fault.getCause()));
        }
        if (status.isError()) {
            this.script.closeAgent(agent);
        }
        status = this.checkReverse(status, this.reverseStatus);
        return status;
    }

    private String parseMainManual(String string) throws ParseException {
        if (string != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + string);
        }
        string = "novalue";
        return string;
    }

    private Status checkReverse(Status status, boolean bl) {
        if (!status.isError() && !status.getReason().startsWith("Unexpected exit from test")) {
            Object object;
            boolean bl2 = status.isPassed();
            int n = status.getType();
            if (bl2 && bl) {
                object = "Execution passed unexpectedly";
                n = 1;
            } else if (bl2 && !bl) {
                object = status.getReason().isEmpty() ? "Execution successful" : status.getReason();
            } else if (!bl2 && bl) {
                object = "Execution failed as expected";
                n = 0;
            } else {
                object = "Execution failed";
            }
            if (n == 1 && status.getReason() != null && !status.getReason().equals("Execution successful")) {
                object = (String)object + ": " + status.getReason();
            }
            status = RStatus.createStatus(n, (String)object);
        }
        return status;
    }

    private String join(String string, String string2) {
        return string == null ? string2 : string + "/" + string2;
    }
}

