/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ModuleConfig {
    private final String title;
    private List<String> addMods;
    private List<String> limitMods;
    private Map<String, List<String>> addExports;
    private Map<String, List<String>> addOpens;
    private Map<String, List<String>> addReads;
    private SearchPath modulePath;
    private SearchPath classPath;
    private SearchPath sourcePath;
    private SearchPath bootClassPathAppend;
    private Map<String, SearchPath> patch;

    ModuleConfig(String string) {
        this.title = string;
    }

    ModuleConfig setFromOpts(JDKOpts jDKOpts) {
        this.setFromOpts(jDKOpts.toList());
        return this;
    }

    ModuleConfig setFromOpts(List<String> list) {
        JDKOpts.OptionHandler optionHandler = new JDKOpts.OptionHandler(){

            @Override
            protected void handleOption(JDKOpts.Option option, String string, String string2) {
                switch (option) {
                    case ADD_EXPORTS: {
                        ModuleConfig.this.setAddExports(StringUtils.beforePart(string2, '='), StringUtils.split(StringUtils.afterPart(string2, '='), ','));
                        break;
                    }
                    case ADD_MODULES: {
                        ModuleConfig.this.setAddModules(StringUtils.split(string2, ','));
                        break;
                    }
                    case ADD_EXPORTS_PRIVATE: 
                    case ADD_OPENS: {
                        ModuleConfig.this.setAddOpens(StringUtils.beforePart(string2, '='), StringUtils.split(StringUtils.afterPart(string2, '='), ','));
                        break;
                    }
                    case ADD_READS: {
                        ModuleConfig.this.setAddReads(StringUtils.beforePart(string2, '='), StringUtils.split(StringUtils.afterPart(string2, '='), ','));
                        break;
                    }
                    case CLASS_PATH: {
                        ModuleConfig.this.setClassPath(new SearchPath(string2));
                        break;
                    }
                    case SOURCE_PATH: {
                        ModuleConfig.this.setSourcePath(new SearchPath(string2));
                        break;
                    }
                    case LIMIT_MODULES: {
                        ModuleConfig.this.setLimitModules(StringUtils.split(string2, ','));
                        break;
                    }
                    case MODULE_PATH: {
                        ModuleConfig.this.setModulePath(new SearchPath(string2));
                        break;
                    }
                    case PATCH_MODULE: {
                        ModuleConfig.this.setPatchPath(StringUtils.beforePart(string2, '='), new SearchPath(StringUtils.afterPart(string2, '=')));
                    }
                }
            }

            @Override
            protected void handleUnknown(String string) {
            }
        };
        optionHandler.handleOptions(list);
        return this;
    }

    ModuleConfig setAddModules(List<String> list) {
        this.addMods = list;
        return this;
    }

    ModuleConfig setLimitModules(List<String> list) {
        this.limitMods = list;
        return this;
    }

    ModuleConfig setAddExportsToUnnamed(Set<String> set) {
        for (String string : set) {
            if (!string.contains("/")) continue;
            this.setAddExports(string, Collections.singletonList("ALL-UNNAMED"));
        }
        return this;
    }

    ModuleConfig setAddOpensToUnnamed(Set<String> set) {
        for (String string : set) {
            if (!string.contains("/")) continue;
            this.setAddOpens(string, Collections.singletonList("ALL-UNNAMED"));
        }
        return this;
    }

    ModuleConfig setAddExports(String string, List<String> list) {
        if (this.addExports == null) {
            this.addExports = new TreeMap<String, List<String>>();
        }
        this.addExports.put(string, list);
        return this;
    }

    ModuleConfig setAddOpens(String string, List<String> list) {
        if (this.addOpens == null) {
            this.addOpens = new TreeMap<String, List<String>>();
        }
        this.addOpens.put(string, list);
        return this;
    }

    ModuleConfig setAddReads(String string, List<String> list) {
        if (this.addReads == null) {
            this.addReads = new TreeMap<String, List<String>>();
        }
        this.addReads.put(string, list);
        return this;
    }

    ModuleConfig setBootClassPathAppend(SearchPath searchPath) {
        this.bootClassPathAppend = searchPath;
        return this;
    }

    ModuleConfig setClassPath(SearchPath searchPath) {
        this.classPath = searchPath;
        return this;
    }

    ModuleConfig setSourcePath(SearchPath searchPath) {
        this.sourcePath = searchPath;
        return this;
    }

    ModuleConfig setModulePath(SearchPath searchPath) {
        this.modulePath = searchPath;
        return this;
    }

    ModuleConfig setPatchPath(String string, SearchPath searchPath) {
        if (this.patch == null) {
            this.patch = new TreeMap<String, SearchPath>();
        }
        this.patch.put(string, searchPath);
        return this;
    }

    void write(PrintWriter printWriter) {
        String string;
        Table table = new Table();
        if (this.addMods != null && !this.addMods.isEmpty()) {
            table.addRow("add modules:", StringUtils.join(this.addMods, " "));
        }
        if (this.limitMods != null && !this.limitMods.isEmpty()) {
            table.addRow("limit modules:", StringUtils.join(this.limitMods, " "));
        }
        if (this.addExports != null && !this.addExports.isEmpty()) {
            string = "add exports:";
            for (Map.Entry<String, List<String>> object : this.addExports.entrySet()) {
                table.addRow(string, object.getKey(), StringUtils.join((Collection)object.getValue(), " "));
                string = null;
            }
        }
        if (this.addOpens != null && !this.addOpens.isEmpty()) {
            string = "add opens:";
            for (Map.Entry entry : this.addOpens.entrySet()) {
                table.addRow(string, (String)entry.getKey(), StringUtils.join((Collection)entry.getValue(), " "));
                string = null;
            }
        }
        if (this.addReads != null && !this.addReads.isEmpty()) {
            string = "add reads:";
            for (Map.Entry entry : this.addReads.entrySet()) {
                table.addRow(string, (String)entry.getKey(), StringUtils.join((Collection)entry.getValue(), " "));
                string = null;
            }
        }
        if (this.modulePath != null) {
            string = "module path:";
            for (File file : this.modulePath.asList()) {
                table.addRow(string, file.getPath());
                string = null;
            }
        }
        if (this.sourcePath != null) {
            string = "source path:";
            for (File file : this.sourcePath.asList()) {
                table.addRow(string, file.getPath());
                string = null;
            }
        }
        if (this.classPath != null) {
            string = "class path:";
            for (File file : this.classPath.asList()) {
                table.addRow(string, file.getPath());
                string = null;
            }
        }
        if (this.bootClassPathAppend != null) {
            string = "boot class path (append):";
            for (File file : this.bootClassPathAppend.asList()) {
                table.addRow(string, file.getPath());
                string = null;
            }
        }
        if (this.patch != null) {
            string = "patch:";
            for (Map.Entry entry : this.patch.entrySet()) {
                String string2 = (String)entry.getKey();
                for (File file : ((SearchPath)entry.getValue()).asList()) {
                    table.addRow(string, string2, file.getPath());
                    string = null;
                    string2 = null;
                }
            }
        }
        if (table.rows.isEmpty()) {
            return;
        }
        printWriter.println(this.title);
        table.write(printWriter, 2);
        printWriter.println();
    }

    private static class Table {
        List<List<String>> rows = new ArrayList<List<String>>();

        private Table() {
        }

        void addRow(String ... stringArray) {
            this.rows.add(Arrays.asList(stringArray));
        }

        void write(PrintWriter printWriter, int n) {
            int n2;
            int n3 = 0;
            for (List<String> iterator : this.rows) {
                n3 = Math.max(n3, iterator.size());
            }
            Object object = new int[n3];
            for (List<String> list : this.rows) {
                n2 = 0;
                for (String string : list) {
                    if (string != null && n2 < list.size() - 1) {
                        object[n2] = Math.max((int)object[n2], string.length());
                    }
                    ++n2;
                }
            }
            for (List<String> list : this.rows) {
                this.space(printWriter, n);
                n2 = 0;
                for (String string : list) {
                    if (string == null) {
                        this.space(printWriter, (int)object[n2]);
                    } else {
                        printWriter.write(string);
                        this.space(printWriter, (int)(object[n2] - string.length()));
                    }
                    if (object[n2] > 0) {
                        printWriter.write(" ");
                    }
                    ++n2;
                }
                printWriter.println();
            }
        }

        private void space(PrintWriter printWriter, int n) {
            for (int i = 0; i < n; ++i) {
                printWriter.print(" ");
            }
        }
    }
}

