/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.util.ProcessUtils;
import com.sun.javatest.regtest.util.StreamCopier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ProcessCommand {
    private HashMap<Integer, Status> statusTable;
    private Status defaultStatus = Status.error("unknown reason");
    private File execDir;
    private List<String> cmd;
    private Map<String, String> env;
    private PrintWriter out;
    private PrintWriter err;
    private long timeout;
    private TimeoutHandler timeoutHandler;

    public ProcessCommand setStatusForExit(int n, Status status) {
        if (this.statusTable == null) {
            this.statusTable = new HashMap();
            if (this.defaultStatus == null) {
                this.defaultStatus = Status.error("unrecognized exit code");
            }
        }
        this.statusTable.put(n, status);
        return this;
    }

    public ProcessCommand setDefaultStatus(Status status) {
        if (this.statusTable == null) {
            this.statusTable = new HashMap();
        }
        this.defaultStatus = status;
        return this;
    }

    public ProcessCommand setExecDir(File file) {
        this.execDir = file;
        return this;
    }

    public File getExecDir() {
        return this.execDir;
    }

    public ProcessCommand setCommand(List<String> list) {
        this.cmd = list;
        return this;
    }

    public List<String> getCommand() {
        return this.cmd;
    }

    public ProcessCommand setEnvironment(Map<String, String> map) {
        this.env = map;
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.env;
    }

    public ProcessCommand setStreams(PrintWriter printWriter, PrintWriter printWriter2) {
        if (printWriter == null) {
            throw new IllegalArgumentException("Output stream is required");
        }
        if (printWriter2 == null) {
            throw new IllegalArgumentException("Error stream is required");
        }
        this.out = printWriter;
        this.err = printWriter2;
        return this;
    }

    public PrintWriter getOutStream() {
        return this.out;
    }

    public PrintWriter getErrorStream() {
        return this.err;
    }

    public ProcessCommand setTimeout(long l, TimeUnit timeUnit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ProcessCommand setTimeoutHandler(TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        return this;
    }

    public TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status exec() {
        Status status;
        Object object;
        if (this.out == null) {
            throw new IllegalArgumentException("Output stream is required");
        }
        if (this.err == null) {
            throw new IllegalArgumentException("Error stream is required");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(this.cmd);
        processBuilder.directory(this.execDir);
        if (this.env != null) {
            processBuilder.environment().clear();
            processBuilder.environment().putAll(this.env);
        }
        Object object2 = processBuilder.start();
        InputStream inputStream = ((Process)object2).getInputStream();
        InputStream inputStream2 = ((Process)object2).getErrorStream();
        long l = System.currentTimeMillis();
        Alarm alarm = Alarm.NONE;
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        if (this.timeout > 0L) {
            object = Thread.currentThread();
            alarm = Alarm.schedule(this.timeout, TimeUnit.MILLISECONDS, this.out, new Runnable(){
                final /* synthetic */ Process val$process;
                final /* synthetic */ Thread val$victim;
                {
                    this.val$process = process;
                    this.val$victim = thread;
                }

                @Override
                public void run() {
                    ProcessCommand.this.invokeTimeoutHandler(ProcessCommand.this.timeoutHandler, countDownLatch, this.val$process, this.val$victim);
                }
            });
        }
        if ((object = ((Process)object2).getOutputStream()) != null) {
            ((OutputStream)object).close();
        }
        try {
            StatusScanner statusScanner = new StatusScanner();
            StreamCopier streamCopier = new StreamCopier(inputStream, this.out);
            StreamCopier streamCopier2 = new StreamCopier(inputStream2, this.err, statusScanner);
            streamCopier.start();
            streamCopier2.start();
            streamCopier.join();
            streamCopier2.join();
            int n = ((Process)object2).waitFor();
            alarm.cancel();
            status = this.getStatus(n, statusScanner.exitStatus());
        }
        catch (InterruptedException interruptedException) {
            Status status2;
            try {
                alarm.cancel();
                status2 = Status.error("Program `" + this.cmd.get(0) + "' interrupted");
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    inputStream2.close();
                    alarm.cancel();
                    if (alarm.didFire()) {
                        boolean bl = this.waitForTimeoutHandler(countDownLatch, this.timeoutHandler);
                        String string = "Program `" + this.cmd.get(0) + "' timed out";
                        if (!bl) {
                            string = string + ": timeout handler did not complete within its own timeout.";
                        }
                        long l2 = System.currentTimeMillis();
                        string = string + " (timeout set to " + this.timeout + "ms, elapsed time including timeout handling was " + (l2 - l) + "ms).";
                        return Status.error(string);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    object2 = "Error invoking program `" + this.cmd.get(0) + "': " + iOException;
                    return Status.error((String)object2);
                }
            }
            inputStream.close();
            inputStream2.close();
            alarm.cancel();
            if (alarm.didFire()) {
                boolean bl = this.waitForTimeoutHandler(countDownLatch, this.timeoutHandler);
                String string = "Program `" + this.cmd.get(0) + "' timed out";
                if (!bl) {
                    string = string + ": timeout handler did not complete within its own timeout.";
                }
                long l3 = System.currentTimeMillis();
                string = string + " (timeout set to " + this.timeout + "ms, elapsed time including timeout handling was " + (l3 - l) + "ms).";
                return Status.error(string);
            }
            return status2;
        }
        inputStream.close();
        inputStream2.close();
        alarm.cancel();
        if (alarm.didFire()) {
            boolean bl = this.waitForTimeoutHandler(countDownLatch, this.timeoutHandler);
            String string = "Program `" + this.cmd.get(0) + "' timed out";
            if (!bl) {
                string = string + ": timeout handler did not complete within its own timeout.";
            }
            long l4 = System.currentTimeMillis();
            string = string + " (timeout set to " + this.timeout + "ms, elapsed time including timeout handling was " + (l4 - l) + "ms).";
            return Status.error(string);
        }
        return status;
    }

    private void invokeTimeoutHandler(final TimeoutHandler timeoutHandler, final CountDownLatch countDownLatch, final Process process, final Thread thread) {
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                if (timeoutHandler != null) {
                    timeoutHandler.handleTimeout(process);
                }
                ProcessUtils.destroyForcibly(process);
                countDownLatch.countDown();
                thread.interrupt();
            }
        };
        thread2.setName("Timeout Handler for " + this.cmd.get(0));
        thread2.start();
    }

    private boolean waitForTimeoutHandler(CountDownLatch countDownLatch, TimeoutHandler timeoutHandler) {
        boolean bl = true;
        while (countDownLatch.getCount() != 0L) {
            try {
                if (timeoutHandler.getTimeout() <= 0L) {
                    countDownLatch.await();
                    continue;
                }
                bl = countDownLatch.await(timeoutHandler.getTimeout() + 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        return bl;
    }

    protected Status getStatus(int n, Status status) {
        if (status != null) {
            return status;
        }
        if (this.statusTable != null) {
            Status status2 = this.statusTable.get(n);
            return status2 == null ? this.defaultStatus.augment("exit code: " + n) : status2;
        }
        if (n == 0) {
            return Status.passed("exit code 0");
        }
        return Status.failed("exit code " + n);
    }

    private static class StatusScanner
    implements StreamCopier.LineScanner {
        private String lastStatusLine;

        private StatusScanner() {
        }

        @Override
        public void scan(String string) {
            if (string.startsWith("STATUS:")) {
                this.lastStatusLine = string = Status.decode(string);
            }
        }

        public Status exitStatus() {
            if (this.lastStatusLine == null) {
                return null;
            }
            return Status.parse(this.lastStatusLine.substring("STATUS:".length()));
        }
    }
}

