/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.exec.Agent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

abstract class ScratchDirectory {
    private static final boolean verboseScratchDir = Flags.get("verboseScratchDir");
    protected final RegressionParameters params;
    protected final TestDescription td;
    File dir;
    private static final Set<File> badDirs = new HashSet<File>();
    private static final int RETRY_DELETE_MILLIS;
    private static final int MAX_RETRY_DELETE_MILLIS;
    private static final String CANT_CLEAN = "Can't clean ";
    private static final String CANT_CREATE = "Can't create ";
    private static final String CANT_SAVE = "Can't save files in ";
    private static final String SECMGR_EXC = "Problem deleting file: ";
    private static final String CANON_FILE_EXC = "Problem determining canonical file: ";

    static ScratchDirectory get(RegressionParameters regressionParameters, ExecMode execMode, TestDescription testDescription) {
        if (execMode == ExecMode.OTHERVM && regressionParameters.isRetainEnabled()) {
            return new TestResultScratchDir(regressionParameters, testDescription);
        }
        return new ThreadSafeScratchDir(regressionParameters, testDescription);
    }

    protected ScratchDirectory(RegressionParameters regressionParameters, TestDescription testDescription, File file) {
        this.params = regressionParameters;
        this.td = testDescription;
        this.dir = file;
    }

    void init(PrintWriter printWriter) throws Fault, InterruptedException {
        if (this.dir.exists()) {
            try {
                this.deleteFiles(this.dir, null, false, printWriter);
            }
            catch (Fault fault) {
                ScratchDirectory.addBadDir(this.dir);
                Agent.Pool.close(this.params, this.dir);
                throw fault;
            }
        } else if (!this.dir.mkdirs()) {
            throw new Fault(CANT_CREATE + this.dir);
        }
    }

    private static synchronized boolean isBadDir(File file) {
        return badDirs.contains(file);
    }

    private static synchronized void addBadDir(File file) {
        badDirs.add(file);
    }

    abstract void retainFiles(Status var1, PrintWriter var2) throws Fault, InterruptedException;

    boolean retainFile(File file, File file2) {
        File file3 = new File(this.dir, file.getPath());
        File file4 = this.params.getWorkDirectory().getFile(file2.getPath());
        return file3.renameTo(file4);
    }

    protected void deleteFiles(File file, Pattern pattern, boolean bl, PrintWriter printWriter) throws Fault, InterruptedException {
        if (ScratchDirectory.isBadDir(file)) {
            throw new Fault(CANT_CLEAN + file);
        }
        try {
            if (!file.exists()) {
                if (verboseScratchDir) {
                    printWriter.println("WARNING: dir " + file + " already deleted.");
                }
                return;
            }
            this.deleteFilesWithRetry(file, pattern, bl, printWriter);
        }
        catch (SecurityException securityException) {
            throw new Fault(SECMGR_EXC + file, securityException);
        }
    }

    private void deleteFilesWithRetry(File file, Pattern pattern, boolean bl, PrintWriter printWriter) throws Fault, InterruptedException {
        long l = System.currentTimeMillis();
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        do {
            if (this.deleteFiles(file, pattern, bl, false, linkedHashSet, printWriter)) {
                return;
            }
            System.gc();
            Thread.sleep(RETRY_DELETE_MILLIS);
        } while (System.currentTimeMillis() - l <= (long)MAX_RETRY_DELETE_MILLIS);
        for (File file2 : linkedHashSet) {
            printWriter.println("Can't delete " + file2);
        }
        throw new Fault(CANT_CLEAN + file);
    }

    private boolean deleteFiles(File file, Pattern pattern, boolean bl, boolean bl2, Set<File> set, PrintWriter printWriter) throws Fault, InterruptedException {
        if (!file.exists()) {
            return true;
        }
        boolean bl3 = true;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            printWriter.println("warning: cannot list contents of directory " + file);
            bl3 = false;
        } else {
            for (File file2 : file.listFiles()) {
                boolean bl4;
                if (ScratchDirectory.isDirectory(file2)) {
                    bl3 &= this.deleteFiles(file2, pattern, bl, true, set, printWriter);
                    continue;
                }
                boolean bl5 = bl4 = pattern == null || pattern.matcher(file2.getName()).matches() == bl;
                if (!bl4 || this.delete(file2, set, printWriter)) continue;
                bl3 = false;
            }
        }
        if (bl3 && ScratchDirectory.isEmpty(file) && bl2) {
            bl3 = this.delete(file, set, printWriter);
        }
        return bl3;
    }

    private boolean delete(File file, Set<File> set, PrintWriter printWriter) {
        if (file.delete() && !file.exists()) {
            set.remove(file);
            return true;
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.canWrite() && this.setWritable(file2, printWriter)) {
            return this.delete(file, set, printWriter);
        }
        if (verboseScratchDir) {
            printWriter.println("warning: failed to delete " + (file.isDirectory() ? "directory " : "") + file);
        }
        set.add(file);
        return false;
    }

    private boolean setWritable(File file, PrintWriter printWriter) {
        if (file.setWritable(true)) {
            return true;
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.canWrite() && this.setWritable(file2, printWriter)) {
            return this.setWritable(file, printWriter);
        }
        if (verboseScratchDir) {
            printWriter.println("warning: failed to set directory writable: " + file);
        }
        return false;
    }

    protected boolean saveFiles(File file, File file2, Pattern pattern, boolean bl, PrintWriter printWriter) throws InterruptedException {
        boolean bl2 = true;
        boolean bl3 = file2.exists();
        if (bl3) {
            try {
                this.deleteFiles(file2, null, false, printWriter);
            }
            catch (Fault fault) {
                printWriter.println("warning: could not empty " + file2 + ": " + fault.getMessage());
            }
        }
        for (File file3 : file.listFiles()) {
            boolean bl4;
            File file4;
            boolean bl5;
            String string = file3.getName();
            if (file3.isDirectory()) {
                File file5 = new File(file2, string);
                bl2 &= this.saveFiles(file3, file5, pattern, bl, printWriter);
                continue;
            }
            boolean bl6 = bl5 = pattern == null || pattern.matcher(string).matches() == bl;
            if (!bl5) continue;
            if (!bl3) {
                file2.mkdirs();
                bl3 = file2.exists();
            }
            if ((file4 = new File(file2, string)).exists()) {
                file4.delete();
            }
            if (bl4 = file3.renameTo(file4)) continue;
            printWriter.println("error: failed to rename " + file3 + " to " + file4);
            bl2 = false;
        }
        return bl2;
    }

    private static boolean isDirectory(File file) throws Fault {
        try {
            return file.isDirectory() && file.equals(file.getCanonicalFile());
        }
        catch (IOException iOException) {
            throw new Fault(CANON_FILE_EXC + file, iOException);
        }
    }

    private static boolean isEmpty(File file) {
        return file.isDirectory() && file.listFiles().length == 0;
    }

    protected static File getResultDir(RegressionParameters regressionParameters, TestDescription testDescription) {
        String string = TestResult.getWorkRelativePath(testDescription);
        if (string.endsWith(".jtr")) {
            string = string.substring(0, string.length() - 4);
        }
        return regressionParameters.getWorkDirectory().getFile(string);
    }

    static {
        boolean bl = System.getProperty("os.name").startsWith("Windows");
        RETRY_DELETE_MILLIS = bl ? 500 : 0;
        MAX_RETRY_DELETE_MILLIS = bl ? 15000 : 0;
    }

    static class TestResultScratchDir
    extends ScratchDirectory {
        TestResultScratchDir(RegressionParameters regressionParameters, TestDescription testDescription) {
            super(regressionParameters, testDescription, TestResultScratchDir.getResultDir(regressionParameters, testDescription));
        }

        @Override
        void retainFiles(Status status, PrintWriter printWriter) throws Fault, InterruptedException {
            if (!this.params.getRetainStatus().contains(status.getType())) {
                Pattern pattern = this.params.getRetainFilesPattern();
                if (pattern != null) {
                    Pattern pattern2 = Pattern.compile(".*\\.jtr|" + pattern.pattern());
                    this.deleteFiles(this.dir, pattern2, false, printWriter);
                } else {
                    Pattern pattern3 = Pattern.compile(".*\\.jtr");
                    this.deleteFiles(this.dir, pattern3, false, printWriter);
                }
            }
        }
    }

    static class ThreadSafeScratchDir
    extends SimpleScratchDirectory {
        private static ThreadLocal<ThreadInfo> threadInfo = new ThreadLocal<ThreadInfo>(){

            @Override
            public ThreadInfo initialValue() {
                return new ThreadInfo();
            }
        };

        ThreadSafeScratchDir(RegressionParameters regressionParameters, TestDescription testDescription) {
            super(regressionParameters, testDescription, threadInfo.get().getDir(regressionParameters));
        }

        @Override
        void init(PrintWriter printWriter) throws Fault, InterruptedException {
            try {
                super.init(printWriter);
            }
            catch (Fault fault) {
                this.useNextDir();
                super.init(printWriter);
            }
        }

        @Override
        void retainFiles(Status status, PrintWriter printWriter) throws InterruptedException, Fault {
            try {
                super.retainFiles(status, printWriter);
            }
            catch (Fault fault) {
                this.useNextDir();
                throw fault;
            }
        }

        private void useNextDir() {
            this.dir = threadInfo.get().getNextDir(this.params);
        }

        private static class ThreadInfo {
            private static AtomicInteger counter = new AtomicInteger();
            final int threadNum = counter.getAndIncrement();
            int serial = 0;

            ThreadInfo() {
            }

            File getDir(RegressionParameters regressionParameters) {
                Object object = "scratch";
                if (regressionParameters.getConcurrency() > 1) {
                    object = (String)object + File.separator + this.threadNum;
                }
                if (this.serial > 0) {
                    object = (String)object + "_" + this.serial;
                }
                return regressionParameters.getWorkDirectory().getFile((String)object);
            }

            File getNextDir(RegressionParameters regressionParameters) {
                ++this.serial;
                return this.getDir(regressionParameters);
            }
        }
    }

    static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String string) {
            super(string);
        }

        Fault(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    static class SimpleScratchDirectory
    extends ScratchDirectory {
        SimpleScratchDirectory(RegressionParameters regressionParameters, TestDescription testDescription) {
            this(regressionParameters, testDescription, regressionParameters.getWorkDirectory().getFile("scratch"));
        }

        protected SimpleScratchDirectory(RegressionParameters regressionParameters, TestDescription testDescription, File file) {
            super(regressionParameters, testDescription, file);
        }

        @Override
        void retainFiles(Status status, PrintWriter printWriter) throws InterruptedException, Fault {
            Pattern pattern;
            File file = SimpleScratchDirectory.getResultDir(this.params, this.td);
            boolean bl = this.params.getRetainStatus().contains(status.getType()) ? this.saveFiles(this.dir, file, null, false, printWriter) : ((pattern = this.params.getRetainFilesPattern()) != null ? this.saveFiles(this.dir, file, pattern, true, printWriter) : true);
            if (!bl) {
                throw new Fault(ScratchDirectory.CANT_SAVE + this.dir);
            }
            this.deleteFiles(this.dir, null, false, printWriter);
        }
    }
}

