/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.report.Report;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class ElapsedTimeHandler {
    private int resolution;
    private Table table;

    public ElapsedTimeHandler() {
        this(1);
    }

    public ElapsedTimeHandler(int n) {
        this.resolution = n;
        this.table = new Table(n);
    }

    public void register(Harness harness) {
        harness.addObserver(new BasicObserver(){
            private Map<TestResult, Long> startTimes;

            @Override
            public void startingTestRun(Parameters parameters) {
                this.startTimes = new WeakHashMap<TestResult, Long>();
            }

            @Override
            public synchronized void startingTest(TestResult testResult) {
                this.startTimes.put(testResult, System.currentTimeMillis());
            }

            @Override
            public synchronized void finishedTest(TestResult testResult) {
                Long l = this.startTimes.remove(testResult);
                if (l == null) {
                    return;
                }
                ElapsedTimeHandler.this.table.record(l, System.currentTimeMillis());
            }

            @Override
            public void stoppingTestRun() {
                this.startTimes = null;
            }
        });
    }

    public void report(Report report) throws IOException {
        File file = report.getReportDir();
        File file2 = new File(file, "text");
        file2.mkdirs();
        File file3 = new File(file2, "timeStats.txt");
        this.report(file3);
    }

    public void report(File file) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            int n;
            if (this.resolution == 1) {
                bufferedWriter.write(String.format("%5s,%5s%n", "time", "count"));
            } else {
                bufferedWriter.write(String.format("%5s,%5s,%5s", "time", "blk", "count"));
            }
            for (Map.Entry entry : this.table.entrySet()) {
                n = (Integer)entry.getKey();
                int n2 = (Integer)entry.getValue();
                if (this.resolution == 1) {
                    bufferedWriter.write(String.format("%5d,%5d%n", n, n2));
                    continue;
                }
                bufferedWriter.write(String.format("%5d,%5d,%5d%n", n * this.resolution, n, n2));
            }
            bufferedWriter.write(String.format("%n", new Object[0]));
            bufferedWriter.write(String.format("Mean               %6.2fs%n", this.table.getMean() * (double)this.resolution));
            bufferedWriter.write(String.format("Standard deviation %6.2fs%n", this.table.getStdDev() * (double)this.resolution));
            int n3 = this.table.getElapsedTime();
            int n4 = n3 / 60;
            n = n3 % 60;
            bufferedWriter.write(String.format("Total elapsed time %dm %ds%n", n4, n));
        }
    }

    class Table
    extends TreeMap<Integer, Integer> {
        private static final long serialVersionUID = 0L;
        int resolution;
        int count;
        double total;
        double totalSquares;
        long earliest;
        long latest;

        Table(int n) {
            this.resolution = n;
        }

        void record(long l, long l2) {
            if (this.earliest == 0L || l < this.earliest) {
                this.earliest = l;
            }
            if (this.latest == 0L || l2 > this.latest) {
                this.latest = l2;
            }
            int n = (int)((l2 - l) / 1000L);
            int n2 = n / this.resolution;
            this.inc(n2);
        }

        void inc(int n) {
            Integer n2 = (Integer)this.get(n);
            this.put(n, n2 == null ? 1 : n2 + 1);
            ++this.count;
            this.total += (double)n;
            this.totalSquares += (double)(n * n);
        }

        double getMean() {
            return this.total / (double)this.count;
        }

        double getStdDev() {
            double d = this.total / (double)this.count;
            return Math.sqrt(this.totalSquares / (double)this.count - d * d);
        }

        int getElapsedTime() {
            if (this.earliest == 0L && this.latest == 0L) {
                return 0;
            }
            if (this.earliest == 0L || this.latest == 0L) {
                throw new IllegalStateException();
            }
            return (int)((this.latest - this.earliest) / 1000L);
        }
    }
}

