/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.tool.Option;
import com.sun.javatest.regtest.tool.Tool;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionDecoder {
    Pattern optPattern = Pattern.compile("(-[-A-Za-z0-9/]+)(?:([:=])(.*))?");
    private Map<String, Option> simpleOptions = new HashMap<String, Option>();
    private List<Option> matchOptions = new ArrayList<Option>();
    private Option fileOption;
    private Map<String, String> locks = new HashMap<String, String>();
    private boolean inFiles;
    protected static boolean debugOptions = Boolean.getBoolean("javatest.regtest.debugOptions");
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Tool.class);

    public OptionDecoder(List<Option> list) {
        block5: for (Option option : list) {
            switch (option.argType) {
                case WILDCARD: {
                    this.matchOptions.add(option);
                    break;
                }
                case FILE: {
                    this.fileOption = option;
                    break;
                }
                case GNU: {
                    for (String string : option.names) {
                        this.simpleOptions.put(string.toLowerCase(Locale.US), option);
                        if (!string.matches("-[^-]")) continue;
                        this.matchOptions.add(option);
                    }
                    continue block5;
                }
                default: {
                    for (String string : option.names) {
                        this.simpleOptions.put(string.toLowerCase(Locale.US), option);
                    }
                    continue block5;
                }
            }
        }
    }

    public void decodeArgs(String[] stringArray) throws BadArgs {
        this.decodeArgs(Arrays.asList(stringArray));
    }

    public void decodeArgs(List<String> list) throws BadArgs {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.length() == 0) {
                throw new BadArgs(i18n, "opt.empty", new Object[0]);
            }
            if (!string.startsWith("-")) {
                this.inFiles = true;
            }
            if (this.inFiles) {
                this.fileOption.process(null, string);
                continue;
            }
            this.decodeArg(string, iterator);
        }
    }

    private void decodeArg(String string, Iterator<String> iterator) throws BadArgs {
        Object object;
        String string2;
        String string3;
        Matcher matcher = this.optPattern.matcher(string);
        if (matcher.matches()) {
            string3 = matcher.group(1);
            string2 = matcher.group(2);
            object = matcher.group(3);
        } else {
            string3 = string;
            string2 = null;
            object = null;
        }
        Option option = this.getOption(string3);
        if (option == null) {
            throw new BadArgs(i18n, "opt.unknown", string3);
        }
        switch (option.argType) {
            case NONE: {
                if (object == null) break;
                throw new BadArgs(i18n, "opt.unexpected.value", string);
            }
            case GNU: {
                if (string2 == null) {
                    if (string3.startsWith("--") || string3.length() == 2) {
                        if (iterator.hasNext()) {
                            object = iterator.next();
                            break;
                        }
                        throw new BadArgs(i18n, "opt.missing.value", string);
                    }
                    object = string.substring(2);
                    break;
                }
                if (string3.startsWith("--") && string2.equals("=")) break;
                throw new BadArgs(i18n, "opt.bad.format", string);
            }
            case STD: {
                if (object == null) {
                    throw new BadArgs(i18n, "opt.missing.value", string);
                }
                if (string2 == null || string2.equals(":")) break;
                throw new BadArgs(i18n, "opt.bad.format", string);
            }
            case SEP: {
                if (object != null) {
                    throw new BadArgs(i18n, "opt.bad.format", string);
                }
                if (iterator.hasNext()) {
                    object = iterator.next();
                    break;
                }
                throw new BadArgs(i18n, "opt.missing.value", string);
            }
            case OLD: {
                if (object == null && iterator.hasNext()) {
                    object = iterator.next();
                }
                if (object == null) {
                    throw new BadArgs(i18n, "opt.missing.value", string);
                }
                if (string2 == null || string2.equals(":")) break;
                throw new BadArgs(i18n, "opt.bad.format", string);
            }
            case OPT: {
                if (string2 == null || string2.equals(":")) break;
                throw new BadArgs(i18n, "opt.bad.format", string);
            }
            case WILDCARD: {
                object = option.getValue(string);
                break;
            }
            case REST: {
                object = (String)(object == null ? "" : (String)object + " ") + OptionDecoder.join(iterator, " ");
            }
        }
        this.checkConflicts(option, string3);
        if (debugOptions) {
            System.err.println("OptionDecoder.decodeArg: " + string3 + " " + (String)object);
        }
        option.process(string, (String)object);
    }

    public void addFile(File file) throws BadArgs {
        this.fileOption.process(null, file.getPath());
    }

    public void addFile(String string) throws BadArgs {
        this.fileOption.process(null, string);
    }

    protected Option getOption(String string) {
        Option option = this.simpleOptions.get(string.toLowerCase());
        if (option != null) {
            return option;
        }
        for (Option option2 : this.matchOptions) {
            if (!option2.matches(string)) continue;
            return option2;
        }
        return null;
    }

    protected void checkConflicts(Option option, String string) throws BadArgs {
        if (option.lockName != null) {
            String string2 = this.locks.get(option.lockName);
            if (string2 != null) {
                if (string2.equals(string)) {
                    throw new BadArgs(i18n, "opt.duplicate", string);
                }
                throw new BadArgs(i18n, "opt.conflict", string2, string);
            }
            this.locks.put(option.lockName, string);
        }
    }

    private static String join(Iterator<?> iterator, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }
}

