/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class RegressionContextManager
extends ContextManager {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionContextManager.class);

    @Override
    public JavaTestMenuManager getMenuManager() {
        return new RegressionMenuManager();
    }

    static class RegressionMenuManager
    extends JavaTestMenuManager {
        RegressionMenuManager() {
        }

        @Override
        public JMenuItem[] getMenuItems(int n) {
            switch (n) {
                case 15: {
                    return this.createHelpAboutItems();
                }
            }
            return super.getMenuItems(n);
        }

        JMenuItem[] createHelpAboutItems() {
            JMenuItem jMenuItem = new JMenuItem("About jtreg");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.showAbout((JComponent)actionEvent.getSource());
                }
            });
            return new JMenuItem[]{jMenuItem};
        }

        void showAbout(JComponent jComponent) {
            Version version = Version.getCurrent();
            String string = String.format("%s %s %s %s", version.product, version.version, version.milestone, version.build);
            String string2 = i18n.getString("help.copyright.txt");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.addAll(Arrays.asList(string2.split("\n")));
            URL uRL = this.getClass().getResource("jtlogo.png");
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            ImageIcon imageIcon = new ImageIcon(image);
            JOptionPane.showMessageDialog(jComponent, arrayList.toArray(), "Regression Test Harness for the OpenJDK platform: jtreg", 1, imageIcon);
        }
    }
}

