/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.tool.VersionPattern;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public final class RuntimeVersion
implements Comparable<RuntimeVersion> {
    private final List<Integer> version;
    private final Optional<String> pre;
    private final Optional<Integer> build;
    private final Optional<String> optional;

    private RuntimeVersion(List<Integer> list, Optional<String> optional, Optional<Integer> optional2, Optional<String> optional3) {
        this.version = list;
        this.pre = optional;
        this.build = optional2;
        this.optional = optional3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RuntimeVersion parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (RuntimeVersion.isSimpleNumber(string)) {
            return new RuntimeVersion(Arrays.asList(Integer.parseInt(string)), Optional.empty(), Optional.empty(), Optional.empty());
        }
        Matcher matcher = VersionPattern.VSTR_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version string: '" + string + "'");
        }
        String[] stringArray = matcher.group("VNUM").split("\\.");
        Integer[] integerArray = new Integer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            integerArray[i] = Integer.parseInt(stringArray[i]);
        }
        Optional<String> optional = Optional.ofNullable(matcher.group("PRE"));
        String string2 = matcher.group("BUILD");
        Optional<Integer> optional2 = string2 == null ? Optional.empty() : Optional.of(Integer.parseInt(string2));
        Optional<String> optional3 = Optional.ofNullable(matcher.group("OPT"));
        if (optional2.isPresent()) return new RuntimeVersion(Arrays.asList(integerArray), optional, optional2, optional3);
        if (matcher.group("PLUS") != null) {
            if (!optional3.isPresent()) throw new IllegalArgumentException("'+' found with neither build or optional components: '" + string + "'");
            if (!optional.isPresent()) return new RuntimeVersion(Arrays.asList(integerArray), optional, optional2, optional3);
            throw new IllegalArgumentException("'+' found with pre-release and optional components:'" + string + "'");
        }
        if (!optional3.isPresent() || optional.isPresent()) return new RuntimeVersion(Arrays.asList(integerArray), optional, optional2, optional3);
        throw new IllegalArgumentException("optional component must be preceeded by a pre-release component or '+': '" + string + "'");
    }

    private static boolean isSimpleNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            char c3 = c = i > 0 ? (char)'0' : '1';
            if (c2 >= c && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public int feature() {
        return this.version.get(0);
    }

    public int interim() {
        return this.version.size() > 1 ? this.version.get(1) : 0;
    }

    public int update() {
        return this.version.size() > 2 ? this.version.get(2) : 0;
    }

    public int patch() {
        return this.version.size() > 3 ? this.version.get(3) : 0;
    }

    @Deprecated
    public int major() {
        return this.feature();
    }

    @Deprecated
    public int minor() {
        return this.interim();
    }

    @Deprecated
    public int security() {
        return this.update();
    }

    public List<Integer> version() {
        return this.version;
    }

    public Optional<String> pre() {
        return this.pre;
    }

    public Optional<Integer> build() {
        return this.build;
    }

    public Optional<String> optional() {
        return this.optional;
    }

    @Override
    public int compareTo(RuntimeVersion runtimeVersion) {
        return this.compare(runtimeVersion, false);
    }

    public int compareToIgnoreOptional(RuntimeVersion runtimeVersion) {
        return this.compare(runtimeVersion, true);
    }

    private int compare(RuntimeVersion runtimeVersion, boolean bl) {
        if (runtimeVersion == null) {
            throw new NullPointerException();
        }
        int n = this.compareVersion(runtimeVersion);
        if (n != 0) {
            return n;
        }
        n = this.comparePre(runtimeVersion);
        if (n != 0) {
            return n;
        }
        n = this.compareBuild(runtimeVersion);
        if (n != 0) {
            return n;
        }
        if (!bl) {
            return this.compareOptional(runtimeVersion);
        }
        return 0;
    }

    private int compareVersion(RuntimeVersion runtimeVersion) {
        int n = this.version.size();
        int n2 = runtimeVersion.version().size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = this.version.get(i);
            if (n5 == (n4 = runtimeVersion.version().get(i).intValue())) continue;
            return n5 - n4;
        }
        return n - n2;
    }

    private int comparePre(RuntimeVersion runtimeVersion) {
        Optional<String> optional = runtimeVersion.pre();
        if (!this.pre.isPresent()) {
            if (optional.isPresent()) {
                return 1;
            }
        } else {
            if (!optional.isPresent()) {
                return -1;
            }
            String string = this.pre.get();
            String string2 = optional.get();
            if (string.matches("\\d+")) {
                return string2.matches("\\d+") ? new BigInteger(string).compareTo(new BigInteger(string2)) : -1;
            }
            return string2.matches("\\d+") ? 1 : string.compareTo(string2);
        }
        return 0;
    }

    private int compareBuild(RuntimeVersion runtimeVersion) {
        Optional<Integer> optional = runtimeVersion.build();
        if (optional.isPresent()) {
            return this.build.isPresent() ? this.build.get().compareTo(optional.get()) : -1;
        }
        if (this.build.isPresent()) {
            return 1;
        }
        return 0;
    }

    private int compareOptional(RuntimeVersion runtimeVersion) {
        Optional<String> optional = runtimeVersion.optional();
        if (!this.optional.isPresent()) {
            if (optional.isPresent()) {
                return -1;
            }
        } else {
            if (!optional.isPresent()) {
                return 1;
            }
            return this.optional.get().compareTo(optional.get());
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.version.stream().map(Object::toString).collect(Collectors.joining(".")));
        this.pre.ifPresent(string -> stringBuilder.append("-").append((String)string));
        if (this.build.isPresent()) {
            stringBuilder.append("+").append(this.build.get());
            if (this.optional.isPresent()) {
                stringBuilder.append("-").append(this.optional.get());
            }
        } else if (this.optional.isPresent()) {
            stringBuilder.append(this.pre.isPresent() ? "-" : "+-");
            stringBuilder.append(this.optional.get());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl = this.equalsIgnoreOptional(object);
        if (!bl) {
            return false;
        }
        RuntimeVersion runtimeVersion = (RuntimeVersion)object;
        return this.optional().equals(runtimeVersion.optional());
    }

    public boolean equalsIgnoreOptional(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuntimeVersion)) {
            return false;
        }
        RuntimeVersion runtimeVersion = (RuntimeVersion)object;
        return this.version().equals(runtimeVersion.version()) && this.pre().equals(runtimeVersion.pre()) && this.build().equals(runtimeVersion.build());
    }

    public int hashCode() {
        int n = 1;
        int n2 = 17;
        n = n2 * n + this.version.hashCode();
        n = n2 * n + this.pre.hashCode();
        n = n2 * n + this.build.hashCode();
        n = n2 * n + this.optional.hashCode();
        return n;
    }
}

