/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

public class ConfigurationGroupMethods {
    private final Map<String, List<ITestNGMethod>> m_beforeGroupsMethods;
    private final Set<String> beforeGroupsThatHaveAlreadyRun = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> afterGroupsThatHaveAlreadyRun = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, List<ITestNGMethod>> m_afterGroupsMethods;
    private final ITestNGMethod[] m_allMethods;
    private volatile Map<String, List<ITestNGMethod>> m_afterGroupsMap = null;

    public ConfigurationGroupMethods(ITestNGMethod[] allMethods, Map<String, List<ITestNGMethod>> beforeGroupsMethods, Map<String, List<ITestNGMethod>> afterGroupsMethods) {
        this.m_allMethods = allMethods;
        this.m_beforeGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(beforeGroupsMethods);
        this.m_afterGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(afterGroupsMethods);
    }

    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allMethods;
    }

    public Map<String, List<ITestNGMethod>> getBeforeGroupsMethods() {
        return this.m_beforeGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getAfterGroupsMethods() {
        return this.m_afterGroupsMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastMethodForGroup(String group, ITestNGMethod method) {
        if (method.hasMoreInvocation()) {
            return false;
        }
        ConfigurationGroupMethods configurationGroupMethods = this;
        synchronized (configurationGroupMethods) {
            List<ITestNGMethod> methodsInGroup;
            if (this.m_afterGroupsMap == null) {
                this.m_afterGroupsMap = this.initializeAfterGroupsMap();
            }
            if (null == (methodsInGroup = this.m_afterGroupsMap.get(group)) || methodsInGroup.isEmpty()) {
                return false;
            }
            methodsInGroup.remove(method);
            return methodsInGroup.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<ITestNGMethod>> initializeAfterGroupsMap() {
        Map<String, List<ITestNGMethod>> result = Maps.newConcurrentMap();
        for (ITestNGMethod m : this.m_allMethods) {
            String[] groups;
            for (String g : groups = m.getGroups()) {
                List methodsInGroup = result.computeIfAbsent(g, key -> Lists.newArrayList());
                methodsInGroup.add(m);
            }
        }
        Set<String> set = this.afterGroupsThatHaveAlreadyRun;
        synchronized (set) {
            this.afterGroupsThatHaveAlreadyRun.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getBeforeGroupMethodsForGroup(String group) {
        Set<String> set = this.beforeGroupsThatHaveAlreadyRun;
        synchronized (set) {
            return ConfigurationGroupMethods.retrieve(this.beforeGroupsThatHaveAlreadyRun, this.m_beforeGroupsMethods, group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getAfterGroupMethodsForGroup(String group) {
        Set<String> set = this.afterGroupsThatHaveAlreadyRun;
        synchronized (set) {
            return ConfigurationGroupMethods.retrieve(this.afterGroupsThatHaveAlreadyRun, this.m_afterGroupsMethods, group);
        }
    }

    public void removeBeforeGroups(String[] groups) {
        for (String group : groups) {
            this.m_beforeGroupsMethods.remove(group);
        }
    }

    public void removeAfterGroups(Collection<String> groups) {
        for (String group : groups) {
            this.m_afterGroupsMethods.remove(group);
        }
    }

    private static List<ITestNGMethod> retrieve(Set<String> tracker, Map<String, List<ITestNGMethod>> map, String group) {
        if (tracker.contains(group)) {
            return Collections.emptyList();
        }
        tracker.add(group);
        return map.get(group);
    }
}

