/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Listeners;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.DataProviderAnnotation;
import org.testng.internal.annotations.FactoryAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.ListenersAnnotation;
import org.testng.internal.annotations.ObjectFactoryAnnotation;
import org.testng.internal.annotations.ParametersAnnotation;
import org.testng.internal.annotations.TestAnnotation;
import org.testng.internal.collections.Ints;
import org.testng.log4testng.Logger;

public class JDK15TagFactory {
    private static final Default<Class<?>> DEFAULT_CLASS = c -> c == Object.class;
    private static final Default<String> DEFAULT_STRING = Utils::isStringEmpty;

    public <A extends IAnnotation> A createTag(Class<?> cls, Method method, Annotation a, Class<A> annotationClass) {
        IAnnotation result = null;
        if (a != null) {
            if (annotationClass == IDataProviderAnnotation.class) {
                result = this.createDataProviderTag(method, a);
            } else if (annotationClass == IFactoryAnnotation.class) {
                result = this.createFactoryTag(cls, a);
            } else if (annotationClass == IParametersAnnotation.class) {
                result = this.createParametersTag(a);
            } else if (annotationClass == IObjectFactoryAnnotation.class) {
                result = this.createObjectFactoryTag();
            } else if (annotationClass == ITestAnnotation.class) {
                result = this.createTestTag(cls, a);
            } else if (annotationClass == IListenersAnnotation.class) {
                result = this.createListenersTag(a);
            } else if (annotationClass == IBeforeSuite.class || annotationClass == IAfterSuite.class || annotationClass == IBeforeTest.class || annotationClass == IAfterTest.class || annotationClass == IBeforeGroups.class || annotationClass == IAfterGroups.class || annotationClass == IBeforeClass.class || annotationClass == IAfterClass.class || annotationClass == IBeforeMethod.class || annotationClass == IAfterMethod.class) {
                result = this.maybeCreateNewConfigurationTag(a, annotationClass);
            } else {
                throw new TestNGException("Unknown annotation requested:" + annotationClass);
            }
        }
        return (A)result;
    }

    private IAnnotation maybeCreateNewConfigurationTag(Annotation a, Class<?> annotationClass) {
        IAnnotation result = null;
        if (annotationClass == IBeforeSuite.class) {
            BeforeSuite bs = (BeforeSuite)a;
            result = this.createConfigurationTag(true, false, false, false, new String[0], false, new String[0], false, false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IAfterSuite.class) {
            AfterSuite bs = (AfterSuite)a;
            result = this.createConfigurationTag(false, true, false, false, new String[0], false, new String[0], false, false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IBeforeTest.class) {
            BeforeTest bs = (BeforeTest)a;
            result = this.createConfigurationTag(false, false, true, false, new String[0], false, new String[0], false, false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IAfterTest.class) {
            AfterTest bs = (AfterTest)a;
            result = this.createConfigurationTag(false, false, false, true, new String[0], false, new String[0], false, false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IBeforeGroups.class) {
            BeforeGroups bs = (BeforeGroups)a;
            String[] groups = bs.value().length > 0 ? bs.value() : bs.groups();
            result = this.createConfigurationTag(false, false, false, false, groups, true, new String[0], false, false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IAfterGroups.class) {
            AfterGroups bs = (AfterGroups)a;
            String[] groups = bs.value().length > 0 ? bs.value() : bs.groups();
            result = this.createConfigurationTag(false, false, false, false, new String[0], false, groups, true, false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IBeforeClass.class) {
            BeforeClass bs = (BeforeClass)a;
            result = this.createConfigurationTag(false, false, false, false, new String[0], false, new String[0], false, true, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IAfterClass.class) {
            AfterClass bs = (AfterClass)a;
            result = this.createConfigurationTag(false, false, false, false, new String[0], false, new String[0], false, false, true, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, false, bs.timeOut(), new String[0]);
        } else if (annotationClass == IBeforeMethod.class) {
            BeforeMethod bs = (BeforeMethod)a;
            result = this.createConfigurationTag(false, false, false, false, new String[0], false, new String[0], false, false, false, true, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), bs.firstTimeOnly(), false, bs.timeOut(), bs.onlyForGroups());
        } else if (annotationClass == IAfterMethod.class) {
            AfterMethod bs = (AfterMethod)a;
            result = this.createConfigurationTag(false, false, false, false, new String[0], false, new String[0], false, false, false, false, true, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), false, bs.lastTimeOnly(), bs.timeOut(), bs.onlyForGroups());
        }
        return result;
    }

    private IAnnotation createConfigurationTag(boolean beforeSuite, boolean afterSuite, boolean beforeTest, boolean afterTest, String[] beforeGroups, boolean isBeforeGroups, String[] afterGroups, boolean isAfterGroups, boolean beforeClass, boolean afterClass, boolean beforeMethod, boolean afterMethod, boolean alwaysRun, String[] dependsOnGroups, String[] dependsOnMethods, String description, boolean enabled, String[] groups, boolean inheritGroups, boolean firstTimeOnly, boolean lastTimeOnly, long timeOut, String[] groupFilters) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        result.setIsBeforeGroups(isBeforeGroups);
        result.setIsAfterGroups(isAfterGroups);
        result.setFakeConfiguration(true);
        result.setBeforeSuite(beforeSuite);
        result.setAfterSuite(afterSuite);
        result.setBeforeTest(beforeTest);
        result.setAfterTest(afterTest);
        result.setBeforeTestClass(beforeClass);
        result.setAfterTestClass(afterClass);
        result.setBeforeGroups(beforeGroups);
        result.setAfterGroups(afterGroups);
        result.setBeforeTestMethod(beforeMethod);
        result.setAfterTestMethod(afterMethod);
        result.setAlwaysRun(alwaysRun);
        result.setDependsOnGroups(dependsOnGroups);
        result.setDependsOnMethods(dependsOnMethods);
        result.setDescription(description);
        result.setEnabled(enabled);
        result.setGroups(groups);
        result.setInheritGroups(inheritGroups);
        result.setGroupFilters(groupFilters);
        result.setFirstTimeOnly(firstTimeOnly);
        result.setLastTimeOnly(lastTimeOnly);
        result.setTimeOut(timeOut);
        return result;
    }

    private IAnnotation createDataProviderTag(Method method, Annotation a) {
        DataProviderAnnotation result = new DataProviderAnnotation();
        DataProvider c = (DataProvider)a;
        if (c.name().isEmpty()) {
            result.setName(method.getName());
        } else {
            result.setName(c.name());
        }
        result.setParallel(c.parallel());
        result.setIndices(Ints.asList(c.indices()));
        return result;
    }

    private IAnnotation createFactoryTag(Class<?> cls, Annotation a) {
        FactoryAnnotation result = new FactoryAnnotation();
        Factory c = (Factory)a;
        Class<?> dpc = this.findInherited(c.dataProviderClass(), cls, Factory.class, "dataProviderClass", DEFAULT_CLASS);
        result.setDataProvider(c.dataProvider());
        result.setDataProviderClass(dpc == null || dpc == Object.class ? cls : dpc);
        result.setEnabled(c.enabled());
        result.setIndices(Ints.asList(c.indices()));
        return result;
    }

    private IAnnotation createObjectFactoryTag() {
        return new ObjectFactoryAnnotation();
    }

    private IAnnotation createParametersTag(Annotation a) {
        ParametersAnnotation result = new ParametersAnnotation();
        Parameters c = (Parameters)a;
        result.setValue(c.value());
        return result;
    }

    private IAnnotation createListenersTag(Annotation a) {
        ListenersAnnotation result = new ListenersAnnotation();
        Listeners l = (Listeners)a;
        result.setValue(l.value());
        return result;
    }

    private IAnnotation createTestTag(Class<?> cls, Annotation a) {
        TestAnnotation result = new TestAnnotation();
        Test test = (Test)a;
        result.setEnabled(test.enabled());
        result.setGroups(this.join(test.groups(), this.findInheritedStringArray(cls, "groups")));
        result.setDependsOnGroups(this.join(test.dependsOnGroups(), this.findInheritedStringArray(cls, "dependsOnGroups")));
        result.setDependsOnMethods(this.join(test.dependsOnMethods(), this.findInheritedStringArray(cls, "dependsOnMethods")));
        result.setTimeOut(test.timeOut());
        result.setInvocationTimeOut(test.invocationTimeOut());
        result.setInvocationCount(test.invocationCount());
        result.setThreadPoolSize(test.threadPoolSize());
        result.setSuccessPercentage(test.successPercentage());
        result.setDataProvider(test.dataProvider());
        result.setDataProviderClass(this.findInherited(test.dataProviderClass(), cls, Test.class, "dataProviderClass", DEFAULT_CLASS));
        result.setAlwaysRun(test.alwaysRun());
        result.setDescription(this.findInherited(test.description(), cls, Test.class, "description", DEFAULT_STRING));
        result.setExpectedExceptions(test.expectedExceptions());
        result.setExpectedExceptionsMessageRegExp(test.expectedExceptionsMessageRegExp());
        result.setSuiteName(test.suiteName());
        result.setTestName(test.testName());
        result.setSingleThreaded(test.singleThreaded());
        result.setRetryAnalyzer(test.retryAnalyzer());
        result.setSkipFailedInvocations(test.skipFailedInvocations());
        result.setIgnoreMissingDependencies(test.ignoreMissingDependencies());
        result.setPriority(test.priority());
        result.setAttributes(test.attributes());
        return result;
    }

    private String[] join(String[] strings, String[] strings2) {
        List<String> result = Lists.newArrayList(strings);
        HashSet<String> seen = new HashSet<String>(Lists.newArrayList(strings));
        for (String s : strings2) {
            if (seen.contains(s)) continue;
            result.add(s);
        }
        return result.toArray(new String[0]);
    }

    private <T> T findInherited(T methodValue, Class<?> cls, Class<? extends Annotation> annotationClass, String methodName, Default<T> def) {
        if (!def.isDefault(methodValue)) {
            return methodValue;
        }
        while (cls != null && cls != Object.class) {
            Object result;
            Annotation annotation = AnnotationHelper.getAnnotationFromClass(cls, annotationClass);
            if (annotation != null && !def.isDefault(result = this.invokeMethod(annotation, methodName))) {
                return (T)result;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    private String[] findInheritedStringArray(Class<?> cls, String methodName) {
        if (null == cls) {
            return new String[0];
        }
        List result = Lists.newArrayList();
        while (cls != null && cls != Object.class) {
            Test annotation = AnnotationHelper.getAnnotationFromClass(cls, Test.class);
            if (annotation != null) {
                String[] g = (String[])this.invokeMethod(annotation, methodName);
                result.addAll(Arrays.asList(g));
            }
            cls = cls.getSuperclass();
        }
        return result.toArray(new String[0]);
    }

    private Object invokeMethod(Annotation test, String methodName) {
        Object result = null;
        try {
            Method m = test.getClass().getMethod(methodName, new Class[0]);
            result = m.invoke((Object)test, new Object[0]);
        }
        catch (Exception e) {
            Logger.getLogger(JDK15TagFactory.class).error(e.getMessage(), e);
        }
        return result;
    }

    static interface Default<T> {
        public boolean isDefault(T var1);
    }
}

