/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Parameter
implements AnnotatedElement {
    private final int index;
    private final Class<?> type;
    private final Annotation[] declaredAnnotations;
    private final Map<Class<? extends Annotation>, Annotation> declaredAnnotationsMap;

    public Parameter(int index, Class<?> type, Annotation[] declaredAnnotations) {
        this.index = index;
        this.type = type;
        this.declaredAnnotations = declaredAnnotations;
        this.declaredAnnotationsMap = Parameter.declaredAnnotations(declaredAnnotations);
    }

    private static Map<Class<? extends Annotation>, Annotation> declaredAnnotations(Annotation[] ann) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        if (ann != null) {
            for (Annotation anAnn : ann) {
                map.put(anAnn.annotationType(), anAnn);
            }
        }
        return map;
    }

    public String toString() {
        return "Parameter{index=" + this.index + ", type=" + (this.type != null ? this.type.getName() : null) + ", declaredAnnotations=" + Arrays.toString(this.declaredAnnotations) + '}';
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)annotationClass.cast(this.declaredAnnotationsMap.get(annotationClass)));
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations;
    }
}

