/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.xml.IFileParser;
import org.testng.xml.IPostProcessor;
import org.testng.xml.ISuiteParser;
import org.testng.xml.SuiteXmlParser;
import org.testng.xml.XmlSuite;

public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String OLD_TESTNG_DTD_URL = "https://beust.com/testng/testng-1.0.dtd";
    private static final String HTTPS_OLD_TESTNG_DTD_URL = "https://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "https://testng.org/testng-1.0.dtd";
    public static final String HTTPS_TESTNG_DTD_URL = "https://testng.org/testng-1.0.dtd";
    private static final List<String> URLS = Collections.unmodifiableList(Arrays.asList("https://beust.com/testng/testng-1.0.dtd", "https://beust.com/testng/testng-1.0.dtd", "https://testng.org/testng-1.0.dtd", "https://testng.org/testng-1.0.dtd"));
    public static final String DEFAULT_FILENAME = "testng.xml";
    private static final ISuiteParser DEFAULT_FILE_PARSER = new SuiteXmlParser();
    private static final List<ISuiteParser> PARSERS = Lists.newArrayList();
    private String m_fileName;
    private InputStream m_inputStream;
    private IPostProcessor m_postProcessor;
    private boolean m_loadClasses = true;

    static boolean isUnRecognizedPublicId(String publicId) {
        return !URLS.contains(publicId);
    }

    public Parser(String fileName) {
        this.init(fileName, null);
    }

    public Parser() {
        this.init(null, null);
    }

    public Parser(InputStream is) {
        this.init(null, is);
    }

    private void init(String fileName, InputStream is) {
        this.m_fileName = fileName != null ? fileName : DEFAULT_FILENAME;
        this.m_inputStream = is;
    }

    public void setPostProcessor(IPostProcessor processor) {
        this.m_postProcessor = processor;
    }

    public void setLoadClasses(boolean loadClasses) {
        this.m_loadClasses = loadClasses;
    }

    private static IFileParser getParser(String fileName) {
        for (ISuiteParser parser : PARSERS) {
            if (!parser.accept(fileName)) continue;
            return parser;
        }
        return DEFAULT_FILE_PARSER;
    }

    public Collection<XmlSuite> parse() throws IOException {
        List processedSuites = Lists.newArrayList();
        XmlSuite resultSuite = null;
        List<String> toBeParsed = Lists.newArrayList();
        List toBeAdded = Lists.newArrayList();
        List toBeRemoved = Lists.newArrayList();
        if (this.m_fileName != null) {
            URI uri = Parser.constructURI(this.m_fileName);
            if (uri == null || uri.getScheme() == null) {
                uri = new File(this.m_fileName).toURI();
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                File mainFile = new File(uri);
                toBeParsed.add(mainFile.getCanonicalPath());
            } else {
                toBeParsed.add(uri.toString());
            }
        }
        Map childToParentMap = Maps.newHashMap();
        while (!toBeParsed.isEmpty()) {
            for (String currentFile : toBeParsed) {
                List<String> suiteFiles;
                File parentFile = null;
                InputStream inputStream = null;
                if (Parser.hasFileScheme(currentFile)) {
                    File currFile = new File(currentFile);
                    parentFile = currFile.getParentFile();
                    inputStream = this.m_inputStream != null ? this.m_inputStream : new FileInputStream(currFile);
                }
                IFileParser fileParser = Parser.getParser(currentFile);
                XmlSuite currentXmlSuite = (XmlSuite)fileParser.parse(currentFile, inputStream, this.m_loadClasses);
                currentXmlSuite.setParsed(true);
                processedSuites.add(currentFile);
                toBeRemoved.add(currentFile);
                if (childToParentMap.containsKey(currentFile)) {
                    XmlSuite parentSuite = (XmlSuite)((Queue)childToParentMap.get(currentFile)).remove();
                    currentXmlSuite.setParentSuite(parentSuite);
                    parentSuite.getChildSuites().add(currentXmlSuite);
                }
                if (null == resultSuite) {
                    resultSuite = currentXmlSuite;
                }
                if ((suiteFiles = currentXmlSuite.getSuiteFiles()).isEmpty()) continue;
                Iterator<String> iterator = suiteFiles.iterator();
                while (iterator.hasNext()) {
                    String path;
                    String canonicalPath = path = iterator.next();
                    if (Parser.hasFileScheme(path)) {
                        canonicalPath = parentFile != null && new File(parentFile, path).exists() ? new File(parentFile, path).getCanonicalPath() : new File(path).getCanonicalPath();
                    }
                    if (processedSuites.contains(canonicalPath)) continue;
                    toBeAdded.add(canonicalPath);
                    if (childToParentMap.containsKey(canonicalPath)) {
                        ((Queue)childToParentMap.get(canonicalPath)).add(currentXmlSuite);
                        continue;
                    }
                    ArrayDeque<XmlSuite> parentQueue = new ArrayDeque<XmlSuite>();
                    parentQueue.add(currentXmlSuite);
                    childToParentMap.put(canonicalPath, parentQueue);
                }
            }
            toBeParsed.removeAll(toBeRemoved);
            toBeRemoved = Lists.newArrayList();
            toBeParsed.addAll(toBeAdded);
            toBeAdded = Lists.newArrayList();
        }
        List<XmlSuite> resultList = Lists.newArrayList();
        resultList.add(resultSuite);
        if (this.m_postProcessor != null) {
            return this.m_postProcessor.process(resultList);
        }
        return resultList;
    }

    public static boolean hasFileScheme(String uri) {
        URI constructedURI = Parser.constructURI(uri);
        if (constructedURI == null) {
            return true;
        }
        String scheme = constructedURI.getScheme();
        return scheme == null || "file".equalsIgnoreCase(scheme);
    }

    public List<XmlSuite> parseToList() throws IOException {
        return Lists.newArrayList(this.parse());
    }

    public static Collection<XmlSuite> parse(String suite, IPostProcessor processor) throws IOException {
        return Parser.newParser(suite, processor).parse();
    }

    public static Collection<XmlSuite> parse(InputStream is, IPostProcessor processor) throws IOException {
        return Parser.newParser(is, processor).parse();
    }

    public static boolean canParse(String fileName) {
        for (ISuiteParser parser : PARSERS) {
            if (!parser.accept(fileName)) continue;
            return true;
        }
        return DEFAULT_FILE_PARSER.accept(fileName);
    }

    private static Parser newParser(String path, IPostProcessor processor) {
        Parser result = new Parser(path);
        result.setPostProcessor(processor);
        return result;
    }

    private static Parser newParser(InputStream is, IPostProcessor processor) {
        Parser result = new Parser(is);
        result.setPostProcessor(processor);
        return result;
    }

    private static URI constructURI(String text) {
        try {
            return URI.create(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        ServiceLoader<ISuiteParser> suiteParserLoader = ServiceLoader.load(ISuiteParser.class);
        for (ISuiteParser parser : suiteParserLoader) {
            PARSERS.add(parser);
        }
    }
}

