/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public abstract class Tool {
    protected final String programName;
    protected int nerrors = 0;
    protected PrintWriter err;
    protected PrintWriter out;
    protected Consumer<String> printCannotReadMsg;
    protected BooleanSupplier DebugFlag = () -> false;

    public Tool(PrintWriter out, String programName) {
        this(out, out, programName);
    }

    public Tool(PrintWriter out, PrintWriter err, String programName) {
        this.out = out;
        this.err = err;
        this.programName = programName;
    }

    public String getError(String msg) {
        return this.programName + ": " + msg;
    }

    public void error(String msg) {
        this.err.println(this.getError(msg));
        this.err.flush();
    }

    public void println(String msg) {
        this.out.println(msg);
        this.out.flush();
    }

    public void println() {
        this.println("");
    }

    public void print(String msg) {
        this.out.print(this.getError(msg));
        this.out.flush();
    }

    public DataInputStream getDataInputStream(String fname) {
        try {
            return new DataInputStream(new FileInputStream(fname));
        }
        catch (IOException ex) {
            block6: {
                if (fname.matches("^[A-Za-z]+:.*")) {
                    try {
                        URI uri = new URI(fname);
                        URL url = uri.toURL();
                        URLConnection conn = url.openConnection();
                        conn.setUseCaches(false);
                        return new DataInputStream(conn.getInputStream());
                    }
                    catch (IOException | URISyntaxException e) {
                        if (!this.DebugFlag.getAsBoolean()) break block6;
                        e.printStackTrace();
                    }
                }
            }
            if (this.printCannotReadMsg != null) {
                this.printCannotReadMsg.accept(fname);
            }
            return null;
        }
    }

    protected abstract void usage();
}

