/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.SwitchTable;

class Instr {
    Instr next = null;
    int pc;
    int pos;
    OpcodeTables.Opcode opc;
    Argument arg;
    Object arg2;

    public Instr(int pc, int pos, OpcodeTables.Opcode opc, Argument arg, Object arg2) {
        this.pc = pc;
        this.pos = pos;
        this.opc = opc;
        this.arg = arg;
        this.arg2 = arg2;
    }

    public Instr() {
    }

    public void write(CheckedDataOutputStream out, Environment env) throws IOException {
        OpcodeTables.OpcodeType type = this.opc.type();
        switch (type) {
            case NORMAL: {
                int iarg;
                if (this.opc == OpcodeTables.Opcode.opc_bytecode) {
                    out.writeByte(this.arg.arg);
                    return;
                }
                out.writeByte(this.opc.value());
                int opcLen = this.opc.length();
                if (opcLen == 1) {
                    return;
                }
                switch (this.opc) {
                    case opc_tableswitch: {
                        ((SwitchTable)this.arg2).writeTableSwitch(out);
                        return;
                    }
                    case opc_lookupswitch: {
                        ((SwitchTable)this.arg2).writeLookupSwitch(out);
                        return;
                    }
                }
                try {
                    iarg = this.arg.arg;
                }
                catch (NullPointerException e) {
                    throw new Parser.CompilerError(env.errorStr("comperr.instr.nullarg", this.opc.parsekey()));
                }
                switch (this.opc) {
                    case opc_jsr: 
                    case opc_goto: 
                    case opc_ifeq: 
                    case opc_ifge: 
                    case opc_ifgt: 
                    case opc_ifle: 
                    case opc_iflt: 
                    case opc_ifne: 
                    case opc_if_icmpeq: 
                    case opc_if_icmpne: 
                    case opc_if_icmpge: 
                    case opc_if_icmpgt: 
                    case opc_if_icmple: 
                    case opc_if_icmplt: 
                    case opc_if_acmpeq: 
                    case opc_if_acmpne: 
                    case opc_ifnull: 
                    case opc_ifnonnull: 
                    case opc_jsr_w: 
                    case opc_goto_w: {
                        iarg -= this.pc;
                        break;
                    }
                    case opc_iinc: {
                        iarg = iarg << 8 | ((Argument)this.arg2).arg & 0xFF;
                        break;
                    }
                    case opc_invokeinterface: {
                        iarg = (iarg << 8 | ((Argument)this.arg2).arg & 0xFF) << 8;
                        break;
                    }
                    case opc_invokedynamic: {
                        iarg <<= 16;
                        break;
                    }
                    case opc_ldc: {
                        if ((iarg & 0xFFFFFF00) == 0) break;
                        throw new Parser.CompilerError(env.errorStr("comperr.instr.arglong", this.opc.parsekey(), iarg));
                    }
                }
                switch (opcLen) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        out.writeByte(iarg);
                        return;
                    }
                    case 3: {
                        out.writeShort(iarg);
                        return;
                    }
                    case 4: {
                        out.writeShort(iarg);
                        iarg = ((Argument)this.arg2).arg;
                        out.writeByte(iarg);
                        return;
                    }
                    case 5: {
                        out.writeInt(iarg);
                        return;
                    }
                }
                throw new Parser.CompilerError(env.errorStr("comperr.instr.opclen", this.opc.parsekey()));
            }
            case WIDE: {
                out.writeByte(OpcodeTables.Opcode.opc_wide.value());
                out.writeByte((int)(this.opc.value() & 0xFF));
                out.writeShort(this.arg.arg);
                if (this.opc == OpcodeTables.Opcode.opc_iinc_w) {
                    out.writeShort(((Argument)this.arg2).arg);
                }
                return;
            }
            case PRIVELEGED: 
            case NONPRIVELEGED: {
                out.writeByte(this.opc.value() >> 8);
                out.writeByte((int)(this.opc.value() & 0xFF));
                return;
            }
        }
        throw new Parser.CompilerError(env.errorStr("comperr.instr.opclen", this.opc.parsekey()));
    }
}

