/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.FieldData;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Tables;

public class RecordData
extends AttrData {
    private List<ComponentData> components = new ArrayList<ComponentData>();

    public RecordData(ClassData cls) {
        super(cls, Tables.AttrTag.ATT_Record.parsekey());
    }

    public void addComponent(ConstantPool.ConstCell nameCell, ConstantPool.ConstCell descCell, ConstantPool.ConstCell signature, ArrayList<AnnotationData> annotations) {
        FieldData fd = this.getClassData().addFieldIfAbsent(0, nameCell, descCell);
        ComponentData cd = new ComponentData(fd);
        if (annotations != null) {
            cd.addAnnotations(annotations);
        }
        if (signature != null) {
            cd.setSignatureAttr(signature);
        }
        this.components.add(cd);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        out.writeShort(this.components.size());
        for (ComponentData cd : this.components) {
            cd.write(out);
        }
    }

    @Override
    public int attrLength() {
        int compsLength = this.components.stream().mapToInt(c -> c.getLength()).sum();
        return 2 + compsLength;
    }

    class ComponentData
    extends MemberData {
        private FieldData field;

        public ComponentData(FieldData field) {
            super(RecordData.this.getClassData());
            this.field = field;
        }

        @Override
        protected DataVector getAttrVector() {
            return this.getDataVector(this.signatureAttr);
        }

        public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
            out.writeShort(this.field.getNameDesc().left.arg);
            out.writeShort(this.field.getNameDesc().right.arg);
            DataVector attrs = this.getAttrVector();
            attrs.write(out);
        }

        public int getLength() {
            return 4 + this.getAttrVector().getLength();
        }
    }
}

